/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.IOException;
import jdk.jfr.events.FileReadEvent;
import jdk.jfr.events.FileWriteEvent;
import oracle.jrockit.jfr.JIInstrumentationMethod;
import oracle.jrockit.jfr.JIInstrumentationTarget;
import oracle.jrockit.jfr.JITracer;

@JIInstrumentationTarget(value="java.io.RandomAccessFile")
public class RandomAccessFileInstrumentor {
    private String path;

    private RandomAccessFileInstrumentor() {
    }

    @JIInstrumentationMethod
    public int read() throws IOException {
        long l;
        if (!JITracer.fileReadToken.isEnabled()) {
            return this.read();
        }
        FileReadEvent fileReadEvent = new FileReadEvent(JITracer.fileReadToken);
        int n = -1;
        try {
            fileReadEvent.begin();
            n = this.read();
            l = n <= 0 ? (long)n : 1L;
        }
        catch (Throwable throwable) {
            fileReadEvent.bytesRead = n <= 0 ? (long)n : 1L;
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
            throw throwable;
        }
        fileReadEvent.bytesRead = l;
        fileReadEvent.path = this.path;
        fileReadEvent.commit();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(byte[] byArray) throws IOException {
        if (!JITracer.fileReadToken.isEnabled()) {
            return this.read(byArray);
        }
        FileReadEvent fileReadEvent = new FileReadEvent(JITracer.fileReadToken);
        int n = -1;
        try {
            fileReadEvent.begin();
            n = this.read(byArray);
        }
        finally {
            fileReadEvent.bytesRead = n;
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!JITracer.fileReadToken.isEnabled()) {
            return this.read(byArray, n, n2);
        }
        FileReadEvent fileReadEvent = new FileReadEvent(JITracer.fileReadToken);
        int n3 = -1;
        try {
            fileReadEvent.begin();
            n3 = this.read(byArray, n, n2);
        }
        finally {
            fileReadEvent.bytesRead = n3;
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public void write(int n) throws IOException {
        if (!JITracer.fileWriteToken.isEnabled()) {
            this.write(n);
            return;
        }
        FileWriteEvent fileWriteEvent = new FileWriteEvent(JITracer.fileWriteToken);
        int n2 = -1;
        try {
            fileWriteEvent.begin();
            this.write(n);
            n2 = 1;
        }
        finally {
            fileWriteEvent.bytesWritten = n2;
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public void write(byte[] byArray) throws IOException {
        if (!JITracer.fileWriteToken.isEnabled()) {
            this.write(byArray);
            return;
        }
        FileWriteEvent fileWriteEvent = new FileWriteEvent(JITracer.fileWriteToken);
        int n = -1;
        try {
            fileWriteEvent.begin();
            this.write(byArray);
            n = byArray.length;
        }
        finally {
            fileWriteEvent.bytesWritten = n;
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!JITracer.fileWriteToken.isEnabled()) {
            this.write(byArray, n, n2);
            return;
        }
        FileWriteEvent fileWriteEvent = new FileWriteEvent(JITracer.fileWriteToken);
        int n3 = -1;
        try {
            fileWriteEvent.begin();
            this.write(byArray, n, n2);
            n3 = n2;
        }
        finally {
            fileWriteEvent.bytesWritten = n3;
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
        }
    }
}

