/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import jdk.nashorn.internal.codegen.BranchOptimizer;
import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.CodeGeneratorLexicalContext;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.Condition;
import jdk.nashorn.internal.codegen.FieldObjectCreator;
import jdk.nashorn.internal.codegen.FunctionSignature;
import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.codegen.MapCreator;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.ObjectClassGenerator;
import jdk.nashorn.internal.codegen.RuntimeCallSite;
import jdk.nashorn.internal.codegen.SharedScopeCall;
import jdk.nashorn.internal.codegen.SpillObjectCreator;
import jdk.nashorn.internal.codegen.SplitMethodEmitter;
import jdk.nashorn.internal.codegen.types.ArrayType;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.BaseNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BlockStatement;
import jdk.nashorn.internal.ir.BreakNode;
import jdk.nashorn.internal.ir.BreakableNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ContinueNode;
import jdk.nashorn.internal.ir.EmptyNode;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.ExpressionStatement;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LexicalContextNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.LoopNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.SplitNode;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.ir.visitor.NodeOperatorVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.ScriptFunctionImpl;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.ECMAException;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.RecompilableScriptFunctionData;
import jdk.nashorn.internal.runtime.Scope;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.Undefined;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

final class CodeGenerator
extends NodeOperatorVisitor<CodeGeneratorLexicalContext> {
    private static final String GLOBAL_OBJECT = Type.getInternalName(Global.class);
    private static final String SCRIPTFUNCTION_IMPL_OBJECT = Type.getInternalName(ScriptFunctionImpl.class);
    private final Compiler compiler;
    private final int callSiteFlags;
    private int regexFieldCount;
    private int lastLineNumber = -1;
    private static final int MAX_REGEX_FIELDS = 2048;
    private MethodEmitter method;
    private CompileUnit unit;
    private static final DebugLogger LOG = new DebugLogger("codegen", "nashorn.codegen.debug");
    private static final int OBJECT_SPILL_THRESHOLD = 300;
    private final Set<String> emittedMethods = new HashSet<String>();

    CodeGenerator(Compiler compiler) {
        super(new CodeGeneratorLexicalContext());
        this.compiler = compiler;
        this.callSiteFlags = compiler.getEnv()._callsite_flags;
    }

    int getCallSiteFlags() {
        return ((CodeGeneratorLexicalContext)this.lc).getCurrentFunction().isStrict() ? this.callSiteFlags | 2 : this.callSiteFlags;
    }

    private MethodEmitter loadIdent(IdentNode identNode, Type type) {
        Symbol symbol = identNode.getSymbol();
        if (!symbol.isScope()) {
            assert (symbol.hasSlot() || symbol.isParam());
            return this.method.load(symbol).convert(type);
        }
        String name = symbol.getName();
        Source source = ((CodeGeneratorLexicalContext)this.lc).getCurrentFunction().getSource();
        if (CompilerConstants.__FILE__.name().equals(name)) {
            return this.method.load(source.getName());
        }
        if (CompilerConstants.__DIR__.name().equals(name)) {
            return this.method.load(source.getBase());
        }
        if (CompilerConstants.__LINE__.name().equals(name)) {
            return this.method.load(source.getLine(identNode.position())).convert(Type.OBJECT);
        }
        assert (identNode.getSymbol().isScope()) : identNode + " is not in scope!";
        int flags = 1 | this.getCallSiteFlags();
        this.method.loadCompilerConstant(CompilerConstants.SCOPE);
        if (this.isFastScope(symbol)) {
            if (symbol.getUseCount() > 200) {
                return this.loadSharedScopeVar(type, symbol, flags);
            }
            return this.loadFastScopeVar(type, symbol, flags, identNode.isFunction());
        }
        return this.method.dynamicGet(type, identNode.getName(), flags, identNode.isFunction());
    }

    private boolean isFastScope(Symbol symbol) {
        if (!symbol.isScope()) {
            return false;
        }
        if (!((CodeGeneratorLexicalContext)this.lc).inDynamicScope()) {
            assert (symbol.isGlobal() || ((CodeGeneratorLexicalContext)this.lc).getDefiningBlock(symbol).needsScope()) : symbol.getName();
            return true;
        }
        if (symbol.isGlobal()) {
            return false;
        }
        String name = symbol.getName();
        boolean previousWasBlock = false;
        Iterator<LexicalContextNode> it = ((CodeGeneratorLexicalContext)this.lc).getAllNodes();
        while (it.hasNext()) {
            LexicalContextNode node = it.next();
            if (node instanceof Block) {
                Block block = (Block)node;
                if (block.getExistingSymbol(name) == symbol) {
                    assert (block.needsScope());
                    return true;
                }
                previousWasBlock = true;
                continue;
            }
            if (node instanceof WithNode && previousWasBlock || node instanceof FunctionNode && CodeGeneratorLexicalContext.isFunctionDynamicScope((FunctionNode)node)) {
                return false;
            }
            previousWasBlock = false;
        }
        throw new AssertionError();
    }

    private MethodEmitter loadSharedScopeVar(Type valueType, Symbol symbol, int flags) {
        this.method.load(this.isFastScope(symbol) ? this.getScopeProtoDepth(((CodeGeneratorLexicalContext)this.lc).getCurrentBlock(), symbol) : -1);
        SharedScopeCall scopeCall = ((CodeGeneratorLexicalContext)this.lc).getScopeGet(this.unit, valueType, symbol, flags | 0x400);
        return scopeCall.generateInvoke(this.method);
    }

    private MethodEmitter loadFastScopeVar(Type valueType, Symbol symbol, int flags, boolean isMethod) {
        this.loadFastScopeProto(symbol, false);
        return this.method.dynamicGet(valueType, symbol.getName(), flags | 0x400, isMethod);
    }

    private MethodEmitter storeFastScopeVar(Symbol symbol, int flags) {
        this.loadFastScopeProto(symbol, true);
        this.method.dynamicSet(symbol.getName(), flags | 0x400);
        return this.method;
    }

    private int getScopeProtoDepth(Block startingBlock, Symbol symbol) {
        int depth = 0;
        String name = symbol.getName();
        Iterator<Block> blocks = ((CodeGeneratorLexicalContext)this.lc).getBlocks(startingBlock);
        while (blocks.hasNext()) {
            Block currentBlock = blocks.next();
            if (currentBlock.getExistingSymbol(name) == symbol) {
                return depth;
            }
            if (!currentBlock.needsScope()) continue;
            ++depth;
        }
        return -1;
    }

    private void loadFastScopeProto(Symbol symbol, boolean swap) {
        int depth = this.getScopeProtoDepth(((CodeGeneratorLexicalContext)this.lc).getCurrentBlock(), symbol);
        assert (depth != -1);
        if (depth > 0) {
            if (swap) {
                this.method.swap();
            }
            for (int i = 0; i < depth; ++i) {
                this.method.invoke(ScriptObject.GET_PROTO);
            }
            if (swap) {
                this.method.swap();
            }
        }
    }

    MethodEmitter load(Expression node) {
        return this.load(node, node.hasType() ? node.getType() : null, false);
    }

    private boolean noToPrimitiveConversion(Type source, Type target) {
        return source.isJSPrimitive() || !target.isJSPrimitive() || target.isBoolean();
    }

    MethodEmitter loadBinaryOperands(Expression lhs, Expression rhs, Type type) {
        return this.loadBinaryOperands(lhs, rhs, type, false);
    }

    private MethodEmitter loadBinaryOperands(Expression lhs, Expression rhs, Type type, boolean baseAlreadyOnStack) {
        if (this.noToPrimitiveConversion(lhs.getType(), type) || rhs.isLocal()) {
            this.load(lhs, type, baseAlreadyOnStack);
            this.load(rhs, type, false);
        } else {
            this.load(lhs, lhs.getType(), baseAlreadyOnStack);
            this.load(rhs, rhs.getType(), false);
            this.method.swap().convert(type).swap().convert(type);
        }
        return this.method;
    }

    MethodEmitter loadBinaryOperands(BinaryNode node) {
        return this.loadBinaryOperands(node.lhs(), node.rhs(), node.getType(), false);
    }

    MethodEmitter load(Expression node, Type type) {
        return this.load(node, type, false);
    }

    private MethodEmitter load(Expression node, final Type type, final boolean baseAlreadyOnStack) {
        final Symbol symbol = node.getSymbol();
        if (symbol == null || type == null) {
            node.accept(this);
            return this.method;
        }
        assert (!type.isUnknown());
        final CodeGenerator codegen = this;
        node.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(this.lc){

            @Override
            public boolean enterIdentNode(IdentNode identNode) {
                CodeGenerator.this.loadIdent(identNode, type);
                return false;
            }

            @Override
            public boolean enterAccessNode(AccessNode accessNode) {
                if (!baseAlreadyOnStack) {
                    CodeGenerator.this.load(accessNode.getBase(), Type.OBJECT);
                }
                assert (CodeGenerator.this.method.peekType().isObject());
                CodeGenerator.this.method.dynamicGet(type, accessNode.getProperty().getName(), CodeGenerator.this.getCallSiteFlags(), accessNode.isFunction());
                return false;
            }

            @Override
            public boolean enterIndexNode(IndexNode indexNode) {
                if (!baseAlreadyOnStack) {
                    CodeGenerator.this.load(indexNode.getBase(), Type.OBJECT);
                    CodeGenerator.this.load(indexNode.getIndex());
                }
                CodeGenerator.this.method.dynamicGetIndex(type, CodeGenerator.this.getCallSiteFlags(), indexNode.isFunction());
                return false;
            }

            @Override
            public boolean enterFunctionNode(FunctionNode functionNode) {
                this.lc.pop(functionNode);
                functionNode.accept((NodeVisitor)codegen);
                this.lc.push(functionNode);
                CodeGenerator.this.method.convert(type);
                return false;
            }

            @Override
            public boolean enterCallNode(CallNode callNode) {
                return codegen.enterCallNode(callNode, type);
            }

            @Override
            public boolean enterLiteralNode(LiteralNode<?> literalNode) {
                return codegen.enterLiteralNode(literalNode, type);
            }

            @Override
            public boolean enterDefault(Node otherNode) {
                Node currentDiscard = ((CodeGeneratorLexicalContext)codegen.lc).getCurrentDiscard();
                otherNode.accept(codegen);
                if (currentDiscard != otherNode) {
                    CodeGenerator.this.method.load(symbol);
                    assert (CodeGenerator.this.method.peekType() != null);
                    CodeGenerator.this.method.convert(type);
                }
                return false;
            }
        });
        return this.method;
    }

    @Override
    public boolean enterAccessNode(AccessNode accessNode) {
        this.load(accessNode);
        return false;
    }

    private void initSymbols(Iterable<Symbol> symbols) {
        LinkedList<Symbol> numbers = new LinkedList<Symbol>();
        LinkedList<Symbol> objects = new LinkedList<Symbol>();
        for (Symbol symbol : symbols) {
            boolean isInternal;
            boolean bl = isInternal = symbol.isParam() || symbol.isInternal() || symbol.isThis() || !symbol.canBeUndefined();
            if (!symbol.hasSlot() || isInternal) continue;
            assert (symbol.getSymbolType().isNumber() || symbol.getSymbolType().isObject()) : "no potentially undefined narrower local vars than doubles are allowed: " + symbol + " in " + ((CodeGeneratorLexicalContext)this.lc).getCurrentFunction();
            if (symbol.getSymbolType().isNumber()) {
                numbers.add(symbol);
                continue;
            }
            if (!symbol.getSymbolType().isObject()) continue;
            objects.add(symbol);
        }
        this.initSymbols(numbers, Type.NUMBER);
        this.initSymbols(objects, Type.OBJECT);
    }

    private void initSymbols(LinkedList<Symbol> symbols, Type type) {
        Iterator it = symbols.iterator();
        if (it.hasNext()) {
            boolean hasNext;
            this.method.loadUndefined(type);
            do {
                Symbol symbol = (Symbol)it.next();
                hasNext = it.hasNext();
                if (hasNext) {
                    this.method.dup();
                }
                this.method.store(symbol);
            } while (hasNext);
        }
    }

    private void symbolInfo(Block block) {
        for (Symbol symbol : block.getSymbols()) {
            if (!symbol.hasSlot()) continue;
            this.method.localVariable(symbol, block.getEntryLabel(), block.getBreakLabel());
        }
    }

    @Override
    public boolean enterBlock(Block block) {
        if (((CodeGeneratorLexicalContext)this.lc).isFunctionBody() && this.emittedMethods.contains(((CodeGeneratorLexicalContext)this.lc).getCurrentFunction().getName())) {
            return false;
        }
        this.method.label(block.getEntryLabel());
        this.initLocals(block);
        return true;
    }

    @Override
    public Node leaveBlock(Block block) {
        this.method.label(block.getBreakLabel());
        this.symbolInfo(block);
        if (block.needsScope() && !block.isTerminal()) {
            this.popBlockScope(block);
        }
        return block;
    }

    private void popBlockScope(Block block) {
        Label exitLabel = new Label("block_exit");
        Label recoveryLabel = new Label("block_catch");
        Label skipLabel = new Label("skip_catch");
        this.method.loadCompilerConstant(CompilerConstants.SCOPE);
        this.method.invoke(ScriptObject.GET_PROTO);
        this.method.storeCompilerConstant(CompilerConstants.SCOPE);
        this.method._goto(skipLabel);
        this.method.label(exitLabel);
        this.method._catch(recoveryLabel);
        this.method.loadCompilerConstant(CompilerConstants.SCOPE);
        this.method.invoke(ScriptObject.GET_PROTO);
        this.method.storeCompilerConstant(CompilerConstants.SCOPE);
        this.method.athrow();
        this.method.label(skipLabel);
        this.method._try(block.getEntryLabel(), exitLabel, recoveryLabel, Throwable.class);
    }

    @Override
    public boolean enterBreakNode(BreakNode breakNode) {
        this.lineNumber(breakNode);
        BreakableNode breakFrom = ((CodeGeneratorLexicalContext)this.lc).getBreakable(breakNode.getLabel());
        for (int i = 0; i < ((CodeGeneratorLexicalContext)this.lc).getScopeNestingLevelTo(breakFrom); ++i) {
            this.closeWith();
        }
        this.method.splitAwareGoto(this.lc, breakFrom.getBreakLabel());
        return false;
    }

    private int loadArgs(List<Expression> args) {
        return this.loadArgs(args, null, false, args.size());
    }

    private int loadArgs(List<Expression> args, String signature, boolean isVarArg, int argCount) {
        if (isVarArg || argCount > 250) {
            this.loadArgsArray(args);
            return 1;
        }
        int n = 0;
        Type[] params = signature == null ? null : Type.getMethodArguments(signature);
        for (Expression arg : args) {
            assert (arg != null);
            if (n >= argCount) {
                this.load(arg);
                this.method.pop();
            } else if (params != null) {
                this.load(arg, params[n]);
            } else {
                this.load(arg);
            }
            ++n;
        }
        while (n < argCount) {
            this.method.loadUndefined(Type.OBJECT);
            ++n;
        }
        return argCount;
    }

    @Override
    public boolean enterCallNode(CallNode callNode) {
        return this.enterCallNode(callNode, callNode.getType());
    }

    private boolean enterCallNode(final CallNode callNode, final Type callNodeType) {
        this.lineNumber(callNode.getLineNumber());
        final List<Expression> args = callNode.getArgs();
        final Expression function = callNode.getFunction();
        final Block currentBlock = ((CodeGeneratorLexicalContext)this.lc).getCurrentBlock();
        final CodeGeneratorLexicalContext codegenLexicalContext = (CodeGeneratorLexicalContext)this.lc;
        function.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

            private MethodEmitter sharedScopeCall(IdentNode identNode, int flags) {
                Symbol symbol = identNode.getSymbol();
                int scopeCallFlags = flags;
                CodeGenerator.this.method.loadCompilerConstant(CompilerConstants.SCOPE);
                if (CodeGenerator.this.isFastScope(symbol)) {
                    CodeGenerator.this.method.load(CodeGenerator.this.getScopeProtoDepth(currentBlock, symbol));
                    scopeCallFlags |= 0x400;
                } else {
                    CodeGenerator.this.method.load(-1);
                }
                CodeGenerator.this.loadArgs(args);
                Type[] paramTypes = CodeGenerator.this.method.getTypesFromStack(args.size());
                SharedScopeCall scopeCall = codegenLexicalContext.getScopeCall(CodeGenerator.this.unit, symbol, identNode.getType(), callNodeType, paramTypes, scopeCallFlags);
                return scopeCall.generateInvoke(CodeGenerator.this.method);
            }

            private void scopeCall(IdentNode node, int flags) {
                CodeGenerator.this.load(node, Type.OBJECT);
                CodeGenerator.this.method.loadUndefined(Type.OBJECT);
                CodeGenerator.this.method.dynamicCall(callNodeType, 2 + CodeGenerator.this.loadArgs(args), flags);
            }

            private void evalCall(IdentNode node, int flags) {
                CodeGenerator.this.load(node, Type.OBJECT);
                Label not_eval = new Label("not_eval");
                Label eval_done = new Label("eval_done");
                CodeGenerator.this.method.dup();
                CodeGenerator.this.globalIsEval();
                CodeGenerator.this.method.ifeq(not_eval);
                CodeGenerator.this.method.pop();
                CodeGenerator.this.method.loadCompilerConstant(CompilerConstants.SCOPE);
                CallNode.EvalArgs evalArgs = callNode.getEvalArgs();
                CodeGenerator.this.load(evalArgs.getCode(), Type.OBJECT);
                List<Expression> args2 = callNode.getArgs();
                int numArgs = args2.size();
                for (int i = 1; i < numArgs; ++i) {
                    CodeGenerator.this.load(args2.get(i)).pop();
                }
                CodeGenerator.this.load(evalArgs.getThis());
                CodeGenerator.this.method.load(evalArgs.getLocation());
                CodeGenerator.this.method.load(evalArgs.getStrictMode());
                CodeGenerator.this.method.convert(Type.OBJECT);
                CodeGenerator.this.globalDirectEval();
                CodeGenerator.this.method.convert(callNodeType);
                CodeGenerator.this.method._goto(eval_done);
                CodeGenerator.this.method.label(not_eval);
                CodeGenerator.this.method.loadNull();
                CodeGenerator.this.method.dynamicCall(callNodeType, 2 + CodeGenerator.this.loadArgs(args2), flags);
                CodeGenerator.this.method.label(eval_done);
            }

            @Override
            public boolean enterIdentNode(IdentNode node) {
                Symbol symbol = node.getSymbol();
                if (symbol.isScope()) {
                    int flags = CodeGenerator.this.getCallSiteFlags() | 1;
                    int useCount = symbol.getUseCount();
                    if (callNode.isEval()) {
                        this.evalCall(node, flags);
                    } else if (useCount <= 4 || !CodeGenerator.this.isFastScope(symbol) && useCount <= 500 || ((CodeGeneratorLexicalContext)CodeGenerator.this.lc).inDynamicScope()) {
                        this.scopeCall(node, flags);
                    } else {
                        this.sharedScopeCall(node, flags);
                    }
                    assert (CodeGenerator.this.method.peekType().equals(callNodeType)) : CodeGenerator.access$100(CodeGenerator.this).peekType() + "!=" + callNode.getType();
                } else {
                    this.enterDefault(node);
                }
                return false;
            }

            @Override
            public boolean enterAccessNode(AccessNode node) {
                CodeGenerator.this.load(node.getBase(), Type.OBJECT);
                CodeGenerator.this.method.dup();
                CodeGenerator.this.method.dynamicGet(node.getType(), node.getProperty().getName(), CodeGenerator.this.getCallSiteFlags(), true);
                CodeGenerator.this.method.swap();
                CodeGenerator.this.method.dynamicCall(callNodeType, 2 + CodeGenerator.this.loadArgs(args), CodeGenerator.this.getCallSiteFlags());
                return false;
            }

            @Override
            public boolean enterFunctionNode(FunctionNode origCallee) {
                FunctionNode callee = (FunctionNode)origCallee.accept((NodeVisitor)CodeGenerator.this);
                boolean isVarArg = callee.isVarArg();
                int argCount = isVarArg ? -1 : callee.getParameters().size();
                String signature = new FunctionSignature(true, callee.needsCallee(), callee.getReturnType(), isVarArg ? null : callee.getParameters()).toString();
                if (callee.isStrict()) {
                    CodeGenerator.this.method.loadUndefined(Type.OBJECT);
                } else {
                    CodeGenerator.this.globalInstance();
                }
                CodeGenerator.this.loadArgs(args, signature, isVarArg, argCount);
                assert (callee.getCompileUnit() != null) : "no compile unit for " + callee.getName() + " " + Debug.id(callee) + " " + callNode;
                CodeGenerator.this.method.invokestatic(callee.getCompileUnit().getUnitClassName(), callee.getName(), signature);
                assert (CodeGenerator.this.method.peekType().equals(callee.getReturnType())) : CodeGenerator.access$100(CodeGenerator.this).peekType() + " != " + callee.getReturnType();
                CodeGenerator.this.method.convert(callNodeType);
                return false;
            }

            @Override
            public boolean enterIndexNode(IndexNode node) {
                CodeGenerator.this.load(node.getBase(), Type.OBJECT);
                CodeGenerator.this.method.dup();
                Type indexType = node.getIndex().getType();
                if (indexType.isObject() || indexType.isBoolean()) {
                    CodeGenerator.this.load(node.getIndex(), Type.OBJECT);
                } else {
                    CodeGenerator.this.load(node.getIndex());
                }
                CodeGenerator.this.method.dynamicGetIndex(node.getType(), CodeGenerator.this.getCallSiteFlags(), true);
                CodeGenerator.this.method.swap();
                CodeGenerator.this.method.dynamicCall(callNodeType, 2 + CodeGenerator.this.loadArgs(args), CodeGenerator.this.getCallSiteFlags());
                return false;
            }

            @Override
            protected boolean enterDefault(Node node) {
                CodeGenerator.this.load(function, Type.OBJECT);
                CodeGenerator.this.method.loadUndefined(Type.OBJECT);
                CodeGenerator.this.method.dynamicCall(callNodeType, 2 + CodeGenerator.this.loadArgs(args), CodeGenerator.this.getCallSiteFlags() | 1);
                return false;
            }
        });
        this.method.store(callNode.getSymbol());
        return false;
    }

    @Override
    public boolean enterContinueNode(ContinueNode continueNode) {
        this.lineNumber(continueNode);
        LoopNode continueTo = ((CodeGeneratorLexicalContext)this.lc).getContinueTo(continueNode.getLabel());
        for (int i = 0; i < ((CodeGeneratorLexicalContext)this.lc).getScopeNestingLevelTo(continueTo); ++i) {
            this.closeWith();
        }
        this.method.splitAwareGoto(this.lc, continueTo.getContinueLabel());
        return false;
    }

    @Override
    public boolean enterEmptyNode(EmptyNode emptyNode) {
        this.lineNumber(emptyNode);
        return false;
    }

    @Override
    public boolean enterExpressionStatement(ExpressionStatement expressionStatement) {
        this.lineNumber(expressionStatement);
        expressionStatement.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean enterBlockStatement(BlockStatement blockStatement) {
        this.lineNumber(blockStatement);
        blockStatement.getBlock().accept(this);
        return false;
    }

    @Override
    public boolean enterForNode(ForNode forNode) {
        this.lineNumber(forNode);
        if (forNode.isForIn()) {
            this.enterForIn(forNode);
        } else {
            this.enterFor(forNode);
        }
        return false;
    }

    private void enterFor(ForNode forNode) {
        Expression init = forNode.getInit();
        Expression test = forNode.getTest();
        Block body = forNode.getBody();
        Expression modify = forNode.getModify();
        if (init != null) {
            init.accept(this);
        }
        Label loopLabel = new Label("loop");
        Label testLabel = new Label("test");
        this.method._goto(testLabel);
        this.method.label(loopLabel);
        body.accept(this);
        this.method.label(forNode.getContinueLabel());
        if (!body.isTerminal() && modify != null) {
            this.load(modify);
        }
        this.method.label(testLabel);
        if (test != null) {
            new BranchOptimizer(this, this.method).execute(test, loopLabel, true);
        } else {
            this.method._goto(loopLabel);
        }
        this.method.label(forNode.getBreakLabel());
    }

    private void enterForIn(ForNode forNode) {
        Block body = forNode.getBody();
        Expression modify = forNode.getModify();
        final Symbol iter = forNode.getIterator();
        Label loopLabel = new Label("loop");
        Expression init = forNode.getInit();
        this.load(modify, Type.OBJECT);
        this.method.invoke(forNode.isForEach() ? ScriptRuntime.TO_VALUE_ITERATOR : ScriptRuntime.TO_PROPERTY_ITERATOR);
        this.method.store(iter);
        this.method._goto(forNode.getContinueLabel());
        this.method.label(loopLabel);
        new Store<Expression>(init){

            @Override
            protected void storeNonDiscard() {
            }

            @Override
            protected void evaluate() {
                CodeGenerator.this.method.load(iter);
                CodeGenerator.this.method.invoke(CompilerConstants.interfaceCallNoLookup(Iterator.class, "next", Object.class, new Class[0]));
            }
        }.store();
        body.accept(this);
        this.method.label(forNode.getContinueLabel());
        this.method.load(iter);
        this.method.invoke(CompilerConstants.interfaceCallNoLookup(Iterator.class, "hasNext", Boolean.TYPE, new Class[0]));
        this.method.ifne(loopLabel);
        this.method.label(forNode.getBreakLabel());
    }

    private void initLocals(Block block) {
        ((CodeGeneratorLexicalContext)this.lc).nextFreeSlot(block);
        boolean isFunctionBody = ((CodeGeneratorLexicalContext)this.lc).isFunctionBody();
        FunctionNode function = ((CodeGeneratorLexicalContext)this.lc).getCurrentFunction();
        if (isFunctionBody) {
            if (this.method.hasScope()) {
                if (function.needsParentScope()) {
                    this.method.loadCompilerConstant(CompilerConstants.CALLEE);
                    this.method.invoke(ScriptFunction.GET_SCOPE);
                } else {
                    assert (function.hasScopeBlock());
                    this.method.loadNull();
                }
                this.method.storeCompilerConstant(CompilerConstants.SCOPE);
            }
            if (function.needsArguments()) {
                this.initArguments(function);
            }
        }
        if (block.needsScope()) {
            boolean varsInScope = function.allVarsInScope();
            ArrayList<String> nameList = new ArrayList<String>();
            ArrayList<Symbol> locals = new ArrayList<Symbol>();
            ArrayList<Symbol> newSymbols = new ArrayList<Symbol>();
            ArrayList<Symbol> values = new ArrayList<Symbol>();
            boolean hasArguments = function.needsArguments();
            for (Symbol symbol : block.getSymbols()) {
                if (symbol.isInternal() || symbol.isThis() || symbol.isTemp()) continue;
                if (symbol.isVar()) {
                    if (varsInScope || symbol.isScope()) {
                        nameList.add(symbol.getName());
                        newSymbols.add(symbol);
                        values.add(null);
                        assert (symbol.isScope()) : "scope for " + symbol + " should have been set in Lower already " + function.getName();
                        assert (!symbol.hasSlot()) : "slot for " + symbol + " should have been removed in Lower already" + function.getName();
                        continue;
                    }
                    assert (symbol.hasSlot()) : symbol + " should have a slot only, no scope";
                    locals.add(symbol);
                    continue;
                }
                if (!symbol.isParam() || !varsInScope && !hasArguments && !symbol.isScope()) continue;
                nameList.add(symbol.getName());
                newSymbols.add(symbol);
                values.add(hasArguments ? null : symbol);
                assert (symbol.isScope()) : "scope for " + symbol + " should have been set in Lower already " + function.getName() + " varsInScope=" + varsInScope + " hasArguments=" + hasArguments + " symbol.isScope()=" + symbol.isScope();
                assert (!hasArguments || !symbol.hasSlot()) : "slot for " + symbol + " should have been removed in Lower already " + function.getName();
            }
            this.initSymbols(locals);
            new FieldObjectCreator<Symbol>(this, nameList, newSymbols, values, true, hasArguments){

                @Override
                protected void loadValue(Symbol value) {
                    CodeGenerator.this.method.load(value);
                }
            }.makeObject(this.method);
            if (isFunctionBody && function.isProgram()) {
                this.method.invoke(ScriptRuntime.MERGE_SCOPE);
            }
            this.method.storeCompilerConstant(CompilerConstants.SCOPE);
        } else {
            int nextParam = 0;
            if (isFunctionBody && function.isVarArg()) {
                for (IdentNode param : function.getParameters()) {
                    param.getSymbol().setFieldIndex(nextParam++);
                }
            }
            this.initSymbols(block.getSymbols());
        }
        this.printSymbols(block, (isFunctionBody ? "Function " : "Block in ") + (function.getIdent() == null ? "<anonymous>" : function.getIdent().getName()));
    }

    private void initArguments(FunctionNode function) {
        this.method.loadCompilerConstant(CompilerConstants.VARARGS);
        if (function.needsCallee()) {
            this.method.loadCompilerConstant(CompilerConstants.CALLEE);
        } else {
            assert (function.isStrict());
            this.method.loadNull();
        }
        this.method.load(function.getParameters().size());
        this.globalAllocateArguments();
        this.method.storeCompilerConstant(CompilerConstants.ARGUMENTS);
    }

    @Override
    public boolean enterFunctionNode(FunctionNode functionNode) {
        if (functionNode.isLazy()) {
            this.newFunctionObject(functionNode, functionNode);
            return false;
        }
        String fnName = functionNode.getName();
        if (!this.emittedMethods.contains(fnName)) {
            LOG.info("=== BEGIN ", fnName);
            assert (functionNode.getCompileUnit() != null) : "no compile unit for " + fnName + " " + Debug.id(functionNode);
            this.unit = ((CodeGeneratorLexicalContext)this.lc).pushCompileUnit(functionNode.getCompileUnit());
            assert (((CodeGeneratorLexicalContext)this.lc).hasCompileUnits());
            this.method = ((CodeGeneratorLexicalContext)this.lc).pushMethodEmitter(this.unit.getClassEmitter().method(functionNode));
            this.lastLineNumber = -1;
            this.method.begin();
        }
        return true;
    }

    @Override
    public Node leaveFunctionNode(FunctionNode functionNode) {
        try {
            if (this.emittedMethods.add(functionNode.getName())) {
                this.method.end();
                this.unit = ((CodeGeneratorLexicalContext)this.lc).popCompileUnit(functionNode.getCompileUnit());
                this.method = ((CodeGeneratorLexicalContext)this.lc).popMethodEmitter(this.method);
                LOG.info("=== END ", functionNode.getName());
            }
            FunctionNode newFunctionNode = functionNode.setState(this.lc, FunctionNode.CompilationState.EMITTED);
            this.newFunctionObject(newFunctionNode, functionNode);
            return newFunctionNode;
        }
        catch (Throwable t) {
            Context.printStackTrace(t);
            VerifyError e = new VerifyError("Code generation bug in \"" + functionNode.getName() + "\": likely stack misaligned: " + t + " " + functionNode.getSource().getName());
            e.initCause(t);
            throw e;
        }
    }

    @Override
    public boolean enterIdentNode(IdentNode identNode) {
        return false;
    }

    @Override
    public boolean enterIfNode(IfNode ifNode) {
        this.lineNumber(ifNode);
        Expression test = ifNode.getTest();
        Block pass = ifNode.getPass();
        Block fail = ifNode.getFail();
        Label failLabel = new Label("if_fail");
        Label afterLabel = fail == null ? failLabel : new Label("if_done");
        new BranchOptimizer(this, this.method).execute(test, failLabel, false);
        boolean passTerminal = false;
        boolean failTerminal = false;
        pass.accept(this);
        if (!pass.hasTerminalFlags()) {
            this.method._goto(afterLabel);
        } else {
            passTerminal = pass.isTerminal();
        }
        if (fail != null) {
            this.method.label(failLabel);
            fail.accept(this);
            failTerminal = fail.isTerminal();
        }
        if (!passTerminal || !failTerminal) {
            this.method.label(afterLabel);
        }
        return false;
    }

    @Override
    public boolean enterIndexNode(IndexNode indexNode) {
        this.load(indexNode);
        return false;
    }

    private void lineNumber(Statement statement) {
        this.lineNumber(statement.getLineNumber());
    }

    private void lineNumber(int lineNumber) {
        if (lineNumber != this.lastLineNumber) {
            this.method.lineNumber(lineNumber);
        }
        this.lastLineNumber = lineNumber;
    }

    private MethodEmitter loadArray(LiteralNode.ArrayLiteralNode arrayLiteralNode, ArrayType arrayType) {
        assert (arrayType == Type.INT_ARRAY || arrayType == Type.LONG_ARRAY || arrayType == Type.NUMBER_ARRAY || arrayType == Type.OBJECT_ARRAY);
        Expression[] nodes = (Expression[])arrayLiteralNode.getValue();
        Object presets = arrayLiteralNode.getPresets();
        int[] postsets = arrayLiteralNode.getPostsets();
        Class<?> type = arrayType.getTypeClass();
        List<LiteralNode.ArrayLiteralNode.ArrayUnit> units = arrayLiteralNode.getUnits();
        this.loadConstant(presets);
        Type elementType = arrayType.getElementType();
        if (units != null) {
            MethodEmitter savedMethod = this.method;
            FunctionNode currentFunction = ((CodeGeneratorLexicalContext)this.lc).getCurrentFunction();
            for (LiteralNode.ArrayLiteralNode.ArrayUnit arrayUnit : units) {
                this.unit = ((CodeGeneratorLexicalContext)this.lc).pushCompileUnit(arrayUnit.getCompileUnit());
                String className = this.unit.getUnitClassName();
                String name = currentFunction.uniqueName(CompilerConstants.SPLIT_PREFIX.symbolName());
                String signature = CompilerConstants.methodDescriptor(type, ScriptFunction.class, Object.class, ScriptObject.class, type);
                MethodEmitter me = this.unit.getClassEmitter().method(EnumSet.of(ClassEmitter.Flag.PUBLIC, ClassEmitter.Flag.STATIC), name, signature);
                this.method = ((CodeGeneratorLexicalContext)this.lc).pushMethodEmitter(me);
                this.method.setFunctionNode(currentFunction);
                this.method.begin();
                this.fixScopeSlot(currentFunction);
                this.method.load(arrayType, CompilerConstants.SPLIT_ARRAY_ARG.slot());
                for (int i = arrayUnit.getLo(); i < arrayUnit.getHi(); ++i) {
                    this.storeElement(nodes, elementType, postsets[i]);
                }
                this.method._return();
                this.method.end();
                this.method = ((CodeGeneratorLexicalContext)this.lc).popMethodEmitter(me);
                assert (this.method == savedMethod);
                this.method.loadCompilerConstant(CompilerConstants.CALLEE);
                this.method.swap();
                this.method.loadCompilerConstant(CompilerConstants.THIS);
                this.method.swap();
                this.method.loadCompilerConstant(CompilerConstants.SCOPE);
                this.method.swap();
                this.method.invokestatic(className, name, signature);
                this.unit = ((CodeGeneratorLexicalContext)this.lc).popCompileUnit(this.unit);
            }
            return this.method;
        }
        for (int postset : postsets) {
            this.storeElement(nodes, elementType, postset);
        }
        return this.method;
    }

    private void storeElement(Expression[] nodes, Type elementType, int index) {
        this.method.dup();
        this.method.load(index);
        Expression element = nodes[index];
        if (element == null) {
            this.method.loadEmpty(elementType);
        } else {
            this.load(element, elementType);
        }
        this.method.arraystore();
    }

    private MethodEmitter loadArgsArray(List<Expression> args) {
        Object[] array = new Object[args.size()];
        this.loadConstant(array);
        for (int i = 0; i < args.size(); ++i) {
            this.method.dup();
            this.method.load(i);
            this.load(args.get(i), Type.OBJECT);
            this.method.arraystore();
        }
        return this.method;
    }

    void loadConstant(String string) {
        String unitClassName = this.unit.getUnitClassName();
        ClassEmitter classEmitter = this.unit.getClassEmitter();
        int index = this.compiler.getConstantData().add(string);
        this.method.load(index);
        this.method.invokestatic(unitClassName, CompilerConstants.GET_STRING.symbolName(), CompilerConstants.methodDescriptor(String.class, Integer.TYPE));
        classEmitter.needGetConstantMethod(String.class);
    }

    void loadConstant(Object object) {
        String unitClassName = this.unit.getUnitClassName();
        ClassEmitter classEmitter = this.unit.getClassEmitter();
        int index = this.compiler.getConstantData().add(object);
        Class<?> cls = object.getClass();
        if (cls == PropertyMap.class) {
            this.method.load(index);
            this.method.invokestatic(unitClassName, CompilerConstants.GET_MAP.symbolName(), CompilerConstants.methodDescriptor(PropertyMap.class, Integer.TYPE));
            classEmitter.needGetConstantMethod(PropertyMap.class);
        } else if (cls.isArray()) {
            this.method.load(index);
            String methodName = ClassEmitter.getArrayMethodName(cls);
            this.method.invokestatic(unitClassName, methodName, CompilerConstants.methodDescriptor(cls, Integer.TYPE));
            classEmitter.needGetConstantMethod(cls);
        } else {
            this.method.loadConstants().load(index).arrayload();
            if (object instanceof ArrayData) {
                this.method.checkcast(ArrayData.class);
                this.method.invoke(CompilerConstants.virtualCallNoLookup(ArrayData.class, "copy", ArrayData.class, new Class[0]));
            } else if (cls != Object.class) {
                this.method.checkcast(cls);
            }
        }
    }

    private MethodEmitter loadLiteral(LiteralNode<?> node, Type type) {
        Object value = node.getValue();
        if (value == null) {
            this.method.loadNull();
        } else if (value instanceof Undefined) {
            this.method.loadUndefined(Type.OBJECT);
        } else if (value instanceof String) {
            String string = (String)value;
            if (string.length() > 10922) {
                this.loadConstant(string);
            } else {
                this.method.load(string);
            }
        } else if (value instanceof Lexer.RegexToken) {
            this.loadRegex((Lexer.RegexToken)value);
        } else if (value instanceof Boolean) {
            this.method.load((Boolean)value);
        } else if (value instanceof Integer) {
            if (type.isEquivalentTo(Type.NUMBER)) {
                this.method.load(((Integer)value).doubleValue());
            } else if (type.isEquivalentTo(Type.LONG)) {
                this.method.load(((Integer)value).longValue());
            } else {
                this.method.load((Integer)value);
            }
        } else if (value instanceof Long) {
            if (type.isEquivalentTo(Type.NUMBER)) {
                this.method.load(((Long)value).doubleValue());
            } else {
                this.method.load((Long)value);
            }
        } else if (value instanceof Double) {
            this.method.load((Double)value);
        } else if (node instanceof LiteralNode.ArrayLiteralNode) {
            LiteralNode.ArrayLiteralNode arrayLiteral = (LiteralNode.ArrayLiteralNode)node;
            ArrayType atype = arrayLiteral.getArrayType();
            this.loadArray(arrayLiteral, atype);
            this.globalAllocateArray(atype);
        } else assert (false) : "Unknown literal for " + node.getClass() + " " + value.getClass() + " " + value;
        return this.method;
    }

    private MethodEmitter loadRegexToken(Lexer.RegexToken value) {
        this.method.load(value.getExpression());
        this.method.load(value.getOptions());
        return this.globalNewRegExp();
    }

    private MethodEmitter loadRegex(Lexer.RegexToken regexToken) {
        if (this.regexFieldCount > 2048) {
            return this.loadRegexToken(regexToken);
        }
        String regexName = ((CodeGeneratorLexicalContext)this.lc).getCurrentFunction().uniqueName(CompilerConstants.REGEX_PREFIX.symbolName());
        ClassEmitter classEmitter = this.unit.getClassEmitter();
        classEmitter.field(EnumSet.of(ClassEmitter.Flag.PRIVATE, ClassEmitter.Flag.STATIC), regexName, Object.class);
        ++this.regexFieldCount;
        this.method.getStatic(this.unit.getUnitClassName(), regexName, CompilerConstants.typeDescriptor(Object.class));
        this.method.dup();
        Label cachedLabel = new Label("cached");
        this.method.ifnonnull(cachedLabel);
        this.method.pop();
        this.loadRegexToken(regexToken);
        this.method.dup();
        this.method.putStatic(this.unit.getUnitClassName(), regexName, CompilerConstants.typeDescriptor(Object.class));
        this.method.label(cachedLabel);
        this.globalRegExpCopy();
        return this.method;
    }

    @Override
    public boolean enterLiteralNode(LiteralNode<?> literalNode) {
        return this.enterLiteralNode(literalNode, literalNode.getType());
    }

    private boolean enterLiteralNode(LiteralNode<?> literalNode, Type type) {
        assert (literalNode.getSymbol() != null) : literalNode + " has no symbol";
        this.loadLiteral(literalNode, type).convert(type).store(literalNode.getSymbol());
        return false;
    }

    @Override
    public boolean enterObjectNode(ObjectNode objectNode) {
        List<PropertyNode> elements = objectNode.getElements();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        ArrayList<Expression> values = new ArrayList<Expression>();
        boolean hasGettersSetters = false;
        Expression protoNode = null;
        for (PropertyNode propertyNode : elements) {
            Symbol symbol;
            Expression value = propertyNode.getValue();
            String key = propertyNode.getKeyName();
            Symbol symbol2 = symbol = value == null ? null : propertyNode.getKey().getSymbol();
            if (value == null) {
                hasGettersSetters = true;
            } else if (propertyNode.getKey() instanceof IdentNode && key.equals("__proto__")) {
                protoNode = value;
                continue;
            }
            keys.add(key);
            symbols.add(symbol);
            values.add(value);
        }
        if (elements.size() > 300) {
            new SpillObjectCreator(this, keys, symbols, values).makeObject(this.method);
        } else {
            new FieldObjectCreator<Expression>(this, keys, symbols, values){

                @Override
                protected void loadValue(Expression node) {
                    CodeGenerator.this.load(node);
                }

                @Override
                protected MapCreator newMapCreator(Class<?> fieldObjectClass) {
                    return new MapCreator(fieldObjectClass, this.keys, this.symbols){

                        @Override
                        protected int getPropertyFlags(Symbol symbol, boolean hasArguments) {
                            return super.getPropertyFlags(symbol, hasArguments) | 0x40;
                        }
                    };
                }
            }.makeObject(this.method);
        }
        this.method.dup();
        if (protoNode != null) {
            this.load(protoNode);
            this.method.convert(Type.OBJECT);
            this.method.invoke(ScriptObject.SET_PROTO_FROM_LITERAL);
        } else {
            this.globalObjectPrototype();
            this.method.invoke(ScriptObject.SET_PROTO);
        }
        if (hasGettersSetters) {
            for (PropertyNode propertyNode : elements) {
                FunctionNode getter = propertyNode.getGetter();
                FunctionNode setter = propertyNode.getSetter();
                if (getter == null && setter == null) continue;
                this.method.dup().loadKey(propertyNode.getKey());
                if (getter == null) {
                    this.method.loadNull();
                } else {
                    getter.accept((NodeVisitor)this);
                }
                if (setter == null) {
                    this.method.loadNull();
                } else {
                    setter.accept((NodeVisitor)this);
                }
                this.method.invoke(ScriptObject.SET_USER_ACCESSORS);
            }
        }
        this.method.store(objectNode.getSymbol());
        return false;
    }

    @Override
    public boolean enterReturnNode(ReturnNode returnNode) {
        this.lineNumber(returnNode);
        this.method.registerReturn();
        Type returnType = ((CodeGeneratorLexicalContext)this.lc).getCurrentFunction().getReturnType();
        Expression expression = returnNode.getExpression();
        if (expression != null) {
            this.load(expression);
        } else {
            this.method.loadUndefined(returnType);
        }
        this.method._return(returnType);
        return false;
    }

    private static boolean isNullLiteral(Node node) {
        return node instanceof LiteralNode && ((LiteralNode)node).isNull();
    }

    private boolean nullCheck(RuntimeNode runtimeNode, List<Expression> args, String signature) {
        RuntimeNode.Request request = runtimeNode.getRequest();
        if (!RuntimeNode.Request.isEQ(request) && !RuntimeNode.Request.isNE(request)) {
            return false;
        }
        assert (args.size() == 2) : "EQ or NE or TYPEOF need two args";
        Expression lhs = args.get(0);
        Expression rhs = args.get(1);
        if (CodeGenerator.isNullLiteral(lhs)) {
            Expression tmp = lhs;
            lhs = rhs;
            rhs = tmp;
        }
        if (CodeGenerator.isNullLiteral(rhs) && lhs.getType().isObject()) {
            Label trueLabel = new Label("trueLabel");
            Label falseLabel = new Label("falseLabel");
            Label endLabel = new Label("end");
            this.load(lhs);
            this.method.dup();
            if (RuntimeNode.Request.isEQ(request)) {
                this.method.ifnull(trueLabel);
            } else if (RuntimeNode.Request.isNE(request)) {
                this.method.ifnonnull(trueLabel);
            } else assert (false) : "Invalid request " + (Object)((Object)request);
            this.method.label(falseLabel);
            this.load(rhs);
            this.method.invokestatic(CompilerConstants.className(ScriptRuntime.class), request.toString(), signature);
            this.method._goto(endLabel);
            this.method.label(trueLabel);
            if (request == RuntimeNode.Request.NE) {
                this.method.loadUndefined(Type.OBJECT);
                Label isUndefined = new Label("isUndefined");
                Label afterUndefinedCheck = new Label("afterUndefinedCheck");
                this.method.if_acmpeq(isUndefined);
                this.method.load(true);
                this.method._goto(afterUndefinedCheck);
                this.method.label(isUndefined);
                this.method.load(false);
                this.method.label(afterUndefinedCheck);
            } else {
                this.method.pop();
                this.method.load(true);
            }
            this.method.label(endLabel);
            this.method.convert(runtimeNode.getType());
            this.method.store(runtimeNode.getSymbol());
            return true;
        }
        return false;
    }

    private boolean specializationCheck(RuntimeNode.Request request, Expression node, List<Expression> args) {
        if (!request.canSpecialize()) {
            return false;
        }
        assert (args.size() == 2);
        Type returnType = node.getType();
        this.load(args.get(0));
        this.load(args.get(1));
        RuntimeNode.Request finalRequest = request;
        RuntimeNode.Request reverse = RuntimeNode.Request.reverse(request);
        if (this.method.peekType().isObject() && reverse != null && !this.method.peekType(1).isObject()) {
            this.method.swap();
            finalRequest = reverse;
        }
        this.method.dynamicRuntimeCall(new RuntimeCallSite.SpecializedRuntimeNode(finalRequest, new Type[]{this.method.peekType(1), this.method.peekType()}, returnType).getInitialName(), returnType, finalRequest);
        this.method.convert(node.getType());
        this.method.store(node.getSymbol());
        return true;
    }

    private static boolean isReducible(RuntimeNode.Request request) {
        return RuntimeNode.Request.isComparison(request) || request == RuntimeNode.Request.ADD;
    }

    @Override
    public boolean enterRuntimeNode(RuntimeNode runtimeNode) {
        List<Expression> args = runtimeNode.getArgs();
        if (runtimeNode.isPrimitive() && !runtimeNode.isFinal() && CodeGenerator.isReducible(runtimeNode.getRequest())) {
            Expression lhs = args.get(0);
            assert (args.size() > 1) : runtimeNode + " must have two args";
            Expression rhs = args.get(1);
            Type type = runtimeNode.getType();
            Symbol symbol = runtimeNode.getSymbol();
            switch (runtimeNode.getRequest()) {
                case EQ: 
                case EQ_STRICT: {
                    return this.enterCmp(lhs, rhs, Condition.EQ, type, symbol);
                }
                case NE: 
                case NE_STRICT: {
                    return this.enterCmp(lhs, rhs, Condition.NE, type, symbol);
                }
                case LE: {
                    return this.enterCmp(lhs, rhs, Condition.LE, type, symbol);
                }
                case LT: {
                    return this.enterCmp(lhs, rhs, Condition.LT, type, symbol);
                }
                case GE: {
                    return this.enterCmp(lhs, rhs, Condition.GE, type, symbol);
                }
                case GT: {
                    return this.enterCmp(lhs, rhs, Condition.GT, type, symbol);
                }
                case ADD: {
                    Type widest = Type.widest(lhs.getType(), rhs.getType());
                    this.load(lhs, widest);
                    this.load(rhs, widest);
                    this.method.add();
                    this.method.convert(type);
                    this.method.store(symbol);
                    return false;
                }
            }
        }
        if (this.nullCheck(runtimeNode, args, new FunctionSignature(false, false, runtimeNode.getType(), args).toString())) {
            return false;
        }
        if (!runtimeNode.isFinal() && this.specializationCheck(runtimeNode.getRequest(), runtimeNode, args)) {
            return false;
        }
        for (Expression arg : args) {
            this.load(arg, Type.OBJECT);
        }
        this.method.invokestatic(CompilerConstants.className(ScriptRuntime.class), runtimeNode.getRequest().toString(), new FunctionSignature(false, false, runtimeNode.getType(), args.size()).toString());
        this.method.convert(runtimeNode.getType());
        this.method.store(runtimeNode.getSymbol());
        return false;
    }

    @Override
    public boolean enterSplitNode(SplitNode splitNode) {
        Class[] classArray;
        CompileUnit splitCompileUnit = splitNode.getCompileUnit();
        FunctionNode fn = ((CodeGeneratorLexicalContext)this.lc).getCurrentFunction();
        String className = splitCompileUnit.getUnitClassName();
        String name = splitNode.getName();
        Class<?> rtype = fn.getReturnType().getTypeClass();
        boolean needsArguments = fn.needsArguments();
        if (needsArguments) {
            Class[] classArray2 = new Class[4];
            classArray2[0] = ScriptFunction.class;
            classArray2[1] = Object.class;
            classArray2[2] = ScriptObject.class;
            classArray = classArray2;
            classArray2[3] = Object.class;
        } else {
            Class[] classArray3 = new Class[3];
            classArray3[0] = ScriptFunction.class;
            classArray3[1] = Object.class;
            classArray = classArray3;
            classArray3[2] = ScriptObject.class;
        }
        Class[] ptypes = classArray;
        MethodEmitter caller = this.method;
        this.unit = ((CodeGeneratorLexicalContext)this.lc).pushCompileUnit(splitCompileUnit);
        CompilerConstants.Call splitCall = CompilerConstants.staticCallNoLookup(className, name, CompilerConstants.methodDescriptor(rtype, ptypes));
        SplitMethodEmitter splitEmitter = splitCompileUnit.getClassEmitter().method(splitNode, name, rtype, ptypes);
        this.method = ((CodeGeneratorLexicalContext)this.lc).pushMethodEmitter(splitEmitter);
        this.method.setFunctionNode(fn);
        assert (fn.needsCallee()) : "split function should require callee";
        caller.loadCompilerConstant(CompilerConstants.CALLEE);
        caller.loadCompilerConstant(CompilerConstants.THIS);
        caller.loadCompilerConstant(CompilerConstants.SCOPE);
        if (needsArguments) {
            caller.loadCompilerConstant(CompilerConstants.ARGUMENTS);
        }
        caller.invoke(splitCall);
        caller.storeCompilerConstant(CompilerConstants.RETURN);
        this.method.begin();
        this.fixScopeSlot(fn);
        this.method.loadUndefined(fn.getReturnType());
        this.method.storeCompilerConstant(CompilerConstants.RETURN);
        return true;
    }

    private void fixScopeSlot(FunctionNode functionNode) {
        if (functionNode.compilerConstant(CompilerConstants.SCOPE).getSlot() != CompilerConstants.SCOPE.slot()) {
            this.method.load(Type.typeFor(ScriptObject.class), CompilerConstants.SCOPE.slot());
            this.method.storeCompilerConstant(CompilerConstants.SCOPE);
        }
    }

    @Override
    public Node leaveSplitNode(SplitNode splitNode) {
        assert (this.method instanceof SplitMethodEmitter);
        boolean hasReturn = this.method.hasReturn();
        List<Label> targets = this.method.getExternalTargets();
        try {
            this.method.loadCompilerConstant(CompilerConstants.RETURN);
            this.method._return(((CodeGeneratorLexicalContext)this.lc).getCurrentFunction().getReturnType());
            this.method.end();
            this.unit = ((CodeGeneratorLexicalContext)this.lc).popCompileUnit(splitNode.getCompileUnit());
            this.method = ((CodeGeneratorLexicalContext)this.lc).popMethodEmitter(this.method);
        }
        catch (Throwable t) {
            Context.printStackTrace(t);
            VerifyError e = new VerifyError("Code generation bug in \"" + splitNode.getName() + "\": likely stack misaligned: " + t + " " + ((CodeGeneratorLexicalContext)this.lc).getCurrentFunction().getSource().getName());
            e.initCause(t);
            throw e;
        }
        MethodEmitter caller = this.method;
        int targetCount = targets.size();
        if (!hasReturn && targets.isEmpty()) {
            return splitNode;
        }
        caller.loadCompilerConstant(CompilerConstants.SCOPE);
        caller.checkcast(Scope.class);
        caller.invoke(Scope.GET_SPLIT_STATE);
        Label breakLabel = new Label("no_split_state");
        if (targetCount == 0) {
            assert (hasReturn);
            caller.ifne(breakLabel);
            caller.label(new Label("split_return"));
            caller.loadCompilerConstant(CompilerConstants.RETURN);
            caller._return(((CodeGeneratorLexicalContext)this.lc).getCurrentFunction().getReturnType());
            caller.label(breakLabel);
        } else {
            int i;
            assert (!targets.isEmpty());
            int low = hasReturn ? 0 : 1;
            int labelCount = targetCount + 1 - low;
            Label[] labels = new Label[labelCount];
            for (i = 0; i < labelCount; ++i) {
                labels[i] = new Label(i == 0 ? "split_return" : "split_" + targets.get(i - 1));
            }
            caller.tableswitch(low, targetCount, breakLabel, labels);
            for (i = low; i <= targetCount; ++i) {
                caller.label(labels[i - low]);
                if (i == 0) {
                    caller.loadCompilerConstant(CompilerConstants.RETURN);
                    caller._return(((CodeGeneratorLexicalContext)this.lc).getCurrentFunction().getReturnType());
                    continue;
                }
                caller.loadCompilerConstant(CompilerConstants.SCOPE);
                caller.checkcast(Scope.class);
                caller.load(-1);
                caller.invoke(Scope.SET_SPLIT_STATE);
                caller.splitAwareGoto(this.lc, targets.get(i - 1));
            }
            caller.label(breakLabel);
        }
        if (hasReturn) {
            caller.setHasReturn();
        }
        return splitNode;
    }

    @Override
    public boolean enterSwitchNode(SwitchNode switchNode) {
        Label breakLabel;
        this.lineNumber(switchNode);
        Expression expression = switchNode.getExpression();
        Symbol tag = switchNode.getTag();
        boolean allInteger = tag.getSymbolType().isInteger();
        List<CaseNode> cases = switchNode.getCases();
        CaseNode defaultCase = switchNode.getDefaultCase();
        Label defaultLabel = breakLabel = switchNode.getBreakLabel();
        boolean hasDefault = false;
        if (defaultCase != null) {
            defaultLabel = defaultCase.getEntry();
            hasDefault = true;
        }
        if (cases.isEmpty()) {
            this.load(expression).pop();
            this.method.label(breakLabel);
            return false;
        }
        if (allInteger) {
            int i;
            int value;
            TreeMap<Integer, Label> tree = new TreeMap<Integer, Label>();
            for (CaseNode caseNode : cases) {
                Expression test = caseNode.getTest();
                if (test == null) continue;
                Integer value2 = (Integer)((LiteralNode)test).getValue();
                Label entry = caseNode.getEntry();
                if (tree.containsKey(value2)) continue;
                tree.put(value2, entry);
            }
            int size = tree.size();
            Integer[] values = tree.keySet().toArray(new Integer[size]);
            Label[] labels = tree.values().toArray(new Label[size]);
            int lo = values[0];
            int hi = values[size - 1];
            int range = hi - lo + 1;
            int deflt = Integer.MIN_VALUE;
            Integer[] integerArray = values;
            int n = integerArray.length;
            for (int j = 0; j < n; ++j) {
                value = integerArray[j];
                if (deflt == value) {
                    ++deflt;
                    continue;
                }
                if (deflt < value) break;
            }
            this.load(expression);
            Type type = expression.getType();
            if (!type.isInteger()) {
                this.method.load(deflt);
                Class<?> exprClass = type.getTypeClass();
                this.method.invoke(CompilerConstants.staticCallNoLookup(ScriptRuntime.class, "switchTagAsInt", Integer.TYPE, exprClass.isPrimitive() ? exprClass : Object.class, Integer.TYPE));
            }
            if (range > 0 && range < 4096 && range < size * 5 / 4) {
                Object[] table = new Label[range];
                Arrays.fill(table, defaultLabel);
                for (i = 0; i < size; ++i) {
                    value = values[i];
                    table[value - lo] = labels[i];
                }
                this.method.tableswitch(lo, hi, defaultLabel, (Label[])table);
            } else {
                int[] ints = new int[size];
                for (i = 0; i < size; ++i) {
                    ints[i] = values[i];
                }
                this.method.lookupswitch(defaultLabel, ints, labels);
            }
        } else {
            this.load(expression, Type.OBJECT);
            this.method.store(tag);
            for (CaseNode caseNode : cases) {
                Expression test = caseNode.getTest();
                if (test == null) continue;
                this.method.load(tag);
                this.load(test, Type.OBJECT);
                this.method.invoke(ScriptRuntime.EQ_STRICT);
                this.method.ifne(caseNode.getEntry());
            }
            this.method._goto(hasDefault ? defaultLabel : breakLabel);
        }
        for (CaseNode caseNode : cases) {
            this.method.label(caseNode.getEntry());
            caseNode.getBody().accept(this);
        }
        if (!switchNode.isTerminal()) {
            this.method.label(breakLabel);
        }
        return false;
    }

    @Override
    public boolean enterThrowNode(ThrowNode throwNode) {
        this.lineNumber(throwNode);
        if (throwNode.isSyntheticRethrow()) {
            this.load(throwNode.getExpression());
            this.method.athrow();
            return false;
        }
        Source source = ((CodeGeneratorLexicalContext)this.lc).getCurrentFunction().getSource();
        Expression expression = throwNode.getExpression();
        int position = throwNode.position();
        int line = throwNode.getLineNumber();
        int column = source.getColumn(position);
        this.load(expression, Type.OBJECT);
        this.method.load(source.getName());
        this.method.load(line);
        this.method.load(column);
        this.method.invoke(ECMAException.CREATE);
        this.method.athrow();
        return false;
    }

    @Override
    public boolean enterTryNode(TryNode tryNode) {
        this.lineNumber(tryNode);
        Block body = tryNode.getBody();
        List<Block> catchBlocks = tryNode.getCatchBlocks();
        final Symbol symbol = tryNode.getException();
        Label entry = new Label("try");
        Label recovery = new Label("catch");
        Label exit = tryNode.getExit();
        Label skip = new Label("skip");
        this.method.label(entry);
        body.accept(this);
        if (!body.hasTerminalFlags()) {
            this.method._goto(skip);
        }
        this.method.label(exit);
        this.method._catch(recovery);
        this.method.store(symbol);
        for (int i = 0; i < catchBlocks.size(); ++i) {
            Label next;
            Block catchBlock = catchBlocks.get(i);
            ((CodeGeneratorLexicalContext)this.lc).push(catchBlock);
            this.enterBlock(catchBlock);
            final CatchNode catchNode = (CatchNode)catchBlocks.get(i).getStatements().get(0);
            IdentNode exception = catchNode.getException();
            Expression exceptionCondition = catchNode.getExceptionCondition();
            Block catchBody = catchNode.getBody();
            new Store<IdentNode>(exception){

                @Override
                protected void storeNonDiscard() {
                }

                @Override
                protected void evaluate() {
                    if (catchNode.isSyntheticRethrow()) {
                        CodeGenerator.this.method.load(symbol);
                        return;
                    }
                    Label notEcmaException = new Label("no_ecma_exception");
                    CodeGenerator.this.method.load(symbol).dup()._instanceof(ECMAException.class).ifeq(notEcmaException);
                    CodeGenerator.this.method.checkcast(ECMAException.class);
                    CodeGenerator.this.method.getField(ECMAException.THROWN);
                    CodeGenerator.this.method.label(notEcmaException);
                }
            }.store();
            if (exceptionCondition != null) {
                next = new Label("next");
                this.load(exceptionCondition, Type.BOOLEAN).ifeq(next);
            } else {
                next = null;
            }
            catchBody.accept(this);
            if (i + 1 != catchBlocks.size() && !catchBody.hasTerminalFlags()) {
                this.method._goto(skip);
            }
            if (next != null) {
                if (i + 1 == catchBlocks.size()) {
                    this.method._goto(skip);
                    this.method.label(next);
                    this.method.load(symbol).athrow();
                } else {
                    this.method.label(next);
                }
            }
            this.leaveBlock(catchBlock);
            ((CodeGeneratorLexicalContext)this.lc).pop(catchBlock);
        }
        this.method.label(skip);
        this.method._try(entry, exit, recovery, Throwable.class);
        return false;
    }

    @Override
    public boolean enterVarNode(VarNode varNode) {
        Expression init = varNode.getInit();
        if (init == null) {
            return false;
        }
        this.lineNumber(varNode);
        IdentNode identNode = varNode.getName();
        Symbol identSymbol = identNode.getSymbol();
        assert (identSymbol != null) : "variable node " + varNode + " requires a name with a symbol";
        assert (this.method != null);
        boolean needsScope = identSymbol.isScope();
        if (needsScope) {
            this.method.loadCompilerConstant(CompilerConstants.SCOPE);
        }
        if (needsScope) {
            this.load(init);
            int flags = 1 | this.getCallSiteFlags();
            if (this.isFastScope(identSymbol)) {
                this.storeFastScopeVar(identSymbol, flags);
            } else {
                this.method.dynamicSet(identNode.getName(), flags);
            }
        } else {
            this.load(init, identNode.getType());
            this.method.store(identSymbol);
        }
        return false;
    }

    @Override
    public boolean enterWhileNode(WhileNode whileNode) {
        Expression test = whileNode.getTest();
        Block body = whileNode.getBody();
        Label breakLabel = whileNode.getBreakLabel();
        Label continueLabel = whileNode.getContinueLabel();
        boolean isDoWhile = whileNode.isDoWhile();
        Label loopLabel = new Label("loop");
        if (!isDoWhile) {
            this.method._goto(continueLabel);
        }
        this.method.label(loopLabel);
        body.accept(this);
        if (!whileNode.isTerminal()) {
            this.method.label(continueLabel);
            this.lineNumber(whileNode);
            new BranchOptimizer(this, this.method).execute(test, loopLabel, true);
            this.method.label(breakLabel);
        }
        return false;
    }

    private void closeWith() {
        if (this.method.hasScope()) {
            this.method.loadCompilerConstant(CompilerConstants.SCOPE);
            this.method.invoke(ScriptRuntime.CLOSE_WITH);
            this.method.storeCompilerConstant(CompilerConstants.SCOPE);
        }
    }

    @Override
    public boolean enterWithNode(WithNode withNode) {
        Label tryLabel;
        Expression expression = withNode.getExpression();
        Block body = withNode.getBody();
        boolean hasScope = this.method.hasScope();
        if (hasScope) {
            tryLabel = new Label("with_try");
            this.method.label(tryLabel);
            this.method.loadCompilerConstant(CompilerConstants.SCOPE);
        } else {
            tryLabel = null;
        }
        this.load(expression, Type.OBJECT);
        if (hasScope) {
            this.method.invoke(ScriptRuntime.OPEN_WITH);
            this.method.storeCompilerConstant(CompilerConstants.SCOPE);
        } else {
            this.globalCheckObjectCoercible();
        }
        ((Node)body).accept(this);
        if (hasScope) {
            Label endLabel = new Label("with_end");
            Label catchLabel = new Label("with_catch");
            Label exitLabel = new Label("with_exit");
            if (!((Node)body).isTerminal()) {
                this.closeWith();
                this.method._goto(exitLabel);
            }
            this.method.label(endLabel);
            this.method._catch(catchLabel);
            this.closeWith();
            this.method.athrow();
            this.method.label(exitLabel);
            this.method._try(tryLabel, endLabel, catchLabel);
        }
        return false;
    }

    @Override
    public boolean enterADD(UnaryNode unaryNode) {
        this.load(unaryNode.rhs(), unaryNode.getType());
        assert (unaryNode.getType().isNumeric());
        this.method.store(unaryNode.getSymbol());
        return false;
    }

    @Override
    public boolean enterBIT_NOT(UnaryNode unaryNode) {
        this.load(unaryNode.rhs(), Type.INT).load(-1).xor().store(unaryNode.getSymbol());
        return false;
    }

    @Override
    public boolean enterDECINC(UnaryNode unaryNode) {
        boolean isIncrement;
        final Expression rhs = unaryNode.rhs();
        final Type type = unaryNode.getType();
        TokenType tokenType = unaryNode.tokenType();
        final boolean isPostfix = tokenType == TokenType.DECPOSTFIX || tokenType == TokenType.INCPOSTFIX;
        boolean bl = isIncrement = tokenType == TokenType.INCPREFIX || tokenType == TokenType.INCPOSTFIX;
        assert (!type.isObject());
        new SelfModifyingStore<UnaryNode>(unaryNode, rhs){

            @Override
            protected void evaluate() {
                CodeGenerator.this.load(rhs, type, true);
                if (!isPostfix) {
                    if (type.isInteger()) {
                        CodeGenerator.this.method.load(isIncrement ? 1 : -1);
                    } else if (type.isLong()) {
                        CodeGenerator.this.method.load(isIncrement ? 1L : -1L);
                    } else {
                        CodeGenerator.this.method.load(isIncrement ? 1.0 : -1.0);
                    }
                    CodeGenerator.this.method.add();
                }
            }

            @Override
            protected void storeNonDiscard() {
                super.storeNonDiscard();
                if (isPostfix) {
                    if (type.isInteger()) {
                        CodeGenerator.this.method.load(isIncrement ? 1 : -1);
                    } else if (type.isLong()) {
                        CodeGenerator.this.method.load(isIncrement ? 1L : 1L);
                    } else {
                        CodeGenerator.this.method.load(isIncrement ? 1.0 : -1.0);
                    }
                    CodeGenerator.this.method.add();
                }
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterDISCARD(UnaryNode unaryNode) {
        Expression rhs = unaryNode.rhs();
        ((CodeGeneratorLexicalContext)this.lc).pushDiscard(rhs);
        this.load(rhs);
        if (((CodeGeneratorLexicalContext)this.lc).getCurrentDiscard() == rhs) {
            assert (!rhs.isAssignment());
            this.method.pop();
            ((CodeGeneratorLexicalContext)this.lc).popDiscard();
        }
        return false;
    }

    @Override
    public boolean enterNEW(UnaryNode unaryNode) {
        CallNode callNode = (CallNode)unaryNode.rhs();
        List<Expression> args = callNode.getArgs();
        this.load(callNode.getFunction(), Type.OBJECT);
        this.method.dynamicNew(1 + this.loadArgs(args), this.getCallSiteFlags());
        this.method.store(unaryNode.getSymbol());
        return false;
    }

    @Override
    public boolean enterNOT(UnaryNode unaryNode) {
        Expression rhs = unaryNode.rhs();
        this.load(rhs, Type.BOOLEAN);
        Label trueLabel = new Label("true");
        Label afterLabel = new Label("after");
        this.method.ifne(trueLabel);
        this.method.load(true);
        this.method._goto(afterLabel);
        this.method.label(trueLabel);
        this.method.load(false);
        this.method.label(afterLabel);
        this.method.store(unaryNode.getSymbol());
        return false;
    }

    @Override
    public boolean enterSUB(UnaryNode unaryNode) {
        assert (unaryNode.getType().isNumeric());
        this.load(unaryNode.rhs(), unaryNode.getType()).neg().store(unaryNode.getSymbol());
        return false;
    }

    @Override
    public boolean enterVOID(UnaryNode unaryNode) {
        this.load(unaryNode.rhs()).pop();
        this.method.loadUndefined(Type.OBJECT);
        return false;
    }

    private void enterNumericAdd(Expression lhs, Expression rhs, Type type, Symbol symbol) {
        this.loadBinaryOperands(lhs, rhs, type);
        this.method.add();
        this.method.store(symbol);
    }

    @Override
    public boolean enterADD(BinaryNode binaryNode) {
        Expression lhs = binaryNode.lhs();
        Expression rhs = binaryNode.rhs();
        Type type = binaryNode.getType();
        if (type.isNumeric()) {
            this.enterNumericAdd(lhs, rhs, type, binaryNode.getSymbol());
        } else {
            this.loadBinaryOperands(binaryNode);
            this.method.add();
            this.method.store(binaryNode.getSymbol());
        }
        return false;
    }

    private boolean enterAND_OR(BinaryNode binaryNode) {
        Expression lhs = binaryNode.lhs();
        Expression rhs = binaryNode.rhs();
        Label skip = new Label("skip");
        this.load(lhs, Type.OBJECT).dup().convert(Type.BOOLEAN);
        if (binaryNode.tokenType() == TokenType.AND) {
            this.method.ifeq(skip);
        } else {
            this.method.ifne(skip);
        }
        this.method.pop();
        this.load(rhs, Type.OBJECT);
        this.method.label(skip);
        this.method.store(binaryNode.getSymbol());
        return false;
    }

    @Override
    public boolean enterAND(BinaryNode binaryNode) {
        return this.enterAND_OR(binaryNode);
    }

    @Override
    public boolean enterASSIGN(BinaryNode binaryNode) {
        Type rhsType;
        final Expression lhs = binaryNode.lhs();
        final Expression rhs = binaryNode.rhs();
        final Type lhsType = lhs.getType();
        if (!lhsType.isEquivalentTo(rhsType = rhs.getType())) {
            // empty if block
        }
        new Store<BinaryNode>(binaryNode, lhs){

            @Override
            protected void evaluate() {
                if (lhs instanceof IdentNode && !lhs.getSymbol().isScope()) {
                    CodeGenerator.this.load(rhs, lhsType);
                } else {
                    CodeGenerator.this.load(rhs);
                }
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterASSIGN_ADD(BinaryNode binaryNode) {
        assert (RuntimeNode.Request.ADD.canSpecialize());
        final Type lhsType = binaryNode.lhs().getType();
        final Type rhsType = binaryNode.rhs().getType();
        final boolean specialize = binaryNode.getType() == Type.OBJECT;
        new AssignOp(binaryNode){

            @Override
            protected void op() {
                if (specialize) {
                    CodeGenerator.this.method.dynamicRuntimeCall(new RuntimeCallSite.SpecializedRuntimeNode(RuntimeNode.Request.ADD, new Type[]{lhsType, rhsType}, Type.OBJECT).getInitialName(), Type.OBJECT, RuntimeNode.Request.ADD);
                } else {
                    CodeGenerator.this.method.add();
                }
            }

            @Override
            protected void evaluate() {
                super.evaluate();
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterASSIGN_BIT_AND(BinaryNode binaryNode) {
        new AssignOp(Type.INT, binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.and();
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterASSIGN_BIT_OR(BinaryNode binaryNode) {
        new AssignOp(Type.INT, binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.or();
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterASSIGN_BIT_XOR(BinaryNode binaryNode) {
        new AssignOp(Type.INT, binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.xor();
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterASSIGN_DIV(BinaryNode binaryNode) {
        new AssignOp(binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.div();
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterASSIGN_MOD(BinaryNode binaryNode) {
        new AssignOp(binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.rem();
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterASSIGN_MUL(BinaryNode binaryNode) {
        new AssignOp(binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.mul();
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterASSIGN_SAR(BinaryNode binaryNode) {
        new AssignOp(Type.INT, binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.sar();
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterASSIGN_SHL(BinaryNode binaryNode) {
        new AssignOp(Type.INT, binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.shl();
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterASSIGN_SHR(BinaryNode binaryNode) {
        new AssignOp(Type.INT, binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.shr();
                CodeGenerator.this.method.convert(Type.LONG).load(0xFFFFFFFFL).and();
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterASSIGN_SUB(BinaryNode binaryNode) {
        new AssignOp(binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.sub();
            }
        }.store();
        return false;
    }

    @Override
    public boolean enterBIT_AND(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.and();
            }
        }.evaluate(binaryNode);
        return false;
    }

    @Override
    public boolean enterBIT_OR(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.or();
            }
        }.evaluate(binaryNode);
        return false;
    }

    @Override
    public boolean enterBIT_XOR(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.xor();
            }
        }.evaluate(binaryNode);
        return false;
    }

    private boolean enterComma(BinaryNode binaryNode) {
        Expression lhs = binaryNode.lhs();
        Expression rhs = binaryNode.rhs();
        this.load(lhs);
        this.load(rhs);
        this.method.store(binaryNode.getSymbol());
        return false;
    }

    @Override
    public boolean enterCOMMARIGHT(BinaryNode binaryNode) {
        return this.enterComma(binaryNode);
    }

    @Override
    public boolean enterCOMMALEFT(BinaryNode binaryNode) {
        return this.enterComma(binaryNode);
    }

    @Override
    public boolean enterDIV(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.div();
            }
        }.evaluate(binaryNode);
        return false;
    }

    private boolean enterCmp(Expression lhs, Expression rhs, Condition cond, Type type, Symbol symbol) {
        Type lhsType = lhs.getType();
        Type rhsType = rhs.getType();
        Type widest = Type.widest(lhsType, rhsType);
        assert (widest.isNumeric() || widest.isBoolean()) : widest;
        this.loadBinaryOperands(lhs, rhs, widest);
        Label trueLabel = new Label("trueLabel");
        Label afterLabel = new Label("skip");
        this.method.conditionalJump(cond, trueLabel);
        this.method.load(Boolean.FALSE);
        this.method._goto(afterLabel);
        this.method.label(trueLabel);
        this.method.load(Boolean.TRUE);
        this.method.label(afterLabel);
        this.method.convert(type);
        this.method.store(symbol);
        return false;
    }

    private boolean enterCmp(BinaryNode binaryNode, Condition cond) {
        return this.enterCmp(binaryNode.lhs(), binaryNode.rhs(), cond, binaryNode.getType(), binaryNode.getSymbol());
    }

    @Override
    public boolean enterEQ(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, Condition.EQ);
    }

    @Override
    public boolean enterEQ_STRICT(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, Condition.EQ);
    }

    @Override
    public boolean enterGE(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, Condition.GE);
    }

    @Override
    public boolean enterGT(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, Condition.GT);
    }

    @Override
    public boolean enterLE(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, Condition.LE);
    }

    @Override
    public boolean enterLT(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, Condition.LT);
    }

    @Override
    public boolean enterMOD(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.rem();
            }
        }.evaluate(binaryNode);
        return false;
    }

    @Override
    public boolean enterMUL(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.mul();
            }
        }.evaluate(binaryNode);
        return false;
    }

    @Override
    public boolean enterNE(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, Condition.NE);
    }

    @Override
    public boolean enterNE_STRICT(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, Condition.NE);
    }

    @Override
    public boolean enterOR(BinaryNode binaryNode) {
        return this.enterAND_OR(binaryNode);
    }

    @Override
    public boolean enterSAR(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.sar();
            }
        }.evaluate(binaryNode);
        return false;
    }

    @Override
    public boolean enterSHL(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.shl();
            }
        }.evaluate(binaryNode);
        return false;
    }

    @Override
    public boolean enterSHR(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void evaluate(BinaryNode node) {
                CodeGenerator.this.loadBinaryOperands(node.lhs(), node.rhs(), Type.INT);
                this.op();
                CodeGenerator.this.method.store(node.getSymbol());
            }

            @Override
            protected void op() {
                CodeGenerator.this.method.shr();
                CodeGenerator.this.method.convert(Type.LONG).load(0xFFFFFFFFL).and();
            }
        }.evaluate(binaryNode);
        return false;
    }

    @Override
    public boolean enterSUB(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.sub();
            }
        }.evaluate(binaryNode);
        return false;
    }

    @Override
    public boolean enterTernaryNode(TernaryNode ternaryNode) {
        Expression test = ternaryNode.getTest();
        Expression trueExpr = ternaryNode.getTrueExpression();
        Expression falseExpr = ternaryNode.getFalseExpression();
        Symbol symbol = ternaryNode.getSymbol();
        Label falseLabel = new Label("ternary_false");
        Label exitLabel = new Label("ternary_exit");
        Type widest = Type.widest(ternaryNode.getType(), Type.widest(trueExpr.getType(), falseExpr.getType()));
        if (trueExpr.getType().isArray() || falseExpr.getType().isArray()) {
            widest = Type.OBJECT;
        }
        this.load(test, Type.BOOLEAN);
        this.method.ifeq(falseLabel);
        this.load(trueExpr, widest);
        this.method._goto(exitLabel);
        this.method.label(falseLabel);
        this.load(falseExpr, widest);
        this.method.label(exitLabel);
        this.method.store(symbol);
        return false;
    }

    protected void generateScopeCalls() {
        for (SharedScopeCall scopeAccess : ((CodeGeneratorLexicalContext)this.lc).getScopeCalls()) {
            scopeAccess.generateScopeCall();
        }
    }

    private void printSymbols(Block block, String ident) {
        if (!this.compiler.getEnv()._print_symbols) {
            return;
        }
        PrintWriter out = this.compiler.getEnv().getErr();
        out.println("[BLOCK in '" + ident + "']");
        if (!block.printSymbols(out)) {
            out.println("<no symbols>");
        }
        out.println();
    }

    private void newFunctionObject(FunctionNode functionNode, FunctionNode originalFunctionNode) {
        assert (((CodeGeneratorLexicalContext)this.lc).peek() == functionNode);
        if (((CodeGeneratorLexicalContext)this.lc).getOutermostFunction() == functionNode || !functionNode.needsCallee() && ((CodeGeneratorLexicalContext)this.lc).isFunctionDefinedInCurrentCall(originalFunctionNode)) {
            return;
        }
        String className = SCRIPTFUNCTION_IMPL_OBJECT;
        int fieldCount = ObjectClassGenerator.getPaddedFieldCount(functionNode.countThisProperties());
        String allocatorClassName = Compiler.binaryName(ObjectClassGenerator.getClassName(fieldCount));
        PropertyMap allocatorMap = PropertyMap.newMap(null, allocatorClassName, 0, fieldCount, 0);
        this.method._new(className).dup();
        this.loadConstant(new RecompilableScriptFunctionData(functionNode, this.compiler.getCodeInstaller(), allocatorClassName, allocatorMap));
        if (functionNode.isLazy() || functionNode.needsParentScope()) {
            this.method.loadCompilerConstant(CompilerConstants.SCOPE);
        } else {
            this.method.loadNull();
        }
        this.method.invoke(CompilerConstants.constructorNoLookup(className, RecompilableScriptFunctionData.class, ScriptObject.class));
    }

    private MethodEmitter globalInstance() {
        return this.method.invokestatic(GLOBAL_OBJECT, "instance", "()L" + GLOBAL_OBJECT + ';');
    }

    private MethodEmitter globalObjectPrototype() {
        return this.method.invokestatic(GLOBAL_OBJECT, "objectPrototype", CompilerConstants.methodDescriptor(ScriptObject.class, new Class[0]));
    }

    private MethodEmitter globalAllocateArguments() {
        return this.method.invokestatic(GLOBAL_OBJECT, "allocateArguments", CompilerConstants.methodDescriptor(ScriptObject.class, Object[].class, Object.class, Integer.TYPE));
    }

    private MethodEmitter globalNewRegExp() {
        return this.method.invokestatic(GLOBAL_OBJECT, "newRegExp", CompilerConstants.methodDescriptor(Object.class, String.class, String.class));
    }

    private MethodEmitter globalRegExpCopy() {
        return this.method.invokestatic(GLOBAL_OBJECT, "regExpCopy", CompilerConstants.methodDescriptor(Object.class, Object.class));
    }

    private MethodEmitter globalAllocateArray(ArrayType type) {
        return this.method.invokestatic(GLOBAL_OBJECT, "allocate", "(" + type.getDescriptor() + ")Ljdk/nashorn/internal/objects/NativeArray;");
    }

    private MethodEmitter globalIsEval() {
        return this.method.invokestatic(GLOBAL_OBJECT, "isEval", CompilerConstants.methodDescriptor(Boolean.TYPE, Object.class));
    }

    private MethodEmitter globalCheckObjectCoercible() {
        return this.method.invokestatic(GLOBAL_OBJECT, "checkObjectCoercible", CompilerConstants.methodDescriptor(Void.TYPE, Object.class));
    }

    private MethodEmitter globalDirectEval() {
        return this.method.invokestatic(GLOBAL_OBJECT, "directEval", CompilerConstants.methodDescriptor(Object.class, Object.class, Object.class, Object.class, Object.class, Object.class));
    }

    private static abstract class Store<T extends Expression> {
        protected final T assignNode;
        private final Expression target;
        private int depth;
        private Symbol quick;
        final /* synthetic */ CodeGenerator this$0;

        protected Store(T assignNode, Expression target) {
            this.this$0 = var1_1;
            this.assignNode = assignNode;
            this.target = target;
        }

        protected Store(T assignNode) {
            this(var1_1, (Expression)assignNode, (Expression)assignNode);
        }

        protected boolean isSelfModifying() {
            return false;
        }

        private void prologue() {
            final Symbol targetSymbol = this.target.getSymbol();
            final Symbol scopeSymbol = ((CodeGeneratorLexicalContext)this.this$0.lc).getCurrentFunction().compilerConstant(CompilerConstants.SCOPE);
            this.target.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

                @Override
                public boolean enterIdentNode(IdentNode node) {
                    if (targetSymbol.isScope()) {
                        Store.this.this$0.method.load(scopeSymbol);
                        Store.this.depth++;
                    }
                    return false;
                }

                private void enterBaseNode() {
                    assert (Store.this.target instanceof BaseNode) : "error - base node " + Store.access$1900(Store.this) + " must be instanceof BaseNode";
                    BaseNode baseNode = (BaseNode)Store.this.target;
                    Expression base = baseNode.getBase();
                    Store.this.this$0.load(base, Type.OBJECT);
                    Store.this.depth = Store.this.depth + Type.OBJECT.getSlots();
                    if (Store.this.isSelfModifying()) {
                        Store.this.this$0.method.dup();
                    }
                }

                @Override
                public boolean enterAccessNode(AccessNode node) {
                    this.enterBaseNode();
                    return false;
                }

                @Override
                public boolean enterIndexNode(IndexNode node) {
                    this.enterBaseNode();
                    Expression index = node.getIndex();
                    if (!index.getType().isNumeric()) {
                        Store.this.this$0.load(index, Type.OBJECT);
                    } else {
                        Store.this.this$0.load(index);
                    }
                    Store.this.depth = Store.this.depth + index.getType().getSlots();
                    if (Store.this.isSelfModifying()) {
                        Store.this.this$0.method.dup(1);
                    }
                    return false;
                }
            });
        }

        private Symbol quickSymbol(Type type) {
            return this.quickSymbol(type, CompilerConstants.QUICK_PREFIX.symbolName());
        }

        private Symbol quickSymbol(Type type, String prefix) {
            String name = ((CodeGeneratorLexicalContext)this.this$0.lc).getCurrentFunction().uniqueName(prefix);
            Symbol symbol = new Symbol(name, 2049);
            symbol.setType(type);
            symbol.setSlot(((CodeGeneratorLexicalContext)this.this$0.lc).quickSlot(symbol));
            return symbol;
        }

        protected void storeNonDiscard() {
            if (((CodeGeneratorLexicalContext)this.this$0.lc).getCurrentDiscard() == this.assignNode) {
                assert (((Node)this.assignNode).isAssignment());
                ((CodeGeneratorLexicalContext)this.this$0.lc).popDiscard();
                return;
            }
            Symbol symbol = ((Expression)this.assignNode).getSymbol();
            if (symbol.hasSlot()) {
                this.this$0.method.dup().store(symbol);
                return;
            }
            if (this.this$0.method.dup(this.depth) == null) {
                this.this$0.method.dup();
                this.quick = this.quickSymbol(this.this$0.method.peekType());
                this.this$0.method.store(this.quick);
            }
        }

        private void epilogue() {
            this.target.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

                @Override
                protected boolean enterDefault(Node node) {
                    throw new AssertionError((Object)("Unexpected node " + node + " in store epilogue"));
                }

                @Override
                public boolean enterIdentNode(IdentNode node) {
                    Symbol symbol = node.getSymbol();
                    assert (symbol != null);
                    if (symbol.isScope()) {
                        if (Store.this.this$0.isFastScope(symbol)) {
                            Store.this.this$0.storeFastScopeVar(symbol, 1 | Store.this.this$0.getCallSiteFlags());
                        } else {
                            Store.this.this$0.method.dynamicSet(node.getName(), 1 | Store.this.this$0.getCallSiteFlags());
                        }
                    } else {
                        Store.this.this$0.method.convert(node.getType());
                        Store.this.this$0.method.store(symbol);
                    }
                    return false;
                }

                @Override
                public boolean enterAccessNode(AccessNode node) {
                    Store.this.this$0.method.dynamicSet(node.getProperty().getName(), Store.this.this$0.getCallSiteFlags());
                    return false;
                }

                @Override
                public boolean enterIndexNode(IndexNode node) {
                    Store.this.this$0.method.dynamicSetIndex(Store.this.this$0.getCallSiteFlags());
                    return false;
                }
            });
        }

        protected abstract void evaluate();

        void store() {
            this.prologue();
            this.evaluate();
            this.storeNonDiscard();
            this.epilogue();
            if (this.quick != null) {
                this.this$0.method.load(this.quick);
            }
        }
    }

    private static abstract class SelfModifyingStore<T extends Expression>
    extends Store<T> {
        final /* synthetic */ CodeGenerator this$0;

        protected SelfModifyingStore(T assignNode, Expression target) {
            this.this$0 = var1_1;
            super((CodeGenerator)var1_1, assignNode, target);
        }

        @Override
        protected boolean isSelfModifying() {
            return true;
        }
    }

    private abstract class BinaryArith {
        private BinaryArith() {
        }

        protected abstract void op();

        protected void evaluate(BinaryNode node) {
            CodeGenerator.this.loadBinaryOperands(node);
            this.op();
            CodeGenerator.this.method.store(node.getSymbol());
        }
    }

    private abstract class AssignOp
    extends SelfModifyingStore<BinaryNode> {
        private final Type opType;

        AssignOp(BinaryNode node) {
            this(node.getType(), node);
        }

        AssignOp(Type opType, BinaryNode node) {
            super(CodeGenerator.this, (Expression)node, node.lhs());
            this.opType = opType;
        }

        protected abstract void op();

        @Override
        protected void evaluate() {
            CodeGenerator.this.loadBinaryOperands(((BinaryNode)this.assignNode).lhs(), ((BinaryNode)this.assignNode).rhs(), this.opType, true);
            this.op();
            CodeGenerator.this.method.convert(((BinaryNode)this.assignNode).getType());
        }
    }
}

