/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.apple.eawt.Application;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.SwingUtilities;
import sun.plugin2.main.client.DetachedAppletController;
import sun.plugin2.main.client.MacOSXKeyHandler;
import sun.plugin2.main.client.PluginEmbeddedFrame;
import sun.plugin2.main.client.ProcessUI;

public class Plugin2EventListener
implements MacOSXKeyHandler.Listener,
AWTEventListener {
    static Plugin2EventListener INSTANCE = new Plugin2EventListener();
    static boolean debugEvents = false;
    boolean dockIconInflated = false;
    PluginEmbeddedFrame activeAppletFrame;

    private Plugin2EventListener() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 121L);
        MacOSXKeyHandler.getInstance().addListener(this);
    }

    public static Plugin2EventListener getInstance() {
        return INSTANCE;
    }

    public void keyChanged(long l) {
    }

    private void dispatchWindowEvent(AWTEvent aWTEvent) {
        Window window = (Window)aWTEvent.getSource();
        switch (aWTEvent.getID()) {
            case 102: 
            case 205: {
                if (this.shouldInflateDockIcon(window)) {
                    Plugin2EventListener.inflateDockIcon();
                }
                if (this.affectsApplicationLevel(window)) {
                    Plugin2EventListener.activateAppletProcess();
                }
                if (!(window instanceof PluginEmbeddedFrame)) {
                    return;
                }
                if (this.activeAppletFrame != null && window == this.activeAppletFrame) {
                    return;
                }
                this.activeAppletFrame = (PluginEmbeddedFrame)((Object)window);
            }
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent || aWTEvent instanceof ComponentEvent && aWTEvent.getSource() instanceof Window) {
            if (debugEvents) {
                Trace.println((String)"Handling window event", (TraceLevel)TraceLevel.UI);
            }
            this.dispatchWindowEvent(aWTEvent);
            return;
        }
        if (aWTEvent instanceof ComponentEvent) {
            return;
        }
        if (debugEvents) {
            Trace.println((String)"Handling key/mouse event", (TraceLevel)TraceLevel.UI);
        }
        switch (aWTEvent.getID()) {
            case 401: 
            case 402: 
            case 503: 
            case 504: {
                this.updateAppletDetachFrame();
                Object object = aWTEvent.getSource();
                if (!(object instanceof Component)) {
                    return;
                }
                Window window = SwingUtilities.getWindowAncestor((Component)object);
                if (!(window instanceof PluginEmbeddedFrame)) {
                    return;
                }
                this.activeAppletFrame = (PluginEmbeddedFrame)((Object)window);
            }
        }
    }

    private boolean isOrdinaryWindow(Window window) {
        if (window == null) {
            return false;
        }
        return !(window instanceof PluginEmbeddedFrame) && !(window instanceof DetachedAppletController.DetachFrame) && window.getType() != Window.Type.POPUP;
    }

    private boolean shouldInflateDockIcon(Window window) {
        if (this.dockIconInflated) {
            return false;
        }
        if (window instanceof Dialog && ((Dialog)window).isModal()) {
            return false;
        }
        return this.isOrdinaryWindow(window);
    }

    private boolean affectsApplicationLevel(Window window) {
        return this.isOrdinaryWindow(window);
    }

    static void inflateDockIcon() {
        if (Plugin2EventListener.INSTANCE.dockIconInflated) {
            return;
        }
        Plugin2EventListener.INSTANCE.dockIconInflated = true;
        Trace.println((String)"Inflating dock icon", (TraceLevel)TraceLevel.UI);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ProcessUI processUI = ProcessUI.getInstance();
                if (processUI.isInflated()) {
                    return null;
                }
                Application application = Application.getApplication();
                application.setDockIconImage(application.getDockIconImage());
                processUI.inflateDockIcon();
                return null;
            }
        });
    }

    static void activateAppletProcess() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Application.getApplication().requestForeground(true);
                return null;
            }
        });
    }

    private void updateAppletDetachFrame() {
        if (debugEvents) {
            Trace.println((String)"Testing for applet detach", (TraceLevel)TraceLevel.UI);
        }
        MacOSXKeyHandler macOSXKeyHandler = MacOSXKeyHandler.getInstance();
        DetachedAppletController detachedAppletController = this.getDetachedAppletController();
        if (detachedAppletController == null) {
            return;
        }
        if (macOSXKeyHandler.isKeyDown(0x100000L) && macOSXKeyHandler.isKeyDown(131072L)) {
            detachedAppletController.showFrame();
        } else {
            detachedAppletController.hideFrame();
        }
    }

    private DetachedAppletController getDetachedAppletController() {
        if (this.activeAppletFrame == null) {
            return null;
        }
        return this.activeAppletFrame.getDetachedAppletController();
    }
}

