/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.swing.internal;

import com.teamdev.jxbrowser.chromium.KeyFilter;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.DragAndDropData;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.MacShortcutSupport;
import com.teamdev.jxbrowser.chromium.internal.MouseDragEventConverter;
import com.teamdev.jxbrowser.chromium.internal.ReflectionUtil;
import com.teamdev.jxbrowser.chromium.internal.SharedMemory;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.TaskExecutor;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DragEndedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DragTargetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.FocusMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardKeyboardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardMouseMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardMouseWheelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCursorChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnGetParentForWindowlessPluginMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnPaintMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShowFullscreenWidgetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShowPopupWidgetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnStartDraggingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTakeFocusMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTooltipChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ScreenChangedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.UnfocusMessage;
import com.teamdev.jxbrowser.chromium.swing.internal.CursorType;
import com.teamdev.jxbrowser.chromium.swing.internal.DragAndDropSupport;
import com.teamdev.jxbrowser.chromium.swing.internal.MemoryImage;
import com.teamdev.jxbrowser.chromium.swing.internal.NativeKeyCodes;
import com.teamdev.jxbrowser.chromium.swing.internal.PopupView;
import com.teamdev.jxbrowser.chromium.swing.internal.TransferableWrapper;
import com.teamdev.jxbrowser.chromium.swing.internal.aa;
import com.teamdev.jxbrowser.chromium.swing.internal.ab;
import com.teamdev.jxbrowser.chromium.swing.internal.t;
import com.teamdev.jxbrowser.chromium.swing.internal.u;
import com.teamdev.jxbrowser.chromium.swing.internal.v;
import com.teamdev.jxbrowser.chromium.swing.internal.x;
import com.teamdev.jxbrowser.chromium.swing.internal.y;
import com.teamdev.jxbrowser.chromium.swing.internal.z;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WidgetView
extends JComponent {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private final IPC b;
    private final Channel c;
    private final NativeKeyCodes d;
    private final MemoryImage e;
    private final KeyListener f;
    private final FocusListener g;
    private final f h;
    private final ChannelListener i;
    private final TaskExecutor j;
    private final ComponentListener k;
    private final ComponentListener l;
    private final IPCChannelListener m;
    private final DragAndDropSupport n;
    private final MouseDragEventConverter o;
    private int p;
    private KeyFilter<KeyEvent> q;
    private boolean r;
    private MacShortcutSupport<KeyEvent> s;
    private WidgetView t;

    protected WidgetView(IPC object, Channel channel) {
        this.b = object;
        this.c = channel;
        this.e = new MemoryImage();
        this.h = new f(this, 0);
        this.f = new e(this, 0);
        this.k = new g(this, 0);
        this.g = new d(this, 0);
        this.l = new i(this, 0);
        this.i = new c(this, 0);
        object = new h(this, 0);
        this.n = new DragAndDropSupport((DropTargetListener)object, (DragSourceListener)object);
        this.o = new MouseDragEventConverter();
        this.m = new b(this, 0);
        this.d = new NativeKeyCodes();
        this.j = new TaskExecutor("Swing WidgetView Resize Task Executor", 250L, TimeUnit.MILLISECONDS);
        this.j.start();
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.setTransferHandler(new t(this));
        object = this;
        ((WidgetView)object).getIPC().addIPCChannelListener(((WidgetView)object).m);
        object = this;
        ((WidgetView)object).getChannel().addChannelListener(new u((WidgetView)object));
    }

    protected void setMacShortcutSupport(MacShortcutSupport<KeyEvent> macShortcutSupport) {
        this.s = macShortcutSupport;
    }

    protected IPC getIPC() {
        return this.b;
    }

    protected Channel getChannel() {
        return this.c;
    }

    final void a(boolean bl) {
        this.r = bl;
    }

    public Image getImage() {
        return this.e.getImage();
    }

    public void setKeyFilter(KeyFilter<KeyEvent> keyFilter) {
        this.q = keyFilter;
    }

    public void setDragAndDropEnabled(boolean bl) {
        this.n.setDragAndDropEnabled(bl);
    }

    public boolean isDragAndDropEnabled() {
        return this.n.isDragAndDropEnabled();
    }

    public double getDeviceScaleFactor() {
        return this.e.getDeviceScaleFactor();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 503) {
            super.processMouseMotionEvent(mouseEvent);
            this.forwardMouseEvent(mouseEvent);
            return;
        }
        if (mouseEvent.getID() == 506 && this.n.isDragStarted()) {
            super.processMouseMotionEvent(mouseEvent);
            if (this.n.isDragGestureRecognized()) {
                this.n.setDragStarted(false);
                this.n.setDragGestureRecognized(false);
                return;
            }
        } else {
            this.forwardMouseEvent(mouseEvent);
        }
    }

    private void a() {
        this.e.setVisible(false);
        this.removeFocusListener(this.g);
        this.removeComponentListener(this.k);
        this.removeKeyListener(this.f);
        this.removeMouseListener(this.h);
        this.removeMouseWheelListener(this.h);
        this.n.unregisterDragGestureHandler();
        this.repaint();
    }

    private void b() {
        if (!this.e.isVisible()) {
            this.setBounds(this.getBounds());
            this.addFocusListener(this.g);
            this.addMouseListener(this.h);
            this.addMouseWheelListener(this.h);
            this.addKeyListener(this.f);
            this.addComponentListener(this.k);
            this.e.setVisible(true);
            this.n.registerDragGestureHandler(this);
            this.repaint();
        }
    }

    private void c() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.removeComponentListener(this.l);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.b();
        if (Environment.isMac()) {
            WidgetView widgetView = this;
            Window window = SwingUtilities.getWindowAncestor(widgetView);
            if (window != null) {
                window.addComponentListener(widgetView.l);
            }
            this.d();
        }
    }

    @Override
    public void removeNotify() {
        if (Environment.isMac()) {
            this.c();
        }
        this.setBounds(new Rectangle());
        this.a();
        super.removeNotify();
    }

    protected void dispose() {
        WidgetView widgetView = this;
        widgetView.getIPC().removeIPCChannelListener(widgetView.m);
        widgetView = this;
        widgetView.getChannel().removeChannelListener(widgetView.i);
        this.j.stop();
    }

    public long getNativeHandle() {
        Object object = SwingUtilities.windowForComponent(this);
        if (object != null && (object = object.getPeer()) != null) {
            try {
                Method method = object.getClass().getMethod("getHWnd", new Class[0]);
                object = method.invoke(object, new Object[0]);
                if (object instanceof Long) {
                    return (Long)object;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
        return 0L;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.t != null) {
            return;
        }
        if (this.e.isVisible() && this.e.isInitialized()) {
            int n2 = this.e.getWidth();
            int n3 = this.e.getHeight();
            graphics = (Graphics2D)graphics;
            if (Environment.isMac()) {
                double d2 = 1.0 / this.e.getDeviceScaleFactor();
                ((Graphics2D)graphics).scale(d2, d2);
            }
            graphics.drawImage(this.e.getImage(), 0, 0, n2, n3, null);
        }
    }

    public void forwardMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        this.a(mouseWheelEvent, Environment.isMac() ? 10 : 25);
    }

    private void a(MouseWheelEvent mouseWheelEvent, int n2) {
        Serializable serializable = mouseWheelEvent.getComponent();
        serializable = serializable.getLocationOnScreen();
        int n3 = ((Point)serializable).x;
        int n4 = ((Point)serializable).y;
        int n5 = mouseWheelEvent.getX();
        int n6 = mouseWheelEvent.getY();
        int n7 = mouseWheelEvent.getX();
        int n8 = mouseWheelEvent.getY();
        int n9 = -mouseWheelEvent.getUnitsToScroll();
        int n10 = -mouseWheelEvent.getWheelRotation();
        int n11 = mouseWheelEvent.getScrollType();
        long l2 = mouseWheelEvent.getWhen();
        int n12 = mouseWheelEvent.getModifiersEx();
        boolean bl = mouseWheelEvent.isShiftDown();
        if (Environment.isWindows()) {
            double d2 = this.e.getDeviceScaleFactor();
            n5 = (int)((double)n5 / d2);
            n6 = (int)((double)n6 / d2);
            n7 = (int)((double)n7 / d2);
            n8 = (int)((double)n8 / d2);
        }
        if (!this.c.isClosed()) {
            this.c.send(new ForwardMouseWheelMessage(MessageUIDGenerator.generate(), n5, n6, n7, n8, n3, n4, n11, n10, n9, l2, n12, bl, n2));
        }
    }

    public void forwardTouchMoveEvent(MouseEvent iterator) {
        iterator = this.o.getMouseWheelEvents((MouseEvent)((Object)iterator));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            MouseWheelEvent mouseWheelEvent = iterator.next();
            this.a(mouseWheelEvent, 1);
        }
    }

    public void forwardMouseEvent(MouseEvent mouseEvent) {
        boolean bl;
        if (mouseEvent.getID() == 506 && Environment.isWindows() && !(bl = SharedMemoryLibrary.getInstance().isCursorVisible())) {
            this.forwardTouchMoveEvent(mouseEvent);
            return;
        }
        this.o.reset();
        Serializable serializable = mouseEvent.getComponent();
        serializable = serializable.isShowing() ? serializable.getLocationOnScreen() : new Point();
        int n2 = mouseEvent.getID();
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        int n5 = ((Point)serializable).x + n3;
        int n6 = ((Point)serializable).y + n4;
        MouseEvent mouseEvent2 = mouseEvent;
        int n7 = SwingUtilities.isLeftMouseButton(mouseEvent2) ? 1 : (SwingUtilities.isMiddleMouseButton(mouseEvent2) ? 2 : (SwingUtilities.isRightMouseButton(mouseEvent2) ? 3 : 0));
        int n8 = mouseEvent.getClickCount();
        long l2 = mouseEvent.getWhen();
        int n9 = mouseEvent.getModifiersEx();
        if (Environment.isWindows()) {
            double d2 = this.e.getDeviceScaleFactor();
            n3 = (int)((double)n3 / d2);
            n4 = (int)((double)n4 / d2);
            n5 = (int)((double)n5 / d2);
            n6 = (int)((double)n6 / d2);
        }
        if (!this.c.isClosed()) {
            this.c.send(new ForwardMouseMessage(MessageUIDGenerator.generate(), n2, n3, n4, n5, n6, n3, n4, n7, n8, l2, n9));
        }
    }

    public void forwardKeyPressedEvent(KeyEvent keyEvent) {
        this.p = Environment.isWindows() ? WidgetView.a(keyEvent) : keyEvent.getKeyCode();
        this.a(keyEvent, 401, keyEvent.getWhen());
    }

    public void forwardKeyTypedEvent(KeyEvent keyEvent) {
        KeyEvent keyEvent2;
        if (Environment.isWindows()) {
            int n2 = this.p != 0 ? this.p : WidgetView.a(keyEvent);
            keyEvent2 = new KeyEvent(keyEvent.getComponent(), 401, keyEvent.getWhen(), keyEvent.getModifiers(), n2, keyEvent.getKeyChar(), keyEvent.getKeyLocation());
            long l2 = n2;
            KeyEvent keyEvent3 = keyEvent2;
            try {
                Field field = keyEvent3.getClass().getDeclaredField("rawCode");
                field.setAccessible(true);
                field.setLong(keyEvent3, l2);
            }
            catch (IllegalAccessException illegalAccessException) {
                a.log(Level.SEVERE, "Failed to set native key code.", illegalAccessException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                a.log(Level.SEVERE, "Failed to set native key code.", noSuchFieldException);
            }
        } else {
            int n3 = this.p != 0 ? this.p : keyEvent.getKeyCode();
            keyEvent2 = new KeyEvent(keyEvent.getComponent(), 401, keyEvent.getWhen(), keyEvent.getModifiers(), n3, keyEvent.getKeyChar(), keyEvent.getKeyLocation());
        }
        this.a(keyEvent2, 400, keyEvent.getWhen());
    }

    public void forwardKeyReleasedEvent(KeyEvent keyEvent) {
        this.p = 0;
        this.a(keyEvent, 402, keyEvent.getWhen());
    }

    private void a(KeyEvent keyEvent, int n2, long l2) {
        boolean bl;
        boolean bl2;
        char c2 = keyEvent.getKeyChar();
        int n3 = keyEvent.getModifiersEx();
        int n5 = keyEvent.getKeyCode();
        n5 = this.d.toNativeKeyCode(n5);
        if (Environment.isWindows() && (bl2 = WidgetView.a(keyEvent))) {
            bl = bl2;
        }
        int n52 = keyEvent.getKeyCode();
        bl2 = Environment.isWindows() ? n52 == 13 : n52 == 10;
        ForwardKeyboardMessage forwardKeyboardMessage = new ForwardKeyboardMessage(MessageUIDGenerator.generate(), n2, bl ? 1 : 0, bl2, c2, l2, n3);
        if (!this.c.isClosed()) {
            this.c.send(forwardKeyboardMessage);
        }
    }

    private static int a(KeyEvent keyEvent) {
        int n2 = 0;
        try {
            Field field = keyEvent.getClass().getDeclaredField("rawCode");
            field.setAccessible(true);
            n2 = (int)field.getLong(keyEvent);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            a.log(Level.SEVERE, "Failed to get native key code.", noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            a.log(Level.SEVERE, "Failed to get native key code.", illegalAccessException);
        }
        return n2;
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        rectangle = new Rectangle(rectangle);
        this.j.invoke(new ab(this, rectangle));
    }

    public void focus() {
        if (!this.c.isClosed()) {
            this.c.send(new FocusMessage(MessageUIDGenerator.generate()));
        }
    }

    public void unfocus() {
        if (!this.c.isClosed()) {
            this.c.send(new UnfocusMessage(MessageUIDGenerator.generate()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void d() {
        v0 = SwingUtilities.getWindowAncestor(this);
        var1_1 = v0;
        var1_1 = v0;
        if (v0 == null) ** GOTO lbl-1000
        if (Environment.isJRE7() || Environment.isJRE8()) {
            var1_1 = var1_1.getPeer();
            var1_1 = ReflectionUtil.invokeMethod(var1_1, "getPlatformWindow");
            var1_1 = ReflectionUtil.invokeMethod(var1_1, "getContentView");
            v1 = (Long)ReflectionUtil.invokeMethod(var1_1, "getAWTView");
        } else if (Environment.isJRE6()) {
            var1_1 = var1_1.getPeer();
            v1 = (Long)ReflectionUtil.invokeMethod(var1_1, "getViewPtr");
        } else lbl-1000:
        // 2 sources

        {
            v1 = 0L;
        }
        var4_3 = v1;
        var1_2 = SharedMemoryLibrary.getInstance().getScreenId(var4_3);
        if (!this.c.isClosed()) {
            this.c.send(new ScreenChangedMessage(MessageUIDGenerator.generate(), var1_2));
        }
    }

    static /* synthetic */ void a(WidgetView widgetView, OnPaintMessage object) {
        long l2 = ((OnPaintMessage)object).getPid();
        long l3 = ((OnPaintMessage)object).getSharedMemoryHandle();
        int n2 = ((OnPaintMessage)object).getSharedMemoryCapacity();
        int n3 = ((OnPaintMessage)object).getClientWidth();
        int n4 = ((OnPaintMessage)object).getClientHeight();
        int n5 = ((OnPaintMessage)object).getRectX();
        int n6 = ((OnPaintMessage)object).getRectY();
        int n7 = ((OnPaintMessage)object).getRectWidth();
        int n8 = ((OnPaintMessage)object).getRectHeight();
        Rectangle rectangle = new Rectangle(n5, n6, n7, n8);
        Dimension dimension = new Dimension(n3, n4);
        String string = ((OnPaintMessage)object).getMemoryFilePath();
        double d2 = ((OnPaintMessage)object).getDeviceScaleFactor();
        object = new SharedMemory(l2, l3, n2, dimension, string, d2);
        widgetView.e.updatePixels((SharedMemory)object, rectangle);
        object = new Rectangle(rectangle);
        if (Environment.isMac()) {
            ((Rectangle)object).x = (int)((double)((Rectangle)object).x / d2);
            ((Rectangle)object).y = (int)((double)((Rectangle)object).y / d2);
            ((Rectangle)object).width = (int)((double)((Rectangle)object).width / d2);
            ((Rectangle)object).height = (int)((double)((Rectangle)object).height / d2);
        }
        widgetView.repaint((Rectangle)object);
    }

    static /* synthetic */ void a(WidgetView widgetView, OnCursorChangeMessage onCursorChangeMessage) {
        int n2 = onCursorChangeMessage.getCursorType();
        byte[] byArray = onCursorChangeMessage.getPixels();
        int n3 = onCursorChangeMessage.getWidth();
        int n4 = onCursorChangeMessage.getHeight();
        widgetView.setCursor(CursorType.toJavaCursor(n2, byArray, n3, n4));
    }

    static /* synthetic */ void a(OnTakeFocusMessage onTakeFocusMessage) {
        if (onTakeFocusMessage.isReverse()) {
            SwingUtilities.invokeLater(new z());
            return;
        }
        SwingUtilities.invokeLater(new aa());
    }

    static /* synthetic */ void a(WidgetView widgetView, OnStartDraggingMessage object) {
        if (!widgetView.n.isDragAndDropEnabled()) {
            if (!widgetView.c.isClosed()) {
                widgetView.c.send(new DragEndedMessage(MessageUIDGenerator.generate()));
                return;
            }
        } else {
            object = new DragAndDropData(((OnStartDraggingMessage)object).getURL(), ((OnStartDraggingMessage)object).getURLTitle(), ((OnStartDraggingMessage)object).getText(), ((OnStartDraggingMessage)object).getHTML(), ((OnStartDraggingMessage)object).getHTMLBaseURL());
            widgetView.n.setDragStarted(true);
            widgetView.n.setData((DragAndDropData)object);
        }
    }

    static /* synthetic */ void a(WidgetView widgetView, OnTooltipChangeMessage object) {
        object = ((OnTooltipChangeMessage)object).getTooltipText();
        SwingUtilities.invokeLater(new y(widgetView, (String)object));
    }

    static /* synthetic */ void a(WidgetView object, OnShowPopupWidgetMessage object2) {
        int n2 = ((OnShowPopupWidgetMessage)object2).getChannelId();
        object2 = ((OnShowPopupWidgetMessage)object2).getPopupBounds();
        object = new PopupView((WidgetView)object, n2, (Rectangle)object2);
        ((PopupView)object).show();
    }

    static /* synthetic */ void a(WidgetView widgetView, OnShowFullscreenWidgetMessage onShowFullscreenWidgetMessage) {
        Channel channel;
        int n2 = onShowFullscreenWidgetMessage.getChannelId();
        if (!widgetView.b.hasChannel(n2, ChannelType.Browser)) {
            widgetView.b.waitChannel(n2, ChannelType.Browser);
        }
        if ((channel = widgetView.b.getChannel(n2, ChannelType.Browser)) != null) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            widgetView.b.addIPCChannelListener(new v(widgetView, n2, countDownLatch));
            SwingUtilities.invokeLater(new x(widgetView, channel, countDownLatch));
            widgetView.setBounds(new Rectangle());
        }
    }

    static /* synthetic */ IPC b(WidgetView widgetView) {
        return widgetView.b;
    }

    static /* synthetic */ WidgetView c(WidgetView widgetView) {
        return widgetView.t;
    }

    static /* synthetic */ WidgetView a(WidgetView widgetView, WidgetView widgetView2) {
        widgetView.t = widgetView2;
        return widgetView.t;
    }

    final class a
    extends WidgetView {
        private /* synthetic */ WidgetView a;

        private a(WidgetView widgetView, IPC iPC, Channel channel) {
            this.a = widgetView;
            super(iPC, channel);
        }

        @Override
        public final void removeNotify() {
            if (Environment.isMac()) {
                this.a.c();
            }
        }

        /* synthetic */ a(WidgetView widgetView, IPC iPC, Channel channel, byte by) {
            this(widgetView, iPC, channel);
        }
    }

    final class h
    extends DragSourceAdapter
    implements DropTargetListener {
        private boolean a;
        private boolean b;
        private /* synthetic */ WidgetView c;

        private h(WidgetView widgetView) {
            this.c = widgetView;
        }

        @Override
        public final void dragEnter(DropTargetDragEvent serializable) {
            if (!this.c.n.isDragAndDropEnabled()) {
                serializable.rejectDrag();
                return;
            }
            this.a(serializable.getTransferable());
            if (this.c.n.getData() == null) {
                serializable.rejectDrag();
                return;
            }
            this.a = true;
            this.b = false;
            Point point = this.c.getLocationOnScreen();
            serializable = serializable.getLocation();
            serializable = new Point(point.x + ((Point)serializable).x, point.y + ((Point)serializable).y);
            this.a((Point)serializable, this.c.n.getData());
        }

        @Override
        public final void dragExit(DropTargetEvent object) {
            DragAndDropData dragAndDropData = this.c.n.getData();
            boolean bl = this.a;
            object = this;
            if (bl && !((h)object).c.c.isClosed()) {
                ((h)object).c.c.send(new DragTargetMessage(MessageUIDGenerator.generate(), DragTargetMessage.Flag.DragTargetDragLeave, 0, 0, 0, 0, DragTargetMessage.WebDragOperation.WebDragOperationNone, 0, dragAndDropData.getURL(), dragAndDropData.getURLTitle(), dragAndDropData.getText(), dragAndDropData.getHTML(), dragAndDropData.getHTMLBaseURL()));
            }
            this.a = false;
            this.b = true;
        }

        @Override
        public final void drop(DropTargetDropEvent dropTargetDropEvent) {
            Point point = this.c.getLocationOnScreen();
            Point point2 = dropTargetDropEvent.getLocation();
            point = new Point(point.x + point2.x, point.y + point2.y);
            if (Environment.isMac()) {
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                this.a(dropTargetDropEvent.getTransferable());
                this.a(point, this.c.n.getData());
            }
            this.a(point, this.a, this.c.n.getData());
            dropTargetDropEvent.dropComplete(true);
            this.a = false;
        }

        @Override
        public final void dragOver(DropTargetDragEvent object) {
            Serializable serializable = this.c.getLocationOnScreen();
            object = ((DropTargetDragEvent)object).getLocation();
            object = new Point(serializable.x + ((Point)object).x, serializable.y + ((Point)object).y);
            DragAndDropData dragAndDropData = this.c.n.getData();
            boolean bl = this.a;
            serializable = object;
            object = this;
            if (bl) {
                Point point = ((h)object).c.getLocationOnScreen();
                int n2 = serializable.x - point.x;
                int n3 = serializable.y - point.y;
                int n4 = serializable.x;
                int n5 = serializable.y;
                if (Environment.isWindows()) {
                    double d2 = ((h)object).c.e.getDeviceScaleFactor();
                    n2 = (int)((double)n2 / d2);
                    n3 = (int)((double)n3 / d2);
                    n4 = (int)((double)n4 / d2);
                    n5 = (int)((double)n5 / d2);
                }
                DragTargetMessage.WebDragOperation webDragOperation = DragTargetMessage.WebDragOperation.WebDragOperationEvery;
                if (!((h)object).c.c.isClosed()) {
                    ((h)object).c.c.send(new DragTargetMessage(MessageUIDGenerator.generate(), DragTargetMessage.Flag.DragTargetDragOver, n2, n3, n4, n5, webDragOperation, 0, dragAndDropData.getURL(), dragAndDropData.getURLTitle(), dragAndDropData.getText(), dragAndDropData.getHTML(), dragAndDropData.getHTMLBaseURL()));
                }
            }
        }

        private void a(Transferable object) {
            object = new TransferableWrapper((Transferable)object);
            this.c.n.setData(new DragAndDropData(((TransferableWrapper)object).getURL(), "", ((TransferableWrapper)object).getText(), ((TransferableWrapper)object).getHTML(), ""));
        }

        private void a(Point point, DragAndDropData dragAndDropData) {
            Point point2 = this.c.getLocationOnScreen();
            int n2 = point.x - point2.x;
            int n3 = point.y - point2.y;
            int n4 = point.x;
            int n5 = point.y;
            if (Environment.isWindows()) {
                double d2 = this.c.e.getDeviceScaleFactor();
                n2 = (int)((double)n2 / d2);
                n3 = (int)((double)n3 / d2);
                n4 = (int)((double)n4 / d2);
                n5 = (int)((double)n5 / d2);
            }
            DragTargetMessage.WebDragOperation webDragOperation = DragTargetMessage.WebDragOperation.WebDragOperationEvery;
            if (!this.c.c.isClosed()) {
                this.c.c.send(new DragTargetMessage(MessageUIDGenerator.generate(), DragTargetMessage.Flag.DragTargetDragEnter, n2, n3, n4, n5, webDragOperation, 0, dragAndDropData.getURL(), dragAndDropData.getURLTitle(), dragAndDropData.getText(), dragAndDropData.getHTML(), dragAndDropData.getHTMLBaseURL()));
            }
        }

        private void a(Point point, boolean bl, DragAndDropData dragAndDropData) {
            int n2 = 0;
            int n3 = 0;
            int n4 = point.x;
            int n5 = point.y;
            if (Environment.isWindows()) {
                double d2 = this.c.e.getDeviceScaleFactor();
                n3 = n2 = (int)(0.0 / d2);
                n4 = (int)((double)n4 / d2);
                n5 = (int)((double)n5 / d2);
            }
            DragTargetMessage.WebDragOperation webDragOperation = DragTargetMessage.WebDragOperation.WebDragOperationEvery;
            if (bl) {
                Point point2 = this.c.getLocationOnScreen();
                n2 = point.x - point2.x;
                n3 = point.y - point2.y;
                if (Environment.isWindows()) {
                    double d3 = this.c.e.getDeviceScaleFactor();
                    n2 = (int)((double)n2 / d3);
                    n3 = (int)((double)n3 / d3);
                }
                if (!this.c.c.isClosed()) {
                    this.c.c.send(new DragTargetMessage(MessageUIDGenerator.generate(), DragTargetMessage.Flag.DragTargetDrop, n2, n3, n4, n5, webDragOperation, 0, dragAndDropData.getURL(), dragAndDropData.getURLTitle(), dragAndDropData.getText(), dragAndDropData.getHTML(), dragAndDropData.getHTMLBaseURL()));
                }
            }
            if (!this.c.c.isClosed()) {
                this.c.c.send(new DragEndedMessage(MessageUIDGenerator.generate(), n2, n3, n4, n5, webDragOperation.ordinal()));
            }
            this.c.n.setData(null);
        }

        @Override
        public final void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (this.b) {
                this.a(dragSourceDropEvent.getLocation(), this.a, this.c.n.getData());
            }
        }

        @Override
        public final void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        /* synthetic */ h(WidgetView widgetView, byte by) {
            this(widgetView);
        }
    }

    final class c
    implements ChannelListener {
        private /* synthetic */ WidgetView a;

        private c(WidgetView widgetView) {
            this.a = widgetView;
        }

        @Override
        public final void onMessageReceived(Message message) {
            MessageType messageType = message.getType();
            if (messageType == MessageType.OnPaint) {
                WidgetView.a(this.a, (OnPaintMessage)message);
                return;
            }
            if (messageType == MessageType.OnCursorChange) {
                WidgetView.a(this.a, (OnCursorChangeMessage)message);
                return;
            }
            if (messageType == MessageType.OnRenderViewGone) {
                this.a.a();
                return;
            }
            if (messageType == MessageType.OnRenderViewCreated) {
                this.a.b();
                return;
            }
            if (messageType == MessageType.OnTakeFocus) {
                WidgetView.a((OnTakeFocusMessage)message);
                return;
            }
            if (messageType == MessageType.OnStartDragging) {
                WidgetView.a(this.a, (OnStartDraggingMessage)message);
                return;
            }
            if (messageType == MessageType.OnTooltipChange) {
                WidgetView.a(this.a, (OnTooltipChangeMessage)message);
                return;
            }
            if (messageType == MessageType.OnShowPopupWidget) {
                WidgetView.a(this.a, (OnShowPopupWidgetMessage)message);
                return;
            }
            if (messageType == MessageType.OnGetParentForWindowlessPlugin) {
                ((OnGetParentForWindowlessPluginMessage)message).setHandle(this.a.getNativeHandle());
            }
        }

        /* synthetic */ c(WidgetView widgetView, byte by) {
            this(widgetView);
        }
    }

    final class b
    extends IPCChannelAdapter {
        private /* synthetic */ WidgetView a;

        private b(WidgetView widgetView) {
            this.a = widgetView;
        }

        @Override
        public final void onChannelRemoved(Channel channel) {
            boolean bl;
            Channel channel2 = this.a.getChannel();
            boolean bl2 = channel.getChannelId() == channel2.getChannelId();
            boolean bl3 = bl = channel.getType() == channel2.getType();
            if (bl2 && bl) {
                this.a.a();
            }
        }

        /* synthetic */ b(WidgetView widgetView, byte by) {
            this(widgetView);
        }
    }

    final class d
    extends FocusAdapter {
        private /* synthetic */ WidgetView a;

        private d(WidgetView widgetView) {
            this.a = widgetView;
        }

        @Override
        public final void focusGained(FocusEvent focusEvent) {
            this.a.focus();
        }

        @Override
        public final void focusLost(FocusEvent focusEvent) {
            this.a.unfocus();
        }

        /* synthetic */ d(WidgetView widgetView, byte by) {
            this(widgetView);
        }
    }

    final class g
    extends ComponentAdapter {
        private /* synthetic */ WidgetView a;

        private g(WidgetView widgetView) {
            this.a = widgetView;
        }

        @Override
        public final void componentResized(ComponentEvent serializable) {
            if ((serializable = ((ComponentEvent)serializable).getComponent()) != null) {
                serializable = ((Component)serializable).getBounds();
                this.a.setBounds((Rectangle)serializable);
            }
        }

        /* synthetic */ g(WidgetView widgetView, byte by) {
            this(widgetView);
        }
    }

    final class e
    extends KeyAdapter {
        private /* synthetic */ WidgetView a;

        private e(WidgetView widgetView) {
            this.a = widgetView;
        }

        @Override
        public final void keyPressed(KeyEvent keyEvent) {
            if (this.a(keyEvent)) {
                this.a.forwardKeyPressedEvent(keyEvent);
            }
            if (this.a.s != null) {
                this.a.s.handleKeyPress(keyEvent);
            }
        }

        @Override
        public final void keyTyped(KeyEvent keyEvent) {
            if (this.a(keyEvent)) {
                this.a.forwardKeyTypedEvent(keyEvent);
            }
        }

        @Override
        public final void keyReleased(KeyEvent keyEvent) {
            if (this.a(keyEvent)) {
                this.a.forwardKeyReleasedEvent(keyEvent);
            }
        }

        private boolean a(KeyEvent keyEvent) {
            boolean bl = keyEvent.getKeyChar() == '\n';
            boolean bl2 = keyEvent.getID() == 400;
            if (bl2 && bl && this.a.r) {
                return false;
            }
            return this.a.q == null || !this.a.q.filter(keyEvent);
        }

        /* synthetic */ e(WidgetView widgetView, byte by) {
            this(widgetView);
        }
    }

    final class f
    extends MouseAdapter {
        private /* synthetic */ WidgetView a;

        private f(WidgetView widgetView) {
            this.a = widgetView;
        }

        @Override
        public final void mousePressed(MouseEvent mouseEvent) {
            this.a.forwardMouseEvent(mouseEvent);
            this.a.requestFocus();
        }

        @Override
        public final void mouseReleased(MouseEvent mouseEvent) {
            this.a.forwardMouseEvent(mouseEvent);
        }

        @Override
        public final void mouseEntered(MouseEvent mouseEvent) {
            this.a.forwardMouseEvent(mouseEvent);
        }

        @Override
        public final void mouseExited(MouseEvent mouseEvent) {
            this.a.forwardMouseEvent(mouseEvent);
        }

        @Override
        public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.a.forwardMouseWheelEvent(mouseWheelEvent);
            mouseWheelEvent.consume();
        }

        /* synthetic */ f(WidgetView widgetView, byte by) {
            this(widgetView);
        }
    }

    final class i
    extends ComponentAdapter {
        private /* synthetic */ WidgetView a;

        private i(WidgetView widgetView) {
            this.a = widgetView;
        }

        @Override
        public final void componentMoved(ComponentEvent componentEvent) {
            this.a.d();
        }

        /* synthetic */ i(WidgetView widgetView, byte by) {
            this(widgetView);
        }
    }
}

