/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.swing.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public enum CursorType {
    TypePointer,
    TypeCross,
    TypeHand,
    TypeIBeam,
    TypeWait,
    TypeHelp,
    TypeEastResize,
    TypeNorthResize,
    TypeNorthEastResize,
    TypeNorthWestResize,
    TypeSouthResize,
    TypeSouthEastResize,
    TypeSouthWestResize,
    TypeWestResize,
    TypeNorthSouthResize,
    TypeEastWestResize,
    TypeNorthEastSouthWestResize,
    TypeNorthWestSouthEastResize,
    TypeColumnResize,
    TypeRowResize,
    TypeMiddlePanning,
    TypeEastPanning,
    TypeNorthPanning,
    TypeNorthEastPanning,
    TypeNorthWestPanning,
    TypeSouthPanning,
    TypeSouthEastPanning,
    TypeSouthWestPanning,
    TypeWestPanning,
    TypeMove,
    TypeVerticalText,
    TypeCell,
    TypeContextMenu,
    TypeAlias,
    TypeProgress,
    TypeNoDrop,
    TypeCopy,
    TypeNone,
    TypeNotAllowed,
    TypeZoomIn,
    TypeZoomOut,
    TypeGrab,
    TypeGrabbing,
    TypeCustom;

    private static final Properties a;
    private static final Logger b;

    public static Cursor toJavaCursor(int n2, byte[] byArray, int n3, int n4) {
        CursorType[] cursorTypeArray = CursorType.values();
        if (n2 < cursorTypeArray.length) {
            Object object = cursorTypeArray[n2];
            if (object == TypeCustom) {
                BufferedImage bufferedImage;
                BufferedImage bufferedImage2;
                int n5;
                int n6;
                object = Toolkit.getDefaultToolkit().getBestCursorSize(n3, n4);
                int n7 = ((Dimension)object).width;
                int n8 = ((Dimension)object).height;
                if (n7 == 0 && n8 == 0) {
                    return Cursor.getDefaultCursor();
                }
                int n9 = n3;
                int n10 = n4;
                int n11 = n7;
                n7 = n8;
                n4 = n11;
                n3 = n10;
                int n12 = n9;
                Object object2 = byArray;
                int[] nArray = new int[byArray.length / 4];
                int n13 = 0;
                for (int i2 = 0; i2 < ((byte[])object2).length; i2 += 4) {
                    n6 = object2[i2 + 3] & 0xFF;
                    n5 = object2[i2 + 2] & 0xFF;
                    int n14 = object2[i2 + 1] & 0xFF;
                    int n15 = object2[i2] & 0xFF;
                    nArray[n13++] = n6 << 24 | n5 << 16 | n14 << 8 | n15;
                }
                if (Environment.isWindows()) {
                    n6 = n12 >= n4 ? n12 : n4;
                    n5 = n3 >= n7 ? n3 : n7;
                    bufferedImage2 = new BufferedImage(n6, n5, 2);
                    if (n12 < n4 || n3 < n7) {
                        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                        graphics2D.setColor(new Color(0, 0, 0, 0));
                        graphics2D.setComposite(AlphaComposite.getInstance(4));
                        graphics2D.fillRect(0, 0, n4, n7);
                    }
                } else {
                    bufferedImage2 = new BufferedImage(n12, n3, 2);
                }
                for (n6 = 0; n6 < n3; ++n6) {
                    for (n5 = 0; n5 < n12; ++n5) {
                        bufferedImage2.setRGB(n5, n6, nArray[n5 + n6 * n12]);
                    }
                }
                if (n12 != n4 || n3 != n7) {
                    bufferedImage = new BufferedImage(n4, n7, 2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    graphics2D.drawImage(bufferedImage2, 0, 0, n4, n7, null);
                } else {
                    bufferedImage = bufferedImage2;
                }
                object2 = bufferedImage;
                return Toolkit.getDefaultToolkit().createCustomCursor((Image)object2, new Point(), "customCursor");
            }
            return CursorType.a(object.name());
        }
        return Cursor.getDefaultCursor();
    }

    private static Cursor a(String string) {
        block7: {
            try {
                Object object = a.getProperty(string + ".swing");
                if (object != null) {
                    int n2 = Cursor.class.getDeclaredField((String)object).getInt(null);
                    return new Cursor(n2);
                }
                object = string + ".file";
                if (Environment.isMac()) {
                    object = (String)object + ".mac";
                }
                object = a.getProperty((String)object);
                Object object2 = a.getProperty(string + ".hotspot");
                if (object == null) break block7;
                object = CursorType.class.getResource((String)object);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                object = toolkit.getImage((URL)object);
                Point point = new Point(0, 0);
                if (object2 != null && ((StringTokenizer)(object2 = new StringTokenizer((String)object2, ","))).countTokens() == 2) {
                    try {
                        point.x = Integer.parseInt(((StringTokenizer)object2).nextToken());
                        point.y = Integer.parseInt(((StringTokenizer)object2).nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        b.warning("Failed to parse hotspot property for cursor: " + string);
                    }
                }
                object2 = toolkit.createCustomCursor((Image)object, point, string);
                return object2;
            }
            catch (Exception exception) {
                b.warning("Unable to load cursor from resources: " + string);
            }
        }
        return Cursor.getDefaultCursor();
    }

    static {
        a = new Properties();
        b = LoggerProvider.getBrowserLogger();
        URL uRL = CursorType.class.getResource("/com/teamdev/jxbrowser/chromium/internal/cursors.properties");
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                a.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                b.warning("Unable to load cursors properties from:" + uRL);
            }
        }
    }
}

