/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.swing;

import com.teamdev.jxbrowser.chromium.Certificate;
import com.teamdev.jxbrowser.chromium.CertificatesDialogParams;
import com.teamdev.jxbrowser.chromium.CloseStatus;
import com.teamdev.jxbrowser.chromium.DialogHandler;
import com.teamdev.jxbrowser.chromium.DialogParams;
import com.teamdev.jxbrowser.chromium.FileChooserMode;
import com.teamdev.jxbrowser.chromium.FileChooserParams;
import com.teamdev.jxbrowser.chromium.PromptDialogParams;
import com.teamdev.jxbrowser.chromium.ReloadPostDataParams;
import com.teamdev.jxbrowser.chromium.UnloadDialogParams;
import com.teamdev.jxbrowser.chromium.swing.b;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DefaultDialogHandler
implements DialogHandler {
    private final JComponent a;

    public DefaultDialogHandler(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("The component parameter cannot be null.");
        }
        this.a = jComponent;
    }

    @Override
    public void onAlert(DialogParams object) {
        String string = ((DialogParams)object).getURL();
        string = "The page at " + string + " says:";
        object = ((DialogParams)object).getMessage();
        JOptionPane.showMessageDialog(this.a, object, string, -1);
    }

    @Override
    public CloseStatus onConfirmation(DialogParams object) {
        String string = ((DialogParams)object).getURL();
        string = "The page at " + string + " says:";
        int n2 = JOptionPane.showConfirmDialog(this.a, object = ((DialogParams)object).getMessage(), string, 2, -1);
        if (n2 == 0) {
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    @Override
    public CloseStatus onPrompt(PromptDialogParams promptDialogParams) {
        String string = promptDialogParams.getURL();
        string = "The page at " + string + " says:";
        Object[] objectArray = promptDialogParams.getMessage();
        JTextField jTextField = new JTextField(promptDialogParams.getPromptText());
        int n2 = JOptionPane.showConfirmDialog(this.a, objectArray = new Object[]{new JLabel((String)objectArray), jTextField}, string, 2, -1);
        if (n2 == 0) {
            promptDialogParams.setPromptText(jTextField.getText());
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    @Override
    public CloseStatus onFileChooser(FileChooserParams fileChooserParams) {
        boolean bl;
        boolean bl2 = fileChooserParams.getMode() == FileChooserMode.Open;
        boolean bl3 = bl = fileChooserParams.getMode() == FileChooserMode.OpenMultiple;
        if (bl2 || bl) {
            File[] fileArray = new JFileChooser();
            fileArray.setMultiSelectionEnabled(bl);
            fileArray.setDialogTitle("Open");
            AtomicInteger atomicInteger = new AtomicInteger(1);
            try {
                SwingUtilities.invokeAndWait(new b(this, atomicInteger, (JFileChooser)fileArray));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            if (atomicInteger.get() == 0) {
                if (bl) {
                    fileArray = fileArray.getSelectedFiles();
                    fileChooserParams.setSelectedFiles(fileArray);
                } else {
                    fileChooserParams.setSelectedFiles(fileArray.getSelectedFile());
                }
                return CloseStatus.OK;
            }
        }
        return CloseStatus.CANCEL;
    }

    @Override
    public CloseStatus onBeforeUnload(UnloadDialogParams unloadDialogParams) {
        int n2;
        String string = "Confirm Navigation";
        String string2 = unloadDialogParams.getMessage();
        Object[] objectArray = new Object[]{"Leave this Page", "Stay on this Page"};
        if (unloadDialogParams.isReload()) {
            string = "Confirm Reload";
            objectArray = new Object[]{"Reload this Page", "Don't Reload"};
        }
        if ((n2 = JOptionPane.showOptionDialog(this.a, string2, string, 2, -1, null, objectArray, objectArray[0])) == 0) {
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    @Override
    public CloseStatus onSelectCertificate(CertificatesDialogParams certificatesDialogParams) {
        Object object = "Select a certificate to authenticate yourself to " + certificatesDialogParams.getHostPortPair().getHostPort();
        Object[] objectArray = certificatesDialogParams.getCertificates();
        if (!objectArray.isEmpty() && (object = JOptionPane.showInputDialog(this.a, object, "Select a certificate", -1, null, objectArray = objectArray.toArray(), objectArray[0])) != null) {
            certificatesDialogParams.setSelectedCertificate((Certificate)object);
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    @Override
    public CloseStatus onReloadPostData(ReloadPostDataParams object) {
        object = "Confirm Form Resubmission";
        String string = "The page that you're looking for used information that you entered.\nReturning to that page might cause any action you took to be repeated.\nDo you want to continue?";
        Object[] objectArray = new Object[]{"Continue", "Cancel"};
        int n2 = JOptionPane.showOptionDialog(this.a, string, (String)object, 2, -1, null, objectArray, objectArray[0]);
        if (n2 == 0) {
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    static /* synthetic */ JComponent a(DefaultDialogHandler defaultDialogHandler) {
        return defaultDialogHandler.a;
    }
}

