/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.javafx.internal;

import com.teamdev.jxbrowser.chromium.javafx.internal.KeyEventType;
import com.teamdev.jxbrowser.chromium.javafx.internal.KeyModifiers;
import com.teamdev.jxbrowser.chromium.javafx.internal.MouseEventType;
import java.util.HashMap;
import java.util.Map;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.stage.Window;

public class FXUtil {
    private static final Map<EventType<MouseEvent>, MouseEventType> a = new HashMap<EventType<MouseEvent>, MouseEventType>();
    private static final Map<EventType<KeyEvent>, KeyEventType> b = new HashMap<EventType<KeyEvent>, KeyEventType>();

    public static int getNativeEventType(MouseEvent object) {
        object = object.getEventType();
        if ((object = a.get(object)) != null) {
            return ((MouseEventType)((Object)object)).getValue();
        }
        return 0;
    }

    public static int getNativeEventType(KeyEvent object) {
        object = object.getEventType();
        if ((object = b.get(object)) != null) {
            return ((KeyEventType)((Object)object)).getValue();
        }
        return 0;
    }

    public static int getModifiers(KeyEvent keyEvent) {
        int n2 = 0;
        if (keyEvent.isShiftDown()) {
            n2 = 0 | KeyModifiers.SHIFT_DOWN_MASK.getValue();
        }
        if (keyEvent.isControlDown()) {
            n2 |= KeyModifiers.CTRL_DOWN_MASK.getValue();
        }
        if (keyEvent.isAltDown()) {
            n2 |= KeyModifiers.ALT_DOWN_MASK.getValue();
        }
        if (keyEvent.isMetaDown()) {
            n2 |= KeyModifiers.META_DOWN_MASK.getValue();
        }
        return n2;
    }

    public static int getModifiers(ScrollEvent scrollEvent) {
        int n2 = 0;
        if (scrollEvent.isShiftDown()) {
            n2 = 0 | KeyModifiers.SHIFT_DOWN_MASK.getValue();
        }
        if (scrollEvent.isControlDown()) {
            n2 |= KeyModifiers.CTRL_DOWN_MASK.getValue();
        }
        if (scrollEvent.isAltDown()) {
            n2 |= KeyModifiers.ALT_DOWN_MASK.getValue();
        }
        if (scrollEvent.isMetaDown()) {
            n2 |= KeyModifiers.META_DOWN_MASK.getValue();
        }
        return n2;
    }

    public static int getModifiers(MouseEvent mouseEvent) {
        int n2 = 0;
        if (mouseEvent.isShiftDown()) {
            n2 = 0 | KeyModifiers.SHIFT_DOWN_MASK.getValue();
        }
        if (mouseEvent.isControlDown()) {
            n2 |= KeyModifiers.CTRL_DOWN_MASK.getValue();
        }
        if (mouseEvent.isAltDown()) {
            n2 |= KeyModifiers.ALT_DOWN_MASK.getValue();
        }
        if (mouseEvent.isMetaDown()) {
            n2 |= KeyModifiers.META_DOWN_MASK.getValue();
        }
        if (mouseEvent.isPrimaryButtonDown()) {
            n2 |= KeyModifiers.LEFT_BUTTON_MASK.getValue();
        }
        if (mouseEvent.isMiddleButtonDown()) {
            n2 |= KeyModifiers.MIDDLE_BUTTON_MASK.getValue();
        }
        if (mouseEvent.isSecondaryButtonDown()) {
            n2 |= KeyModifiers.RIGHT_BUTTON_MASK.getValue();
        }
        return n2;
    }

    public static Window getWindowForNode(Node node) {
        if (node != null && (node = node.getScene()) != null) {
            return node.getWindow();
        }
        return null;
    }

    static {
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED, MouseEventType.MOUSE_CLICKED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_PRESSED, MouseEventType.MOUSE_PRESSED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_RELEASED, MouseEventType.MOUSE_RELEASED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_MOVED, MouseEventType.MOUSE_MOVED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_ENTERED, MouseEventType.MOUSE_ENTERED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_EXITED, MouseEventType.MOUSE_EXITED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_DRAGGED, MouseEventType.MOUSE_DRAGGED);
        b.put((EventType<KeyEvent>)KeyEvent.KEY_PRESSED, KeyEventType.KEY_PRESSED);
        b.put((EventType<KeyEvent>)KeyEvent.KEY_RELEASED, KeyEventType.KEY_RELEASED);
        b.put((EventType<KeyEvent>)KeyEvent.KEY_TYPED, KeyEventType.KEY_TYPED);
    }
}

