/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.javafx.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;

public enum CursorType {
    TypePointer,
    TypeCross,
    TypeHand,
    TypeIBeam,
    TypeWait,
    TypeHelp,
    TypeEastResize,
    TypeNorthResize,
    TypeNorthEastResize,
    TypeNorthWestResize,
    TypeSouthResize,
    TypeSouthEastResize,
    TypeSouthWestResize,
    TypeWestResize,
    TypeNorthSouthResize,
    TypeEastWestResize,
    TypeNorthEastSouthWestResize,
    TypeNorthWestSouthEastResize,
    TypeColumnResize,
    TypeRowResize,
    TypeMiddlePanning,
    TypeEastPanning,
    TypeNorthPanning,
    TypeNorthEastPanning,
    TypeNorthWestPanning,
    TypeSouthPanning,
    TypeSouthEastPanning,
    TypeSouthWestPanning,
    TypeWestPanning,
    TypeMove,
    TypeVerticalText,
    TypeCell,
    TypeContextMenu,
    TypeAlias,
    TypeProgress,
    TypeNoDrop,
    TypeCopy,
    TypeNone,
    TypeNotAllowed,
    TypeZoomIn,
    TypeZoomOut,
    TypeGrab,
    TypeGrabbing,
    TypeCustom;

    private static final Properties a;
    private static final Logger b;

    public static Cursor toJavaCursor(int n2, byte[] byArray, int n3, int n4) {
        CursorType[] cursorTypeArray = CursorType.values();
        if (n2 < cursorTypeArray.length) {
            CursorType cursorType = cursorTypeArray[n2];
            if (cursorType == TypeCustom) {
                WritableImage writableImage;
                cursorType = ImageCursor.getBestSize((double)n3, (double)n4);
                int n5 = (int)cursorType.getWidth();
                int n6 = (int)cursorType.getHeight();
                int n7 = n3;
                int n8 = n4;
                int n9 = n5;
                n5 = n6;
                n4 = n9;
                n3 = n8;
                int n10 = n7;
                Object object = byArray;
                if (Environment.isWindows()) {
                    int n11 = n10 >= n4 ? n10 : n4;
                    n4 = n3 >= n5 ? n3 : n5;
                    writableImage = new WritableImage(n11, n4);
                } else {
                    writableImage = new WritableImage(n10, n3);
                }
                PixelWriter pixelWriter = writableImage.getPixelWriter();
                pixelWriter.setPixels(0, 0, n10, n3, (PixelFormat)PixelFormat.getByteBgraInstance(), object, 0, n10 << 2);
                object = writableImage;
                return new ImageCursor((Image)object);
            }
            return CursorType.a(cursorType.name());
        }
        return Cursor.DEFAULT;
    }

    private static Cursor a(String string) {
        block7: {
            try {
                Object object = a.getProperty(string + ".javafx");
                if (object != null && (object = Cursor.class.getDeclaredField((String)object).get(Cursor.class)) != null) {
                    return (Cursor)object;
                }
                object = string + ".file";
                if (Environment.isMac()) {
                    object = (String)object + ".mac";
                }
                object = a.getProperty((String)object);
                Object object2 = a.getProperty(string + ".hotspot");
                if (object == null) break block7;
                object = CursorType.class.getResource((String)object);
                object = new Image(((URL)object).toString());
                Point point = new Point(0, 0);
                if (object2 != null && ((StringTokenizer)(object2 = new StringTokenizer((String)object2, ","))).countTokens() == 2) {
                    try {
                        point.x = Integer.parseInt(((StringTokenizer)object2).nextToken());
                        point.y = Integer.parseInt(((StringTokenizer)object2).nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        b.warning("Failed to parse hotspot property for cursor: " + string);
                    }
                }
                object2 = new ImageCursor((Image)object, point.getX(), point.getY());
                return object2;
            }
            catch (Exception exception) {
                b.warning("Unable to load cursor from resources: " + string);
            }
        }
        return Cursor.DEFAULT;
    }

    static {
        a = new Properties();
        b = LoggerProvider.getBrowserLogger();
        URL uRL = CursorType.class.getResource("/com/teamdev/jxbrowser/chromium/internal/cursors.properties");
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                a.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                b.warning("Unable to load cursors properties from:" + uRL);
            }
        }
    }
}

