/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ipc.ServerException;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketChannelReader;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketChannelStream;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketChannelWriter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ServerListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.m;
import com.teamdev.jxbrowser.chromium.internal.ipc.n;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class Server {
    private static final Logger a = LoggerProvider.getIPCLogger();
    private final List<ServerListener> b = new CopyOnWriteArrayList<ServerListener>();
    private ServerSocket c;

    public void addServerListener(ServerListener serverListener) {
        if (!this.b.contains(serverListener)) {
            this.b.add(serverListener);
        }
    }

    public void removeServerListener(ServerListener serverListener) {
        this.b.remove(serverListener);
    }

    public List<ServerListener> getServerListeners() {
        return new ArrayList<ServerListener>(this.b);
    }

    public int getPort() {
        if (this.c != null) {
            return this.c.getLocalPort();
        }
        return 0;
    }

    public void start(int n2) {
        if (this.isStarted()) {
            return;
        }
        try {
            this.c = new ServerSocket(n2, 0, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException iOException) {
            throw new ServerException("Failed to create socket at port: " + n2, iOException);
        }
        for (ServerListener serverListener : this.getServerListeners()) {
            serverListener.onServerStarted();
        }
        while (true) {
            Object object2;
            try {
                object2 = this.c.accept();
            }
            catch (IOException iOException) {
                if (!this.c.isClosed()) {
                    throw new ServerException("Failed to accept client connection.", iOException);
                }
                for (ServerListener serverListener : this.getServerListeners()) {
                    serverListener.onServerStopped();
                }
                return;
            }
            SocketChannelStream socketChannelStream = new SocketChannelStream((Socket)object2);
            socketChannelStream.addChannelStreamListener(new m(this));
            object2 = new SocketChannelWriter(socketChannelStream);
            SocketChannelReader object3 = new SocketChannelReader(socketChannelStream);
            object3.addChannelListener(new n(this, object3, (SocketChannelWriter)object2, socketChannelStream));
            new Thread((Runnable)object3, "Socket Reader").start();
            new Thread((Runnable)object2, "Socket Writer").start();
        }
    }

    public boolean isStarted() {
        return this.c != null && !this.c.isClosed();
    }

    public void stop() {
        if (this.isStarted()) {
            a.info("Stopping Server...");
            try {
                this.c.close();
            }
            catch (IOException iOException) {
                throw new ServerException("Failed to close socket connection.", iOException);
            }
            for (ServerListener serverListener : this.getServerListeners()) {
                serverListener.onServerStopped();
            }
            a.info("Stopping Server... [DONE]");
        }
    }

    static /* synthetic */ Logger a() {
        return a;
    }
}

