/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ChromiumExtractor;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcess;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPCException;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.Sender;
import com.teamdev.jxbrowser.chromium.internal.ipc.Server;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.c;
import com.teamdev.jxbrowser.chromium.internal.ipc.d;
import com.teamdev.jxbrowser.chromium.internal.ipc.e;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ServerAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ServerListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.g;
import com.teamdev.jxbrowser.chromium.internal.ipc.h;
import com.teamdev.jxbrowser.chromium.internal.ipc.i;
import com.teamdev.jxbrowser.chromium.internal.ipc.j;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ShutdownMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class IPC
implements Sender {
    private static final Logger a = LoggerProvider.getIPCLogger();
    private Channel b;
    private final Server c;
    private final ChromiumProcess d;
    private final List<Channel> e;
    private final ServerListener f;
    private final AtomicInteger g;
    private final List<IPCChannelListener> h;

    public static synchronized IPC getDefault() {
        return com.teamdev.jxbrowser.chromium.internal.ipc.IPC$a.a;
    }

    public static synchronized IPC create() {
        Object object = new Server();
        String string = BrowserPreferences.getChromiumDir();
        object = new IPC((Server)object, new ChromiumProcess(string));
        return object;
    }

    public IPC(Server server, ChromiumProcess chromiumProcess) {
        j.a().b();
        Environment.traceEnvironment();
        Environment.checkEnvironment();
        String string = BrowserPreferences.getChromiumDir();
        ChromiumExtractor chromiumExtractor = ChromiumExtractor.create();
        if (chromiumExtractor.shouldExtract(string)) {
            chromiumExtractor.extract(string);
        }
        this.c = server;
        this.d = chromiumProcess;
        this.f = new b(this, 0);
        this.e = new CopyOnWriteArrayList<Channel>();
        this.h = new CopyOnWriteArrayList<IPCChannelListener>();
        this.g = new AtomicInteger();
        Runtime.getRuntime().addShutdownHook(new Thread(new com.teamdev.jxbrowser.chromium.internal.ipc.b(this)));
    }

    public synchronized Channel getMainChannel() {
        return this.b;
    }

    public synchronized boolean isStarted() {
        return this.c.isStarted();
    }

    public synchronized void start() {
        this.g.incrementAndGet();
        a.info("Starting IPC...");
        if (this.c.isStarted()) {
            a.info("IPC is already started.");
            if (!this.d.isStarted()) {
                a.info("Chromium process is dead. Restarting IPC...");
                this.b = this.a(false);
                return;
            }
            return;
        }
        this.b = this.a(true);
        this.c.addServerListener(this.f);
        a.info("IPC is started.");
    }

    private Channel a(boolean bl) {
        Object object;
        Object object2;
        AtomicReference atomicReference = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference<IPCException> atomicReference2 = new AtomicReference<IPCException>();
        c c2 = new c(this, atomicReference, countDownLatch);
        this.c.addServerListener(c2);
        if (bl) {
            int n2;
            int n3 = n2 = SocketUtil.getNextAvailablePort(1100);
            AtomicReference<IPCException> atomicReference3 = atomicReference2;
            object2 = countDownLatch;
            object = this;
            a.info("Starting IPC Server...");
            CountDownLatch countDownLatch2 = new CountDownLatch(1);
            object = new Thread(new e((IPC)object, countDownLatch2, n3, atomicReference3, (CountDownLatch)object2));
            ((Thread)object).setName("IPC Server Thread");
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
            LatchUtil.await(countDownLatch2, new RuntimeException(new TimeoutException()), 15);
            this.a(countDownLatch, atomicReference2, n2);
        } else {
            this.a(countDownLatch, atomicReference2, this.c.getPort());
        }
        try {
            LatchUtil.await(countDownLatch, new IPCException("Failed to initialize IPC. Remote process doesn't respond."));
        }
        finally {
            this.c.removeServerListener(c2);
        }
        object = atomicReference2;
        object2 = ((AtomicReference)object).get();
        if (object2 != null) {
            throw object2;
        }
        for (IPCChannelListener iPCChannelListener : this.getIPCChannelListeners()) {
            iPCChannelListener.onMainChannelAdded((Channel)atomicReference.get());
        }
        return (Channel)atomicReference.get();
    }

    private void a(CountDownLatch object, AtomicReference<IPCException> atomicReference, int n2) {
        a.info("Starting IPC Process...");
        object = new Thread(new d(this, n2, atomicReference, (CountDownLatch)object));
        ((Thread)object).setName("IPC Process Thread");
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    private synchronized void b() {
        a.info("Shutdown IPC...");
        if (this.c.isStarted()) {
            this.c();
            this.c.removeServerListener(this.f);
            this.c.stop();
            this.d();
        }
    }

    public synchronized void stop() {
        if (this.g.decrementAndGet() > 0) {
            return;
        }
        a.info("Stopping IPC...");
        if (!this.c.isStarted()) {
            a.info("IPC is already stopped.");
            return;
        }
        this.c();
        this.c.stop();
        this.e();
        this.c.removeServerListener(this.f);
        this.d();
        a.info("IPC is stopped.");
    }

    private void c() {
        if (this.b.isClosed()) {
            return;
        }
        a.info("Stopping main channel...");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        long l2 = this.b.getChannelId();
        g object2 = new g(this, l2, countDownLatch);
        this.c.addServerListener(object2);
        this.send(new ShutdownMessage(MessageUIDGenerator.generate()));
        try {
            LatchUtil.await(countDownLatch, new IPCException("Failed to execute shutdown post message."));
        }
        finally {
            this.c.removeServerListener(object2);
        }
        for (IPCChannelListener iPCChannelListener : this.getIPCChannelListeners()) {
            iPCChannelListener.onMainChannelRemoved(this.b);
        }
    }

    private void d() {
        a.info("Waiting process exit...");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        h h2 = new h(this, countDownLatch);
        this.d.addChromiumProcessListener(h2);
        try {
            if (this.d.isStarted()) {
                LatchUtil.await(countDownLatch, new IPCException("Chromium process hasn't been exited because of timeout."));
            }
            return;
        }
        finally {
            this.d.removeChromiumProcessListener(h2);
        }
    }

    private synchronized void e() {
        while (!this.e.isEmpty()) {
            a.info("Waiting for channels disconnection...");
            for (Channel channel : this.getChannels()) {
                a.info("\tWaiting for channel: " + channel);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void addIPCChannelListener(IPCChannelListener iPCChannelListener) {
        if (!this.h.contains(iPCChannelListener)) {
            this.h.add(iPCChannelListener);
        }
    }

    public void removeIPCChannelListener(IPCChannelListener iPCChannelListener) {
        this.h.remove(iPCChannelListener);
    }

    public List<IPCChannelListener> getIPCChannelListeners() {
        return new ArrayList<IPCChannelListener>(this.h);
    }

    public Channel getChannel(long l2, ChannelType channelType) {
        for (Channel channel : this.getChannels()) {
            boolean bl;
            boolean bl2 = channel.getChannelId() == l2;
            boolean bl3 = bl = channel.getType() == channelType;
            if (!bl2 || !bl) continue;
            return channel;
        }
        return null;
    }

    public boolean hasChannel(long l2, ChannelType channelType) {
        for (Channel channel : this.getChannels()) {
            boolean bl;
            boolean bl2 = channel.getChannelId() == l2;
            boolean bl3 = bl = channel.getType() == channelType;
            if (!bl2 || !bl) continue;
            return true;
        }
        return false;
    }

    public void waitChannel(long l2, ChannelType channelType) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        i i2 = new i(this, l2, channelType, countDownLatch);
        this.addIPCChannelListener(i2);
        if (this.hasChannel(l2, channelType)) {
            return;
        }
        try {
            LatchUtil.await(countDownLatch, new IPCException("Failed to get Browser channel " + l2));
            return;
        }
        finally {
            this.removeIPCChannelListener(i2);
        }
    }

    public List<Channel> getChannels() {
        return new ArrayList<Channel>(this.e);
    }

    @Override
    public synchronized void send(Message message) {
        if (!this.isStarted()) {
            throw new IllegalStateException("IPC isn't started.");
        }
        this.b.send(message);
    }

    @Override
    public synchronized <T extends Message> T post(T t2) {
        if (!this.isStarted()) {
            throw new IllegalStateException("IPC isn't started.");
        }
        return this.b.post(t2);
    }

    static /* synthetic */ void a(IPC iPC) {
        iPC.b();
    }

    static /* synthetic */ ChromiumProcess b(IPC iPC) {
        return iPC.d;
    }

    static /* synthetic */ Server c(IPC iPC) {
        return iPC.c;
    }

    final class b
    extends ServerAdapter {
        private /* synthetic */ IPC a;

        private b(IPC iPC) {
            this.a = iPC;
        }

        @Override
        public final void onChannelConnected(Channel channel) {
            if (!this.a.hasChannel(channel.getChannelId(), channel.getType())) {
                this.a.e.add(channel);
                a.info("Channel is connected: " + channel);
                for (IPCChannelListener iPCChannelListener : this.a.getIPCChannelListeners()) {
                    iPCChannelListener.onChannelAdded(channel);
                }
            }
        }

        @Override
        public final void onChannelDisconnected(Channel channel) {
            if (this.a.e.remove(channel)) {
                a.info("Channel is disconnected: " + channel);
                for (IPCChannelListener iPCChannelListener : this.a.getIPCChannelListeners()) {
                    iPCChannelListener.onChannelRemoved(channel);
                }
            }
        }

        /* synthetic */ b(IPC iPC, byte by) {
            this(iPC);
        }
    }

    static final class a {
        private static final IPC a = IPC.create();
    }
}

