/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcessLogger;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChromiumProcessListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChromiumProcess {
    private static final Logger a = LoggerProvider.getChromiumProcessLogger();
    private Process b;
    private final File c;
    private final List<ChromiumProcessListener> d;

    public ChromiumProcess(String string) {
        String string2;
        if (Environment.isWindows()) {
            string2 = "jxbrowser-chromium.exe";
        } else if (Environment.isMac()) {
            string2 = "jxbrowser.app/Contents/MacOS/jxbrowser";
        } else if (Environment.isLinux()) {
            string2 = "jxbrowser-chromium";
        } else {
            throw new RuntimeException("Unsupported operating system.");
        }
        this.c = new File(string, string2);
        this.d = new CopyOnWriteArrayList<ChromiumProcessListener>();
    }

    public void addChromiumProcessListener(ChromiumProcessListener chromiumProcessListener) {
        if (!this.d.contains(chromiumProcessListener)) {
            this.d.add(chromiumProcessListener);
        }
    }

    public void removeChromiumProcessListener(ChromiumProcessListener chromiumProcessListener) {
        this.d.remove(chromiumProcessListener);
    }

    public List<ChromiumProcessListener> getChromiumProcessListeners() {
        return new ArrayList<ChromiumProcessListener>(this.d);
    }

    public int start(int n2) {
        ProcessBuilder processBuilder;
        a.info("Start Chromium process...");
        String object3 = this.c.getParentFile().getAbsolutePath();
        int n3 = n2;
        Object object = this;
        Map<String, String> map = ((ChromiumProcess)object).c.getAbsolutePath();
        object = new LinkedHashSet<String>();
        object.add(map);
        object.add(String.valueOf(n3));
        object.add(String.valueOf(SharedMemoryLibrary.getInstance().getCurrentProcessId()));
        Iterator<ChromiumProcessListener> iterator = BrowserPreferences.getUserAgent();
        if (iterator != null && !((String)((Object)iterator)).isEmpty()) {
            object.add("--user-agent=" + (String)((Object)iterator));
        }
        object.add("--enable-npapi");
        iterator = BrowserPreferences.getChromiumSwitches();
        object.addAll(iterator);
        iterator = new ArrayList<String>((Collection<String>)object);
        ProcessBuilder processBuilder2 = processBuilder = new ProcessBuilder((List<String>)((Object)iterator));
        object = object3;
        if (Environment.isLinux()) {
            map = processBuilder2.environment();
            if (map.containsKey("LD_LIBRARY_PATH")) {
                object = (String)object + ':' + (String)map.get("LD_LIBRARY_PATH");
            }
            map.put("LD_LIBRARY_PATH", (String)object);
        }
        ChromiumProcess.a(processBuilder);
        processBuilder.directory(new File(object3));
        processBuilder.redirectErrorStream(true);
        object = object3;
        if (Environment.isLinux()) {
            ChromiumProcess.a("libudev.so.0", "libudev.so.", (String)object);
            ChromiumProcess.a("libgcrypt.so.11", "libgcrypt.so.", (String)object);
        }
        try {
            StringBuilder interruptedException = new StringBuilder();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                interruptedException.append((String)object);
                interruptedException.append(' ');
            }
            a.info("Command line: " + interruptedException);
            this.b = processBuilder.start();
            iterator = new ChromiumProcessLogger();
            ((ChromiumProcessLogger)((Object)iterator)).startLogging(this.b);
            int n4 = this.b.waitFor();
            this.b = null;
            a.info("Chromium process exit code " + n4);
            for (ChromiumProcessListener exception : this.getChromiumProcessListeners()) {
                exception.onExit(n4);
            }
            return n4;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void a(ProcessBuilder object) {
        object = ((ProcessBuilder)((Object)object)).environment();
        Map<String, String> map = BrowserPreferences.getChromiumVariables();
        for (Map.Entry entry : map.entrySet()) {
            object.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static void a(String string, String string2, String string3) {
        String[] stringArray;
        string3 = string3 + File.separator;
        Object object = Environment.is64Bit() ? "/lib/x86_64-linux-gnu/" : "/lib/i386-linux-gnu/";
        object = new File((String)object + string);
        a.info("The '" + ((File)object).getAbsolutePath() + "' library exists: " + (((File)object).exists() ? "TRUE" : "FALSE"));
        if (((File)object).exists()) {
            return;
        }
        object = new File(string3 + string);
        a.info("The '" + ((File)object).getAbsolutePath() + "' library exists: " + (((File)object).exists() ? "TRUE" : "FALSE"));
        if (((File)object).exists()) {
            return;
        }
        object = null;
        boolean bl = Environment.is64Bit();
        if (bl) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "/lib/x86_64-linux-gnu/";
            stringArray2[1] = "/lib64/";
            stringArray = stringArray2;
            stringArray2[2] = "/usr/lib64/";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "/lib/i386-linux-gnu/";
            stringArray3[1] = "/lib/";
            stringArray = stringArray3;
            stringArray3[2] = "/usr/lib/";
        }
        String[] stringArray4 = stringArray;
        stringArray4 = stringArray;
        for (int i2 = 0; i2 < 3; ++i2) {
            object = stringArray4[i2];
            a.info("Looking for " + string2 + "x.x.x in '" + (String)object + "'...");
            object = FileUtil.findByTemplate((String)object, string2);
            if (object == null) continue;
            a.info("Found the '" + ((File)object).getAbsolutePath() + "' library");
            string = "/bin/ln -s " + ((File)object).getAbsolutePath() + ' ' + string3 + string;
            a.info("Create symlink: " + string);
            try {
                Runtime.getRuntime().exec(string);
            }
            catch (IOException iOException) {
                a.log(Level.SEVERE, "Failed to execute the '" + string + "' command.", iOException);
            }
            break;
        }
        if (object == null) {
            a.info("Failed to find " + string2 + "x.x.x");
        }
    }

    public boolean isStarted() {
        return this.b != null;
    }
}

