/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.LibraryLoader;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class SharedMemoryLibrary {
    private static SharedMemoryLibrary a = null;

    public static SharedMemoryLibrary getInstance() {
        if (a == null) {
            a = new SharedMemoryLibrary();
            return a;
        }
        return a;
    }

    public native boolean isCursorVisible();

    public native long getCurrentProcessId();

    public native void updatePixels(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int[] var13);

    public native void updatePixels(String var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int[] var10);

    public native long getScreenId(long var1);

    private SharedMemoryLibrary() {
        File file = new File(BrowserPreferences.getChromiumDir(), SharedMemoryLibrary.getName());
        Object object = file;
        File file2 = new File(BrowserPreferences.getTempDir());
        FileUtil.createDirs(file2);
        String string = FileUtil.getFileName((File)object);
        object = FileUtil.getFileExtension((File)object, true);
        String string2 = UUID.randomUUID().toString();
        object = string + '-' + string2 + (String)object;
        object = new File(file2.getAbsolutePath(), (String)object);
        try {
            if (!FileUtil.copyFile(file, (File)object)) {
                throw new RuntimeException("Failed to copy " + file.getAbsolutePath() + " file into " + ((File)object).getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        LibraryLoader.loadLibrary(((File)object).getAbsolutePath());
        ((File)object).deleteOnExit();
    }

    public static String getName() {
        String string = "jxbrowser-common" + (Environment.is32Bit() ? "32" : "64");
        if (Environment.isWindows()) {
            return string + ".dll";
        }
        if (Environment.isMac()) {
            return "lib" + string + ".dylib";
        }
        if (Environment.isLinux()) {
            return "libjxbrowser-common.so";
        }
        throw new RuntimeException("Unsupported operating system.");
    }
}

