/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.ColorModel;
import com.teamdev.jxbrowser.chromium.DuplexMode;
import com.teamdev.jxbrowser.chromium.PageMargins;
import com.teamdev.jxbrowser.chromium.PageRange;
import com.teamdev.jxbrowser.chromium.PaperSize;
import com.teamdev.jxbrowser.chromium.PrintSettings;
import java.util.ArrayList;
import java.util.List;

public class PrintDialogModel {
    public static final String LAYOUT_PORTRAIT = "Portrait";
    public static final String LAYOUT_LANDSCAPE = "Landscape";
    public static final String COLOR_MODE_COLOR = "Color";
    public static final String COLOR_MODE_BLACK_AND_WHITE = "Black and White";
    public static final String MARGIN_TYPE_DEFAULT = "Default";
    public static final String MARGIN_TYPE_CUSTOM = "Custom";
    private CloseStatus a;
    private final PrintSettings b;

    public PrintDialogModel(PrintSettings printSettings) {
        this.b = printSettings;
    }

    public void printHeadersAndFooters(boolean bl) {
        this.b.setDisplayHeaderFooter(bl);
    }

    public boolean isPrintHeadersAndFooters() {
        return this.b.isDisplayHeaderFooter();
    }

    public void printBackgroundGraphics(boolean bl) {
        this.b.setPrintBackgrounds(bl);
    }

    public boolean isPrintBackgroundGraphics() {
        return this.b.isPrintBackgrounds();
    }

    public void printTwoSided(boolean bl) {
        if (bl) {
            this.b.setDuplexMode(this.b.isLandscape() ? DuplexMode.SHORT_EDGE : DuplexMode.LONG_EDGE);
            return;
        }
        this.b.setDuplexMode(DuplexMode.SIMPLEX);
    }

    public boolean isPrintTwoSided() {
        return this.b.getDuplexMode() == DuplexMode.SHORT_EDGE;
    }

    public void setPrinterName(String string) {
        this.b.setPrinterName(string);
    }

    public String getPrinterName() {
        return this.b.getPrinterName();
    }

    public void setLandscape(boolean bl) {
        this.b.setLandscape(bl);
        DuplexMode duplexMode = this.b.getDuplexMode();
        this.printTwoSided(duplexMode == DuplexMode.SHORT_EDGE || duplexMode == DuplexMode.LONG_EDGE);
    }

    public boolean isLandscape() {
        return this.b.isLandscape();
    }

    public void setPaperSize(PaperSize paperSize) {
        this.b.setPaperSize(paperSize);
    }

    public PaperSize getPaperSize() {
        return this.b.getPaperSize();
    }

    public void setCopies(int n2) {
        this.b.setCopies(n2);
    }

    public int getCopies() {
        return this.b.getCopies();
    }

    public void setColorMode(boolean bl) {
        this.b.setColorModel(bl ? ColorModel.COLOR : ColorModel.BLACK);
    }

    public boolean isColorMode() {
        return this.b.getColorModel() == ColorModel.COLOR;
    }

    public boolean isCustomMarginsEnabled() {
        return this.b.getPageMargins() != null;
    }

    public void setCustomMargins(int n2, int n3, int n4, int n5) {
        this.b.setPageMargins(new PageMargins(0, 0, n2, n5, n3, n4));
    }

    public void setCustomMargins(PageMargins pageMargins) {
        this.b.setPageMargins(pageMargins);
    }

    public PageMargins getCustomMargins() {
        return this.b.getPageMargins();
    }

    public void printAllPages() {
        this.b.setPageRanges(new ArrayList<PageRange>());
    }

    public boolean isPrintAllPages() {
        return this.b.getPageRanges() == null || this.b.getPageRanges().isEmpty();
    }

    public void printPageRanges(int n2, int n3) {
        if (n3 >= n2) {
            ArrayList<PageRange> arrayList = new ArrayList<PageRange>();
            arrayList.add(new PageRange(n2 - 1, n3 - 1));
            this.b.setPageRanges(arrayList);
        }
    }

    public PageRange getPrintPageRange() {
        List<PageRange> list = this.b.getPageRanges();
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public void setCloseStatus(CloseStatus closeStatus) {
        this.a = closeStatus;
    }

    public CloseStatus getCloseStatus() {
        return this.a;
    }

    public static enum CloseStatus {
        PRINT,
        CANCEL;

    }
}

