/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.PageRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class PageRanges {
    public static List<PageRange> from(String string) {
        ArrayList<PageRange> arrayList = new ArrayList<PageRange>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray = stringTokenizer.nextToken();
            if ((stringArray = stringArray.split(",")).length != 2) {
                throw new IllegalArgumentException("Invalid string format. String: " + string);
            }
            try {
                int n2 = Integer.valueOf(stringArray[0]);
                int n3 = Integer.valueOf(stringArray[1]);
                arrayList.add(new PageRange(n2, n3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid string format. String: " + string, numberFormatException);
            }
        }
        return arrayList;
    }

    public static List<Integer> getPageNumbers(List<PageRange> object) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        object = object.iterator();
        while (object.hasNext()) {
            PageRange pageRange = (PageRange)object.next();
            for (int i2 = pageRange.getFrom(); i2 <= pageRange.getTo(); ++i2) {
                if (arrayList.contains(i2)) continue;
                arrayList.add(i2);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static List<PageRange> getPageRanges(List<Integer> list) {
        ArrayList<PageRange> arrayList = new ArrayList<PageRange>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            linkedList.add(list.get(i2));
            int n2 = i2 + 1;
            while (n2 < list.size() && (Integer)linkedList.getLast() + 1 == list.get(n2)) {
                linkedList.add(list.get(n2));
                ++n2;
                ++i2;
            }
            arrayList.add(new PageRange((Integer)linkedList.getFirst(), (Integer)linkedList.getLast()));
        }
        return arrayList;
    }

    public static String to(List<PageRange> object) {
        if (object == null) {
            throw new IllegalArgumentException("The pageRanges cannot be null.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            PageRange pageRange = (PageRange)object.next();
            stringBuilder.append(pageRange.getFrom());
            stringBuilder.append(',');
            stringBuilder.append(pageRange.getTo());
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }
}

