/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ChromiumExtractorException;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.logging.Logger;

public abstract class ChromiumExtractor {
    private static final Logger a = LoggerProvider.getBrowserLogger();

    public static ChromiumExtractor create() {
        if (Environment.isWindows()) {
            return new f(0);
        }
        if (Environment.isMac()) {
            return new e(0);
        }
        if (Environment.isLinux() && Environment.is32Bit()) {
            return new c(0);
        }
        if (Environment.isLinux() && Environment.is64Bit()) {
            return new d(0);
        }
        throw new IllegalStateException("Unsupported operating system.");
    }

    public void extract(String object) {
        object = new File((String)object);
        try {
            AccessController.doPrivileged(new com.teamdev.jxbrowser.chromium.internal.e(this, (File)object));
            return;
        }
        catch (Exception exception) {
            throw new ChromiumExtractorException("Failed to extract chromium binaries into " + ((File)object).getAbsoluteFile(), exception);
        }
    }

    public boolean shouldExtract(String string) {
        return !FileUtil.allFilesExist(new File(string), this.getChromiumFiles());
    }

    protected abstract String getArchiveName();

    protected abstract String[] getChromiumFiles();

    static /* synthetic */ Logger a() {
        return a;
    }

    static /* synthetic */ void a(File file) {
        a.info("Restore permissions for file: " + file.getAbsolutePath());
        if (!file.setExecutable(true, false)) {
            throw new RuntimeException("Failed to update permissions for file: " + file.getAbsolutePath());
        }
    }

    static final class d
    extends b {
        private d() {
            super((byte)0);
        }

        @Override
        protected final String getArchiveName() {
            return "/chromium-linux64.zip";
        }

        /* synthetic */ d(byte by) {
            this();
        }
    }

    static final class c
    extends b {
        private c() {
            super((byte)0);
        }

        @Override
        protected final String getArchiveName() {
            return "/chromium-linux32.zip";
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }

    static abstract class b
    extends ChromiumExtractor
    implements a {
        private b() {
        }

        @Override
        protected String[] getChromiumFiles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("locales");
            arrayList.add("jxbrowser-chromium");
            arrayList.add("libjxbrowser-chromium-lib.so");
            arrayList.add("libjxbrowser-common.so");
            arrayList.add("icudtl.dat");
            arrayList.add("libffmpegsumo.so");
            arrayList.add("resources.pak");
            arrayList.add("chrome_100_percent.pak");
            arrayList.add("devtools_resources.pak");
            arrayList.add("webui_resources.pak");
            arrayList.add("snapshot_blob.bin");
            arrayList.add("natives_blob.bin");
            return arrayList.toArray(new String[arrayList.size()]);
        }

        @Override
        public final void a_(File file) {
            ChromiumExtractor.a(new File(file, "jxbrowser-chromium"));
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }

    static final class e
    extends ChromiumExtractor
    implements a {
        private e() {
        }

        @Override
        protected final String getArchiveName() {
            return "/chromium-mac.zip";
        }

        @Override
        protected final String[] getChromiumFiles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("jxbrowser.app");
            arrayList.add("libjxbrowser-common32.dylib");
            arrayList.add("libjxbrowser-common64.dylib");
            return arrayList.toArray(new String[arrayList.size()]);
        }

        @Override
        public final void a_(File file) {
            ChromiumExtractor.a(new File(file, "jxbrowser.app/Contents/MacOS/jxbrowser"));
            ChromiumExtractor.a(new File(file, "jxbrowser.app/Contents/Frameworks/jxbrowser-helper.app/Contents/MacOS/jxbrowser-helper"));
            ChromiumExtractor.a(new File(file, "jxbrowser.app/Contents/Frameworks/jxbrowser-helper NP.app/Contents/MacOS/jxbrowser-helper NP"));
            ChromiumExtractor.a(new File(file, "jxbrowser.app/Contents/Frameworks/jxbrowser-helper EH.app/Contents/MacOS/jxbrowser-helper EH"));
        }

        /* synthetic */ e(byte by) {
            this();
        }
    }

    static final class f
    extends ChromiumExtractor {
        private f() {
        }

        @Override
        protected final String getArchiveName() {
            return "/chromium-windows.zip";
        }

        @Override
        protected final String[] getChromiumFiles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("locales");
            arrayList.add("ffmpegsumo.dll");
            arrayList.add("jxbrowser-chromium.exe");
            arrayList.add("jxbrowser-chromium-lib.dll");
            arrayList.add("jxbrowser-common32.dll");
            arrayList.add("jxbrowser-common64.dll");
            arrayList.add("libEGL.dll");
            arrayList.add("libGLESv2.dll");
            arrayList.add("d3dcompiler_47.dll");
            arrayList.add("resources.pak");
            arrayList.add("chrome_100_percent.pak");
            arrayList.add("chrome_200_percent.pak");
            arrayList.add("devtools_resources.pak");
            arrayList.add("webui_resources.pak");
            arrayList.add("snapshot_blob.bin");
            arrayList.add("natives_blob.bin");
            return arrayList.toArray(new String[arrayList.size()]);
        }

        /* synthetic */ f(byte by) {
            this();
        }
    }

    static interface a {
        public void a_(File var1);
    }
}

