/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.dom.internal;

import com.teamdev.jxbrowser.chromium.XPathResult;
import com.teamdev.jxbrowser.chromium.XPathResultType;
import com.teamdev.jxbrowser.chromium.dom.By;
import com.teamdev.jxbrowser.chromium.dom.DOMElement;
import com.teamdev.jxbrowser.chromium.dom.DOMNode;
import com.teamdev.jxbrowser.chromium.dom.DOMNodeType;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMContext;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMFactory;
import com.teamdev.jxbrowser.chromium.dom.internal.EventTarget;
import com.teamdev.jxbrowser.chromium.dom.internal.NodeInfo;
import com.teamdev.jxbrowser.chromium.dom.internal.NodePtr;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.AppendChildNodeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.EvaluateXPathMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetElementsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetNodeDataMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetTextContentMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.InsertChildNodeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.QuerySelectorAllMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.RemoveChildNodeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ReplaceChildNodeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetNodeValueMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetTextContentMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SimulateClickMessage;
import java.util.ArrayList;
import java.util.List;

public class Node
extends EventTarget
implements DOMNode {
    private final DOMNodeType a;

    public Node(long l2, DOMFactory dOMFactory, DOMContext dOMContext, DOMNodeType dOMNodeType) {
        super(l2, dOMFactory, dOMContext);
        this.a = dOMNodeType;
    }

    @Override
    public synchronized String getNodeName() {
        GetNodeDataMessage getNodeDataMessage = this.post(new GetNodeDataMessage(MessageUIDGenerator.generate(), GetNodeDataMessage.Flag.GetNodeName, this.getPtr(), ""));
        return getNodeDataMessage.getResult();
    }

    @Override
    public synchronized String getNodeValue() {
        GetNodeDataMessage getNodeDataMessage = this.post(new GetNodeDataMessage(MessageUIDGenerator.generate(), GetNodeDataMessage.Flag.GetNodeValue, this.getPtr(), ""));
        return getNodeDataMessage.getResult();
    }

    @Override
    public synchronized void setNodeValue(String string) {
        this.send(new SetNodeValueMessage(MessageUIDGenerator.generate(), string, this.getPtr()));
    }

    @Override
    public synchronized DOMNodeType getNodeType() {
        return this.a;
    }

    @Override
    public synchronized DOMNode getParent() {
        GetNodeDataMessage getNodeDataMessage = this.post(new GetNodeDataMessage(MessageUIDGenerator.generate(), GetNodeDataMessage.Flag.GetParent, this.getPtr(), ""));
        return this.getFactory().createNode(NodeInfo.getNodeInfo(getNodeDataMessage.getResult()));
    }

    @Override
    public synchronized List<DOMNode> getChildren() {
        GetNodeDataMessage getNodeDataMessage = this.post(new GetNodeDataMessage(MessageUIDGenerator.generate(), GetNodeDataMessage.Flag.GetChildren, this.getPtr(), ""));
        return this.getFactory().createNodes(NodeInfo.getNodeInfos(getNodeDataMessage.getResult()));
    }

    @Override
    public synchronized void click() {
        this.send(new SimulateClickMessage(MessageUIDGenerator.generate(), this.getPtr()));
    }

    @Override
    public synchronized boolean insertChild(DOMNode object, DOMNode dOMNode) {
        if (object == null) {
            throw new IllegalArgumentException("The node parameter cannot be null.");
        }
        if (dOMNode == null) {
            throw new IllegalArgumentException("The beforeNode parameter cannot be null.");
        }
        long l2 = this.getPtr();
        long l3 = ((NodePtr)object).getPtr();
        long l4 = ((NodePtr)((Object)dOMNode)).getPtr();
        object = this.post(new InsertChildNodeMessage(MessageUIDGenerator.generate(), l2, l3, l4, false));
        return ((InsertChildNodeMessage)object).getResult();
    }

    @Override
    public synchronized boolean replaceChild(DOMNode object, DOMNode dOMNode) {
        if (object == null) {
            throw new IllegalArgumentException("The newNode parameter cannot be null.");
        }
        if (dOMNode == null) {
            throw new IllegalArgumentException("The oldNode parameter cannot be null.");
        }
        long l2 = this.getPtr();
        long l3 = ((NodePtr)object).getPtr();
        long l4 = ((NodePtr)((Object)dOMNode)).getPtr();
        object = this.post(new ReplaceChildNodeMessage(MessageUIDGenerator.generate(), l2, l3, l4, false));
        return ((ReplaceChildNodeMessage)object).getResult();
    }

    @Override
    public synchronized boolean removeChild(DOMNode object) {
        if (object == null) {
            throw new IllegalArgumentException("The childNode parameter cannot be null.");
        }
        long l2 = this.getPtr();
        long l3 = ((NodePtr)object).getPtr();
        object = this.post(new RemoveChildNodeMessage(MessageUIDGenerator.generate(), l2, l3, false));
        return ((RemoveChildNodeMessage)object).getResult();
    }

    @Override
    public synchronized boolean appendChild(DOMNode object) {
        if (object == null) {
            throw new IllegalArgumentException("The childNode parameter cannot be null.");
        }
        long l2 = this.getPtr();
        long l3 = ((NodePtr)object).getPtr();
        object = this.post(new AppendChildNodeMessage(MessageUIDGenerator.generate(), l2, l3, false));
        return ((AppendChildNodeMessage)object).getResult();
    }

    @Override
    public synchronized String getTextContent() {
        GetTextContentMessage getTextContentMessage = this.post(new GetTextContentMessage(MessageUIDGenerator.generate(), this.getPtr(), ""));
        return getTextContentMessage.getTextContent();
    }

    @Override
    public synchronized void setTextContent(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The textContent parameter cannot be null.");
        }
        this.post(new SetTextContentMessage(MessageUIDGenerator.generate(), this.getPtr(), string));
    }

    private List<DOMElement> a(String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("The selectors parameter cannot be null or empty");
        }
        object = this.post(new QuerySelectorAllMessage(MessageUIDGenerator.generate(), this.getPtr(), (String)object, null));
        return this.getFactory().createNodes(NodeInfo.getNodeInfos(((QuerySelectorAllMessage)object).getResultNodes()));
    }

    @Override
    public synchronized List<DOMElement> findElements(By list) {
        if (((By)((Object)list)).getType() == By.Type.ID) {
            return this.a("[id='" + ((By)((Object)list)).getValue() + "']");
        }
        if (((By)((Object)list)).getType() == By.Type.TAG) {
            Object object = ((By)((Object)list)).getValue();
            list = this;
            object = ((NodePtr)((Object)list)).post(new GetElementsMessage(MessageUIDGenerator.generate(), GetElementsMessage.Flag.GetElementsByTagName, ((NodePtr)((Object)list)).getPtr(), (String)object, ""));
            return ((NodePtr)((Object)list)).getFactory().createNodes(NodeInfo.getNodeInfos(((GetElementsMessage)object).getElementPointers()));
        }
        if (((By)((Object)list)).getType() == By.Type.NAME) {
            Object object = ((By)((Object)list)).getValue();
            list = this;
            object = ((NodePtr)((Object)list)).post(new GetElementsMessage(MessageUIDGenerator.generate(), GetElementsMessage.Flag.GetElementsByName, ((NodePtr)((Object)list)).getPtr(), (String)object, ""));
            return ((NodePtr)((Object)list)).getFactory().createNodes(NodeInfo.getNodeInfos(((GetElementsMessage)object).getElementPointers()));
        }
        if (((By)((Object)list)).getType() == By.Type.CLASS) {
            Object object = ((By)((Object)list)).getValue();
            list = this;
            object = ((NodePtr)((Object)list)).post(new GetElementsMessage(MessageUIDGenerator.generate(), GetElementsMessage.Flag.GetElementsByClassName, ((NodePtr)((Object)list)).getPtr(), (String)object, ""));
            return ((NodePtr)((Object)list)).getFactory().createNodes(NodeInfo.getNodeInfos(((GetElementsMessage)object).getElementPointers()));
        }
        if (((By)((Object)list)).getType() == By.Type.CSS_SELECTOR) {
            return this.a(((By)((Object)list)).getValue());
        }
        if (((By)((Object)list)).getType() == By.Type.XPATH && !((XPathResult)((Object)(list = this.evaluate(((By)((Object)list)).getValue(), XPathResultType.ORDERED_NODE_SNAPSHOT_TYPE)))).isError() && ((XPathResult)((Object)list)).isSnapshotNodes()) {
            ArrayList<DOMElement> arrayList = new ArrayList<DOMElement>();
            list = ((XPathResult)((Object)list)).getSnapshotNodes();
            for (DOMNode dOMNode : list) {
                if (!(dOMNode instanceof DOMElement)) continue;
                arrayList.add((DOMElement)dOMNode);
            }
            if (arrayList.size() == list.size()) {
                return arrayList;
            }
        }
        return new ArrayList<DOMElement>();
    }

    @Override
    public synchronized DOMElement findElement(By object) {
        if ((object = this.findElements((By)object)).size() > 0) {
            return (DOMElement)object.get(0);
        }
        return null;
    }

    @Override
    public synchronized XPathResult evaluate(String string) {
        return this.evaluate(string, XPathResultType.ANY_TYPE);
    }

    @Override
    public synchronized XPathResult evaluate(String object, XPathResultType xPathResultType) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("The expression parameter cannot be null or empty.");
        }
        if (xPathResultType == null) {
            throw new IllegalArgumentException("The type parameter cannot be null.");
        }
        object = this.post(new EvaluateXPathMessage(MessageUIDGenerator.generate(), (String)object, this.getPtr(), 0L, xPathResultType.getValue()));
        return new XPathResult(this.getChannel(), this.getFactory(), ((EvaluateXPathMessage)object).getResultId(), ((EvaluateXPathMessage)object).getErrorMsg());
    }
}

