/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.dom.internal;

import com.teamdev.jxbrowser.chromium.dom.DOMElement;
import com.teamdev.jxbrowser.chromium.dom.DOMFormElement;
import com.teamdev.jxbrowser.chromium.dom.DOMInputElement;
import com.teamdev.jxbrowser.chromium.dom.DOMNode;
import com.teamdev.jxbrowser.chromium.dom.DOMNodeAtPoint;
import com.teamdev.jxbrowser.chromium.dom.DOMNodeType;
import com.teamdev.jxbrowser.chromium.dom.DOMOptionElement;
import com.teamdev.jxbrowser.chromium.dom.DOMSelectElement;
import com.teamdev.jxbrowser.chromium.dom.DOMTextAreaElement;
import com.teamdev.jxbrowser.chromium.dom.events.DOMEvent;
import com.teamdev.jxbrowser.chromium.dom.events.DOMEventPhase;
import com.teamdev.jxbrowser.chromium.dom.events.DOMEventType;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMContext;
import com.teamdev.jxbrowser.chromium.dom.internal.Element;
import com.teamdev.jxbrowser.chromium.dom.internal.Event;
import com.teamdev.jxbrowser.chromium.dom.internal.EventTarget;
import com.teamdev.jxbrowser.chromium.dom.internal.FormElement;
import com.teamdev.jxbrowser.chromium.dom.internal.InputElement;
import com.teamdev.jxbrowser.chromium.dom.internal.KeyEvent;
import com.teamdev.jxbrowser.chromium.dom.internal.MouseEvent;
import com.teamdev.jxbrowser.chromium.dom.internal.Node;
import com.teamdev.jxbrowser.chromium.dom.internal.NodeAtPoint;
import com.teamdev.jxbrowser.chromium.dom.internal.NodeInfo;
import com.teamdev.jxbrowser.chromium.dom.internal.OptionElement;
import com.teamdev.jxbrowser.chromium.dom.internal.SelectElement;
import com.teamdev.jxbrowser.chromium.dom.internal.TextAreaElement;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetNodeAtPointMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnHandleDOMEventMessage;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public final class DOMFactory {
    private final DOMContext a;

    public DOMFactory(DOMContext dOMContext) {
        this.a = dOMContext;
    }

    public final synchronized <T extends DOMNode> List<T> createNodes(List<NodeInfo> object) {
        ArrayList<DOMNode> arrayList = new ArrayList<DOMNode>();
        object = object.iterator();
        while (object.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)object.next();
            arrayList.add(this.createNode(nodeInfo));
        }
        return arrayList;
    }

    public final synchronized DOMNode createNode(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return null;
        }
        if (nodeInfo.getNodeType() == DOMNodeType.ElementNode) {
            return this.createElement(nodeInfo);
        }
        return new Node(nodeInfo.getNodePtr(), this, this.a, nodeInfo.getNodeType());
    }

    public final synchronized DOMElement createElement(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return null;
        }
        if (nodeInfo.getNodeType() != DOMNodeType.ElementNode) {
            throw new IllegalArgumentException("Wrong node type: " + nodeInfo);
        }
        if (nodeInfo.getTagName().equalsIgnoreCase("form")) {
            return this.createFormElement(nodeInfo);
        }
        if (nodeInfo.getTagName().equalsIgnoreCase("select")) {
            return this.createSelectElement(nodeInfo);
        }
        if (nodeInfo.getTagName().equalsIgnoreCase("option")) {
            return this.createOptionElement(nodeInfo);
        }
        if (nodeInfo.getTagName().equalsIgnoreCase("input")) {
            return this.createInputElement(nodeInfo);
        }
        if (nodeInfo.getTagName().equalsIgnoreCase("textarea")) {
            return this.createTextAreaElement(nodeInfo);
        }
        return new Element(nodeInfo.getNodePtr(), this, this.a);
    }

    public final synchronized DOMTextAreaElement createTextAreaElement(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return null;
        }
        return new TextAreaElement(nodeInfo.getNodePtr(), this, this.a);
    }

    public final synchronized DOMInputElement createInputElement(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return null;
        }
        return new InputElement(nodeInfo.getNodePtr(), this, this.a);
    }

    public final synchronized DOMOptionElement createOptionElement(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return null;
        }
        return new OptionElement(nodeInfo.getNodePtr(), this, this.a);
    }

    public final synchronized DOMSelectElement createSelectElement(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return null;
        }
        return new SelectElement(nodeInfo.getNodePtr(), this, this.a);
    }

    public final synchronized DOMFormElement createFormElement(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return null;
        }
        return new FormElement(nodeInfo.getNodePtr(), this, this.a);
    }

    public final synchronized DOMEvent createEvent(EventTarget eventTarget, OnHandleDOMEventMessage onHandleDOMEventMessage) {
        DOMEventType dOMEventType = DOMEventType.valueFromString(onHandleDOMEventMessage.getEventType());
        DOMEventPhase dOMEventPhase = DOMEventPhase.valueOf(onHandleDOMEventMessage.getEventPhase());
        long l2 = onHandleDOMEventMessage.getEventPtr();
        DOMNode dOMNode = this.createNode(NodeInfo.getNodeInfo(onHandleDOMEventMessage.getCurrentTargetPtr()));
        boolean bl = onHandleDOMEventMessage.isBubbles();
        boolean bl2 = onHandleDOMEventMessage.isCancelable();
        boolean bl3 = onHandleDOMEventMessage.isMouseEvent();
        boolean bl4 = onHandleDOMEventMessage.isKeyboardEvent();
        if (bl3) {
            int n2 = onHandleDOMEventMessage.getClientX();
            int n3 = onHandleDOMEventMessage.getClientY();
            int n4 = onHandleDOMEventMessage.getScreenX();
            int n5 = onHandleDOMEventMessage.getScreenY();
            int n6 = onHandleDOMEventMessage.getButton();
            return new MouseEvent(l2, dOMEventType, dOMEventPhase, eventTarget, dOMNode, bl, bl2, bl3, bl4, this.a, n2, n3, n4, n5, n6);
        }
        if (bl4) {
            int n7 = onHandleDOMEventMessage.getKeyCode();
            boolean bl5 = onHandleDOMEventMessage.isCtrlKey();
            boolean bl6 = onHandleDOMEventMessage.isAltKey();
            boolean bl7 = onHandleDOMEventMessage.isShiftKey();
            boolean bl8 = onHandleDOMEventMessage.isMetaKey();
            return new KeyEvent(l2, dOMEventType, dOMEventPhase, eventTarget, dOMNode, bl, bl2, bl3, bl4, this.a, n7, bl5, bl6, bl7, bl8);
        }
        return new Event(l2, dOMEventType, dOMEventPhase, eventTarget, dOMNode, bl, bl2, bl3, bl4, this.a);
    }

    public final synchronized DOMNodeAtPoint createNodeAtPoint(GetNodeAtPointMessage object) {
        Object object2 = ((GetNodeAtPointMessage)object).getURLElementInfo();
        int n2 = ((GetNodeAtPointMessage)object).getLocalX();
        int n3 = ((GetNodeAtPointMessage)object).getLocalY();
        String string = ((GetNodeAtPointMessage)object).getAbsoluteImageURL();
        String string2 = ((GetNodeAtPointMessage)object).getAbsoluteLinkURL();
        object = this.createNode(NodeInfo.getNodeInfo(((GetNodeAtPointMessage)object).getNodeInfo()));
        object2 = this.createElement(NodeInfo.getNodeInfo((String)object2));
        Point point = new Point(n2, n3);
        return new NodeAtPoint((DOMNode)object, (DOMElement)object2, point, string, string2);
    }
}

