/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.BeforeRedirectParams;
import com.teamdev.jxbrowser.chromium.BeforeSendHeadersParams;
import com.teamdev.jxbrowser.chromium.BeforeSendProxyHeadersParams;
import com.teamdev.jxbrowser.chromium.BeforeURLRequestParams;
import com.teamdev.jxbrowser.chromium.Cookie;
import com.teamdev.jxbrowser.chromium.FormData;
import com.teamdev.jxbrowser.chromium.HeadersReceivedParams;
import com.teamdev.jxbrowser.chromium.HostPortPair;
import com.teamdev.jxbrowser.chromium.HttpHeaders;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.MultipartFormData;
import com.teamdev.jxbrowser.chromium.NetworkDelegate;
import com.teamdev.jxbrowser.chromium.PostData;
import com.teamdev.jxbrowser.chromium.ProxyType;
import com.teamdev.jxbrowser.chromium.RawData;
import com.teamdev.jxbrowser.chromium.RequestCompletedParams;
import com.teamdev.jxbrowser.chromium.RequestParams;
import com.teamdev.jxbrowser.chromium.RequestStatus;
import com.teamdev.jxbrowser.chromium.ResourceHandler;
import com.teamdev.jxbrowser.chromium.ResourceParams;
import com.teamdev.jxbrowser.chromium.ResourceType;
import com.teamdev.jxbrowser.chromium.ResponseStartedParams;
import com.teamdev.jxbrowser.chromium.SendHeadersParams;
import com.teamdev.jxbrowser.chromium.ah;
import com.teamdev.jxbrowser.chromium.events.NetError;
import com.teamdev.jxbrowser.chromium.internal.ChromiumEventQueue;
import com.teamdev.jxbrowser.chromium.internal.CookieParser;
import com.teamdev.jxbrowser.chromium.internal.HttpHeadersImpl;
import com.teamdev.jxbrowser.chromium.internal.PostDataBuilderCreator;
import com.teamdev.jxbrowser.chromium.internal.PostDataFactory;
import com.teamdev.jxbrowser.chromium.internal.PostDataUtils;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CloseAuthDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeRedirectMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeSendHeadersMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeSendProxyHeadersMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeURLRequestMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCanGetCookiesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCanSetCookiesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCompletedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnHeadersReceivedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRequestDestroyedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnResponseStartedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunAuthDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnSendHeadersMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShouldBeginRequestMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetNetworkDelegateConfigMessage;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkService {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private final int b;
    private final ChromiumEventQueue c;
    private final ChannelListener d;
    private final IPCChannelListener e;
    private Channel f;
    private ResourceHandler g;
    private NetworkDelegate h;

    public NetworkService(int n2) {
        this.b = n2;
        this.c = new ChromiumEventQueue();
        this.d = new a(0);
        this.e = new b(this, 0);
    }

    final void a(IPC iPC) {
        this.f = iPC.getMainChannel();
        if (this.f != null) {
            this.f.addChannelListener(this.d);
        }
        iPC.addIPCChannelListener(this.e);
    }

    final void b(IPC iPC) {
        if (this.f != null) {
            this.f.removeChannelListener(this.d);
        }
        iPC.removeIPCChannelListener(this.e);
    }

    final void a() {
        if (this.f != null) {
            boolean bl = this.h == null;
            this.f.send(new SetNetworkDelegateConfigMessage(MessageUIDGenerator.generate(), this.b, bl));
        }
    }

    public void setNetworkDelegate(NetworkDelegate networkDelegate) {
        this.h = networkDelegate;
        this.a();
    }

    public NetworkDelegate getNetworkDelegate() {
        return this.h;
    }

    public void setResourceHandler(ResourceHandler resourceHandler) {
        this.g = resourceHandler;
    }

    public ResourceHandler getResourceHandler() {
        return this.g;
    }

    final class b
    extends IPCChannelAdapter {
        private /* synthetic */ NetworkService a;

        private b(NetworkService networkService) {
            this.a = networkService;
        }

        @Override
        public final void onMainChannelAdded(Channel channel) {
            channel.addChannelListener(this.a.d);
        }

        @Override
        public final void onMainChannelRemoved(Channel channel) {
            channel.removeChannelListener(this.a.d);
        }

        /* synthetic */ b(NetworkService networkService, byte by) {
            this(networkService);
        }
    }

    final class a
    extends ChannelAdapter {
        private a() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void onMessageReceived(Message object) {
            MessageType messageType = object.getType();
            if (messageType == MessageType.OnBeforeUrlRequest) {
                OnBeforeURLRequestMessage onBeforeURLRequestMessage = (OnBeforeURLRequestMessage)object;
                object = this;
                if (onBeforeURLRequestMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.h == null) return;
                try {
                    Object object2;
                    long l2 = onBeforeURLRequestMessage.getRequestId();
                    String string = onBeforeURLRequestMessage.getURL();
                    String string2 = onBeforeURLRequestMessage.getMethod();
                    Object object3 = onBeforeURLRequestMessage.getOriginalHeaders();
                    String string3 = onBeforeURLRequestMessage.getPostData();
                    Map<String, List<String>> map = onBeforeURLRequestMessage.getFileList();
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString((String)object3);
                    String string4 = httpHeadersImpl.getStringRepresentation("\r\n");
                    Object object4 = null;
                    if ("POST".equals(string2)) {
                        object3 = httpHeadersImpl.getHeader("Content-Type");
                        object4 = PostDataFactory.createPostData((String)object3, string3, (String)((Object)map));
                    }
                    object3 = new BeforeURLRequestParams(l2, string, string2, (PostData)object4);
                    ((a)object).NetworkService.this.h.onBeforeURLRequest((BeforeURLRequestParams)object3);
                    if ("POST".equals(string2)) {
                        object2 = ((BeforeURLRequestParams)object3).getPostData();
                        if (object2 instanceof RawData) {
                            PostDataBuilderCreator.create(object2.getContentType(), httpHeadersImpl);
                            object4 = (RawData)object2;
                            String string5 = ((RawData)object4).getData();
                            if (!string5.equals(string3)) {
                                onBeforeURLRequestMessage.setPostData(string5);
                            }
                        } else if (object2 instanceof MultipartFormData) {
                            if (!object2.equals(object4)) {
                                object4 = PostDataBuilderCreator.create(object2.getContentType(), httpHeadersImpl);
                                MultipartFormData multipartFormData = (MultipartFormData)object2;
                                map = PostDataUtils.buildKeyValuesMap(multipartFormData);
                                object = PostDataUtils.buildFilesMap(multipartFormData);
                                onBeforeURLRequestMessage.setPostData(object4.buildKeyValues(map, (Map<String, List<String>>)object));
                                onBeforeURLRequestMessage.setFileList(object4.buildFileList((Map<String, List<String>>)object));
                            }
                        } else if (object2 instanceof FormData && !object2.equals(object4)) {
                            object4 = PostDataBuilderCreator.create(object2.getContentType(), httpHeadersImpl);
                            FormData formData = (FormData)object2;
                            map = PostDataUtils.buildKeyValuesMap(formData);
                            onBeforeURLRequestMessage.setPostData(object4.buildKeyValues(map));
                        }
                    }
                    if (!string4.equals(object2 = httpHeadersImpl.getStringRepresentation("\r\n"))) {
                        onBeforeURLRequestMessage.setOverrideHeaders((String)object2);
                    }
                    if ((object4 = ((RequestParams)object3).getURL()) == null || string.equals(object4)) return;
                    onBeforeURLRequestMessage.setNewLocation((String)object4);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onBeforeURLRequest() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnBeforeSendHeaders) {
                OnBeforeSendHeadersMessage onBeforeSendHeadersMessage = (OnBeforeSendHeadersMessage)object;
                object = this;
                if (onBeforeSendHeadersMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.h == null) return;
                try {
                    String string = onBeforeSendHeadersMessage.getURL();
                    String string6 = onBeforeSendHeadersMessage.getMethod();
                    long l3 = onBeforeSendHeadersMessage.getRequestId();
                    String string7 = onBeforeSendHeadersMessage.getOriginalHeaders();
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString(string7);
                    String string8 = httpHeadersImpl.getStringRepresentation("\r\n");
                    BeforeSendHeadersParams beforeSendHeadersParams = new BeforeSendHeadersParams(l3, string, string6, httpHeadersImpl);
                    ((a)object).NetworkService.this.h.onBeforeSendHeaders(beforeSendHeadersParams);
                    String string9 = httpHeadersImpl.getStringRepresentation("\r\n");
                    if (string8.equals(string9)) return;
                    onBeforeSendHeadersMessage.setOverrideHeaders(string9);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onBeforeSendHeaders() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnSendHeaders) {
                OnSendHeadersMessage onSendHeadersMessage = (OnSendHeadersMessage)object;
                object = this;
                if (onSendHeadersMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.h == null) return;
                try {
                    String string = onSendHeadersMessage.getURL();
                    String string10 = onSendHeadersMessage.getMethod();
                    String string11 = onSendHeadersMessage.getHeaders();
                    long l4 = onSendHeadersMessage.getRequestId();
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString(string11);
                    SendHeadersParams sendHeadersParams = new SendHeadersParams(l4, string, string10, httpHeadersImpl);
                    ((a)object).NetworkService.this.h.onSendHeaders(sendHeadersParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onSendHeaders() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnHeadersReceived) {
                OnHeadersReceivedMessage onHeadersReceivedMessage = (OnHeadersReceivedMessage)object;
                object = this;
                if (onHeadersReceivedMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.h == null) return;
                try {
                    String string = onHeadersReceivedMessage.getURL();
                    String string12 = onHeadersReceivedMessage.getMethod();
                    long l5 = onHeadersReceivedMessage.getRequestId();
                    String string13 = onHeadersReceivedMessage.getOriginalHeaders();
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString(string13);
                    String string14 = httpHeadersImpl.getStringRepresentation("\r\n");
                    HeadersReceivedParams headersReceivedParams = new HeadersReceivedParams(l5, string, string12, httpHeadersImpl);
                    ((a)object).NetworkService.this.h.onHeadersReceived(headersReceivedParams);
                    String string15 = httpHeadersImpl.getStringRepresentation("\r\n");
                    if (string14.equals(string15)) return;
                    onHeadersReceivedMessage.setOverrideHeaders(string15);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onHeadersReceived() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnBeforeRedirect) {
                OnBeforeRedirectMessage onBeforeRedirectMessage = (OnBeforeRedirectMessage)object;
                object = this;
                if (onBeforeRedirectMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.h == null) return;
                try {
                    String string = onBeforeRedirectMessage.getURL();
                    String string16 = onBeforeRedirectMessage.getMethod();
                    long l6 = onBeforeRedirectMessage.getRequestId();
                    int n2 = onBeforeRedirectMessage.getResponseCode();
                    String string17 = onBeforeRedirectMessage.getNewLocation();
                    BeforeRedirectParams beforeRedirectParams = new BeforeRedirectParams(l6, string, string16, n2, string17);
                    ((a)object).NetworkService.this.h.onBeforeRedirect(beforeRedirectParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onBeforeRedirect() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnResponseStarted) {
                OnResponseStartedMessage onResponseStartedMessage = (OnResponseStartedMessage)object;
                object = this;
                if (onResponseStartedMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.h == null) return;
                try {
                    String string = onResponseStartedMessage.getURL();
                    String string18 = onResponseStartedMessage.getMethod();
                    long l7 = onResponseStartedMessage.getRequestId();
                    int n3 = onResponseStartedMessage.getResponseCode();
                    ResponseStartedParams responseStartedParams = new ResponseStartedParams(l7, string, string18, n3);
                    ((a)object).NetworkService.this.h.onResponseStarted(responseStartedParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onResponseStarted() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnCompleted) {
                OnCompletedMessage onCompletedMessage = (OnCompletedMessage)object;
                object = this;
                if (onCompletedMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.h == null) return;
                try {
                    RequestStatus requestStatus = RequestStatus.valueOf(onCompletedMessage.getStatus());
                    NetError netError = NetError.valueOf(onCompletedMessage.getErrorCode());
                    if (netError == NetError.UNKNOWN) {
                        netError = null;
                    }
                    String string = onCompletedMessage.getURL();
                    String string19 = onCompletedMessage.getMethod();
                    long l8 = onCompletedMessage.getRequestId();
                    int n4 = onCompletedMessage.getResponseCode();
                    RequestCompletedParams requestCompletedParams = new RequestCompletedParams(l8, string, string19, n4, requestStatus, netError);
                    ((a)object).NetworkService.this.h.onCompleted(requestCompletedParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onCompleted() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnRequestDestroyed) {
                OnRequestDestroyedMessage onRequestDestroyedMessage = (OnRequestDestroyedMessage)object;
                object = this;
                if (onRequestDestroyedMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.h == null) return;
                try {
                    String string = onRequestDestroyedMessage.getURL();
                    String string20 = onRequestDestroyedMessage.getMethod();
                    long l9 = onRequestDestroyedMessage.getRequestId();
                    RequestParams requestParams = new RequestParams(l9, string, string20);
                    ((a)object).NetworkService.this.h.onDestroyed(requestParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onCompleted() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnPACScriptError) return;
            if (messageType == MessageType.OnRunAuthDialog) {
                OnRunAuthDialogMessage onRunAuthDialogMessage = (OnRunAuthDialogMessage)object;
                object = this;
                if (onRunAuthDialogMessage.getBrowserContextId() != ((a)object).NetworkService.this.b) return;
                if (((a)object).NetworkService.this.h == null) {
                    ((a)object).NetworkService.this.f.send(new CloseAuthDialogMessage(MessageUIDGenerator.generate(), ((a)object).NetworkService.this.b, onRunAuthDialogMessage.getDialogID(), false, "", ""));
                    return;
                }
                ((a)object).NetworkService.this.c.invokeLater(new ah((a)object, onRunAuthDialogMessage));
                return;
            }
            if (messageType == MessageType.OnCanGetCookies) {
                OnCanGetCookiesMessage onCanGetCookiesMessage = (OnCanGetCookiesMessage)object;
                object = this;
                if (onCanGetCookiesMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.h == null) return;
                String string = onCanGetCookiesMessage.getURL();
                List<Cookie> list = CookieParser.parseCookiesString(onCanGetCookiesMessage.getCookies());
                try {
                    onCanGetCookiesMessage.setCanGetCookies(((a)object).NetworkService.this.h.onCanGetCookies(string, list));
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The DialogHandler.onCanGetCookies() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnCanSetCookies) {
                OnCanSetCookiesMessage onCanSetCookiesMessage = (OnCanSetCookiesMessage)object;
                object = this;
                if (onCanSetCookiesMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.h == null) return;
                String string = onCanSetCookiesMessage.getURL();
                List<Cookie> list = CookieParser.parseCookiesString(onCanSetCookiesMessage.getCookies());
                try {
                    onCanSetCookiesMessage.setCanSetCookies(((a)object).NetworkService.this.h.onCanSetCookies(string, list));
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The DialogHandler.onCanSetCookies() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnShouldBeginRequest) {
                OnShouldBeginRequestMessage onShouldBeginRequestMessage = (OnShouldBeginRequestMessage)object;
                object = this;
                if (onShouldBeginRequestMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                String string = onShouldBeginRequestMessage.getURL();
                String string21 = onShouldBeginRequestMessage.getMethod();
                ResourceType resourceType = ResourceType.valueOf(onShouldBeginRequestMessage.getResourceType());
                try {
                    onShouldBeginRequestMessage.setCancel(!((a)object).NetworkService.this.g.canLoadResource(new ResourceParams(string, string21, resourceType)));
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The ResourceHandler.canLoadResource() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType != MessageType.OnBeforeSendProxyHeaders) return;
            OnBeforeSendProxyHeadersMessage onBeforeSendProxyHeadersMessage = (OnBeforeSendProxyHeadersMessage)object;
            object = this;
            if (onBeforeSendProxyHeadersMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.h == null) return;
            try {
                String string = onBeforeSendProxyHeadersMessage.getURL();
                String string22 = onBeforeSendProxyHeadersMessage.getMethod();
                long l10 = onBeforeSendProxyHeadersMessage.getRequestId();
                Object object5 = onBeforeSendProxyHeadersMessage.getOriginalHeaders();
                boolean bl = onBeforeSendProxyHeadersMessage.isDidProxyBypass();
                boolean bl2 = onBeforeSendProxyHeadersMessage.isDidUsePacScript();
                String string23 = onBeforeSendProxyHeadersMessage.getHost();
                int n5 = onBeforeSendProxyHeadersMessage.getPort();
                int n6 = onBeforeSendProxyHeadersMessage.getSchema();
                object5 = HttpHeadersImpl.buildFromString((String)object5);
                String string24 = ((HttpHeadersImpl)object5).getStringRepresentation("\r\n");
                ProxyType proxyType = ProxyType.from(n6);
                HostPortPair hostPortPair = new HostPortPair(string23, n5);
                BeforeSendProxyHeadersParams beforeSendProxyHeadersParams = new BeforeSendProxyHeadersParams(l10, string, string22, (HttpHeaders)object5, bl, bl2, proxyType, hostPortPair);
                ((a)object).NetworkService.this.h.onBeforeSendProxyHeaders(beforeSendProxyHeadersParams);
                object = ((HttpHeadersImpl)object5).getStringRepresentation("\r\n");
                if (string24.equals(object)) return;
                onBeforeSendProxyHeadersMessage.setOverrideHeaders((String)object);
                return;
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "The NetworkDelegate.onBeforeSendProxyHeaders() method has thrown exception: ", exception);
            }
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

