/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.JSObject;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.events.DisposeEvent;
import com.teamdev.jxbrowser.chromium.events.DisposeListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.JSNewObjectMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSContext {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private boolean b;
    private final long c;
    private final long d;
    private final Channel e;
    private final List<DisposeListener<JSContext>> f;

    JSContext(Channel channel, long l2, long l3) {
        this.e = channel;
        this.c = l2;
        this.d = l3;
        this.f = new CopyOnWriteArrayList<DisposeListener<JSContext>>();
    }

    public long getFrameId() {
        return this.c;
    }

    public synchronized JSObject createObject() {
        JSNewObjectMessage jSNewObjectMessage = this.a().post(new JSNewObjectMessage(MessageUIDGenerator.generate(), 0L, this.d));
        return new JSObject(jSNewObjectMessage.getObjectPtr(), this);
    }

    public boolean isDisposed() {
        return this.b;
    }

    public void addDisposeListener(DisposeListener<JSContext> disposeListener) {
        if (!this.f.contains(disposeListener)) {
            this.f.add(disposeListener);
        }
    }

    public void removeDisposeListener(DisposeListener<JSContext> disposeListener) {
        this.f.remove(disposeListener);
    }

    public List<DisposeListener<JSContext>> getDisposeListeners() {
        return new ArrayList<DisposeListener<JSContext>>(this.f);
    }

    final Channel a() {
        if (this.isDisposed()) {
            throw new IllegalStateException("JSContext is already disposed.");
        }
        return this.e;
    }

    final long b() {
        return this.d;
    }

    final void c() {
        if (this.isDisposed()) {
            return;
        }
        this.b = true;
        DisposeEvent<JSContext> disposeEvent = new DisposeEvent<JSContext>(this);
        for (DisposeListener<JSContext> disposeListener : this.getDisposeListeners()) {
            try {
                disposeListener.onDisposed(disposeEvent);
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "Unexpected exception in DisposeListener<JSContext>.onDisposed() event.", exception);
            }
        }
    }
}

