/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.NetworkService;
import com.teamdev.jxbrowser.chromium.ZoomService;
import com.teamdev.jxbrowser.chromium.internal.BrowserContextIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class BrowserContext {
    private static final BrowserContext a = new BrowserContext(BrowserPreferences.getDefaultDataDir(), BrowserPreferences.getDefaultCacheDir(), BrowserPreferences.getDefaultMemoryDir(), BrowserPreferences.getDefaultAcceptLanguage(), -1);
    private final int b;
    private final IPC c;
    private final String d;
    private final String e;
    private final String f;
    private final String g;
    private final List<Browser> h;
    private final ZoomService i;
    private final NetworkService j;

    public static BrowserContext defaultContext() {
        return a;
    }

    public BrowserContext(String string) {
        this(string, BrowserPreferences.getDefaultAcceptLanguage());
    }

    public BrowserContext(String string, String string2) {
        this(string, string + File.separator + "Cache", string2);
    }

    public BrowserContext(String string, String string2, String string3) {
        this(string, string2, string + File.separator + "Memory", string3);
    }

    public BrowserContext(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, BrowserContextIDGenerator.generate());
    }

    private BrowserContext(String string, String string2, String string3, String string4, int n2) {
        this(string, string2, string3, string4, n2, IPC.getDefault());
    }

    private BrowserContext(String object, String string, String string2, String string3, int n2, IPC iPC) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("The dataDir parameter cannot be null or empty.");
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The cacheDir parameter cannot be null or empty.");
        }
        if (!Environment.isWindows() && (string2 == null || string2.isEmpty())) {
            throw new IllegalArgumentException("The cacheDir parameter cannot be null or empty.");
        }
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException("The acceptLanguage parameter cannot be null or empty.");
        }
        this.b = n2;
        this.c = iPC;
        this.d = object;
        this.e = string;
        this.f = string2;
        this.g = string3;
        this.h = new ArrayList<Browser>();
        this.i = new ZoomService(n2);
        this.j = new NetworkService(n2);
        object = this;
        FileUtil.createDirs(((BrowserContext)object).d);
        FileUtil.createDirs(((BrowserContext)object).e);
        if (!Environment.isWindows()) {
            FileUtil.createDirs(((BrowserContext)object).f);
        }
    }

    public final String getDataDir() {
        return this.d;
    }

    public final String getCacheDir() {
        return this.e;
    }

    public final String getMemoryDir() {
        return this.f;
    }

    public final String getAcceptLanguage() {
        return this.g;
    }

    public final NetworkService getNetworkService() {
        return this.j;
    }

    public final ZoomService getZoomService() {
        return this.i;
    }

    public final int getIdentifier() {
        return this.b;
    }

    final IPC a() {
        return this.c;
    }

    final void a(Browser browser) {
        if (this.h.isEmpty()) {
            this.i.a(this.c);
            this.j.a(this.c);
        }
        if (!this.h.contains(browser)) {
            this.h.add(browser);
        }
    }

    final void b(Browser browser) {
        this.h.remove(browser);
        if (this.h.isEmpty()) {
            this.i.b(this.c);
            this.j.b(this.c);
        }
    }
}

