/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.BrowserContext;
import com.teamdev.jxbrowser.chromium.BrowserException;
import com.teamdev.jxbrowser.chromium.BrowserFunction;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.CacheStorage;
import com.teamdev.jxbrowser.chromium.Callback;
import com.teamdev.jxbrowser.chromium.ContextMenuHandler;
import com.teamdev.jxbrowser.chromium.ContextMenuParams;
import com.teamdev.jxbrowser.chromium.CookieStorage;
import com.teamdev.jxbrowser.chromium.DialogHandler;
import com.teamdev.jxbrowser.chromium.DownloadHandler;
import com.teamdev.jxbrowser.chromium.DownloadItem;
import com.teamdev.jxbrowser.chromium.EditorCommand;
import com.teamdev.jxbrowser.chromium.FullScreenHandler;
import com.teamdev.jxbrowser.chromium.JSContext;
import com.teamdev.jxbrowser.chromium.JSValue;
import com.teamdev.jxbrowser.chromium.LoadDataParams;
import com.teamdev.jxbrowser.chromium.LoadHTMLParams;
import com.teamdev.jxbrowser.chromium.LoadHandler;
import com.teamdev.jxbrowser.chromium.LoadParams;
import com.teamdev.jxbrowser.chromium.LoadURLParams;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.MediaType;
import com.teamdev.jxbrowser.chromium.NavigationEntry;
import com.teamdev.jxbrowser.chromium.PluginInfo;
import com.teamdev.jxbrowser.chromium.PluginManager;
import com.teamdev.jxbrowser.chromium.PopupContainer;
import com.teamdev.jxbrowser.chromium.PopupHandler;
import com.teamdev.jxbrowser.chromium.PopupParams;
import com.teamdev.jxbrowser.chromium.PrintHandler;
import com.teamdev.jxbrowser.chromium.PrintJob;
import com.teamdev.jxbrowser.chromium.ProxyConfig;
import com.teamdev.jxbrowser.chromium.SavePageType;
import com.teamdev.jxbrowser.chromium.SearchParams;
import com.teamdev.jxbrowser.chromium.SearchResult;
import com.teamdev.jxbrowser.chromium.StopFindAction;
import com.teamdev.jxbrowser.chromium.TerminationStatus;
import com.teamdev.jxbrowser.chromium.aa;
import com.teamdev.jxbrowser.chromium.ab;
import com.teamdev.jxbrowser.chromium.ac;
import com.teamdev.jxbrowser.chromium.ad;
import com.teamdev.jxbrowser.chromium.ae;
import com.teamdev.jxbrowser.chromium.af;
import com.teamdev.jxbrowser.chromium.ag;
import com.teamdev.jxbrowser.chromium.c;
import com.teamdev.jxbrowser.chromium.d;
import com.teamdev.jxbrowser.chromium.dom.DOMDocument;
import com.teamdev.jxbrowser.chromium.dom.DOMNodeAtPoint;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMContext;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMFactory;
import com.teamdev.jxbrowser.chromium.dom.internal.Document;
import com.teamdev.jxbrowser.chromium.e;
import com.teamdev.jxbrowser.chromium.events.ConsoleEvent;
import com.teamdev.jxbrowser.chromium.events.ConsoleListener;
import com.teamdev.jxbrowser.chromium.events.DisposeEvent;
import com.teamdev.jxbrowser.chromium.events.DisposeListener;
import com.teamdev.jxbrowser.chromium.events.FailLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.FrameLoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import com.teamdev.jxbrowser.chromium.events.NetError;
import com.teamdev.jxbrowser.chromium.events.PrintJobEvent;
import com.teamdev.jxbrowser.chromium.events.PrintJobListener;
import com.teamdev.jxbrowser.chromium.events.ProvisionalLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.RenderEvent;
import com.teamdev.jxbrowser.chromium.events.RenderListener;
import com.teamdev.jxbrowser.chromium.events.StartLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.StatusEvent;
import com.teamdev.jxbrowser.chromium.events.StatusListener;
import com.teamdev.jxbrowser.chromium.events.TitleEvent;
import com.teamdev.jxbrowser.chromium.events.TitleListener;
import com.teamdev.jxbrowser.chromium.f;
import com.teamdev.jxbrowser.chromium.g;
import com.teamdev.jxbrowser.chromium.h;
import com.teamdev.jxbrowser.chromium.i;
import com.teamdev.jxbrowser.chromium.internal.ChannelCacheStorage;
import com.teamdev.jxbrowser.chromium.internal.ChannelCookieStorage;
import com.teamdev.jxbrowser.chromium.internal.ChromiumEventQueue;
import com.teamdev.jxbrowser.chromium.internal.DialogHandlerDelegate;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.MutableDownloadItem;
import com.teamdev.jxbrowser.chromium.internal.PDFPrintJob;
import com.teamdev.jxbrowser.chromium.internal.PluginInfoParser;
import com.teamdev.jxbrowser.chromium.internal.PluginManagerImpl;
import com.teamdev.jxbrowser.chromium.internal.ProxyParams;
import com.teamdev.jxbrowser.chromium.internal.SearchCompleteCallback;
import com.teamdev.jxbrowser.chromium.internal.SearchRequestIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPCException;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.AllowCertificateErrorMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.BeforeDisposeBrowserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CanGoBackMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CanGoForwardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CanGoToOffsetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CreateBrowserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DisposeBrowserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ExecuteCommandMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ExecuteJavaScriptMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.FindTextMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetCurrentEntryIndexMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetDocumentMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetEntryCountMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetEntryMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetFramesIdsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetHTMLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetNodeAtPointMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetRemoteDebuggingURLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetSelectedTextMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetTitleMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetURLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetWebPreferencesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetZoomLevelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoBackMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoForwardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoToIndexMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoToOffsetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.IsCommandEnabledMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.IsFrameExistsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.IsLoadingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.LoadDataMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.LoadURLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnAddNewContentsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnAllowCertificateErrorMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeDownloadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnConsoleMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidCommitProvisionalLoadForFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidCreateScriptContextMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidFailLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidFailProvisionalLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidFinishLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidStartProvisionalLoadForFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDocumentAvailableInMainFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDocumentLoadedInFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnFormRepostWarningShowMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnGetJSFunctionsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnHandleLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnInvokeJSFunctionMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnPDFPrintingDoneMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnPrintingDoneMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderViewCreatedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderViewGoneMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRequestPDFPrintSettingsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRequestPluginStateMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRequestPrintSettingsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunFileChooserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunJavaScriptDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnSearchCompleteMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnSelectClientCertificateMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShouldCreateWebContentsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShowContextMenuMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnStatusChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTitleChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnToggleFullscreenModeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnWindowCloseMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.PageZoom;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.PingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.PrintMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.PrintToPDFMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ReloadIgnoringCacheMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ReloadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.RemoveEntryAtIndexMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SaveWebPageMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetBoundsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetZoomLevelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetZoomMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.StopFindingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.StopMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.UpdateWebPreferencesMessage;
import com.teamdev.jxbrowser.chromium.j;
import com.teamdev.jxbrowser.chromium.k;
import com.teamdev.jxbrowser.chromium.l;
import com.teamdev.jxbrowser.chromium.m;
import com.teamdev.jxbrowser.chromium.n;
import com.teamdev.jxbrowser.chromium.o;
import com.teamdev.jxbrowser.chromium.p;
import com.teamdev.jxbrowser.chromium.q;
import com.teamdev.jxbrowser.chromium.r;
import com.teamdev.jxbrowser.chromium.s;
import com.teamdev.jxbrowser.chromium.t;
import com.teamdev.jxbrowser.chromium.u;
import com.teamdev.jxbrowser.chromium.v;
import com.teamdev.jxbrowser.chromium.w;
import com.teamdev.jxbrowser.chromium.x;
import com.teamdev.jxbrowser.chromium.y;
import com.teamdev.jxbrowser.chromium.z;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Browser {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    public static final int MAIN_FRAME_ID = -1;
    public static final int FOCUSED_FRAME_ID = -2;
    private Channel b;
    private final Channel c;
    private final ProxyConfig d;
    private final CacheStorage e;
    private final CookieStorage f;
    private final BrowserContext g;
    private final ChromiumEventQueue h;
    private final PluginManagerImpl i;
    private final List<LoadListener> j;
    private final List<TitleListener> k;
    private final List<RenderListener> l;
    private final List<StatusListener> m;
    private final List<ConsoleListener> n;
    private final List<DisposeListener<Browser>> o;
    private final DialogHandlerDelegate p;
    private final Deque<PDFPrintJob> q;
    private final Map<Integer, PDFPrintJob> r;
    private final Map<Integer, PrintJob> s;
    private final Map<Long, JSContext> t;
    private final Map<String, BrowserFunction> u;
    private final Map<Integer, SearchCompleteCallback> v;
    private LoadHandler w;
    private PopupHandler x;
    private PrintHandler y;
    private DownloadHandler z;
    private FullScreenHandler A;
    private PopupContainer B;
    private ContextMenuHandler C;
    private final ChannelListener D;
    private final IPCChannelListener E;

    public Browser() {
        this(BrowserContext.defaultContext());
    }

    public Browser(ProxyConfig proxyConfig) {
        this(BrowserContext.defaultContext(), proxyConfig);
    }

    public Browser(BrowserContext browserContext) {
        this(browserContext, null);
    }

    public Browser(BrowserContext browserContext, ProxyConfig proxyConfig) {
        this(browserContext, proxyConfig, null);
    }

    private Browser(BrowserContext object, ProxyConfig object2, Channel object3) {
        if (object == null) {
            throw new IllegalArgumentException("The browserContext cannot be null.");
        }
        this.g = object;
        this.d = object2;
        this.E = new a(this, 0);
        this.D = new b(this, 0);
        ((BrowserContext)object).a().start();
        ((BrowserContext)object).a(this);
        this.c = object3 == null ? this.a((ProxyConfig)object2, ((BrowserContext)object).a()) : object3;
        Channel channel = this.b = object3 != null ? this.b() : null;
        if (this.b != null) {
            this.b.addChannelListener(this.D);
        }
        ((BrowserContext)object).getNetworkService().a();
        this.q = new LinkedList<PDFPrintJob>();
        this.s = new HashMap<Integer, PrintJob>();
        this.r = new HashMap<Integer, PDFPrintJob>();
        this.t = new HashMap<Long, JSContext>();
        this.u = new HashMap<String, BrowserFunction>();
        this.v = new HashMap<Integer, SearchCompleteCallback>();
        this.h = new ChromiumEventQueue();
        this.k = new CopyOnWriteArrayList<TitleListener>();
        this.j = new CopyOnWriteArrayList<LoadListener>();
        this.l = new CopyOnWriteArrayList<RenderListener>();
        this.o = new CopyOnWriteArrayList<DisposeListener<Browser>>();
        this.n = new CopyOnWriteArrayList<ConsoleListener>();
        this.m = new CopyOnWriteArrayList<StatusListener>();
        this.p = new DialogHandlerDelegate();
        this.f = new ChannelCookieStorage(this.c);
        this.e = new ChannelCacheStorage(this.c, this.h);
        this.i = new PluginManagerImpl(this.c);
        object2 = this;
        ((Browser)object2).getChannel().addChannelListener(new w((Browser)object2));
        ((BrowserContext)object).a().addIPCChannelListener(this.E);
        if (object3 == null) {
            object2 = this;
            object = new CountDownLatch(1);
            object3 = new com.teamdev.jxbrowser.chromium.a((Browser)object2, (CountDownLatch)object);
            ((Browser)object2).addLoadListener((LoadListener)object3);
            ((Browser)object2).loadURL("about:blank");
            try {
                LatchUtil.await((CountDownLatch)object, new BrowserException("Failed to load 'about:blank' web page within 300 seconds."));
                return;
            }
            finally {
                ((Browser)object2).removeLoadListener((LoadListener)object3);
            }
        }
    }

    private Channel getChannel() {
        return this.c;
    }

    private Channel b() {
        Object object = this.getIPC().getChannels();
        object = object.iterator();
        while (object.hasNext()) {
            boolean bl;
            Channel channel = (Channel)object.next();
            boolean bl2 = channel.getType() == ChannelType.Render;
            boolean bl3 = bl = channel.getBrowserId() == this.getChannel().getBrowserId();
            if (!bl2 || !bl) continue;
            return channel;
        }
        return null;
    }

    private IPC getIPC() {
        return this.g.a();
    }

    private void a(Message message) {
        this.c.send(message);
    }

    private <M extends Message> M b(M m2) {
        return this.c.post(m2);
    }

    public void setSize(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Width cannot be negative");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Height cannot be negative");
        }
        this.a(new SetBoundsMessage(MessageUIDGenerator.generate(), new Rectangle(n2, n3)));
    }

    public void setSize(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException("The size parameter cannot be null.");
        }
        this.setSize(dimension.width, dimension.height);
    }

    private Channel a(ProxyConfig object, IPC iPC) {
        object = ProxyParams.from((ProxyConfig)object);
        int n2 = ChannelIDGenerator.generate();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        l l2 = new l(this, n2, countDownLatch);
        iPC.addIPCChannelListener(l2);
        iPC.send(new CreateBrowserMessage(MessageUIDGenerator.generate(), n2, this.g.getIdentifier(), this.g.getCacheDir(), this.g.getMemoryDir(), this.g.getDataDir(), this.g.getAcceptLanguage(), ((ProxyParams)object).getProxyType(), ((ProxyParams)object).getProxyRules(), ((ProxyParams)object).getProxyBypassRules(), ((ProxyParams)object).getProxyAutoConfigURL(), this.g.getZoomService().getDefaultZoomLevel()));
        try {
            LatchUtil.await(countDownLatch, new IPCException("Failed to get Browser channel " + n2));
        }
        finally {
            iPC.removeIPCChannelListener(l2);
        }
        object = iPC.getChannel(n2, ChannelType.Browser);
        if (object == null) {
            throw new IPCException("Failed to get Browser channel " + n2);
        }
        return object;
    }

    public void addTitleListener(TitleListener titleListener) {
        if (!this.k.contains(titleListener)) {
            this.k.add(titleListener);
        }
    }

    public void removeTitleListener(TitleListener titleListener) {
        this.k.remove(titleListener);
    }

    public List<TitleListener> getTitleListeners() {
        return new ArrayList<TitleListener>(this.k);
    }

    public void addStatusListener(StatusListener statusListener) {
        if (!this.m.contains(statusListener)) {
            this.m.add(statusListener);
        }
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.m.remove(statusListener);
    }

    public List<StatusListener> getStatusListeners() {
        return new ArrayList<StatusListener>(this.m);
    }

    public void addLoadListener(LoadListener loadListener) {
        if (!this.j.contains(loadListener)) {
            this.j.add(loadListener);
        }
    }

    public void removeLoadListener(LoadListener loadListener) {
        this.j.remove(loadListener);
    }

    public List<LoadListener> getLoadListeners() {
        return new ArrayList<LoadListener>(this.j);
    }

    public void addRenderListener(RenderListener renderListener) {
        if (!this.l.contains(renderListener)) {
            this.l.add(renderListener);
        }
    }

    public void removeRenderListener(RenderListener renderListener) {
        this.l.remove(renderListener);
    }

    public List<RenderListener> getRenderListeners() {
        return new ArrayList<RenderListener>(this.l);
    }

    public void addConsoleListener(ConsoleListener consoleListener) {
        if (!this.n.contains(consoleListener)) {
            this.n.add(consoleListener);
        }
    }

    public void removeConsoleListener(ConsoleListener consoleListener) {
        this.n.remove(consoleListener);
    }

    public List<ConsoleListener> getConsoleListeners() {
        return new ArrayList<ConsoleListener>(this.n);
    }

    public void setFullScreenHandler(FullScreenHandler fullScreenHandler) {
        this.A = fullScreenHandler;
    }

    public FullScreenHandler getFullScreenHandler() {
        return this.A;
    }

    public void setPopupHandler(PopupHandler popupHandler) {
        this.x = popupHandler;
    }

    public PopupHandler getPopupHandler() {
        return this.x;
    }

    public void setContextMenuHandler(ContextMenuHandler contextMenuHandler) {
        this.C = contextMenuHandler;
    }

    public ContextMenuHandler getContextMenuHandler() {
        return this.C;
    }

    public void setDownloadHandler(DownloadHandler downloadHandler) {
        this.z = downloadHandler;
    }

    public DownloadHandler getDownloadHandler() {
        return this.z;
    }

    public void setDialogHandler(DialogHandler dialogHandler) {
        this.p.setDialogHandler(dialogHandler);
    }

    public DialogHandler getDialogHandler() {
        return this.p.getDialogHandler();
    }

    public CookieStorage getCookieStorage() {
        return this.f;
    }

    public CacheStorage getCacheStorage() {
        return this.e;
    }

    public synchronized boolean isCommandEnabled(EditorCommand object) {
        if (object == null) {
            throw new IllegalArgumentException("The command parameter cannot be null.");
        }
        if (this.b != null) {
            object = this.b.post(new IsCommandEnabledMessage(MessageUIDGenerator.generate(), object.getCommandText()));
            return ((IsCommandEnabledMessage)object).getResult();
        }
        return false;
    }

    public synchronized boolean executeCommand(EditorCommand editorCommand) {
        return this.executeCommand(-2L, editorCommand);
    }

    public synchronized boolean executeCommand(long l2, EditorCommand editorCommand) {
        return this.executeCommand(l2, editorCommand, null);
    }

    public synchronized boolean executeCommand(EditorCommand editorCommand, String string) {
        return this.executeCommand(-2L, editorCommand, string);
    }

    public synchronized boolean executeCommand(long l2, EditorCommand editorCommand, String string) {
        if (editorCommand == null) {
            throw new IllegalArgumentException("The command parameter cannot be null.");
        }
        this.a(l2);
        if (this.b != null) {
            ExecuteCommandMessage executeCommandMessage = new ExecuteCommandMessage(MessageUIDGenerator.generate(), l2, editorCommand.getCommandText(), string);
            executeCommandMessage = this.b.post(executeCommandMessage);
            return executeCommandMessage.getResult();
        }
        return false;
    }

    public void setLoadHandler(LoadHandler loadHandler) {
        this.w = loadHandler;
    }

    public LoadHandler getLoadHandler() {
        return this.w;
    }

    public synchronized String getRemoteDebuggingURL() {
        GetRemoteDebuggingURLMessage getRemoteDebuggingURLMessage = this.b(new GetRemoteDebuggingURLMessage(MessageUIDGenerator.generate()));
        return getRemoteDebuggingURLMessage.getRemoteDebuggingURL();
    }

    public synchronized Set<Long> getFramesIds() {
        if (this.b != null) {
            Object object = this.b.post(new GetFramesIdsMessage(MessageUIDGenerator.generate()));
            HashSet<Long> hashSet = new HashSet<Long>();
            object = new StringTokenizer(((GetFramesIdsMessage)object).getIds(), "|");
            while (((StringTokenizer)object).hasMoreTokens()) {
                Object object2 = ((StringTokenizer)object).nextToken();
                object2 = Long.parseLong((String)object2);
                hashSet.add((Long)object2);
            }
            return hashSet;
        }
        return new HashSet<Long>();
    }

    public synchronized SearchResult findText(SearchParams object) {
        if (object == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        int n2 = SearchRequestIDGenerator.generate();
        object = new FindTextMessage(MessageUIDGenerator.generate(), n2, ((SearchParams)object).getSearchText(), ((SearchParams)object).isForward(), ((SearchParams)object).isMatchCase(), false);
        AtomicReference atomicReference = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        aa aa2 = new aa(this, atomicReference, countDownLatch);
        this.v.put(n2, aa2);
        this.a((Message)object);
        LatchUtil.await(countDownLatch, new IPCException("Response was not received."));
        return (SearchResult)atomicReference.get();
    }

    public synchronized void stopFindingText(StopFindAction stopFindAction) {
        if (stopFindAction == null) {
            throw new IllegalArgumentException("The action parameter cannot be null.");
        }
        this.a(new StopFindingMessage(MessageUIDGenerator.generate(), stopFindAction.getValue()));
    }

    public synchronized String getSelectedText() {
        return this.getSelectedText(-2L);
    }

    public synchronized String getSelectedText(long l2) {
        this.a(l2);
        if (this.b != null) {
            GetSelectedTextMessage getSelectedTextMessage = this.b.post(new GetSelectedTextMessage(MessageUIDGenerator.generate(), l2, ""));
            return getSelectedTextMessage.getSelectedText();
        }
        return "";
    }

    public PluginManager getPluginManager() {
        return this.i;
    }

    public void setPrintHandler(PrintHandler printHandler) {
        this.y = printHandler;
    }

    public PrintHandler getPrintHandler() {
        return this.y;
    }

    public synchronized void print() {
        this.a(new PrintMessage(MessageUIDGenerator.generate()));
    }

    public synchronized void printToPDF(String string) {
        this.printToPDF(string, null);
    }

    public synchronized void printToPDF(String object, PrintJobListener printJobListener) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("The filePath parameter cannot be null or empty.");
        }
        if (!((File)(object = new File((String)object))).exists() && !FileUtil.createFile((File)object)) {
            throw new IllegalArgumentException("Java process doesn't have rights to create a new file at " + ((File)object).getAbsolutePath());
        }
        this.q.addLast(new PDFPrintJob((File)object, printJobListener));
        this.a(new PrintToPDFMessage(MessageUIDGenerator.generate()));
    }

    public synchronized void setPreferences(BrowserPreferences browserPreferences) {
        if (browserPreferences == null) {
            throw new IllegalArgumentException("Preferences cannot be null.");
        }
        this.a(new UpdateWebPreferencesMessage(MessageUIDGenerator.generate(), browserPreferences));
    }

    public synchronized BrowserPreferences getPreferences() {
        GetWebPreferencesMessage getWebPreferencesMessage = this.b(new GetWebPreferencesMessage(MessageUIDGenerator.generate()));
        return getWebPreferencesMessage.getPreferences();
    }

    public synchronized boolean saveWebPage(String object, String string, SavePageType savePageType) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("The filePath parameter cannot be empty or null.");
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The dirPath parameter cannot be empty or null.");
        }
        if (savePageType == null) {
            throw new IllegalArgumentException("The saveType parameter cannot be null.");
        }
        object = this.b(new SaveWebPageMessage(MessageUIDGenerator.generate(), (String)object, string, savePageType.getValue()));
        return ((SaveWebPageMessage)object).getResult();
    }

    public ProxyConfig getProxyConfig() {
        return this.d;
    }

    public BrowserContext getContext() {
        return this.g;
    }

    public synchronized DOMDocument getDocument() {
        return this.getDocument(-1L);
    }

    public synchronized DOMDocument getDocument(long l2) {
        Object object;
        long l3;
        this.a(l2);
        if (this.b != null && (l3 = ((GetDocumentMessage)(object = this.b.post(new GetDocumentMessage(MessageUIDGenerator.generate(), l2, 0L)))).getDocumentPtr()) != 0L) {
            object = new DOMContext(this.b);
            DOMFactory dOMFactory = new DOMFactory((DOMContext)object);
            return new Document(l3, dOMFactory, (DOMContext)object);
        }
        return null;
    }

    public synchronized DOMNodeAtPoint getNodeAtPoint(int n2, int n3) {
        if (this.b != null) {
            GetNodeAtPointMessage getNodeAtPointMessage = this.b.post(new GetNodeAtPointMessage(MessageUIDGenerator.generate(), n2, n3, "", "", 0, 0, "", ""));
            Object object = new DOMContext(this.b);
            object = new DOMFactory((DOMContext)object);
            return ((DOMFactory)object).createNodeAtPoint(getNodeAtPointMessage);
        }
        return null;
    }

    public synchronized DOMNodeAtPoint getNodeAtPoint(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("The point parameter cannot be null.");
        }
        return this.getNodeAtPoint(point.x, point.y);
    }

    public synchronized void dispose() {
        this.a(true);
    }

    private synchronized void a(boolean bl) {
        if (!this.isDisposed()) {
            Object object = new CountDownLatch(1);
            ab ab2 = new ab(this, (CountDownLatch)object);
            IPC iPC = this.getIPC();
            iPC.addIPCChannelListener(ab2);
            try {
                this.b(new BeforeDisposeBrowserMessage(MessageUIDGenerator.generate()));
                this.a(new DisposeBrowserMessage(MessageUIDGenerator.generate()));
                Channel channel = this.c;
                Iterator<DisposeListener<Browser>> iterator = this.b;
                if (iterator != null) {
                    iterator.blockWriteMessages();
                }
                if (channel != null) {
                    channel.blockWriteMessages();
                }
                this.c.waitForPendingPostRequests();
                if (this.b != null) {
                    this.b.waitForPendingPostRequests();
                }
                LatchUtil.await((CountDownLatch)object, new IPCException("Failed to execute WebEngine dispose post message."));
                object = new HashSet<Long>(this.t.keySet());
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    long l2 = (Long)iterator.next();
                    object = this.t.remove(l2);
                    if (object == null) continue;
                    ((JSContext)object).c();
                }
                if (this.b != null) {
                    this.b.removeChannelListener(this.D);
                    this.b = null;
                }
            }
            finally {
                iPC.removeIPCChannelListener(this.E);
                iPC.removeIPCChannelListener(ab2);
                iPC.stop();
            }
            object = new DisposeEvent<Browser>(this);
            for (DisposeListener<Browser> disposeListener : this.getDisposeListeners()) {
                this.h.invokeLater(new ac(this, disposeListener, (DisposeEvent)object));
            }
            this.h.dispose();
            this.g.b(this);
        }
    }

    public synchronized boolean isDisposed() {
        try {
            PingMessage pingMessage = this.b(new PingMessage(MessageUIDGenerator.generate()));
            return !pingMessage.isAlive();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void addDisposeListener(DisposeListener<Browser> disposeListener) {
        if (!this.o.contains(disposeListener)) {
            this.o.add(disposeListener);
        }
    }

    public void removeDisposeListener(DisposeListener<Browser> disposeListener) {
        this.o.remove(disposeListener);
    }

    public List<DisposeListener<Browser>> getDisposeListeners() {
        return new ArrayList<DisposeListener<Browser>>(this.o);
    }

    public synchronized void loadURL(String string) {
        this.loadURL(-1L, string);
    }

    public synchronized void loadURL(long l2, String string) {
        if (string == null) {
            throw new IllegalArgumentException("The url parameter cannot be null.");
        }
        this.a(l2);
        this.a(new LoadURLMessage(MessageUIDGenerator.generate(), string, l2));
    }

    public synchronized void loadURL(LoadURLParams loadURLParams) {
        if (loadURLParams == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        this.a(new LoadURLMessage(MessageUIDGenerator.generate(), loadURLParams.getURL(), -1L, loadURLParams.getExtraHeaders(), loadURLParams.getPostData().getBytes(Charset.forName("UTF-8"))));
    }

    public synchronized void loadHTML(String string) {
        this.loadHTML(-1L, string);
    }

    public synchronized void loadHTML(long l2, String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The html parameter cannot be null or empty.");
        }
        this.a(l2);
        this.loadHTML(l2, new LoadHTMLParams(string, "UTF-8", "about:blank"));
    }

    public synchronized void loadHTML(LoadHTMLParams loadHTMLParams) {
        this.loadHTML(-1L, loadHTMLParams);
    }

    public synchronized void loadHTML(long l2, LoadHTMLParams loadHTMLParams) {
        if (loadHTMLParams == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        this.loadData(l2, new LoadDataParams(loadHTMLParams.getHTML(), "text/html", loadHTMLParams.getTextEncoding(), loadHTMLParams.getBaseURL()));
    }

    public synchronized void loadData(LoadDataParams loadDataParams) {
        this.loadData(-1L, loadDataParams);
    }

    public synchronized void loadData(long l2, LoadDataParams loadDataParams) {
        if (loadDataParams == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        this.a(l2);
        if (this.b == null || this.b.isClosed()) {
            throw new IllegalStateException("HTML document isn't available.");
        }
        this.b.send(new LoadDataMessage(MessageUIDGenerator.generate(), loadDataParams.getData(), loadDataParams.getMimeType(), loadDataParams.getTextEncoding(), loadDataParams.getBaseURL(), l2));
    }

    public synchronized String getHTML() {
        return this.getHTML(-1L);
    }

    public synchronized String getHTML(long l2) {
        this.a(l2);
        if (this.b == null || this.b.isClosed()) {
            throw new IllegalStateException("HTML document isn't available.");
        }
        GetHTMLMessage getHTMLMessage = this.b.post(new GetHTMLMessage(MessageUIDGenerator.generate(), l2, null));
        return getHTMLMessage.getHTML();
    }

    public synchronized String getURL() {
        GetURLMessage getURLMessage = this.b(new GetURLMessage(MessageUIDGenerator.generate()));
        return getURLMessage.getURL();
    }

    public synchronized void executeJavaScript(String string) {
        this.executeJavaScript(-1L, string);
    }

    public synchronized JSValue executeJavaScriptAndReturnValue(String string) {
        return this.executeJavaScriptAndReturnValue(-1L, string);
    }

    public synchronized void executeJavaScript(long l2, String string) {
        if (string == null) {
            throw new IllegalArgumentException("The javaScript parameter cannot be null.");
        }
        this.a(l2);
        if (this.b == null || this.b.isClosed()) {
            throw new IllegalStateException("HTML document isn't available.");
        }
        this.b.send(new ExecuteJavaScriptMessage(MessageUIDGenerator.generate(), l2, string));
    }

    public synchronized JSValue executeJavaScriptAndReturnValue(long l2, String object) {
        if (object == null) {
            throw new IllegalArgumentException("The javaScript parameter cannot be null.");
        }
        this.a(l2);
        if (this.b == null || this.b.isClosed()) {
            throw new IllegalStateException("HTML document isn't available.");
        }
        object = this.b.post(new ExecuteJavaScriptMessage(MessageUIDGenerator.generate(), l2, (String)object, true));
        return ag.a((ExecuteJavaScriptMessage)object, this.getJSContext(l2));
    }

    public void registerFunction(String string, BrowserFunction browserFunction) {
        this.u.put(string, browserFunction);
    }

    public void unregisterFunction(String string) {
        this.u.remove(string);
    }

    public JSContext getJSContext() {
        return this.getJSContext(-1L);
    }

    public JSContext getJSContext(long l2) {
        return this.t.get(l2);
    }

    public List<String> getBrowserFunctionNames() {
        return new ArrayList<String>(this.u.keySet());
    }

    public BrowserFunction getBrowserFunction(String string) {
        return this.u.get(string);
    }

    public synchronized String getTitle() {
        GetTitleMessage getTitleMessage = this.b(new GetTitleMessage(MessageUIDGenerator.generate()));
        return getTitleMessage.getTitle();
    }

    public synchronized void setZoomLevel(double d2) {
        this.a(new SetZoomLevelMessage(MessageUIDGenerator.generate(), d2));
    }

    public synchronized double getZoomLevel() {
        GetZoomLevelMessage getZoomLevelMessage = this.b(new GetZoomLevelMessage(MessageUIDGenerator.generate()));
        return getZoomLevelMessage.getZoomLevel();
    }

    public synchronized void zoomIn() {
        this.a(new SetZoomMessage(MessageUIDGenerator.generate(), PageZoom.PAGE_ZOOM_IN.getValue()));
    }

    public synchronized void zoomOut() {
        this.a(new SetZoomMessage(MessageUIDGenerator.generate(), PageZoom.PAGE_ZOOM_OUT.getValue()));
    }

    public synchronized void zoomReset() {
        this.a(new SetZoomMessage(MessageUIDGenerator.generate(), PageZoom.PAGE_ZOOM_RESET.getValue()));
    }

    public synchronized boolean isLoading() {
        IsLoadingMessage isLoadingMessage = this.b(new IsLoadingMessage(MessageUIDGenerator.generate()));
        return isLoadingMessage.isLoading();
    }

    public synchronized void stop() {
        this.a(new StopMessage(MessageUIDGenerator.generate()));
    }

    public synchronized void goBack() {
        this.a(new GoBackMessage(MessageUIDGenerator.generate()));
    }

    public synchronized boolean canGoBack() {
        CanGoBackMessage canGoBackMessage = this.b(new CanGoBackMessage(MessageUIDGenerator.generate()));
        return canGoBackMessage.canGoBack();
    }

    public synchronized void goForward() {
        this.a(new GoForwardMessage(MessageUIDGenerator.generate()));
    }

    public synchronized boolean canGoForward() {
        CanGoForwardMessage canGoForwardMessage = this.b(new CanGoForwardMessage(MessageUIDGenerator.generate()));
        return canGoForwardMessage.canGoForward();
    }

    public synchronized boolean canGoToOffset(int n2) {
        CanGoToOffsetMessage canGoToOffsetMessage = this.b(new CanGoToOffsetMessage(MessageUIDGenerator.generate(), n2, false));
        return canGoToOffsetMessage.canGoToOffset();
    }

    public synchronized void goToOffset(int n2) {
        this.a(new GoToOffsetMessage(MessageUIDGenerator.generate(), n2));
    }

    public synchronized void goToIndex(int n2) {
        this.a(new GoToIndexMessage(MessageUIDGenerator.generate(), n2));
    }

    public synchronized int getNavigationEntryCount() {
        GetEntryCountMessage getEntryCountMessage = this.b(new GetEntryCountMessage(MessageUIDGenerator.generate(), 0));
        return getEntryCountMessage.getEntryCount();
    }

    public synchronized int getCurrentNavigationEntryIndex() {
        GetCurrentEntryIndexMessage getCurrentEntryIndexMessage = this.b(new GetCurrentEntryIndexMessage(MessageUIDGenerator.generate(), 0));
        return getCurrentEntryIndexMessage.getIndex();
    }

    public synchronized NavigationEntry getCurrentNavigationEntry() {
        return this.a(GetEntryMessage.Flag.CURRENT, -1);
    }

    public synchronized NavigationEntry getNavigationEntryAtIndex(int n2) {
        return this.a(GetEntryMessage.Flag.AT_INDEX, n2);
    }

    public synchronized NavigationEntry getNavigationEntryAtOffset(int n2) {
        return this.a(GetEntryMessage.Flag.AT_OFFSET, n2);
    }

    private NavigationEntry a(GetEntryMessage.Flag object, int n2) {
        object = this.b(new GetEntryMessage(MessageUIDGenerator.generate(), (GetEntryMessage.Flag)((Object)object), n2));
        if (((GetEntryMessage)object).isSuccess()) {
            String string = ((GetEntryMessage)object).getURL();
            String string2 = ((GetEntryMessage)object).getTitle();
            long l2 = ((GetEntryMessage)object).getTimestamp();
            NavigationEntry.PageType pageType = NavigationEntry.PageType.valueOf(((GetEntryMessage)object).getPageType());
            int n3 = ((GetEntryMessage)object).getHttpStatusCode();
            object = ((GetEntryMessage)object).getOriginalRequestURL();
            return new NavigationEntry(string, string2, l2, pageType, n3, (String)object);
        }
        return null;
    }

    public synchronized boolean removeNavigationEntryAtIndex(int n2) {
        RemoveEntryAtIndexMessage removeEntryAtIndexMessage = this.b(new RemoveEntryAtIndexMessage(MessageUIDGenerator.generate(), n2, false));
        return removeEntryAtIndexMessage.isSuccess();
    }

    public synchronized void reload() {
        this.reload(false);
    }

    public synchronized void reloadIgnoringCache() {
        this.reloadIgnoringCache(false);
    }

    public synchronized void reload(boolean bl) {
        this.a(new ReloadMessage(MessageUIDGenerator.generate(), bl));
    }

    public synchronized void reloadIgnoringCache(boolean bl) {
        this.a(new ReloadIgnoringCacheMessage(MessageUIDGenerator.generate(), bl));
    }

    private synchronized void a(long l2) {
        boolean bl;
        boolean bl2 = l2 == -1L;
        boolean bl3 = bl = l2 == -2L;
        if (bl2 || bl) {
            return;
        }
        if (this.b == null || this.b.isClosed()) {
            throw new IllegalStateException("HTML document isn't available.");
        }
        IsFrameExistsMessage isFrameExistsMessage = this.b.post(new IsFrameExistsMessage(MessageUIDGenerator.generate(), l2, false));
        if (!isFrameExistsMessage.getResult()) {
            throw new IllegalArgumentException("The '" + l2 + "' frame ID doesn't exist.");
        }
    }

    public static void invokeAndWaitFinishLoadingMainFrame(Browser browser, Callback<Browser> callback) {
        Browser.invokeAndWaitFinishLoadingMainFrame(browser, callback, 45);
    }

    public static void invokeAndWaitFinishLoadingMainFrame(Browser browser, Callback<Browser> callback, int n2) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        z z2 = new z(countDownLatch);
        browser.addLoadListener(z2);
        try {
            callback.invoke(browser);
            try {
                if (!countDownLatch.await(n2, TimeUnit.SECONDS)) {
                    throw new RuntimeException(new TimeoutException());
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            return;
        }
        finally {
            browser.removeLoadListener(z2);
        }
    }

    static /* synthetic */ void a(Browser browser, OnRenderViewCreatedMessage object) {
        object = new RenderEvent(browser);
        for (RenderListener renderListener : browser.getRenderListeners()) {
            browser.h.invokeLater(new q(browser, renderListener, (RenderEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnRenderViewGoneMessage object) {
        object = new RenderEvent(browser, ((OnRenderViewGoneMessage)object).getErrorCode(), TerminationStatus.valueOf(((OnRenderViewGoneMessage)object).getTerminationStatus()));
        for (RenderListener renderListener : browser.getRenderListeners()) {
            browser.h.invokeLater(new y(browser, renderListener, (RenderEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDidStartProvisionalLoadForFrameMessage object) {
        object = new StartLoadingEvent(browser, ((OnDidStartProvisionalLoadForFrameMessage)object).getFrameId(), ((OnDidStartProvisionalLoadForFrameMessage)object).getParentFrameId(), ((OnDidStartProvisionalLoadForFrameMessage)object).isMainFrame(), ((OnDidStartProvisionalLoadForFrameMessage)object).getValidatedURL(), ((OnDidStartProvisionalLoadForFrameMessage)object).isErrorPage());
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.h.invokeLater(new x(browser, loadListener, (StartLoadingEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDidCommitProvisionalLoadForFrameMessage object) {
        object = new ProvisionalLoadingEvent(browser, ((OnDidCommitProvisionalLoadForFrameMessage)object).getFrameId(), ((OnDidCommitProvisionalLoadForFrameMessage)object).isMainFrame(), ((OnDidCommitProvisionalLoadForFrameMessage)object).getURL());
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.h.invokeLater(new v(browser, loadListener, (ProvisionalLoadingEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDidFinishLoadMessage object) {
        object = new FinishLoadingEvent(browser, ((OnDidFinishLoadMessage)object).getFrameId(), ((OnDidFinishLoadMessage)object).isMainFrame(), ((OnDidFinishLoadMessage)object).getValidatedURL());
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.h.invokeLater(new u(browser, loadListener, (FinishLoadingEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDidFailProvisionalLoadMessage object) {
        object = new FailLoadingEvent(browser, ((OnDidFailProvisionalLoadMessage)object).getFrameId(), ((OnDidFailProvisionalLoadMessage)object).isMainFrame(), ((OnDidFailProvisionalLoadMessage)object).getValidatedURL(), NetError.valueOf(((OnDidFailProvisionalLoadMessage)object).getErrorCode()), ((OnDidFailProvisionalLoadMessage)object).getErrorDescription());
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.h.invokeLater(new t(browser, loadListener, (FailLoadingEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDidFailLoadMessage object) {
        object = new FailLoadingEvent(browser, ((OnDidFailLoadMessage)object).getFrameId(), ((OnDidFailLoadMessage)object).isMainFrame(), ((OnDidFailLoadMessage)object).getValidatedURL(), NetError.valueOf(((OnDidFailLoadMessage)object).getErrorCode()), ((OnDidFailLoadMessage)object).getErrorDescription());
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.h.invokeLater(new o(browser, loadListener, (FailLoadingEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDocumentAvailableInMainFrameMessage object) {
        object = new LoadEvent(browser);
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.h.invokeLater(new s(browser, loadListener, (LoadEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDocumentLoadedInFrameMessage object) {
        object = new FrameLoadEvent(browser, ((OnDocumentLoadedInFrameMessage)object).getFrameId(), ((OnDocumentLoadedInFrameMessage)object).isMainFrame());
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.h.invokeLater(new r(browser, loadListener, (FrameLoadEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnTitleChangeMessage object) {
        object = new TitleEvent(browser, ((OnTitleChangeMessage)object).getTitle());
        for (TitleListener titleListener : browser.getTitleListeners()) {
            browser.h.invokeLater(new p(browser, titleListener, (TitleEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnShouldCreateWebContentsMessage onShouldCreateWebContentsMessage) {
        Object object = onShouldCreateWebContentsMessage.getFrameName();
        String string = onShouldCreateWebContentsMessage.getTargetURL();
        if (browser.x != null) {
            object = new PopupParams(browser, (String)object, string);
            browser.B = browser.x.handlePopup((PopupParams)object);
            onShouldCreateWebContentsMessage.setShouldCreate(browser.B != null);
        }
    }

    static /* synthetic */ void a(Browser browser, OnAddNewContentsMessage object) {
        Object object2;
        int n2 = ((OnAddNewContentsMessage)object).getChannelId();
        IPC iPC = browser.getIPC();
        if (!iPC.hasChannel(n2, ChannelType.Browser)) {
            iPC.waitChannel(n2, ChannelType.Browser);
        }
        if ((object2 = iPC.getChannel(n2, ChannelType.Browser)) != null) {
            object2 = new Browser(browser.getContext(), browser.getProxyConfig(), (Channel)object2);
            object = ((OnAddNewContentsMessage)object).getInitialBounds();
            if (browser.B != null) {
                browser.B.insertBrowser((Browser)object2, (Rectangle)object);
                browser.B = null;
            }
        }
    }

    static /* synthetic */ void a(Browser browser, OnShowContextMenuMessage object) {
        if (browser.C != null) {
            MediaType mediaType = MediaType.valueOf(((OnShowContextMenuMessage)object).getMediaType());
            object = new ContextMenuParams(browser, mediaType, ((OnShowContextMenuMessage)object).getX(), ((OnShowContextMenuMessage)object).getY(), ((OnShowContextMenuMessage)object).getLinkURL(), ((OnShowContextMenuMessage)object).getLinkText(), ((OnShowContextMenuMessage)object).getSrcURL(), ((OnShowContextMenuMessage)object).isImageBlocked(), ((OnShowContextMenuMessage)object).getPageURL(), ((OnShowContextMenuMessage)object).getFrameURL(), ((OnShowContextMenuMessage)object).getFrameId(), ((OnShowContextMenuMessage)object).getSelectionText(), ((OnShowContextMenuMessage)object).getMisspelledWord(), ((OnShowContextMenuMessage)object).getFrameCharset());
            browser.h.invokeLater(new n(browser, (ContextMenuParams)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnBeforeDownloadMessage onBeforeDownloadMessage) {
        Object object = new File(onBeforeDownloadMessage.getDestinationFile());
        int n2 = onBeforeDownloadMessage.getPercentComplete();
        long l2 = onBeforeDownloadMessage.getReceivedBytes();
        long l3 = onBeforeDownloadMessage.getTotalBytes();
        long l4 = onBeforeDownloadMessage.getCurrentSpeed();
        boolean bl = onBeforeDownloadMessage.isPaused();
        boolean bl2 = onBeforeDownloadMessage.isCanceled();
        boolean bl3 = onBeforeDownloadMessage.isCompleted();
        String string = onBeforeDownloadMessage.getMimeType();
        String string2 = onBeforeDownloadMessage.getURL();
        int n3 = onBeforeDownloadMessage.getID();
        object = new MutableDownloadItem(browser, browser.getIPC().getMainChannel(), browser.c, (File)object, n2, l2, l3, l4, bl, bl2, bl3, string, string2, n3);
        try {
            boolean bl4 = browser.z != null && browser.z.allowDownload((DownloadItem)object);
            onBeforeDownloadMessage.setDestinationFile(((MutableDownloadItem)object).getDestinationFile().getAbsolutePath());
            onBeforeDownloadMessage.setCancel(!bl4);
            return;
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "The DownloadHandler.allowDownload() method has thrown exception.", exception);
            onBeforeDownloadMessage.setCancel(true);
            return;
        }
    }

    static /* synthetic */ void a(Browser browser, OnRunJavaScriptDialogMessage onRunJavaScriptDialogMessage) {
        browser.p.handle(browser, browser.h, onRunJavaScriptDialogMessage, (Callback<Message>)new m(browser));
    }

    static /* synthetic */ void a(Browser browser, OnWindowCloseMessage onWindowCloseMessage) {
        browser.h.invokeLater(new k(browser));
    }

    static /* synthetic */ void a(Browser browser, OnRunFileChooserMessage onRunFileChooserMessage) {
        browser.p.handle(browser, browser.h, onRunFileChooserMessage, (Callback<Message>)new j(browser));
    }

    static /* synthetic */ void a(Browser browser, OnConsoleMessage object) {
        object = new ConsoleEvent(browser, ConsoleEvent.Level.valueOf(((OnConsoleMessage)object).getLevel()), ((OnConsoleMessage)object).getLineNumber(), ((OnConsoleMessage)object).getMessage(), ((OnConsoleMessage)object).getSourceId());
        for (ConsoleListener consoleListener : browser.getConsoleListeners()) {
            browser.h.invokeLater(new i(browser, consoleListener, (ConsoleEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnStatusChangeMessage object) {
        object = new StatusEvent(browser, ((OnStatusChangeMessage)object).getURL());
        for (StatusListener statusListener : browser.getStatusListeners()) {
            browser.h.invokeLater(new h(browser, statusListener, (StatusEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnSelectClientCertificateMessage onSelectClientCertificateMessage) {
        browser.p.handle(browser, browser.h, onSelectClientCertificateMessage, (Callback<Message>)new g(browser));
    }

    static /* synthetic */ void a(Browser browser, OnAllowCertificateErrorMessage onAllowCertificateErrorMessage) {
        int n2 = onAllowCertificateErrorMessage.getCallbackID();
        LoadHandler loadHandler = browser.getLoadHandler();
        if (loadHandler == null) {
            browser.a(new AllowCertificateErrorMessage(MessageUIDGenerator.generate(), n2, true));
            return;
        }
        browser.h.invokeLater(new f(browser, onAllowCertificateErrorMessage, loadHandler, n2));
    }

    static /* synthetic */ void a(Browser object, OnSearchCompleteMessage onSearchCompleteMessage) {
        int n2 = onSearchCompleteMessage.getRequestId();
        object = ((Browser)object).v.remove(n2);
        if (object != null) {
            n2 = onSearchCompleteMessage.getCurrentMatch();
            int n3 = onSearchCompleteMessage.getNumberOfMatches();
            SearchResult searchResult = new SearchResult(n2, n3);
            object.searchComplete(searchResult);
        }
    }

    static /* synthetic */ void a(Browser browser, OnFormRepostWarningShowMessage onFormRepostWarningShowMessage) {
        browser.p.handleReloadPostData(browser, browser.h, new e(browser));
    }

    static /* synthetic */ void a(Browser browser, OnRequestPrintSettingsMessage onRequestPrintSettingsMessage) {
        browser.h.invokeLater(new d(browser, onRequestPrintSettingsMessage));
    }

    static /* synthetic */ void a(Browser browser, OnPrintingDoneMessage object) {
        int n2 = ((OnPrintingDoneMessage)object).getRequestId();
        Object object2 = browser.s.remove(n2);
        if (object2 != null) {
            object = new PrintJobEvent(browser, ((OnPrintingDoneMessage)object).isSuccess());
            object2 = ((PrintJob)object2).getPrintJobListeners();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                PrintJobListener printJobListener = object2.next();
                browser.h.invokeLater(new af(browser, printJobListener, (PrintJobEvent)object));
            }
        }
    }

    static /* synthetic */ void a(Browser browser, OnRequestPDFPrintSettingsMessage onRequestPDFPrintSettingsMessage) {
        browser.h.invokeLater(new com.teamdev.jxbrowser.chromium.b(browser, onRequestPDFPrintSettingsMessage));
    }

    static /* synthetic */ void a(Browser browser, OnPDFPrintingDoneMessage object) {
        int n2 = ((OnPDFPrintingDoneMessage)object).getRequestId();
        PDFPrintJob pDFPrintJob = browser.r.remove(n2);
        if (pDFPrintJob != null && pDFPrintJob.hasListener()) {
            object = new PrintJobEvent(browser, ((OnPDFPrintingDoneMessage)object).isSuccess());
            browser.h.invokeLater(new c(browser, pDFPrintJob, (PrintJobEvent)object));
        }
    }

    static /* synthetic */ void a(Browser object, OnRequestPluginStateMessage onRequestPluginStateMessage) {
        onRequestPluginStateMessage.setAvailable(true);
        object = ((Browser)object).getPluginManager().getPluginFilter();
        if (object != null) {
            Object object2 = onRequestPluginStateMessage.getPluginRepresentation();
            object2 = PluginInfoParser.parsePluginInfo((String)object2);
            try {
                if (object2 != null) {
                    onRequestPluginStateMessage.setAvailable(object.isPluginAllowed((PluginInfo)object2));
                }
                return;
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "The PluginFilter.isPluginAllowed() method has thrown exception: ", exception);
            }
        }
    }

    static /* synthetic */ void a(Browser browser, OnToggleFullscreenModeMessage onToggleFullscreenModeMessage) {
        if (onToggleFullscreenModeMessage.isFullScreenEnabled()) {
            browser.h.invokeLater(new ad(browser));
            return;
        }
        browser.h.invokeLater(new ae(browser));
    }

    static /* synthetic */ Channel a(Browser browser) {
        return browser.getChannel();
    }

    static /* synthetic */ FullScreenHandler b(Browser browser) {
        return browser.A;
    }

    static /* synthetic */ Deque c(Browser browser) {
        return browser.q;
    }

    static /* synthetic */ Map d(Browser browser) {
        return browser.r;
    }

    static /* synthetic */ void a(Browser browser, Message message) {
        browser.a(message);
    }

    static /* synthetic */ PrintHandler e(Browser browser) {
        return browser.y;
    }

    static /* synthetic */ Map f(Browser browser) {
        return browser.s;
    }

    static /* synthetic */ ContextMenuHandler g(Browser browser) {
        return browser.C;
    }

    final class a
    extends IPCChannelAdapter {
        private /* synthetic */ Browser a;

        private a(Browser browser) {
            this.a = browser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onChannelAdded(Channel channel) {
            boolean bl;
            boolean bl2 = channel.getType() == ChannelType.Render;
            boolean bl3 = bl = channel.getBrowserId() == this.a.c.getBrowserId();
            if (bl2 && bl) {
                Browser browser = this.a;
                synchronized (browser) {
                    if (this.a.b != null) {
                        this.a.b.removeChannelListener(this.a.D);
                    }
                    this.a.b = channel;
                    this.a.b.addChannelListener(this.a.D);
                    return;
                }
            }
        }

        /* synthetic */ a(Browser browser, byte by) {
            this(browser);
        }
    }

    final class b
    implements ChannelListener {
        private /* synthetic */ Browser a;

        private b(Browser browser) {
            this.a = browser;
        }

        @Override
        public final void onMessageReceived(Message object) {
            block14: {
                Object object2 = object.getType();
                if (object2 == MessageType.OnGetJSFunctions) {
                    object2 = (OnGetJSFunctionsMessage)object;
                    object = this;
                    List<String> list = ((b)object).a.getBrowserFunctionNames();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string : list) {
                        stringBuilder.append(string);
                        stringBuilder.append(' ');
                    }
                    ((OnGetJSFunctionsMessage)object2).setFunctionNames(stringBuilder.toString());
                    return;
                }
                if (object2 == MessageType.OnInvokeJSFunction) {
                    object2 = (OnInvokeJSFunctionMessage)object;
                    object = this;
                    String string = ((OnInvokeJSFunctionMessage)object2).getName();
                    BrowserFunction browserFunction = ((b)object).a.getBrowserFunction(string);
                    List<JSValue> list = ag.a(((OnInvokeJSFunctionMessage)object2).getArgs(), ((b)object).a.getJSContext());
                    try {
                        JSValue jSValue = browserFunction.invoke(list.toArray(new JSValue[list.size()]));
                        if (jSValue == null) {
                            jSValue = JSValue.createUndefined();
                        }
                        ((OnInvokeJSFunctionMessage)object2).setReturnValue(ag.a(jSValue));
                    }
                    catch (Exception exception) {
                        a.log(Level.SEVERE, object.toString());
                        a.log(Level.SEVERE, "The Browser.invoke() method has thrown exception: ", exception);
                        ((OnInvokeJSFunctionMessage)object2).setErrorMessage(exception.getMessage());
                        return;
                    }
                }
                if (object2 == MessageType.OnHandleLoadMessage) {
                    block13: {
                        object2 = (OnHandleLoadMessage)object;
                        object = this;
                        LoadHandler loadHandler = ((b)object).a.getLoadHandler();
                        if (loadHandler != null) {
                            String string = ((OnHandleLoadMessage)object2).getURL();
                            LoadParams.LoadType loadType = LoadParams.LoadType.valueOf(((OnHandleLoadMessage)object2).getLoadType());
                            LoadParams.LoadPolicy loadPolicy = LoadParams.LoadPolicy.valueOf(((OnHandleLoadMessage)object2).getLoadPpolicy());
                            try {
                                if (((OnHandleLoadMessage)object2).isBackForward()) {
                                    ((OnHandleLoadMessage)object2).setCancel(!loadHandler.canNavigateOnBackspace());
                                    break block13;
                                }
                                ((OnHandleLoadMessage)object2).setCancel(loadHandler.onLoad(new LoadParams(string, loadType, loadPolicy, ((OnHandleLoadMessage)object2).isRedirect())));
                                break block14;
                            }
                            catch (Exception exception) {
                                a.log(Level.SEVERE, "The LoadHandler.onLoad() method has thrown exception: ", exception);
                            }
                        }
                    }
                    return;
                }
                if (object2 == MessageType.OnDidCreateScriptContext) {
                    object2 = (OnDidCreateScriptContextMessage)object;
                    object = this;
                    long l2 = ((OnDidCreateScriptContextMessage)object2).getFrameId();
                    JSContext jSContext = (JSContext)((b)object).a.t.remove(l2);
                    if (jSContext != null) {
                        jSContext.c();
                    }
                    ((b)object).a.t.put(l2, new JSContext(((b)object).a.b, l2, ((OnDidCreateScriptContextMessage)object2).getContextPtr()));
                }
            }
        }

        /* synthetic */ b(Browser browser, byte by) {
            this(browser);
        }
    }
}

