/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.Utils;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.TableColumnBase;

class ControlUtils {
    private ControlUtils() {
    }

    public static void scrollToIndex(Control control, int n) {
        Utils.executeOnceWhenPropertyIsNonNull(control.skinProperty(), skin -> Event.fireEvent(control, new ScrollToEvent<Integer>(control, control, ScrollToEvent.scrollToTopIndex(), n)));
    }

    public static void scrollToColumn(Control control, TableColumnBase<?, ?> tableColumnBase) {
        Utils.executeOnceWhenPropertyIsNonNull(control.skinProperty(), skin -> control.fireEvent(new ScrollToEvent<TableColumnBase>(control, control, ScrollToEvent.scrollToColumn(), tableColumnBase)));
    }

    static void requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(Control control) {
        Node node;
        Scene scene = control.getScene();
        Node node2 = node = scene == null ? null : scene.getFocusOwner();
        if (node == null) {
            control.requestFocus();
        } else if (!control.equals(node)) {
            for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
                if (!control.equals(parent)) continue;
                control.requestFocus();
                break;
            }
        }
    }
}

