/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.osx;

import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.effects.AudioEqualizer;
import com.sun.media.jfxmedia.effects.AudioSpectrum;
import com.sun.media.jfxmedia.effects.EqualizerBand;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmediaimpl.NativeMedia;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer;
import com.sun.media.jfxmediaimpl.platform.osx.OSXMedia;
import java.util.HashMap;
import java.util.Map;

final class OSXMediaPlayer
extends NativeMediaPlayer {
    private NullAudioEQ audioEq;
    private NullAudioSpectrum audioSpectrum;
    private final Locator mediaLocator;

    OSXMediaPlayer(NativeMedia nativeMedia) {
        super(nativeMedia);
        this.init();
        this.mediaLocator = nativeMedia.getLocator();
        this.audioEq = new NullAudioEQ();
        this.audioSpectrum = new NullAudioSpectrum();
    }

    OSXMediaPlayer(Locator locator) {
        this(new OSXMedia(locator));
    }

    @Override
    public AudioEqualizer getEqualizer() {
        return this.audioEq;
    }

    @Override
    public AudioSpectrum getAudioSpectrum() {
        return this.audioSpectrum;
    }

    void initializePlayer() {
        this.osxCreatePlayer(this.mediaLocator.getStringLocation());
    }

    @Override
    protected long playerGetAudioSyncDelay() throws MediaException {
        return this.osxGetAudioSyncDelay();
    }

    @Override
    protected void playerSetAudioSyncDelay(long l) throws MediaException {
        this.osxSetAudioSyncDelay(l);
    }

    @Override
    protected void playerPlay() throws MediaException {
        this.osxPlay();
    }

    @Override
    protected void playerStop() throws MediaException {
        this.osxStop();
    }

    @Override
    protected void playerPause() throws MediaException {
        this.osxPause();
    }

    @Override
    protected void playerFinish() throws MediaException {
        this.osxFinish();
    }

    @Override
    protected float playerGetRate() throws MediaException {
        return this.osxGetRate();
    }

    @Override
    protected void playerSetRate(float f) throws MediaException {
        this.osxSetRate(f);
    }

    @Override
    protected double playerGetPresentationTime() throws MediaException {
        return this.osxGetPresentationTime();
    }

    @Override
    protected boolean playerGetMute() throws MediaException {
        return this.osxGetMute();
    }

    @Override
    protected void playerSetMute(boolean bl) throws MediaException {
        this.osxSetMute(bl);
    }

    @Override
    protected float playerGetVolume() throws MediaException {
        return this.osxGetVolume();
    }

    @Override
    protected void playerSetVolume(float f) throws MediaException {
        this.osxSetVolume(f);
    }

    @Override
    protected float playerGetBalance() throws MediaException {
        return this.osxGetBalance();
    }

    @Override
    protected void playerSetBalance(float f) throws MediaException {
        this.osxSetBalance(f);
    }

    @Override
    protected double playerGetDuration() throws MediaException {
        double d = this.osxGetDuration();
        if (d == -1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return d;
    }

    @Override
    protected void playerSeek(double d) throws MediaException {
        this.osxSeek(d);
    }

    @Override
    protected void playerDispose() {
        this.osxDispose();
    }

    private native void osxCreatePlayer(String var1) throws MediaException;

    private native long osxGetAudioSyncDelay() throws MediaException;

    private native void osxSetAudioSyncDelay(long var1) throws MediaException;

    private native void osxPlay() throws MediaException;

    private native void osxStop() throws MediaException;

    private native void osxPause() throws MediaException;

    private native void osxFinish() throws MediaException;

    private native float osxGetRate() throws MediaException;

    private native void osxSetRate(float var1) throws MediaException;

    private native double osxGetPresentationTime() throws MediaException;

    private native boolean osxGetMute() throws MediaException;

    private native void osxSetMute(boolean var1) throws MediaException;

    private native float osxGetVolume() throws MediaException;

    private native void osxSetVolume(float var1) throws MediaException;

    private native float osxGetBalance() throws MediaException;

    private native void osxSetBalance(float var1) throws MediaException;

    private native double osxGetDuration() throws MediaException;

    private native void osxSeek(double var1) throws MediaException;

    private native void osxDispose();

    @Override
    public void playerInit() throws MediaException {
    }

    private static final class NullEQBand
    implements EqualizerBand {
        private double center;
        private double bandwidth;
        private double gain;

        NullEQBand(double d, double d2, double d3) {
            this.center = d;
            this.bandwidth = d2;
            this.gain = d3;
        }

        @Override
        public double getCenterFrequency() {
            return this.center;
        }

        @Override
        public void setCenterFrequency(double d) {
            this.center = d;
        }

        @Override
        public double getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public void setBandwidth(double d) {
            this.bandwidth = d;
        }

        @Override
        public double getGain() {
            return this.gain;
        }

        @Override
        public void setGain(double d) {
            this.gain = d;
        }
    }

    private static final class NullAudioSpectrum
    implements AudioSpectrum {
        private boolean enabled = false;
        private int bandCount = 128;
        private double interval = 0.1;
        private int threshold = 60;
        private float[] fakeData;

        private NullAudioSpectrum() {
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        @Override
        public int getBandCount() {
            return this.bandCount;
        }

        @Override
        public void setBandCount(int n) {
            this.bandCount = n;
            this.fakeData = new float[this.bandCount];
        }

        @Override
        public double getInterval() {
            return this.interval;
        }

        @Override
        public void setInterval(double d) {
            this.interval = d;
        }

        @Override
        public int getSensitivityThreshold() {
            return this.threshold;
        }

        @Override
        public void setSensitivityThreshold(int n) {
            this.threshold = n;
        }

        @Override
        public float[] getMagnitudes(float[] fArray) {
            int n = this.fakeData.length;
            if (fArray == null || fArray.length < n) {
                fArray = new float[n];
            }
            System.arraycopy(this.fakeData, 0, fArray, 0, n);
            return fArray;
        }

        @Override
        public float[] getPhases(float[] fArray) {
            int n = this.fakeData.length;
            if (fArray == null || fArray.length < n) {
                fArray = new float[n];
            }
            System.arraycopy(this.fakeData, 0, fArray, 0, n);
            return fArray;
        }
    }

    private static final class NullAudioEQ
    implements AudioEqualizer {
        private boolean enabled = false;
        private Map<Double, EqualizerBand> bands = new HashMap<Double, EqualizerBand>();

        private NullAudioEQ() {
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        @Override
        public EqualizerBand addBand(double d, double d2, double d3) {
            Double d4 = new Double(d);
            if (this.bands.containsKey(d4)) {
                this.removeBand(d);
            }
            NullEQBand nullEQBand = new NullEQBand(d, d2, d3);
            this.bands.put(d4, nullEQBand);
            return nullEQBand;
        }

        @Override
        public boolean removeBand(double d) {
            Double d2 = new Double(d);
            if (this.bands.containsKey(d2)) {
                this.bands.remove(d2);
                return true;
            }
            return false;
        }
    }
}

