/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.PlatformAccessible;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.mac.MacApplication;
import com.sun.glass.ui.mac.MacVariant;
import com.sun.javafx.scene.accessibility.Accessible;
import com.sun.javafx.scene.accessibility.Action;
import com.sun.javafx.scene.accessibility.Attribute;
import com.sun.javafx.scene.accessibility.Role;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javafx.collections.ObservableList;
import javafx.event.EventTarget;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.text.Font;

final class MacAccessible
extends PlatformAccessible {
    static final List<MacAttribute> baseAttributes = Arrays.asList(MacAttribute.NSAccessibilityRoleAttribute, MacAttribute.NSAccessibilityRoleDescriptionAttribute, MacAttribute.NSAccessibilityHelpAttribute, MacAttribute.NSAccessibilityFocusedAttribute, MacAttribute.NSAccessibilityParentAttribute, MacAttribute.NSAccessibilityChildrenAttribute, MacAttribute.NSAccessibilityPositionAttribute, MacAttribute.NSAccessibilitySizeAttribute, MacAttribute.NSAccessibilityWindowAttribute, MacAttribute.NSAccessibilityTopLevelUIElementAttribute, MacAttribute.NSAccessibilityTitleUIElementAttribute);
    static final List<MacAttribute> textAttributes = Arrays.asList(MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityValueAttribute, MacAttribute.NSAccessibilityNumberOfCharactersAttribute, MacAttribute.NSAccessibilitySelectedTextAttribute, MacAttribute.NSAccessibilitySelectedTextRangeAttribute, MacAttribute.NSAccessibilityInsertionPointLineNumberAttribute, MacAttribute.NSAccessibilityVisibleCharacterRangeAttribute);
    static final List<MacAttribute> textParameterizedAttributes = Arrays.asList(MacAttribute.NSAccessibilityLineForIndexParameterizedAttribute, MacAttribute.NSAccessibilityRangeForLineParameterizedAttribute, MacAttribute.NSAccessibilityAttributedStringForRangeParameterizedAttribute, MacAttribute.NSAccessibilityStringForRangeParameterizedAttribute);
    private long peer = this._createGlassAccessible();
    private static final int kAXMenuItemModifierNone = 0;
    private static final int kAXMenuItemModifierShift = 1;
    private static final int kAXMenuItemModifierOption = 2;
    private static final int kAXMenuItemModifierControl = 4;
    private static final int kAXMenuItemModifierNoCommand = 8;
    private Boolean inMenu;
    private Boolean inSlider;
    Boolean ignoreInnerText;

    private static native void _initIDs();

    private static native boolean _initEnum(String var0);

    private native long _createGlassAccessible();

    private native void _destroyGlassAccessible(long var1);

    private static native String getString(long var0);

    private static native boolean isEqualToString(long var0, long var2);

    private static native long NSAccessibilityUnignoredAncestor(long var0);

    private static native long[] NSAccessibilityUnignoredChildren(long[] var0);

    private static native void NSAccessibilityPostNotification(long var0, long var2);

    private static native String NSAccessibilityActionDescription(long var0);

    private static native String NSAccessibilityRoleDescription(long var0, long var2);

    private static native MacVariant idToMacVariant(long var0, int var2);

    private static native MacAccessible GlassAccessibleToMacAccessible(long var0);

    private MacAccessible(Accessible accessible) {
        super(accessible);
    }

    static MacAccessible createAccessible(Accessible accessible) {
        return null;
    }

    @Override
    public void dispose() {
        if (this.peer != 0L) {
            if (this.getView() == null) {
                MacAccessible.NSAccessibilityPostNotification(this.peer, MacNotification.NSAccessibilityUIElementDestroyedNotification.ptr);
            }
            this._destroyGlassAccessible(this.peer);
            this.peer = 0L;
        }
        super.dispose();
    }

    @Override
    public void sendNotification(Attribute attribute) {
        if (this.isDisposed()) {
            return;
        }
        MacNotification macNotification = null;
        switch (attribute) {
            case SELECTED_TAB: 
            case SELECTED_PAGE: {
                View view = this.getRootView((Scene)this.getAttribute(Attribute.SCENE, new Object[0]));
                if (view != null) {
                    long l = view.getNativeView();
                    MacAccessible.NSAccessibilityPostNotification(l, MacNotification.NSAccessibilityFocusedUIElementChangedNotification.ptr);
                }
                return;
            }
            case SELECTED_ROWS: {
                macNotification = MacNotification.NSAccessibilitySelectedRowsChangedNotification;
                break;
            }
            case SELECTED_CELLS: {
                macNotification = MacNotification.NSAccessibilitySelectedCellsChangedNotification;
                break;
            }
            case FOCUS_NODE: {
                Accessible accessible;
                Scene scene;
                Node node = (Node)this.getAttribute(Attribute.FOCUS_NODE, new Object[0]);
                View view = this.getView();
                if (node == null && view == null && (scene = (Scene)this.getAttribute(Attribute.SCENE, new Object[0])) != null && (accessible = null) != null) {
                    node = (Node)accessible.getAttribute(Attribute.FOCUS_NODE, new Object[0]);
                }
                long l = 0L;
                if (node != null) {
                    Node node2 = null;
                    l = node2 != null ? this.getAccessible(node2) : this.getAccessible(node);
                } else {
                    if (view == null) {
                        view = this.getRootView((Scene)this.getAttribute(Attribute.SCENE, new Object[0]));
                    }
                    if (view != null) {
                        l = view.getNativeView();
                    }
                }
                if (l != 0L) {
                    MacAccessible.NSAccessibilityPostNotification(l, MacNotification.NSAccessibilityFocusedUIElementChangedNotification.ptr);
                }
                return;
            }
            case FOCUSED: {
                return;
            }
            case SELECTION_START: 
            case SELECTION_END: {
                macNotification = MacNotification.NSAccessibilitySelectedTextChangedNotification;
                break;
            }
            case EXPANDED: {
                Role role;
                long l;
                boolean bl = Boolean.TRUE.equals(this.getAttribute(Attribute.EXPANDED, new Object[0]));
                macNotification = bl ? MacNotification.NSAccessibilityRowExpandedNotification : MacNotification.NSAccessibilityRowCollapsedNotification;
                Role role2 = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
                if (role2 != Role.TREE_ITEM && role2 != Role.TREE_TABLE_ITEM || (l = this.getAccessible(this.getContainerNode(role = role2 == Role.TREE_ITEM ? Role.TREE_VIEW : Role.TREE_TABLE_VIEW))) == 0L) break;
                MacAccessible.NSAccessibilityPostNotification(l, MacNotification.NSAccessibilityRowCountChangedNotification.ptr);
                break;
            }
            case VISIBLE: {
                if (this.getAttribute(Attribute.ROLE, new Object[0]) != Role.CONTEXT_MENU) break;
                Boolean bl = (Boolean)this.getAttribute(Attribute.VISIBLE, new Object[0]);
                if (Boolean.TRUE.equals(bl)) {
                    macNotification = MacNotification.AXMenuOpened;
                    break;
                }
                macNotification = MacNotification.AXMenuClosed;
                Node node = (Node)this.getAttribute(Attribute.MENU_FOR, new Object[0]);
                long l = this.getAccessible(this.getContainerNode(node, Role.CONTEXT_MENU));
                if (l == 0L) break;
                MacAccessible.NSAccessibilityPostNotification(l, MacNotification.AXMenuClosed.ptr);
                MacAccessible.NSAccessibilityPostNotification(l, MacNotification.AXMenuOpened.ptr);
                break;
            }
            case PARENT: {
                this.ignoreInnerText = null;
                break;
            }
            default: {
                macNotification = MacNotification.NSAccessibilityValueChangedNotification;
            }
        }
        if (macNotification != null) {
            View view = this.getView();
            long l = view != null ? view.getNativeView() : this.peer;
            MacAccessible.NSAccessibilityPostNotification(l, macNotification.ptr);
        }
    }

    @Override
    protected long getNativeAccessible() {
        return this.peer;
    }

    private View getRootView(Scene scene) {
        if (scene == null) {
            return null;
        }
        Accessible accessible = null;
        if (accessible == null) {
            return null;
        }
        MacAccessible macAccessible = (MacAccessible)accessible.impl_getDelegate();
        if (macAccessible == null || macAccessible.isDisposed()) {
            return null;
        }
        View view = macAccessible.getView();
        if (view == null || view.isClosed()) {
            return null;
        }
        return view;
    }

    long[] getUnignoredChildren(ObservableList<Node> observableList) {
        if (observableList == null) {
            return new long[0];
        }
        long[] lArray = observableList.stream().mapToLong(node -> this.getAccessible((Node)node)).filter(l -> l != 0L).toArray();
        return MacAccessible.NSAccessibilityUnignoredChildren(lArray);
    }

    private boolean isInMenu() {
        if (this.inMenu == null) {
            this.inMenu = this.getContainerNode(Role.CONTEXT_MENU) != null || this.getContainerNode(Role.MENU_BAR) != null;
        }
        return this.inMenu;
    }

    private boolean isInSlider() {
        if (this.inSlider == null) {
            this.inSlider = this.getContainerNode(Role.SLIDER) != null;
        }
        return this.inSlider;
    }

    boolean ignoreInnerText() {
        if (this.ignoreInnerText != null) {
            return this.ignoreInnerText;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        this.ignoreInnerText = false;
        if (role == Role.TEXT) {
            Node node = (Node)this.getAttribute(Attribute.PARENT, new Object[0]);
            if (node == null) {
                return this.ignoreInnerText;
            }
            Enum enum_ = null;
            if (enum_ == null) {
                return this.ignoreInnerText;
            }
            switch (1.$SwitchMap$com$sun$javafx$scene$accessibility$Role[enum_.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.ignoreInnerText = true;
                }
            }
        }
        return this.ignoreInnerText;
    }

    private int getMenuItemCmdGlyph(KeyCode keyCode) {
        switch (keyCode) {
            case ENTER: {
                return 4;
            }
            case SHIFT: {
                return 5;
            }
            case CONTROL: {
                return 6;
            }
            case META: {
                return 7;
            }
            case SPACE: {
                return 9;
            }
            case COMMAND: {
                return 17;
            }
            case ESCAPE: {
                return 27;
            }
            case CLEAR: {
                return 28;
            }
            case PAGE_UP: {
                return 98;
            }
            case CAPS: {
                return 99;
            }
            case LEFT: 
            case KP_LEFT: {
                return 100;
            }
            case RIGHT: 
            case KP_RIGHT: {
                return 101;
            }
            case HELP: {
                return 103;
            }
            case UP: 
            case KP_UP: {
                return 104;
            }
            case DOWN: 
            case KP_DOWN: {
                return 106;
            }
            case PAGE_DOWN: {
                return 107;
            }
            case CONTEXT_MENU: {
                return 109;
            }
            case POWER: {
                return 110;
            }
            case F1: {
                return 111;
            }
            case F2: {
                return 112;
            }
            case F3: {
                return 113;
            }
            case F4: {
                return 114;
            }
            case F5: {
                return 115;
            }
            case F6: {
                return 116;
            }
            case F7: {
                return 117;
            }
            case F8: {
                return 118;
            }
            case F9: {
                return 119;
            }
            case F10: {
                return 120;
            }
            case F11: {
                return 121;
            }
            case F12: {
                return 122;
            }
            case F13: {
                return 135;
            }
            case F14: {
                return 136;
            }
            case F15: {
                return 137;
            }
        }
        return 0;
    }

    private boolean isCmdCharBased(KeyCode keyCode) {
        return keyCode.isLetterKey() || keyCode.isDigitKey() && !keyCode.isKeypadKey();
    }

    private MacRole getRole(Role role) {
        if (role == Role.COMBOBOX) {
            if (Boolean.TRUE.equals(this.getAttribute(Attribute.EDITABLE, new Object[0]))) {
                return MacRole.NSAccessibilityComboBoxRole;
            }
            return MacRole.NSAccessibilityPopUpButtonRole;
        }
        return MacRole.getRole(role);
    }

    private Bounds flipBounds(Bounds bounds) {
        View view = this.getRootView((Scene)this.getAttribute(Attribute.SCENE, new Object[0]));
        if (view == null) {
            return null;
        }
        Screen screen = view.getWindow().getScreen();
        float f = screen.getHeight();
        return new BoundingBox(bounds.getMinX(), (double)f - bounds.getMinY() - bounds.getHeight(), bounds.getWidth(), bounds.getHeight());
    }

    long[] accessibilityAttributeNames() {
        if (this.getView() != null) {
            return null;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role != null) {
            MacSubrole macSubrole;
            ArrayList<MacAttribute> arrayList = new ArrayList<MacAttribute>(baseAttributes);
            MacRole macRole = this.getRole(role);
            if (macRole != null && macRole.macAttributes != null) {
                arrayList.addAll(macRole.macAttributes);
            }
            if ((macSubrole = MacSubrole.getRole(role)) != null && macSubrole.macAttributes != null) {
                arrayList.addAll(macSubrole.macAttributes);
            }
            switch (role) {
                case LIST_VIEW: 
                case TREE_TABLE_VIEW: {
                    arrayList.remove((Object)MacAttribute.NSAccessibilitySelectedCellsAttribute);
                    break;
                }
                case CONTEXT_MENU: 
                case MENU_ITEM: 
                case MENU_BAR: {
                    arrayList.remove((Object)MacAttribute.NSAccessibilityWindowAttribute);
                    arrayList.remove((Object)MacAttribute.NSAccessibilityTopLevelUIElementAttribute);
                    break;
                }
                case COMBOBOX: 
                case TEXT: 
                case TEXT_FIELD: 
                case TEXT_AREA: 
                case PASSWORD_FIELD: {
                    arrayList.addAll(textAttributes);
                    break;
                }
            }
            return arrayList.stream().mapToLong(macAttribute -> macAttribute.ptr).toArray();
        }
        return null;
    }

    int accessibilityArrayAttributeCount(long l) {
        MacAttribute macAttribute = MacAttribute.getAttribute(l);
        if (macAttribute == null) {
            return -1;
        }
        switch (macAttribute) {
            case NSAccessibilityRowsAttribute: {
                Integer n = (Integer)this.getAttribute(Attribute.ROW_COUNT, new Object[0]);
                return n != null ? n : 0;
            }
            case NSAccessibilityColumnsAttribute: {
                Integer n = (Integer)this.getAttribute(Attribute.COLUMN_COUNT, new Object[0]);
                return n != null ? n : 1;
            }
            case NSAccessibilityChildrenAttribute: {
                if (this.getAttribute(Attribute.ROLE, new Object[0]) == Role.MENU_ITEM) {
                    ObservableList observableList = (ObservableList)this.getAttribute(Attribute.CHILDREN, new Object[0]);
                    long[] lArray = this.getUnignoredChildren(observableList);
                    int n = lArray.length;
                    if (this.getAttribute(Attribute.MENU_ITEM_TYPE, new Object[0]) == Role.CONTEXT_MENU) {
                        ++n;
                    }
                    return n;
                }
                return -1;
            }
            case NSAccessibilityDisclosedRowsAttribute: {
                Integer n = (Integer)this.getAttribute(Attribute.TREE_ITEM_COUNT, new Object[0]);
                return n != null ? n : 0;
            }
        }
        return -1;
    }

    long[] accessibilityArrayAttributeValues(long l, int n, int n2) {
        MacAttribute macAttribute = MacAttribute.getAttribute(l);
        if (macAttribute == null) {
            return null;
        }
        Attribute attribute = null;
        switch (macAttribute) {
            case NSAccessibilityColumnsAttribute: {
                attribute = Attribute.COLUMN_AT_INDEX;
                break;
            }
            case NSAccessibilityRowsAttribute: {
                attribute = Attribute.ROW_AT_INDEX;
                break;
            }
            case NSAccessibilityDisclosedRowsAttribute: {
                attribute = Attribute.TREE_ITEM_AT_INDEX;
                break;
            }
            case NSAccessibilityChildrenAttribute: {
                Object object;
                if (this.getAttribute(Attribute.ROLE, new Object[0]) != Role.MENU_ITEM) break;
                long[] lArray = new long[n2];
                int n3 = 0;
                if (n == 0) {
                    object = (Node)this.getAttribute(Attribute.MENU, new Object[0]);
                    lArray[n3++] = this.getAccessible((Node)object);
                }
                if (n3 < n2) {
                    object = (ObservableList)this.getAttribute(Attribute.CHILDREN, new Object[0]);
                    long[] lArray2 = this.getUnignoredChildren((ObservableList<Node>)object);
                    --n;
                    while (n3 < n2 && n < lArray2.length) {
                        lArray[n3++] = lArray2[n++];
                    }
                }
                if (n3 < n2) {
                    lArray = Arrays.copyOf(lArray, n3);
                }
                return lArray;
            }
        }
        if (attribute != null) {
            Node node;
            int n4;
            long[] lArray = new long[n2];
            for (n4 = 0; n4 < n2 && (node = (Node)this.getAttribute(attribute, n + n4)) != null; ++n4) {
                lArray[n4] = this.getAccessible(node);
            }
            if (n4 == n2) {
                return MacAccessible.NSAccessibilityUnignoredChildren(lArray);
            }
        }
        return null;
    }

    boolean accessibilityIsAttributeSettable(long l) {
        MacAttribute macAttribute = MacAttribute.getAttribute(l);
        if (macAttribute == null) {
            return false;
        }
        switch (macAttribute) {
            case NSAccessibilityDisclosingAttribute: {
                Integer n = (Integer)this.getAttribute(Attribute.TREE_ITEM_COUNT, new Object[0]);
                return n != null && n > 0;
            }
            case NSAccessibilityFocusedAttribute: 
            case NSAccessibilitySelectedAttribute: 
            case NSAccessibilitySelectedRowsAttribute: 
            case NSAccessibilitySelectedCellsAttribute: 
            case NSAccessibilitySelectedTextRangeAttribute: {
                return true;
            }
        }
        return false;
    }

    MacVariant accessibilityAttributeValue(long l) {
        MacAttribute macAttribute = MacAttribute.getAttribute(l);
        if (macAttribute == null) {
            return null;
        }
        Function<Object, MacVariant> function = macAttribute.map;
        Attribute attribute = macAttribute.jfxAttr;
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role == null) {
            return null;
        }
        if (attribute == null) {
            block0 : switch (macAttribute) {
                case NSAccessibilityValueAttribute: {
                    switch (role) {
                        case TAB_PANE: {
                            attribute = Attribute.SELECTED_TAB;
                            function = MacVariant::createNSObject;
                            break block0;
                        }
                        case PAGINATION: {
                            attribute = Attribute.SELECTED_PAGE;
                            function = MacVariant::createNSObject;
                            break block0;
                        }
                        case RADIO_BUTTON: 
                        case TAB_ITEM: 
                        case PAGE: {
                            attribute = Attribute.SELECTED;
                            function = MacVariant::createNSNumberForBoolean;
                            break block0;
                        }
                        case SCROLL_BAR: 
                        case SLIDER: 
                        case PROGRESS_INDICATOR: 
                        case THUMB: {
                            attribute = Attribute.VALUE;
                            function = MacVariant::createNSNumberForDouble;
                            break block0;
                        }
                        case COMBOBOX: 
                        case TEXT: 
                        case TEXT_FIELD: 
                        case TEXT_AREA: {
                            attribute = Attribute.TITLE;
                            function = MacVariant::createNSString;
                            break block0;
                        }
                        case TOGGLE_BUTTON: 
                        case CHECKBOX: {
                            attribute = Attribute.SELECTED;
                            function = MacVariant::createNSNumberForInt;
                            break block0;
                        }
                        case DATE_PICKER: {
                            attribute = Attribute.DATE;
                            function = MacVariant::createNSDate;
                            break block0;
                        }
                        case TITLED_PANE: {
                            attribute = Attribute.EXPANDED;
                            function = MacVariant::createNSNumberForInt;
                            break block0;
                        }
                    }
                    return null;
                }
                case NSAccessibilityTabsAttribute: {
                    switch (role) {
                        case TAB_PANE: {
                            attribute = Attribute.TABS;
                            break block0;
                        }
                        case PAGINATION: {
                            attribute = Attribute.PAGES;
                            break block0;
                        }
                    }
                    break;
                }
                case NSAccessibilitySelectedChildrenAttribute: {
                    EventTarget eventTarget;
                    if (role != Role.CONTEXT_MENU || (eventTarget = (Scene)this.getAttribute(Attribute.SCENE, new Object[0])) != null) {
                        // empty if block
                    }
                    if (role == Role.MENU_BAR) {
                        eventTarget = (Node)this.getAttribute(Attribute.FOCUS_NODE, new Object[0]);
                    }
                    return null;
                }
                case AXDateTimeComponents: {
                    return macAttribute.map.apply(224);
                }
            }
        }
        if (attribute == null) {
            return null;
        }
        Object object = this.getAttribute(attribute, new Object[0]);
        if (object == null) {
            switch (macAttribute) {
                case NSAccessibilityParentAttribute: {
                    break;
                }
                case NSAccessibilityColumnCountAttribute: {
                    object = 1;
                    break;
                }
                case AXMenuItemCmdModifiers: {
                    return macAttribute.map.apply(8);
                }
                default: {
                    return null;
                }
            }
        }
        block25 : switch (macAttribute) {
            case NSAccessibilityWindowAttribute: 
            case NSAccessibilityTopLevelUIElementAttribute: {
                if (role == Role.CONTEXT_MENU || role == Role.MENU_ITEM || role == Role.MENU_BAR) {
                    return null;
                }
                Scene scene = (Scene)object;
                View view = this.getRootView(scene);
                if (view == null) {
                    return null;
                }
                object = view.getWindow().getNativeWindow();
                break;
            }
            case NSAccessibilitySubroleAttribute: {
                MacSubrole macSubrole = MacSubrole.getRole((Role)((Object)object));
                object = macSubrole != null ? macSubrole.ptr : 0L;
                break;
            }
            case NSAccessibilityRoleAttribute: {
                MacRole macRole = this.getRole(role);
                object = macRole != null ? macRole.ptr : 0L;
                break;
            }
            case NSAccessibilityRoleDescriptionAttribute: {
                MacRole macRole = this.getRole(role);
                switch (role) {
                    case TITLED_PANE: {
                        object = "title pane";
                        break block25;
                    }
                    case SPLIT_MENU_BUTTON: {
                        object = "split button";
                        break block25;
                    }
                    case PAGE: {
                        object = "page";
                        break block25;
                    }
                    case TAB_ITEM: {
                        object = "tab";
                        break block25;
                    }
                }
                MacSubrole macSubrole = MacSubrole.getRole(role);
                object = MacAccessible.NSAccessibilityRoleDescription(macRole.ptr, macSubrole != null ? macSubrole.ptr : 0L);
                break;
            }
            case NSAccessibilityChildrenAttribute: 
            case NSAccessibilitySelectedRowsAttribute: 
            case NSAccessibilitySelectedCellsAttribute: 
            case NSAccessibilityTabsAttribute: 
            case NSAccessibilityVisibleChildrenAttribute: {
                ObservableList observableList = (ObservableList)object;
                object = this.getUnignoredChildren(observableList);
                break;
            }
            case NSAccessibilityParentAttribute: {
                if (this.getView() != null) {
                    object = this.getView().getWindow().getNativeWindow();
                } else if (object != null) {
                    Node node;
                    if (role != Role.CONTEXT_MENU || (node = (Node)this.getAttribute(Attribute.MENU_FOR, new Object[0])) != null) {
                        // empty if block
                    }
                    object = this.getAccessible((Node)object);
                } else {
                    View view = this.getRootView((Scene)this.getAttribute(Attribute.SCENE, new Object[0]));
                    if (view == null) {
                        return null;
                    }
                    object = view.getNativeView();
                }
                object = MacAccessible.NSAccessibilityUnignoredAncestor((Long)object);
                break;
            }
            case NSAccessibilityValueAttribute: {
                switch (role) {
                    case TAB_PANE: 
                    case PAGINATION: {
                        object = this.getAccessible((Node)object);
                        break block25;
                    }
                    case TOGGLE_BUTTON: 
                    case CHECKBOX: {
                        if (Boolean.TRUE.equals(this.getAttribute(Attribute.INDETERMINATE, new Object[0]))) {
                            object = 2;
                            break block25;
                        }
                        object = Boolean.TRUE.equals(object) ? 1 : 0;
                        break block25;
                    }
                    case TITLED_PANE: {
                        object = Boolean.TRUE.equals(object) ? 1 : 0;
                        break block25;
                    }
                }
                break;
            }
            case NSAccessibilityPositionAttribute: {
                object = this.flipBounds((Bounds)object);
                break;
            }
            case NSAccessibilityMaxValueAttribute: {
                if (!Boolean.TRUE.equals(this.getAttribute(Attribute.INDETERMINATE, new Object[0]))) break;
                return null;
            }
            case NSAccessibilityTitleAttribute: {
                switch (role) {
                    case COMBOBOX: 
                    case TEXT: 
                    case TEXT_FIELD: 
                    case TEXT_AREA: 
                    case TREE_TABLE_ITEM: {
                        return null;
                    }
                    case TREE_TABLE_CELL: {
                        Node node = (Node)this.getAttribute(Attribute.PARENT, new Object[0]);
                        if (node != null) break block25;
                        return null;
                    }
                }
                break;
            }
            case AXMenuItemCmdChar: {
                KeyCode keyCode;
                KeyCombination keyCombination = (KeyCombination)object;
                object = null;
                if (keyCombination instanceof KeyCharacterCombination) {
                    object = ((KeyCharacterCombination)keyCombination).getCharacter();
                }
                if (keyCombination instanceof KeyCodeCombination && this.isCmdCharBased(keyCode = ((KeyCodeCombination)keyCombination).getCode())) {
                    object = keyCode.getName();
                }
                if (object != null) break;
                return null;
            }
            case AXMenuItemCmdVirtualKey: {
                KeyCode keyCode;
                KeyCombination keyCombination = (KeyCombination)object;
                object = null;
                if (keyCombination instanceof KeyCodeCombination && !this.isCmdCharBased(keyCode = ((KeyCodeCombination)keyCombination).getCode())) {
                    int n = keyCode.impl_getCode();
                    object = MacApplication._getMacKey(n);
                }
                if (object != null) break;
                return null;
            }
            case AXMenuItemCmdGlyph: {
                KeyCode keyCode;
                KeyCombination keyCombination = (KeyCombination)object;
                object = null;
                if (keyCombination instanceof KeyCodeCombination && !this.isCmdCharBased(keyCode = ((KeyCodeCombination)keyCombination).getCode())) {
                    object = this.getMenuItemCmdGlyph(keyCode);
                }
                if (object != null) break;
                return null;
            }
            case AXMenuItemCmdModifiers: {
                KeyCombination keyCombination = (KeyCombination)object;
                int n = 8;
                if (keyCombination != null) {
                    if (keyCombination.getShortcut() == KeyCombination.ModifierValue.DOWN) {
                        n = 0;
                    }
                    if (keyCombination.getAlt() == KeyCombination.ModifierValue.DOWN) {
                        n |= 2;
                    }
                    if (keyCombination.getControl() == KeyCombination.ModifierValue.DOWN) {
                        n |= 4;
                    }
                    if (keyCombination.getShift() == KeyCombination.ModifierValue.DOWN) {
                        n |= 1;
                    }
                }
                object = n;
                break;
            }
            case AXMenuItemMarkChar: {
                if (Boolean.TRUE.equals(object)) {
                    object = "\u2713";
                    break;
                }
                return null;
            }
            case NSAccessibilityNumberOfCharactersAttribute: {
                String string = (String)object;
                object = string.length();
                break;
            }
            case NSAccessibilitySelectedTextAttribute: {
                int n = (Integer)object;
                int n2 = -1;
                if (n != -1) {
                    n2 = (Integer)this.getAttribute(Attribute.SELECTION_END, new Object[0]);
                }
                if (n < 0 || n2 < 0 || n > n2) {
                    return null;
                }
                String string = (String)this.getAttribute(Attribute.TITLE, new Object[0]);
                if (string == null) {
                    return null;
                }
                if (n2 > string.length()) {
                    return null;
                }
                object = string.substring(n, n2);
                break;
            }
            case NSAccessibilitySelectedTextRangeAttribute: {
                int n = (Integer)object;
                int n3 = -1;
                if (n != -1) {
                    n3 = (Integer)this.getAttribute(Attribute.SELECTION_END, new Object[0]);
                }
                if (n < 0 || n3 < 0 || n > n3) {
                    return null;
                }
                String string = (String)this.getAttribute(Attribute.TITLE, new Object[0]);
                if (string == null) {
                    return null;
                }
                if (n3 > string.length()) {
                    return null;
                }
                object = new int[]{n, n3 - n};
                break;
            }
            case NSAccessibilityInsertionPointLineNumberAttribute: {
                if (role == Role.TEXT_AREA) {
                    Integer n = (Integer)this.getAttribute(Attribute.LINE_FOR_OFFSET, object);
                    object = n != null ? n : 0;
                    break;
                }
                object = 0;
                break;
            }
            case NSAccessibilityVisibleCharacterRangeAttribute: {
                String string = (String)object;
                object = new int[]{0, string.length()};
                break;
            }
            case NSAccessibilityContentsAttribute: {
                if (object == null) break;
                object = new long[]{this.getAccessible((Node)object)};
                break;
            }
            case NSAccessibilityRowIndexRangeAttribute: 
            case NSAccessibilityColumnIndexRangeAttribute: {
                Integer n = (Integer)object;
                object = new int[]{n, 1};
                break;
            }
            case NSAccessibilityDisclosedByRowAttribute: 
            case NSAccessibilityOverflowButtonAttribute: 
            case NSAccessibilityTitleUIElementAttribute: 
            case NSAccessibilityHeaderAttribute: 
            case NSAccessibilityHorizontalScrollBarAttribute: 
            case NSAccessibilityVerticalScrollBarAttribute: {
                object = this.getAccessible((Node)object);
                break;
            }
            case NSAccessibilityOrientationAttribute: {
                Orientation orientation = (Orientation)((Object)object);
                switch (orientation) {
                    case HORIZONTAL: {
                        object = MacOrientation.NSAccessibilityHorizontalOrientationValue.ptr;
                        break block25;
                    }
                    case VERTICAL: {
                        object = MacOrientation.NSAccessibilityVerticalOrientationValue.ptr;
                        break block25;
                    }
                }
                return null;
            }
            case NSAccessibilityDisclosingAttribute: {
                if (object != Boolean.TRUE || !Boolean.TRUE.equals(this.getAttribute(Attribute.LEAF, new Object[0]))) break;
                object = Boolean.FALSE;
                break;
            }
        }
        return function.apply(object);
    }

    void accessibilitySetValue(long l, long l2) {
        MacAttribute macAttribute = MacAttribute.getAttribute(l2);
        if (macAttribute != null) {
            switch (macAttribute) {
                case NSAccessibilityExpandedAttribute: {
                    if (this.getAttribute(Attribute.ROLE, new Object[0]) != Role.COMBOBOX) break;
                    this.executeAction(Action.EXPAND, new Object[0]);
                    break;
                }
                case NSAccessibilitySelectedRowsAttribute: 
                case NSAccessibilitySelectedCellsAttribute: {
                    long[] lArray;
                    MacVariant macVariant = MacAccessible.idToMacVariant(l, 1);
                    if (macVariant == null || macVariant.longArray == null || macVariant.longArray.length <= 0) break;
                    for (long l3 : lArray = macVariant.longArray) {
                        MacAccessible macAccessible = MacAccessible.GlassAccessibleToMacAccessible(l3);
                        if (macAccessible == null) continue;
                        macAccessible.executeAction(Action.SELECT, new Object[0]);
                    }
                    break;
                }
                case NSAccessibilitySelectedTextRangeAttribute: {
                    MacVariant macVariant = MacAccessible.idToMacVariant(l, 18);
                    if (macVariant == null) break;
                    int n = macVariant.int1;
                    int n2 = macVariant.int1 + macVariant.int2;
                    this.executeAction(Action.SELECT, n, n2);
                    break;
                }
            }
        }
    }

    long accessibilityIndexOfChild(long l) {
        return -1L;
    }

    long[] accessibilityParameterizedAttributeNames() {
        if (this.getView() != null) {
            return null;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role != null) {
            ArrayList<MacAttribute> arrayList = new ArrayList<MacAttribute>();
            MacRole macRole = this.getRole(role);
            if (macRole != null && macRole.macParameterizedAttributes != null) {
                arrayList.addAll(macRole.macParameterizedAttributes);
            }
            switch (role) {
                case LIST_VIEW: 
                case TREE_TABLE_VIEW: {
                    arrayList.remove((Object)MacAttribute.NSAccessibilityCellForColumnAndRowParameterizedAttribute);
                    break;
                }
                case COMBOBOX: 
                case TEXT: 
                case TEXT_FIELD: 
                case TEXT_AREA: 
                case PASSWORD_FIELD: {
                    arrayList.addAll(textParameterizedAttributes);
                    break;
                }
            }
            return arrayList.stream().mapToLong(macAttribute -> macAttribute.ptr).toArray();
        }
        return null;
    }

    MacVariant accessibilityAttributeValueForParameter(long l, long l2) {
        Object object;
        Object object2;
        Object object3;
        MacAttribute macAttribute = MacAttribute.getAttribute(l);
        if (macAttribute == null || macAttribute.inputType == 0 || macAttribute.jfxAttr == null) {
            return null;
        }
        MacVariant macVariant = MacAccessible.idToMacVariant(l2, macAttribute.inputType);
        if (macVariant == null) {
            return null;
        }
        Object object4 = macVariant.getValue();
        switch (macAttribute) {
            case NSAccessibilityCellForColumnAndRowParameterizedAttribute: {
                object3 = (int[])object4;
                object2 = this.getAttribute(macAttribute.jfxAttr, object3[1], object3[0]);
                break;
            }
            case NSAccessibilityLineForIndexParameterizedAttribute: {
                if (this.getAttribute(Attribute.ROLE, new Object[0]) == Role.TEXT_AREA) {
                    object2 = this.getAttribute(macAttribute.jfxAttr, object4);
                    break;
                }
                object2 = 0;
                break;
            }
            case NSAccessibilityRangeForLineParameterizedAttribute: {
                if (this.getAttribute(Attribute.ROLE, new Object[0]) == Role.TEXT_AREA) {
                    object3 = (Integer)this.getAttribute(Attribute.LINE_START, object4);
                    object = (Integer)this.getAttribute(Attribute.LINE_END, object4);
                    if (object3 != null && object != null) {
                        object2 = new int[]{(Integer)object3, (Integer)object - (Integer)object3};
                        break;
                    }
                    object2 = null;
                    break;
                }
                object3 = (String)this.getAttribute(Attribute.TITLE, new Object[0]);
                object2 = new int[]{0, object3 != null ? ((String)object3).length() : 0};
                break;
            }
            case NSAccessibilityBoundsForRangeParameterizedAttribute: {
                object3 = (int[])object4;
                object = (Bounds[])this.getAttribute(macAttribute.jfxAttr, object3[0], object3[0] + object3[1] - 1);
                double d = Double.POSITIVE_INFINITY;
                double d2 = Double.POSITIVE_INFINITY;
                double d3 = Double.NEGATIVE_INFINITY;
                double d4 = Double.NEGATIVE_INFINITY;
                if (object != null) {
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        Object object5 = object[i];
                        if (object5 == null) continue;
                        if (((Bounds)object5).getMinX() < d) {
                            d = ((Bounds)object5).getMinX();
                        }
                        if (((Bounds)object5).getMinY() < d2) {
                            d2 = ((Bounds)object5).getMinY();
                        }
                        if (((Bounds)object5).getMaxX() > d3) {
                            d3 = ((Bounds)object5).getMaxX();
                        }
                        if (!(((Bounds)object5).getMaxY() > d4)) continue;
                        d4 = ((Bounds)object5).getMaxY();
                    }
                }
                object2 = this.flipBounds(new BoundingBox(d, d2, d3 - d, d4 - d2));
                break;
            }
            case NSAccessibilityRangeForPositionParameterizedAttribute: {
                object3 = (float[])object4;
                object = (Bounds[])this.getAttribute(macAttribute.jfxAttr, new Point2D(object3[0], object3[1]));
                if (object != null) {
                    object2 = new int[]{(Integer)object, 1};
                    break;
                }
                object2 = null;
                break;
            }
            default: {
                object2 = this.getAttribute(macAttribute.jfxAttr, object4);
            }
        }
        if (object2 == null) {
            return null;
        }
        switch (macAttribute) {
            case NSAccessibilityAttributedStringForRangeParameterizedAttribute: {
                MacVariant macVariant2;
                object3 = (String)object2;
                object3 = ((String)object3).substring(macVariant.int1, macVariant.int1 + macVariant.int2);
                object = new ArrayList();
                Font font = (Font)this.getAttribute(Attribute.FONT, new Object[0]);
                if (font != null) {
                    macVariant2 = new MacVariant();
                    macVariant2.type = 8;
                    macVariant2.longArray = new long[]{MacText.NSAccessibilityFontNameKey.ptr, MacText.NSAccessibilityFontFamilyKey.ptr, MacText.NSAccessibilityVisibleNameKey.ptr, MacText.NSAccessibilityFontSizeKey.ptr};
                    macVariant2.variantArray = new MacVariant[]{MacVariant.createNSString(font.getName()), MacVariant.createNSString(font.getFamily()), MacVariant.createNSString(font.getName()), MacVariant.createNSNumberForDouble(font.getSize())};
                    macVariant2.key = MacText.NSAccessibilityFontTextAttribute.ptr;
                    macVariant2.location = 0;
                    macVariant2.length = ((String)object3).length();
                    object.add(macVariant2);
                }
                macVariant2 = macAttribute.map.apply(object3);
                macVariant2.variantArray = object.toArray(new MacVariant[0]);
                return macVariant2;
            }
            case NSAccessibilityStringForRangeParameterizedAttribute: {
                object3 = (String)object2;
                object2 = ((String)object3).substring(macVariant.int1, macVariant.int1 + macVariant.int2);
                break;
            }
            case NSAccessibilityCellForColumnAndRowParameterizedAttribute: {
                object2 = this.getAccessible((Node)object2);
                break;
            }
        }
        return macAttribute.map.apply(object2);
    }

    long[] accessibilityActionNames() {
        if (this.getView() != null) {
            return null;
        }
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        ArrayList<MacAction> arrayList = new ArrayList<MacAction>();
        if (role != null) {
            MacRole macRole = this.getRole(role);
            if (macRole != null && macRole.macActions != null) {
                arrayList.addAll(macRole.macActions);
            }
            if (role != Role.NODE && role != Role.PARENT) {
                arrayList.add(MacAction.NSAccessibilityShowMenuAction);
            }
        }
        return arrayList.stream().mapToLong(macAction -> macAction.ptr).toArray();
    }

    String accessibilityActionDescription(long l) {
        return MacAccessible.NSAccessibilityActionDescription(l);
    }

    void accessibilityPerformAction(long l) {
        Role role;
        MacAction macAction = MacAction.getAction(l);
        boolean bl = false;
        if (macAction == MacAction.NSAccessibilityPressAction && ((role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]))) == Role.TITLED_PANE || role == Role.COMBOBOX)) {
            bl = true;
        }
        if (macAction == MacAction.NSAccessibilityShowMenuAction && this.getAttribute(Attribute.ROLE, new Object[0]) == Role.SPLIT_MENU_BUTTON) {
            bl = true;
        }
        if (bl) {
            if (Boolean.TRUE.equals(this.getAttribute(Attribute.EXPANDED, new Object[0]))) {
                this.executeAction(Action.COLLAPSE, new Object[0]);
            } else {
                this.executeAction(Action.EXPAND, new Object[0]);
            }
            return;
        }
        if (macAction != null && macAction.jfxAction != null) {
            this.executeAction(macAction.jfxAction, new Object[0]);
        }
    }

    long accessibilityFocusedUIElement() {
        Node node = (Node)this.getAttribute(Attribute.FOCUS_NODE, new Object[0]);
        if (node == null) {
            return 0L;
        }
        Node node2 = null;
        if (node2 != null) {
            return this.getAccessible(node2);
        }
        return this.getAccessible(node);
    }

    boolean accessibilityIsIgnored() {
        if (this.isIgnored()) {
            return true;
        }
        if (this.isInSlider()) {
            return true;
        }
        if (this.isInMenu()) {
            Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
            return role != Role.CONTEXT_MENU && role != Role.MENU_ITEM && role != Role.MENU_BAR;
        }
        return this.ignoreInnerText();
    }

    long accessibilityHitTest(float f, float f2) {
        View view = this.getView();
        if (view == null) {
            return 0L;
        }
        Screen screen = view.getWindow().getScreen();
        f2 = (float)screen.getHeight() - f2;
        Node node = (Node)this.getAttribute(Attribute.NODE_AT_POINT, new Point2D(f, f2));
        return MacAccessible.NSAccessibilityUnignoredAncestor(this.getAccessible(node));
    }

    static enum MacText {
        NSAccessibilityBackgroundColorTextAttribute,
        NSAccessibilityForegroundColorTextAttribute,
        NSAccessibilityUnderlineTextAttribute,
        NSAccessibilityStrikethroughTextAttribute,
        NSAccessibilityMarkedMisspelledTextAttribute,
        NSAccessibilityFontTextAttribute,
        NSAccessibilityFontNameKey,
        NSAccessibilityFontFamilyKey,
        NSAccessibilityVisibleNameKey,
        NSAccessibilityFontSizeKey;

        long ptr;
    }

    static enum MacOrientation {
        NSAccessibilityHorizontalOrientationValue,
        NSAccessibilityVerticalOrientationValue,
        NSAccessibilityUnknownOrientationValue;

        long ptr;
    }

    static enum MacNotification {
        NSAccessibilityCreatedNotification,
        NSAccessibilityFocusedUIElementChangedNotification,
        NSAccessibilityValueChangedNotification,
        NSAccessibilitySelectedChildrenChangedNotification,
        NSAccessibilitySelectedRowsChangedNotification,
        NSAccessibilityTitleChangedNotification,
        NSAccessibilityRowCountChangedNotification,
        NSAccessibilitySelectedCellsChangedNotification,
        NSAccessibilityUIElementDestroyedNotification,
        NSAccessibilitySelectedTextChangedNotification,
        NSAccessibilityRowExpandedNotification,
        NSAccessibilityRowCollapsedNotification,
        AXMenuOpened,
        AXMenuClosed;

        long ptr;
    }

    static enum MacAction {
        NSAccessibilityCancelAction,
        NSAccessibilityConfirmAction,
        NSAccessibilityDecrementAction(Action.DECREMENT),
        NSAccessibilityDeleteAction,
        NSAccessibilityIncrementAction(Action.INCREMENT),
        NSAccessibilityPickAction,
        NSAccessibilityPressAction(Action.FIRE),
        NSAccessibilityRaiseAction,
        NSAccessibilityShowMenuAction(Action.SHOW_MENU);

        long ptr;
        Action jfxAction;

        private MacAction() {
        }

        private MacAction(Action action) {
            this.jfxAction = action;
        }

        static MacAction getAction(long l) {
            for (MacAction macAction : MacAction.values()) {
                if (macAction.ptr != l && !MacAccessible.isEqualToString(macAction.ptr, l)) continue;
                return macAction;
            }
            return null;
        }
    }

    static enum MacSubrole {
        NSAccessibilityTableRowSubrole(Role.LIST_ITEM, Role.TABLE_ROW),
        NSAccessibilitySortButtonSubrole(Role.HEADER),
        NSAccessibilitySecureTextFieldSubrole(Role.PASSWORD_FIELD),
        NSAccessibilityOutlineRowSubrole(new Role[]{Role.TREE_ITEM, Role.TREE_TABLE_ITEM}, new MacAttribute[]{MacAttribute.NSAccessibilityDisclosedByRowAttribute, MacAttribute.NSAccessibilityDisclosedRowsAttribute, MacAttribute.NSAccessibilityDisclosingAttribute, MacAttribute.NSAccessibilityDisclosureLevelAttribute}),
        NSAccessibilityDecrementArrowSubrole(new Role[]{Role.DECREMENT_BUTTON}, new MacAttribute[]{MacAttribute.NSAccessibilitySubroleAttribute}),
        NSAccessibilityIncrementArrowSubrole(new Role[]{Role.INCREMENT_BUTTON}, new MacAttribute[]{MacAttribute.NSAccessibilitySubroleAttribute});

        long ptr;
        Role[] jfxRoles;
        List<MacAttribute> macAttributes;

        private MacSubrole(Role ... roleArray) {
            this(roleArray, (MacAttribute[])null);
        }

        private MacSubrole(Role[] roleArray, MacAttribute[] macAttributeArray) {
            this.jfxRoles = roleArray;
            this.macAttributes = macAttributeArray != null ? Arrays.asList(macAttributeArray) : null;
        }

        static MacSubrole getRole(Role role) {
            if (role == null) {
                return null;
            }
            for (MacSubrole macSubrole : MacSubrole.values()) {
                for (Role role2 : macSubrole.jfxRoles) {
                    if (role2 != role) continue;
                    return macSubrole;
                }
            }
            return null;
        }
    }

    static enum MacRole {
        NSAccessibilityUnknownRole(Role.NODE, null, null),
        NSAccessibilityGroupRole(Role.PARENT, null, null),
        NSAccessibilityButtonRole(new Role[]{Role.BUTTON, Role.INCREMENT_BUTTON, Role.DECREMENT_BUTTON, Role.HEADER, Role.SPLIT_MENU_BUTTON}, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityTitleAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}, null),
        AXJFXTOOLTIP(Role.TOOLTIP, null, null),
        NSAccessibilityImageRole(Role.IMAGE, null, null),
        NSAccessibilityRadioButtonRole(new Role[]{Role.RADIO_BUTTON, Role.TAB_ITEM, Role.PAGE}, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityTitleAttribute, MacAttribute.NSAccessibilityValueAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}, null),
        NSAccessibilityCheckBoxRole(new Role[]{Role.CHECKBOX, Role.TOGGLE_BUTTON}, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityTitleAttribute, MacAttribute.NSAccessibilityValueAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}, null),
        NSAccessibilityComboBoxRole(Role.COMBOBOX, new MacAttribute[]{MacAttribute.NSAccessibilityExpandedAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}),
        NSAccessibilityPopUpButtonRole(Role.COMBOBOX, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityValueAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}),
        NSAccessibilityTabGroupRole(new Role[]{Role.TAB_PANE, Role.PAGINATION}, new MacAttribute[]{MacAttribute.NSAccessibilityTabsAttribute, MacAttribute.NSAccessibilityValueAttribute}, null, null),
        NSAccessibilityProgressIndicatorRole(Role.PROGRESS_INDICATOR, new MacAttribute[]{MacAttribute.NSAccessibilityOrientationAttribute, MacAttribute.NSAccessibilityValueAttribute, MacAttribute.NSAccessibilityMaxValueAttribute, MacAttribute.NSAccessibilityMinValueAttribute}, null),
        NSAccessibilityMenuBarRole(Role.MENU_BAR, new MacAttribute[]{MacAttribute.NSAccessibilitySelectedChildrenAttribute, MacAttribute.NSAccessibilityEnabledAttribute}, new MacAction[]{MacAction.NSAccessibilityCancelAction}),
        NSAccessibilityMenuRole(Role.CONTEXT_MENU, new MacAttribute[]{MacAttribute.NSAccessibilitySelectedChildrenAttribute, MacAttribute.NSAccessibilityEnabledAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction, MacAction.NSAccessibilityCancelAction}),
        NSAccessibilityMenuItemRole(Role.MENU_ITEM, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityTitleAttribute, MacAttribute.NSAccessibilitySelectedAttribute, MacAttribute.AXMenuItemCmdChar, MacAttribute.AXMenuItemCmdVirtualKey, MacAttribute.AXMenuItemCmdGlyph, MacAttribute.AXMenuItemCmdModifiers, MacAttribute.AXMenuItemMarkChar}, new MacAction[]{MacAction.NSAccessibilityPressAction, MacAction.NSAccessibilityCancelAction}),
        NSAccessibilityMenuButtonRole(Role.MENU_BUTTON, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityTitleAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}),
        NSAccessibilityStaticTextRole(new Role[]{Role.TEXT, Role.TREE_TABLE_CELL}, null, null, null),
        NSAccessibilityTextFieldRole(new Role[]{Role.TEXT_FIELD, Role.PASSWORD_FIELD}, null, null, null),
        NSAccessibilityTextAreaRole(Role.TEXT_AREA, null, null),
        NSAccessibilitySliderRole(Role.SLIDER, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityOrientationAttribute, MacAttribute.NSAccessibilityValueAttribute, MacAttribute.NSAccessibilityMaxValueAttribute, MacAttribute.NSAccessibilityMinValueAttribute}, new MacAction[]{MacAction.NSAccessibilityDecrementAction, MacAction.NSAccessibilityIncrementAction}),
        NSAccessibilityScrollAreaRole(Role.SCROLL_PANE, new MacAttribute[]{MacAttribute.NSAccessibilityContentsAttribute, MacAttribute.NSAccessibilityHorizontalScrollBarAttribute, MacAttribute.NSAccessibilityVerticalScrollBarAttribute}, null),
        NSAccessibilityScrollBarRole(Role.SCROLL_BAR, new MacAttribute[]{MacAttribute.NSAccessibilityValueAttribute, MacAttribute.NSAccessibilityMinValueAttribute, MacAttribute.NSAccessibilityMaxValueAttribute, MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityOrientationAttribute}, null),
        NSAccessibilityValueIndicatorRole(Role.THUMB, new MacAttribute[]{MacAttribute.NSAccessibilityValueAttribute}, null),
        NSAccessibilityRowRole(new Role[]{Role.LIST_ITEM, Role.TABLE_ROW, Role.TREE_ITEM, Role.TREE_TABLE_ITEM}, new MacAttribute[]{MacAttribute.NSAccessibilitySubroleAttribute, MacAttribute.NSAccessibilityIndexAttribute, MacAttribute.NSAccessibilitySelectedAttribute, MacAttribute.NSAccessibilityVisibleChildrenAttribute}, null, null),
        NSAccessibilityTableRole(new Role[]{Role.LIST_VIEW, Role.TABLE_VIEW}, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityColumnsAttribute, MacAttribute.NSAccessibilityHeaderAttribute, MacAttribute.NSAccessibilityRowsAttribute, MacAttribute.NSAccessibilitySelectedRowsAttribute, MacAttribute.NSAccessibilityRowCountAttribute, MacAttribute.NSAccessibilityColumnCountAttribute, MacAttribute.NSAccessibilitySelectedCellsAttribute}, null, new MacAttribute[]{MacAttribute.NSAccessibilityCellForColumnAndRowParameterizedAttribute}),
        NSAccessibilityColumnRole(Role.TABLE_COLUMN, new MacAttribute[]{MacAttribute.NSAccessibilityHeaderAttribute, MacAttribute.NSAccessibilityIndexAttribute, MacAttribute.NSAccessibilityRowsAttribute, MacAttribute.NSAccessibilitySelectedAttribute}, null),
        NSAccessibilityCellRole(new Role[]{Role.TABLE_CELL}, new MacAttribute[]{MacAttribute.NSAccessibilityColumnIndexRangeAttribute, MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityRowIndexRangeAttribute, MacAttribute.NSAccessibilitySelectedAttribute}, null, null),
        NSAccessibilityLinkRole(Role.HYPERLINK, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.AXVisited}, null),
        NSAccessibilityOutlineRole(new Role[]{Role.TREE_VIEW, Role.TREE_TABLE_VIEW}, new MacAttribute[]{MacAttribute.NSAccessibilityColumnsAttribute, MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityHeaderAttribute, MacAttribute.NSAccessibilityRowsAttribute, MacAttribute.NSAccessibilitySelectedRowsAttribute}, null, null),
        NSAccessibilityDisclosureTriangleRole(new Role[]{Role.DISCLOSURE_NODE, Role.TITLED_PANE}, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityValueAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}, null),
        NSAccessibilityToolbarRole(Role.TOOLBAR, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityOverflowButtonAttribute}, null),
        AXDateTimeArea(Role.DATE_PICKER, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityValueAttribute, MacAttribute.AXDateTimeComponents}, null);

        long ptr;
        Role[] jfxRoles;
        List<MacAttribute> macAttributes;
        List<MacAttribute> macParameterizedAttributes;
        List<MacAction> macActions;

        private MacRole(Role role, MacAttribute[] macAttributeArray, MacAction[] macActionArray) {
            this(new Role[]{role}, macAttributeArray, macActionArray, null);
        }

        private MacRole(Role[] roleArray, MacAttribute[] macAttributeArray, MacAction[] macActionArray, MacAttribute[] macAttributeArray2) {
            this.jfxRoles = roleArray;
            this.macAttributes = macAttributeArray != null ? Arrays.asList(macAttributeArray) : null;
            this.macActions = macActionArray != null ? Arrays.asList(macActionArray) : null;
            this.macParameterizedAttributes = macAttributeArray2 != null ? Arrays.asList(macAttributeArray2) : null;
        }

        static MacRole getRole(Role role) {
            if (role == null) {
                return null;
            }
            for (MacRole macRole : MacRole.values()) {
                for (Role role2 : macRole.jfxRoles) {
                    if (role2 != role) continue;
                    return macRole;
                }
            }
            return null;
        }
    }

    static enum MacAttribute {
        NSAccessibilityValueAttribute(null, null),
        NSAccessibilityChildrenAttribute(Attribute.CHILDREN, MacVariant::createNSArray),
        NSAccessibilityDescriptionAttribute(Attribute.DESCRIPTION, MacVariant::createNSString),
        NSAccessibilityEnabledAttribute(Attribute.ENABLED, MacVariant::createNSNumberForBoolean),
        NSAccessibilityHelpAttribute(Attribute.TOOLTIP, MacVariant::createNSString),
        NSAccessibilityFocusedAttribute(Attribute.FOCUSED, MacVariant::createNSNumberForBoolean),
        NSAccessibilityExpandedAttribute(Attribute.EXPANDED, MacVariant::createNSNumberForBoolean),
        NSAccessibilityMaxValueAttribute(Attribute.MAX_VALUE, MacVariant::createNSNumberForDouble),
        NSAccessibilityMinValueAttribute(Attribute.MIN_VALUE, MacVariant::createNSNumberForDouble),
        NSAccessibilityParentAttribute(Attribute.PARENT, MacVariant::createNSObject),
        NSAccessibilityPositionAttribute(Attribute.BOUNDS, MacVariant::createNSValueForPoint),
        NSAccessibilityRoleAttribute(Attribute.ROLE, MacVariant::createNSObject),
        NSAccessibilitySubroleAttribute(Attribute.ROLE, MacVariant::createNSObject),
        NSAccessibilityRoleDescriptionAttribute(Attribute.ROLE, MacVariant::createNSString),
        NSAccessibilitySizeAttribute(Attribute.BOUNDS, MacVariant::createNSValueForSize),
        NSAccessibilityTabsAttribute(null, MacVariant::createNSArray),
        NSAccessibilityTitleAttribute(Attribute.TITLE, MacVariant::createNSString),
        NSAccessibilityTopLevelUIElementAttribute(Attribute.SCENE, MacVariant::createNSObject),
        NSAccessibilityWindowAttribute(Attribute.SCENE, MacVariant::createNSObject),
        NSAccessibilityTitleUIElementAttribute(Attribute.LABELED_BY, MacVariant::createNSObject),
        NSAccessibilityOrientationAttribute(Attribute.ORIENTATION, MacVariant::createNSObject),
        NSAccessibilityOverflowButtonAttribute(Attribute.OVERFLOW_BUTTON, MacVariant::createNSObject),
        AXVisited(Attribute.VISITED, MacVariant::createNSNumberForBoolean),
        AXMenuItemCmdChar(Attribute.ACCELERATOR, MacVariant::createNSString),
        AXMenuItemCmdVirtualKey(Attribute.ACCELERATOR, MacVariant::createNSNumberForInt),
        AXMenuItemCmdGlyph(Attribute.ACCELERATOR, MacVariant::createNSNumberForInt),
        AXMenuItemCmdModifiers(Attribute.ACCELERATOR, MacVariant::createNSNumberForInt),
        AXMenuItemMarkChar(Attribute.SELECTED, MacVariant::createNSString),
        AXDateTimeComponents(null, MacVariant::createNSNumberForInt),
        NSAccessibilitySelectedChildrenAttribute(null, MacVariant::createNSArray),
        NSAccessibilityNumberOfCharactersAttribute(Attribute.TITLE, MacVariant::createNSNumberForInt),
        NSAccessibilitySelectedTextAttribute(Attribute.SELECTION_START, MacVariant::createNSString),
        NSAccessibilitySelectedTextRangeAttribute(Attribute.SELECTION_START, MacVariant::createNSValueForRange),
        NSAccessibilitySelectedTextRangesAttribute(null, null),
        NSAccessibilityInsertionPointLineNumberAttribute(Attribute.CARET_OFFSET, MacVariant::createNSNumberForInt),
        NSAccessibilityVisibleCharacterRangeAttribute(Attribute.TITLE, MacVariant::createNSValueForRange),
        NSAccessibilityContentsAttribute(Attribute.CONTENTS, MacVariant::createNSArray),
        NSAccessibilityHorizontalScrollBarAttribute(Attribute.HORIZONTAL_SCROLLBAR, MacVariant::createNSObject),
        NSAccessibilityVerticalScrollBarAttribute(Attribute.VERTICAL_SCROLLBAR, MacVariant::createNSObject),
        NSAccessibilityIndexAttribute(Attribute.INDEX, MacVariant::createNSNumberForInt),
        NSAccessibilitySelectedAttribute(Attribute.SELECTED, MacVariant::createNSNumberForBoolean),
        NSAccessibilityVisibleChildrenAttribute(Attribute.CHILDREN, MacVariant::createNSArray),
        NSAccessibilityDisclosedByRowAttribute(Attribute.TREE_ITEM_PARENT, MacVariant::createNSObject),
        NSAccessibilityDisclosedRowsAttribute(null, null),
        NSAccessibilityDisclosingAttribute(Attribute.EXPANDED, MacVariant::createNSNumberForBoolean),
        NSAccessibilityDisclosureLevelAttribute(Attribute.DISCLOSURE_LEVEL, MacVariant::createNSNumberForInt),
        NSAccessibilityColumnsAttribute(null, null),
        NSAccessibilityRowsAttribute(null, null),
        NSAccessibilityHeaderAttribute(Attribute.HEADER, MacVariant::createNSObject),
        NSAccessibilitySelectedRowsAttribute(Attribute.SELECTED_ROWS, MacVariant::createNSArray),
        NSAccessibilityRowCountAttribute(Attribute.ROW_COUNT, MacVariant::createNSNumberForInt),
        NSAccessibilityColumnCountAttribute(Attribute.COLUMN_COUNT, MacVariant::createNSNumberForInt),
        NSAccessibilitySelectedCellsAttribute(Attribute.SELECTED_CELLS, MacVariant::createNSArray),
        NSAccessibilityRowIndexRangeAttribute(Attribute.ROW_INDEX, MacVariant::createNSValueForRange),
        NSAccessibilityColumnIndexRangeAttribute(Attribute.COLUMN_INDEX, MacVariant::createNSValueForRange),
        NSAccessibilityLineForIndexParameterizedAttribute(Attribute.LINE_FOR_OFFSET, MacVariant::createNSNumberForInt, 10),
        NSAccessibilityStringForRangeParameterizedAttribute(Attribute.TITLE, MacVariant::createNSString, 18),
        NSAccessibilityRangeForLineParameterizedAttribute(Attribute.LINE_START, MacVariant::createNSValueForRange, 10),
        NSAccessibilityAttributedStringForRangeParameterizedAttribute(Attribute.TITLE, MacVariant::createNSAttributedString, 18),
        NSAccessibilityCellForColumnAndRowParameterizedAttribute(Attribute.CELL_AT_ROW_COLUMN, MacVariant::createNSObject, 3),
        NSAccessibilityRangeForPositionParameterizedAttribute(Attribute.OFFSET_AT_POINT, MacVariant::createNSValueForRange, 15),
        NSAccessibilityBoundsForRangeParameterizedAttribute(Attribute.BOUNDS_FOR_RANGE, MacVariant::createNSValueForRectangle, 18);

        long ptr;
        Attribute jfxAttr;
        Function<Object, MacVariant> map;
        int inputType;

        private MacAttribute(Attribute attribute, Function<Object, MacVariant> function, int n2) {
            this.jfxAttr = attribute;
            this.map = function;
            this.inputType = n2;
        }

        private MacAttribute(Attribute attribute, Function<Object, MacVariant> function) {
            this.jfxAttr = attribute;
            this.map = function;
        }

        static MacAttribute getAttribute(long l) {
            if (l == 0L) {
                return null;
            }
            for (MacAttribute macAttribute : MacAttribute.values()) {
                if (l != macAttribute.ptr && !MacAccessible.isEqualToString(macAttribute.ptr, l)) continue;
                return macAttribute;
            }
            return null;
        }
    }
}

