/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIControl;
import apple.laf.JRSUIState;
import apple.laf.JRSUIUtils;
import com.apple.laf.AquaImageFactory;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import sun.awt.image.ImageCache;
import sun.awt.image.MultiResolutionBufferedImage;
import sun.awt.image.SunWritableRaster;
import sun.java2d.SunGraphics2D;
import sun.print.PeekGraphics;
import sun.print.ProxyGraphics2D;

abstract class AquaPainter<T extends JRSUIState> {
    final Rectangle boundsRect = new Rectangle();
    final JRSUIControl control;
    T state;

    static <T extends JRSUIState> AquaPainter<T> create(T t) {
        return new AquaSingleImagePainter<T>(t);
    }

    static <T extends JRSUIState> AquaPainter<T> create(T t, int n, int n2, int n3, int n4, int n5, int n6) {
        return AquaPainter.create(t, n, n2, n3, n4, n5, n6, true);
    }

    static <T extends JRSUIState> AquaPainter<T> create(T t, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        return AquaPainter.create(t, n, n2, n3, n4, n5, n6, bl, true, true);
    }

    static <T extends JRSUIState> AquaPainter<T> create(T t, final int n, final int n2, final int n3, final int n4, final int n5, final int n6, final boolean bl, final boolean bl2, final boolean bl3) {
        return AquaPainter.create(t, new JRSUIUtils.NineSliceMetricsProvider(){

            @Override
            public AquaImageFactory.NineSliceMetrics getNineSliceMetricsForState(JRSUIState jRSUIState) {
                return new AquaImageFactory.NineSliceMetrics(n, n2, n3, n4, n5, n6, bl, bl2, bl3);
            }
        });
    }

    static <T extends JRSUIState> AquaPainter<T> create(T t, JRSUIUtils.NineSliceMetricsProvider nineSliceMetricsProvider) {
        return new AquaNineSlicingImagePainter<T>(t, nineSliceMetricsProvider);
    }

    abstract void paint(Graphics2D var1, T var2);

    AquaPainter(JRSUIControl jRSUIControl, T t) {
        this.control = jRSUIControl;
        this.state = t;
    }

    final JRSUIControl getControl() {
        this.state = ((JRSUIState)this.state).derive();
        this.control.set((JRSUIState)this.state);
        return this.control;
    }

    final void paint(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        this.boundsRect.setBounds(n, n2, n3, n4);
        Object t = ((JRSUIState)this.state).derive();
        Graphics2D graphics2D = this.getGraphics2D(graphics);
        if (graphics2D != null) {
            this.paint(graphics2D, t);
        }
        this.state = t;
    }

    private Graphics2D getGraphics2D(Graphics graphics) {
        try {
            return (SunGraphics2D)graphics;
        }
        catch (Exception exception) {
            if (graphics instanceof PeekGraphics) {
                graphics.fillRect(this.boundsRect.x, this.boundsRect.y, this.boundsRect.width, this.boundsRect.height);
            } else if (graphics instanceof ProxyGraphics2D) {
                ProxyGraphics2D proxyGraphics2D = (ProxyGraphics2D)graphics;
                Graphics2D graphics2D = proxyGraphics2D.getDelegate();
                if (graphics2D instanceof SunGraphics2D) {
                    return graphics2D;
                }
            } else if (graphics instanceof Graphics2D) {
                return (Graphics2D)graphics;
            }
            return null;
        }
    }

    private static class RecyclableJRSUISlicedImageControl
    extends AquaImageFactory.RecyclableSlicedImageControl {
        private final JRSUIControl control;
        private final JRSUIState state;

        RecyclableJRSUISlicedImageControl(JRSUIControl jRSUIControl, JRSUIState jRSUIState, AquaImageFactory.NineSliceMetrics nineSliceMetrics) {
            super(nineSliceMetrics);
            this.control = jRSUIControl;
            this.state = jRSUIState;
        }

        @Override
        protected Image createTemplateImage(int n, int n2) {
            BufferedImage bufferedImage = new BufferedImage(this.metrics.minW, this.metrics.minH, 3);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            this.control.set(this.state);
            this.control.paint(SunWritableRaster.stealData(dataBufferInt, 0), this.metrics.minW, this.metrics.minH, 0.0, 0.0, this.metrics.minW, this.metrics.minH);
            SunWritableRaster.markDirty(dataBufferInt);
            return bufferedImage;
        }
    }

    private static class AquaPixelsKey
    implements ImageCache.PixelsKey {
        private final int pixelCount;
        private final int hash;
        private final GraphicsConfiguration config;
        private final int w;
        private final int h;
        private final Rectangle bounds;
        private final JRSUIState state;

        AquaPixelsKey(GraphicsConfiguration graphicsConfiguration, int n, int n2, Rectangle rectangle, JRSUIState jRSUIState) {
            this.pixelCount = n * n2;
            this.config = graphicsConfiguration;
            this.w = n;
            this.h = n2;
            this.bounds = rectangle;
            this.state = jRSUIState;
            this.hash = this.hash();
        }

        @Override
        public int getPixelCount() {
            return this.pixelCount;
        }

        private int hash() {
            int n = this.config != null ? this.config.hashCode() : 0;
            n = 31 * n + this.w;
            n = 31 * n + this.h;
            n = 31 * n + this.bounds.hashCode();
            n = 31 * n + this.state.hashCode();
            return n;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof AquaPixelsKey) {
                AquaPixelsKey aquaPixelsKey = (AquaPixelsKey)object;
                return this.config == aquaPixelsKey.config && this.w == aquaPixelsKey.w && this.h == aquaPixelsKey.h && this.bounds.equals(aquaPixelsKey.bounds) && this.state.equals(aquaPixelsKey.state);
            }
            return false;
        }
    }

    private static final class AquaSingleImagePainter<T extends JRSUIState>
    extends AquaPainter<T> {
        AquaSingleImagePainter(T t) {
            super(new JRSUIControl(false), t);
        }

        @Override
        void paint(Graphics2D graphics2D, T t) {
            AquaSingleImagePainter.paintFromSingleCachedImage(graphics2D, this.control, t, this.boundsRect);
        }

        static void paintFromSingleCachedImage(Graphics2D graphics2D, JRSUIControl jRSUIControl, JRSUIState jRSUIState, Rectangle rectangle) {
            AquaPixelsKey aquaPixelsKey;
            if (rectangle.width <= 0 || rectangle.height <= 0) {
                return;
            }
            int n = 0;
            if (jRSUIState.is(JRSUIConstants.Focused.YES)) {
                n = 4;
            }
            int n2 = rectangle.x - n;
            int n5 = rectangle.y - n;
            int n6 = rectangle.width + (n << 1);
            int n7 = rectangle.height + (n << 1);
            GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
            ImageCache imageCache = ImageCache.getInstance();
            Image image = imageCache.getImage(aquaPixelsKey = new AquaPixelsKey(graphicsConfiguration, n6, n7, rectangle, jRSUIState));
            if (image == null) {
                Image image2 = AquaSingleImagePainter.createImage(n2, n5, n6, n7, rectangle, jRSUIControl, jRSUIState);
                image = new MultiResolutionBufferedImage(image2, (n3, n4) -> AquaSingleImagePainter.createImage(n2, n5, n3, n4, rectangle, jRSUIControl, jRSUIState));
                if (!jRSUIState.is(JRSUIConstants.Animating.YES)) {
                    imageCache.setImage(aquaPixelsKey, image);
                }
            }
            graphics2D.drawImage(image, n2, n5, n6, n7, null);
        }

        private static Image createImage(int n, int n2, int n3, int n4, Rectangle rectangle, JRSUIControl jRSUIControl, JRSUIState jRSUIState) {
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 3);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            jRSUIControl.set(jRSUIState);
            jRSUIControl.paint(SunWritableRaster.stealData(dataBufferInt, 0), n3, n4, rectangle.x - n, rectangle.y - n2, rectangle.width, rectangle.height);
            SunWritableRaster.markDirty(dataBufferInt);
            return bufferedImage;
        }
    }

    private static class AquaNineSlicingImagePainter<T extends JRSUIState>
    extends AquaPainter<T> {
        private final HashMap<T, RecyclableJRSUISlicedImageControl> slicedControlImages;
        private final JRSUIUtils.NineSliceMetricsProvider metricsProvider;

        AquaNineSlicingImagePainter(T t) {
            this(t, null);
        }

        AquaNineSlicingImagePainter(T t, JRSUIUtils.NineSliceMetricsProvider nineSliceMetricsProvider) {
            super(new JRSUIControl(false), t);
            this.metricsProvider = nineSliceMetricsProvider;
            this.slicedControlImages = new HashMap();
        }

        @Override
        void paint(Graphics2D graphics2D, T t) {
            Object object;
            if (this.metricsProvider == null) {
                AquaSingleImagePainter.paintFromSingleCachedImage(graphics2D, this.control, t, this.boundsRect);
                return;
            }
            RecyclableJRSUISlicedImageControl recyclableJRSUISlicedImageControl = this.slicedControlImages.get(t);
            if (recyclableJRSUISlicedImageControl == null) {
                object = this.metricsProvider.getNineSliceMetricsForState((JRSUIState)t);
                if (object == null) {
                    AquaSingleImagePainter.paintFromSingleCachedImage(graphics2D, this.control, t, this.boundsRect);
                    return;
                }
                recyclableJRSUISlicedImageControl = new RecyclableJRSUISlicedImageControl(this.control, (JRSUIState)t, (AquaImageFactory.NineSliceMetrics)object);
                this.slicedControlImages.put(t, recyclableJRSUISlicedImageControl);
            }
            object = (AquaImageFactory.SlicedImageControl)recyclableJRSUISlicedImageControl.get();
            ((AquaImageFactory.SlicedImageControl)object).paint(graphics2D, this.boundsRect.x, this.boundsRect.y, this.boundsRect.width, this.boundsRect.height);
        }
    }
}

