/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIUtils;
import com.apple.eawt.Application;
import com.apple.eio.FileManager;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import sun.awt.image.MultiResolutionBufferedImage;
import sun.awt.image.MultiResolutionImage;
import sun.lwawt.macosx.LWCToolkit;

public class AquaImageFactory {
    private static final int kAlertIconSize = 64;
    protected static final NamedImageSingleton northArrow = new NamedImageSingleton("NSMenuScrollUp");
    protected static final IconUIResourceSingleton northArrowIcon = new IconUIResourceSingleton(northArrow);
    protected static final NamedImageSingleton southArrow = new NamedImageSingleton("NSMenuScrollDown");
    protected static final IconUIResourceSingleton southArrowIcon = new IconUIResourceSingleton(southArrow);
    protected static final NamedImageSingleton westArrow = new NamedImageSingleton("NSMenuSubmenuLeft");
    protected static final IconUIResourceSingleton westArrowIcon = new IconUIResourceSingleton(westArrow);
    protected static final NamedImageSingleton eastArrow = new NamedImageSingleton("NSMenuSubmenu");
    protected static final IconUIResourceSingleton eastArrowIcon = new IconUIResourceSingleton(eastArrow);

    public static IconUIResource getConfirmImageIcon() {
        return new IconUIResource(new AquaIcon.CachingScalingIcon(64, 64){

            @Override
            Image createImage() {
                return AquaImageFactory.getGenericJavaIcon();
            }
        });
    }

    public static IconUIResource getCautionImageIcon() {
        return AquaImageFactory.getAppIconCompositedOn(AquaIcon.SystemIcon.getCautionIcon());
    }

    public static IconUIResource getStopImageIcon() {
        return AquaImageFactory.getAppIconCompositedOn(AquaIcon.SystemIcon.getStopIcon());
    }

    public static IconUIResource getLockImageIcon() {
        if (JRSUIUtils.Images.shouldUseLegacySecurityUIPath()) {
            BufferedImage bufferedImage = AquaUtils.getCImageCreator().createImageFromFile("/System/Library/CoreServices/SecurityAgent.app/Contents/Resources/Security.icns", 64.0, 64.0);
            return AquaImageFactory.getAppIconCompositedOn(bufferedImage);
        }
        Image image = Toolkit.getDefaultToolkit().getImage("NSImage://NSSecurity");
        return AquaImageFactory.getAppIconCompositedOn(image);
    }

    static Image getGenericJavaIcon() {
        return AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return Application.getApplication().getDockIconImage();
            }
        });
    }

    static String getPathToThisApplication() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return FileManager.getPathToApplicationBundle();
            }
        });
    }

    static IconUIResource getAppIconCompositedOn(AquaIcon.SystemIcon systemIcon) {
        systemIcon.setSize(64, 64);
        return AquaImageFactory.getAppIconCompositedOn(systemIcon.createImage());
    }

    static IconUIResource getAppIconCompositedOn(Image image2) {
        if (image2 instanceof MultiResolutionBufferedImage) {
            int n = image2.getWidth(null);
            MultiResolutionBufferedImage multiResolutionBufferedImage = ((MultiResolutionBufferedImage)image2).map(image -> AquaImageFactory.getAppIconImageCompositedOn(image, image.getWidth(null) / n));
            return new IconUIResource(new ImageIcon(multiResolutionBufferedImage));
        }
        BufferedImage bufferedImage = AquaImageFactory.getAppIconImageCompositedOn(image2, 1);
        return new IconUIResource(new ImageIcon(bufferedImage));
    }

    static BufferedImage getAppIconImageCompositedOn(Image image, int n) {
        int n2 = 64 * n;
        int n3 = (int)((double)n2 * 0.5);
        int n4 = n2 - n3;
        AquaIcon.CachingScalingIcon cachingScalingIcon = new AquaIcon.CachingScalingIcon(n3, n3){

            @Override
            Image createImage() {
                return AquaImageFactory.getGenericJavaIcon();
            }
        };
        BufferedImage bufferedImage = new BufferedImage(n2, n2, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, n2, n2, null);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        cachingScalingIcon.paintIcon(null, graphics, n4, n4);
        graphics.dispose();
        return bufferedImage;
    }

    public static IconUIResource getTreeFolderIcon() {
        return AquaIcon.SystemIcon.getFolderIconUIResource();
    }

    public static IconUIResource getTreeOpenFolderIcon() {
        return AquaIcon.SystemIcon.getOpenFolderIconUIResource();
    }

    public static IconUIResource getTreeDocumentIcon() {
        return AquaIcon.SystemIcon.getDocumentIconUIResource();
    }

    public static UIResource getTreeExpandedIcon() {
        return AquaIcon.getIconFor(new AquaIcon.JRSUIControlSpec(){

            @Override
            public void initIconPainter(AquaPainter<? extends JRSUIState> aquaPainter) {
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Widget.DISCLOSURE_TRIANGLE);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.State.ACTIVE);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Direction.DOWN);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
            }
        }, 20, 20);
    }

    public static UIResource getTreeCollapsedIcon() {
        return AquaIcon.getIconFor(new AquaIcon.JRSUIControlSpec(){

            @Override
            public void initIconPainter(AquaPainter<? extends JRSUIState> aquaPainter) {
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Widget.DISCLOSURE_TRIANGLE);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.State.ACTIVE);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Direction.RIGHT);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
            }
        }, 20, 20);
    }

    public static UIResource getTreeRightToLeftCollapsedIcon() {
        return AquaIcon.getIconFor(new AquaIcon.JRSUIControlSpec(){

            @Override
            public void initIconPainter(AquaPainter<? extends JRSUIState> aquaPainter) {
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Widget.DISCLOSURE_TRIANGLE);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.State.ACTIVE);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Direction.LEFT);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
            }
        }, 20, 20);
    }

    static Image getArrowImageForDirection(int n) {
        switch (n) {
            case 1: {
                return (Image)northArrow.get();
            }
            case 5: {
                return (Image)southArrow.get();
            }
            case 3: {
                return (Image)eastArrow.get();
            }
            case 7: {
                return (Image)westArrow.get();
            }
        }
        return null;
    }

    static Icon getArrowIconForDirection(int n) {
        switch (n) {
            case 1: {
                return (Icon)northArrowIcon.get();
            }
            case 5: {
                return (Icon)southArrowIcon.get();
            }
            case 3: {
                return (Icon)eastArrowIcon.get();
            }
            case 7: {
                return (Icon)westArrowIcon.get();
            }
        }
        return null;
    }

    public static Icon getMenuArrowIcon() {
        return new InvertableImageIcon(AquaUtils.generateLightenedImage((Image)eastArrow.get(), 25));
    }

    public static Icon getMenuItemCheckIcon() {
        return new InvertableImageIcon(AquaUtils.generateLightenedImage(AquaImageFactory.getNSIcon("NSMenuItemSelection"), 25));
    }

    public static Icon getMenuItemDashIcon() {
        return new InvertableImageIcon(AquaUtils.generateLightenedImage(AquaImageFactory.getNSIcon("NSMenuMixedState"), 25));
    }

    private static Image getNSIcon(String string) {
        Image image = Toolkit.getDefaultToolkit().getImage("NSImage://" + string);
        if (image instanceof MultiResolutionImage) {
            return image;
        }
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        Dimension2D[] dimension2DArray = new Dimension[]{new Dimension(n3, n4), new Dimension(2 * n3, 2 * n4)};
        return new MultiResolutionBufferedImage(image, dimension2DArray, (n, n2) -> AquaUtils.getCImageCreator().createImageFromName(string, (int)n, (int)n2));
    }

    public static Color getWindowBackgroundColorUIResource() {
        return new SystemColorProxy(SystemColor.window);
    }

    public static Color getTextSelectionBackgroundColorUIResource() {
        return new SystemColorProxy(SystemColor.textHighlight);
    }

    public static Color getTextSelectionForegroundColorUIResource() {
        return new SystemColorProxy(SystemColor.textHighlightText);
    }

    public static Color getSelectionBackgroundColorUIResource() {
        return new SystemColorProxy(SystemColor.controlHighlight);
    }

    public static Color getSelectionForegroundColorUIResource() {
        return new SystemColorProxy(SystemColor.controlLtHighlight);
    }

    public static Color getFocusRingColorUIResource() {
        return new SystemColorProxy(LWCToolkit.getAppleColor(0));
    }

    public static Color getSelectionInactiveBackgroundColorUIResource() {
        return new SystemColorProxy(LWCToolkit.getAppleColor(1));
    }

    public static Color getSelectionInactiveForegroundColorUIResource() {
        return new SystemColorProxy(LWCToolkit.getAppleColor(2));
    }

    private static class SystemColorProxy
    extends Color
    implements UIResource {
        final Color color;

        public SystemColorProxy(Color color) {
            super(color.getRGB());
            this.color = color;
        }

        @Override
        public int getRGB() {
            return this.color.getRGB();
        }
    }

    public static abstract class RecyclableSlicedImageControl
    extends AquaUtils.RecyclableObject<SlicedImageControl> {
        final NineSliceMetrics metrics;

        public RecyclableSlicedImageControl(NineSliceMetrics nineSliceMetrics) {
            this.metrics = nineSliceMetrics;
        }

        @Override
        protected SlicedImageControl create() {
            return new SlicedImageControl(this.createTemplateImage(this.metrics.minW, this.metrics.minH), this.metrics);
        }

        protected abstract Image createTemplateImage(int var1, int var2);
    }

    public static class SlicedImageControl {
        final BufferedImage NW;
        final BufferedImage N;
        final BufferedImage NE;
        final BufferedImage W;
        final BufferedImage C;
        final BufferedImage E;
        final BufferedImage SW;
        final BufferedImage S;
        final BufferedImage SE;
        final NineSliceMetrics metrics;
        final int totalWidth;
        final int totalHeight;
        final int centerColWidth;
        final int centerRowHeight;

        public SlicedImageControl(Image image, int n, int n2, int n3, int n4) {
            this(image, n, n2, n3, n4, true);
        }

        public SlicedImageControl(Image image, int n, int n2, int n3, int n4, boolean bl) {
            this(image, n, n2, n3, n4, bl, true, true);
        }

        public SlicedImageControl(Image image, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
            this(image, new NineSliceMetrics(image.getWidth(null), image.getHeight(null), n, n2, n3, n4, bl, bl2, bl3));
        }

        public SlicedImageControl(Image image, NineSliceMetrics nineSliceMetrics) {
            this.metrics = nineSliceMetrics;
            if (image.getWidth(null) != nineSliceMetrics.minW || image.getHeight(null) != nineSliceMetrics.minH) {
                throw new IllegalArgumentException("SlicedImageControl: template image and NineSliceMetrics don't agree on minimum dimensions");
            }
            this.totalWidth = nineSliceMetrics.minW;
            this.totalHeight = nineSliceMetrics.minH;
            this.centerColWidth = this.totalWidth - nineSliceMetrics.wCut - nineSliceMetrics.eCut;
            this.centerRowHeight = this.totalHeight - nineSliceMetrics.nCut - nineSliceMetrics.sCut;
            this.NW = SlicedImageControl.createSlice(image, 0, 0, nineSliceMetrics.wCut, nineSliceMetrics.nCut);
            this.N = SlicedImageControl.createSlice(image, nineSliceMetrics.wCut, 0, this.centerColWidth, nineSliceMetrics.nCut);
            this.NE = SlicedImageControl.createSlice(image, this.totalWidth - nineSliceMetrics.eCut, 0, nineSliceMetrics.eCut, nineSliceMetrics.nCut);
            this.W = SlicedImageControl.createSlice(image, 0, nineSliceMetrics.nCut, nineSliceMetrics.wCut, this.centerRowHeight);
            this.C = nineSliceMetrics.showMiddle ? SlicedImageControl.createSlice(image, nineSliceMetrics.wCut, nineSliceMetrics.nCut, this.centerColWidth, this.centerRowHeight) : null;
            this.E = SlicedImageControl.createSlice(image, this.totalWidth - nineSliceMetrics.eCut, nineSliceMetrics.nCut, nineSliceMetrics.eCut, this.centerRowHeight);
            this.SW = SlicedImageControl.createSlice(image, 0, this.totalHeight - nineSliceMetrics.sCut, nineSliceMetrics.wCut, nineSliceMetrics.sCut);
            this.S = SlicedImageControl.createSlice(image, nineSliceMetrics.wCut, this.totalHeight - nineSliceMetrics.sCut, this.centerColWidth, nineSliceMetrics.sCut);
            this.SE = SlicedImageControl.createSlice(image, this.totalWidth - nineSliceMetrics.eCut, this.totalHeight - nineSliceMetrics.sCut, nineSliceMetrics.eCut, nineSliceMetrics.sCut);
        }

        static BufferedImage createSlice(Image image, int n, int n2, int n3, int n4) {
            if (n3 == 0 || n4 == 0) {
                return null;
            }
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, n3, n4, n, n2, n + n3, n2 + n4, null);
            graphics2D.dispose();
            return bufferedImage;
        }

        public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            if (n3 < this.totalWidth || n4 < this.totalHeight) {
                this.paintCompressed(graphics, n3, n4);
            } else {
                this.paintStretchedMiddles(graphics, n3, n4);
            }
            graphics.translate(-n, -n2);
        }

        void paintStretchedMiddles(Graphics graphics, int n, int n2) {
            int n3;
            int n4 = this.metrics.stretchH ? 0 : n / 2 - this.totalWidth / 2;
            int n5 = this.metrics.stretchV ? 0 : n2 / 2 - this.totalHeight / 2;
            int n6 = this.metrics.stretchH ? n : this.totalWidth;
            int n7 = n3 = this.metrics.stretchV ? n2 : this.totalHeight;
            if (this.NW != null) {
                graphics.drawImage(this.NW, n4, n5, null);
            }
            if (this.N != null) {
                graphics.drawImage(this.N, n4 + this.metrics.wCut, n5, n6 - this.metrics.eCut - this.metrics.wCut, this.metrics.nCut, null);
            }
            if (this.NE != null) {
                graphics.drawImage(this.NE, n4 + n6 - this.metrics.eCut, n5, null);
            }
            if (this.W != null) {
                graphics.drawImage(this.W, n4, n5 + this.metrics.nCut, this.metrics.wCut, n3 - this.metrics.nCut - this.metrics.sCut, null);
            }
            if (this.C != null) {
                graphics.drawImage(this.C, n4 + this.metrics.wCut, n5 + this.metrics.nCut, n6 - this.metrics.eCut - this.metrics.wCut, n3 - this.metrics.nCut - this.metrics.sCut, null);
            }
            if (this.E != null) {
                graphics.drawImage(this.E, n4 + n6 - this.metrics.eCut, n5 + this.metrics.nCut, this.metrics.eCut, n3 - this.metrics.nCut - this.metrics.sCut, null);
            }
            if (this.SW != null) {
                graphics.drawImage(this.SW, n4, n5 + n3 - this.metrics.sCut, null);
            }
            if (this.S != null) {
                graphics.drawImage(this.S, n4 + this.metrics.wCut, n5 + n3 - this.metrics.sCut, n6 - this.metrics.eCut - this.metrics.wCut, this.metrics.sCut, null);
            }
            if (this.SE != null) {
                graphics.drawImage(this.SE, n4 + n6 - this.metrics.eCut, n5 + n3 - this.metrics.sCut, null);
            }
        }

        void paintCompressed(Graphics graphics, int n, int n2) {
            double d = n2 > this.totalHeight ? 1.0 : (double)n2 / (double)this.totalHeight;
            double d2 = n > this.totalWidth ? 1.0 : (double)n / (double)this.totalWidth;
            int n3 = (int)((double)this.metrics.nCut * d);
            int n4 = (int)((double)this.metrics.sCut * d);
            int n5 = n2 - n3 - n4;
            int n6 = (int)((double)this.metrics.wCut * d2);
            int n7 = (int)((double)this.metrics.eCut * d2);
            int n8 = n - n6 - n7;
            if (this.NW != null) {
                graphics.drawImage(this.NW, 0, 0, n6, n3, null);
            }
            if (this.N != null) {
                graphics.drawImage(this.N, n6, 0, n8, n3, null);
            }
            if (this.NE != null) {
                graphics.drawImage(this.NE, n - n7, 0, n7, n3, null);
            }
            if (this.W != null) {
                graphics.drawImage(this.W, 0, n3, n6, n5, null);
            }
            if (this.C != null) {
                graphics.drawImage(this.C, n6, n3, n8, n5, null);
            }
            if (this.E != null) {
                graphics.drawImage(this.E, n - n7, n3, n7, n5, null);
            }
            if (this.SW != null) {
                graphics.drawImage(this.SW, 0, n2 - n4, n6, n4, null);
            }
            if (this.S != null) {
                graphics.drawImage(this.S, n6, n2 - n4, n8, n4, null);
            }
            if (this.SE != null) {
                graphics.drawImage(this.SE, n - n7, n2 - n4, n7, n4, null);
            }
        }
    }

    public static class NineSliceMetrics {
        public final int wCut;
        public final int eCut;
        public final int nCut;
        public final int sCut;
        public final int minW;
        public final int minH;
        public final boolean showMiddle;
        public final boolean stretchH;
        public final boolean stretchV;

        public NineSliceMetrics(int n, int n2, int n3, int n4, int n5, int n6) {
            this(n, n2, n3, n4, n5, n6, true);
        }

        public NineSliceMetrics(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            this(n, n2, n3, n4, n5, n6, bl, true, true);
        }

        public NineSliceMetrics(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3) {
            this.wCut = n3;
            this.eCut = n4;
            this.nCut = n5;
            this.sCut = n6;
            this.minW = n;
            this.minH = n2;
            this.showMiddle = bl;
            this.stretchH = bl2;
            this.stretchV = bl3;
        }
    }

    static class InvertableImageIcon
    extends ImageIcon
    implements AquaIcon.InvertableIcon,
    UIResource {
        Icon invertedImage;

        public InvertableImageIcon(Image image) {
            super(image);
        }

        @Override
        public Icon getInvertedIcon() {
            if (this.invertedImage != null) {
                return this.invertedImage;
            }
            this.invertedImage = new IconUIResource(new ImageIcon(AquaUtils.generateLightenedImage(this.getImage(), 100)));
            return this.invertedImage;
        }
    }

    static class IconUIResourceSingleton
    extends AquaUtils.RecyclableSingleton<IconUIResource> {
        final NamedImageSingleton holder;

        public IconUIResourceSingleton(NamedImageSingleton namedImageSingleton) {
            this.holder = namedImageSingleton;
        }

        @Override
        protected IconUIResource getInstance() {
            return new IconUIResource(new ImageIcon((Image)this.holder.get()));
        }
    }

    static class NamedImageSingleton
    extends AquaUtils.RecyclableSingleton<Image> {
        final String namedImage;

        NamedImageSingleton(String string) {
            this.namedImage = string;
        }

        @Override
        protected Image getInstance() {
            return AquaImageFactory.getNSIcon(this.namedImage);
        }
    }
}

