/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CertificateDialog;
import com.sun.deploy.security.URLClassPathControl;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.DialogHelper;
import com.sun.deploy.ui.DialogInterface;
import com.sun.deploy.ui.FancyButton;
import com.sun.deploy.ui.ImageLoader;
import com.sun.deploy.ui.ImageLoaderCallback;
import com.sun.deploy.ui.MoreInfoDialog;
import com.sun.deploy.ui.PromptEditorKit;
import com.sun.deploy.ui.SSV3DialogContent;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.ui.UITextArea;
import com.sun.deploy.util.DialogListener;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.TreeMap;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;

public class DialogTemplate
implements ActionListener,
ImageLoaderCallback {
    private final Color LINK_COLOR = new Color(33, 79, 131);
    private final Color LINK_HIGHLIGHT_COLOR = new Color(192, 63, 63);
    private static Font ssvFont;
    private static Font ssvBold;
    private static Font ssvBigFont;
    private static Font ssvBigBoldFont;
    private static Font ssvSmallFont;
    private static Font ssvSmallBoldFont;
    private DialogInterface dialogInterface;
    private AppInfo ainfo = null;
    private String topText = null;
    private String appTitle = null;
    private String appPublisher = null;
    private URL appURL = null;
    private int defaultButton = 0;
    private Frame dummyFrame = null;
    private boolean useErrorIcon = false;
    private boolean useWarningIcon = false;
    private boolean useInfoIcon = false;
    private boolean useMixcodeIcon = false;
    private boolean useBlockedIcon = false;
    private boolean isBlockedDialog = false;
    private JLabel progressStatusLabel = null;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JPanel bottomPanel;
    private JLabel topIcon;
    private JLabel securityIcon;
    private JLabel nameInfo;
    private JLabel publisherInfo;
    private JLabel urlInfo;
    private JLabel originInfo;
    private JLabel appletLocationInfo;
    private JButton okBtn;
    private JButton cancelBtn;
    private JCheckBox always;
    private JLabel mixedCodeLabel;
    private JTextComponent masthead = null;
    private static final int ICON_SIZE = 48;
    private int userAnswer = -1;
    private final int DIALOG_WIDTH = 510;
    private final int SMALL_DIALOG_WIDTH = 260;
    private int dialogWidth = 510;
    private final int MAX_LARGE_SCROLL_WIDTH = 600;
    private final Color BG = Color.white;
    private final String SECURITY_ALERT_HIGH = "com/sun/deploy/resources/image/security_high.png";
    private final String SECURITY_ALERT_LOW = "com/sun/deploy/resources/image/security_low.png";
    private static int MAIN_TEXT_WIDTH;
    private final String OK_ACTION = "OK";
    private final int MAX_BUTTONS = 2;
    private int start;
    private int end;
    private Certificate[] certs;
    private String[] alertStrs;
    private String[] infoStrs;
    private int securityInfoCount;
    private String acceptTitle = null;
    private String acceptText = null;
    private Color originalColor;
    private Cursor handCursor = new Cursor(12);
    private Cursor originalCursor = null;
    protected JProgressBar progressBar = null;
    private boolean stayAliveOnOk = false;
    private String contentString = null;
    private String reason = null;
    private String cacheUpgradeContentString = null;
    private String contentLabel = null;
    private String alwaysString = null;
    private String mixedCodeString = null;
    private boolean contentScroll = false;
    private boolean includeMasthead = true;
    private boolean includeAppInfo = true;
    private boolean largeScroll = false;
    private Throwable throwable = null;
    private JPanel detailPanel = null;
    private char[] pwd = new char[0];
    private String userName;
    private String domain;
    private JTextField pwdName;
    private JTextField pwdDomain;
    private JPasswordField password;
    private JList scrollList;
    private boolean showDetails = false;
    TreeMap clientAuthCertsMap;
    static int minFontSize;
    private boolean majorWarning = false;
    private boolean sandboxApp = false;
    protected boolean hideTitleAndPublisher = false;
    private boolean mixedJsToJava = false;

    DialogTemplate(AppInfo appInfo, Component component, String string, String string2, boolean bl) {
        this(appInfo, component, string, string2, bl, true);
    }

    DialogTemplate(AppInfo appInfo, Component component, String string, String string2, boolean bl, boolean bl2) {
        this(appInfo, component, string, string2, bl, bl2, 0);
    }

    DialogTemplate(AppInfo appInfo, Component component, String string, String string2, boolean bl, boolean bl2, int n) {
        this.dialogInterface = new DialogHelper(component, appInfo, string, bl);
        this.dialogInterface.setModalOnTop(bl2);
        if (appInfo == null) {
            appInfo = new AppInfo();
        }
        this.ainfo = appInfo;
        this.topText = string2;
        this.appTitle = appInfo.getDisplayTitle();
        this.appPublisher = appInfo.getDisplayVendor();
        this.appURL = appInfo.getFrom();
        this.defaultButton = n;
    }

    void setSecurityContent(boolean bl, boolean bl2, String string, String string2, String[] stringArray, String[] stringArray2, int n, boolean bl3, Certificate[] certificateArray, int n2, int n3, boolean bl4) {
        this.certs = certificateArray;
        this.start = n2;
        this.end = n3;
        this.alertStrs = stringArray;
        this.infoStrs = stringArray2;
        this.securityInfoCount = n;
        this.majorWarning = bl4;
        if (stringArray != null && stringArray.length > 0) {
            this.useWarningIcon = true;
        }
        try {
            Container container = this.dialogInterface.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this.createTopPanel(false), "North");
            this.dialogInterface.setModalOnTop(true);
            if (bl) {
                this.alwaysString = this.getMessage("security.dialog.always");
            }
            container.add((Component)this.createCenterPanel(bl2, string, string2, -1, true), "Center");
            container.add((Component)this.createBottomPanel(bl3), "South");
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setNewSecurityContent(boolean bl, boolean bl2, String string, String string2, String[] stringArray, String[] stringArray2, int n, boolean bl3, Certificate[] certificateArray, int n2, int n3, boolean bl4, String string3, String string4, boolean bl5, boolean bl6, boolean bl7) {
        this.certs = certificateArray;
        this.start = n2;
        this.end = n3;
        this.alertStrs = stringArray;
        this.infoStrs = stringArray2;
        this.securityInfoCount = n;
        this.majorWarning = bl4;
        this.acceptTitle = string3;
        this.acceptText = string4;
        this.sandboxApp = bl6;
        try {
            Object object;
            this.alwaysString = bl ? this.getMessage(bl6 ? "sandbox.security.dialog.always" : "security.dialog.always") : null;
            this.ssvSetFonts();
            JPanel jPanel = new JPanel();
            if (this.alertStrs == null || this.alertStrs.length == 0) {
                jPanel = DialogTemplate.createShadedContentBorderPanel(true);
                this.dialogInterface.setUndecorated(true);
                this.dialogInterface.setMouseListener(true);
            } else {
                jPanel = this.createShadedContentPanel();
            }
            this.dialogInterface.setContentPane(jPanel);
            jPanel.setLayout(new BorderLayout());
            jPanel.setOpaque(false);
            this.dialogInterface.setModalOnTop(true);
            JPanel jPanel2 = this.createSecurityTopPanel(bl5);
            jPanel.add((Component)jPanel2, "North");
            JPanel jPanel3 = new JPanel();
            JPanel jPanel4 = new JPanel();
            jPanel4.setOpaque(false);
            if (bl5) {
                object = this.alertStrs == null || this.alertStrs.length == 0 ? this.getMessage("security.dialog.https.valid.risk") : this.getMessage("security.dialog.https.mismatch.risk");
                jPanel3 = this.createSecurityRiskPanel((String)object, false, true);
                jPanel4 = this.createButtonsPanel(string, string2);
                jPanel4.setOpaque(false);
                jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 16));
            } else if (!bl4) {
                object = bl6 ? this.getMessage("sandbox.security.dialog.valid.signed.risk") : (this.ainfo.isMultiHost() ? this.getMessage("security.dialog.valid.signed.risk.multihost") : this.getMessage("security.dialog.valid.signed.risk"));
                jPanel3 = this.createTrustSecurityRiskPanel((String)object);
                if (this.alwaysString != null) {
                    jPanel4 = this.createTrustSecurityAlwaysPanel(bl2);
                }
            } else {
                jPanel3 = this.createSecurityRiskPanel(stringArray[0], bl7, false);
                this.consumeAlertString0();
                jPanel4 = this.createSecurityAcceptPanel(string, string2, bl2);
            }
            object = new JPanel(new BorderLayout());
            ((Container)object).add((Component)jPanel3, "North");
            ((Container)object).add((Component)jPanel4, "South");
            ((JComponent)object).setOpaque(false);
            jPanel.add((Component)object, "Center");
            JPanel jPanel5 = new JPanel();
            jPanel5.setOpaque(false);
            if (!bl5 && !bl4) {
                jPanel5 = this.createTrustSecurityBottomPanel(string, string2);
            } else if (this.alwaysString != null) {
                jPanel5 = this.createSecurityBottomPanel(bl5);
            }
            if (bl7) {
                JPanel jPanel6 = new JPanel(new BorderLayout());
                jPanel6.setOpaque(false);
                jPanel6.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
                jPanel.add((Component)jPanel6, "South");
            } else {
                jPanel.add((Component)jPanel5, "South");
            }
            if (this.alertStrs == null || this.alertStrs.length == 0) {
                this.dialogInterface.setInitialFocusComponent(this.okBtn);
                this.dialogInterface.setDefaultButton(this.okBtn);
            } else {
                this.dialogInterface.setInitialFocusComponent(this.cancelBtn);
                this.dialogInterface.setDefaultButton(this.cancelBtn);
            }
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setSSVContent(String string, String string2, URL uRL, String string3, String string4, String string5, String string6, String string7) {
        try {
            this.ssvSetFonts();
            JPanel jPanel = this.createShadedContentPanel();
            this.dialogInterface.setContentPane(jPanel);
            jPanel.setLayout(new BorderLayout());
            jPanel.setOpaque(false);
            this.dialogInterface.setModalOnTop(true);
            jPanel.add((Component)this.createSSVTopPanel(this.topText, this.appTitle, this.ainfo.getDisplayFrom()), "North");
            JPanel jPanel2 = this.createSSVRiskPanel(string, string2, uRL);
            final SSVChoicePanel sSVChoicePanel = new SSVChoicePanel(string3, string4, string5);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel2, "North");
            jPanel3.add((Component)sSVChoicePanel, "South");
            jPanel3.setOpaque(false);
            jPanel.add((Component)jPanel3, "Center");
            JPanel jPanel4 = new JPanel(new FlowLayout(4, 0, 0));
            jPanel4.setOpaque(false);
            jPanel4.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 16));
            this.okBtn = new JButton(string6);
            this.okBtn.setFont(ssvFont);
            this.okBtn.setOpaque(false);
            this.okBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (sSVChoicePanel.getSelection() == 0) {
                        DialogTemplate.this.setUserAnswer(2);
                    } else {
                        DialogTemplate.this.setUserAnswer(0);
                    }
                    DialogTemplate.this.setVisible(false);
                }
            });
            jPanel4.add(this.okBtn);
            this.cancelBtn = new JButton(string7);
            this.cancelBtn.setFont(ssvFont);
            this.cancelBtn.setOpaque(false);
            this.cancelBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DialogTemplate.this.cancelAction();
                }
            });
            this.dialogInterface.setCancelAction(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DialogTemplate.this.cancelAction();
                }
            });
            jPanel4.add(Box.createHorizontalStrut(10));
            jPanel4.add(this.cancelBtn);
            this.dialogInterface.setDefaultButton(this.okBtn);
            jPanel.add((Component)jPanel4, "South");
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setSSV3Content(SSV3DialogContent sSV3DialogContent) {
        try {
            JPanel jPanel = DialogTemplate.createShadedContentBorderPanel(false);
            jPanel.setLayout(new BorderLayout());
            jPanel.setOpaque(false);
            jPanel.add((Component)sSV3DialogContent.getContent(), "Center");
            this.dialogInterface.setContentPane(jPanel);
            this.dialogInterface.setModalOnTop(true);
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    DialogInterface getDialogInterface() {
        return this.dialogInterface;
    }

    void setCannotDownloadContent(String string, String string2, URL uRL, String string3) {
        Container container = this.dialogInterface.getContentPane();
        if (container instanceof JComponent) {
            ((JComponent)container).setOpaque(false);
        }
        try {
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            this.dialogInterface.getContentPane().add((Component)this.createLinkPanel(this.topText, uRL, string3), "North");
            this.dialogInterface.getContentPane().add((Component)this.createCenterPanel(false, string, string2, -1, false), "Center");
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setSimpleContent(String string, boolean bl, String string2, String string3, String string4, boolean bl2, boolean bl3) {
        String[] stringArray;
        this.contentString = string;
        this.contentScroll = bl;
        this.throwable = this.throwable;
        this.detailPanel = this.detailPanel;
        this.includeMasthead = bl2;
        this.includeAppInfo = bl2;
        this.largeScroll = !bl2;
        this.useWarningIcon = bl3;
        if (string2 != null) {
            stringArray = new String[]{string2};
            if (bl3) {
                this.alertStrs = stringArray;
            } else {
                this.infoStrs = stringArray;
            }
        }
        if ((stringArray = this.dialogInterface.getContentPane()) instanceof JComponent) {
            ((JComponent)stringArray).setOpaque(false);
        }
        try {
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            if (this.ainfo != null && this.ainfo.getTitle() != null && this.ainfo.getTitle().length() == 0) {
                this.hideTitleAndPublisher = true;
            }
            this.dialogInterface.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialogInterface.getContentPane().add((Component)this.createCenterPanel(false, string3, string4, -1, false), "Center");
            this.dialogInterface.getContentPane().add((Component)this.createBottomPanel(false), "South");
            boolean bl4 = bl;
            this.dialogInterface.setResizable(bl4);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setMixedCodeContent(String string, boolean bl, String string2, String string3, String string4, String string5, boolean bl2, boolean bl3, boolean bl4, String string6) {
        this.mixedJsToJava = bl4;
        this.contentString = string;
        this.contentScroll = bl;
        this.throwable = this.throwable;
        this.detailPanel = this.detailPanel;
        this.includeMasthead = bl2;
        this.includeAppInfo = bl2;
        this.largeScroll = !bl2;
        this.useMixcodeIcon = true;
        this.alwaysString = string6;
        this.alertStrs = new String[1];
        String[] stringArray = new String[]{string3};
        this.alertStrs = stringArray;
        this.infoStrs = new String[3];
        String string7 = "security.dialog.mixcode." + (this.mixedJsToJava ? "js." : "");
        String string8 = this.getMessage(string7 + "info1");
        String string9 = this.getMessage(string7 + "info2");
        String string10 = this.getMessage(string7 + "info3");
        String[] stringArray2 = new String[]{string8, string9, string10};
        this.infoStrs = stringArray2;
        try {
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            this.dialogInterface.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.mixedCodeString = string2;
            this.dialogInterface.getContentPane().add((Component)this.createCenterPanel(false, string4, string5, -1, true), "Center");
            this.dialogInterface.getContentPane().add((Component)this.createBottomPanel(false), "South");
            this.dialogInterface.setModalOnTop(true);
            this.okBtn.requestFocusInWindow();
            boolean bl5 = bl;
            this.dialogInterface.setResizable(bl5);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setListContent(String string, JList jList, boolean bl, String string2, String string3, TreeMap treeMap) {
        this.useWarningIcon = true;
        this.includeAppInfo = false;
        this.clientAuthCertsMap = treeMap;
        this.contentLabel = string;
        this.contentScroll = true;
        this.scrollList = jList;
        this.showDetails = bl;
        try {
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            this.dialogInterface.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialogInterface.getContentPane().add((Component)this.createCenterPanel(false, string2, string3, -1, true), "Center");
            this.dialogInterface.getContentPane().add((Component)this.createBottomPanel(false), "South");
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setApiContent(String string, String string2, String string3, boolean bl, String string4, String string5) {
        this.contentString = string;
        this.contentLabel = string2;
        this.contentScroll = string != null;
        this.alwaysString = string3;
        if (string2 == null && string != null) {
            this.infoStrs = new String[1];
            this.infoStrs[0] = string;
            this.contentString = null;
        }
        this.includeMasthead = true;
        this.includeAppInfo = this.contentString == null;
        this.largeScroll = false;
        try {
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            this.dialogInterface.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialogInterface.getContentPane().add((Component)this.createCenterPanel(false, string4, string5, -1, false), "Center");
            this.dialogInterface.getContentPane().add((Component)this.createBottomPanel(false), "South");
            this.dialogInterface.setModalOnTop(true);
            boolean bl2 = this.contentScroll;
            this.dialogInterface.setResizable(bl2);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setPublisherInfo(String string, String string2, String string3, JPanel jPanel, boolean bl) {
        this.contentString = string;
        this.detailPanel = jPanel;
        this.useInfoIcon = true;
        if (jPanel == null) {
            string3 = null;
        }
        if (bl) {
            this.includeAppInfo = false;
        }
        try {
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            this.dialogInterface.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialogInterface.getContentPane().add((Component)this.createCenterPanel(false, string2, string3, -1, true), "Center");
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setBlockedDialogInfo(String string, String string2, String string3, String string4, JPanel jPanel, boolean bl) {
        this.contentString = string2;
        this.reason = string;
        this.detailPanel = jPanel;
        this.useBlockedIcon = true;
        this.isBlockedDialog = true;
        if (jPanel == null) {
            string4 = null;
        }
        if (bl) {
            this.includeAppInfo = false;
        }
        try {
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            this.dialogInterface.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialogInterface.getContentPane().add((Component)this.createCenterPanel(false, string3, string4, -1, true), "Center");
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setErrorContent(String string, String string2, String string3, Throwable throwable, JPanel jPanel, Certificate[] certificateArray, boolean bl) {
        this.contentString = string;
        this.throwable = throwable;
        this.detailPanel = jPanel;
        this.certs = certificateArray;
        if (bl) {
            this.includeAppInfo = false;
        }
        if (throwable instanceof BlockedException) {
            this.useBlockedIcon = true;
        } else {
            this.useErrorIcon = true;
        }
        try {
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            this.dialogInterface.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialogInterface.getContentPane().add((Component)this.createCenterPanel(false, string2, string3, -1, true), "Center");
            this.dialogInterface.getContentPane().add((Component)this.createBottomPanel(false), "South");
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable2) {
            Trace.ignored(throwable2);
        }
    }

    void setMultiButtonErrorContent(String string, String string2, String string3, String string4) {
        this.useErrorIcon = true;
        try {
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            this.dialogInterface.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialogInterface.getContentPane().add((Component)this.createInfoPanel(string), "Center");
            this.dialogInterface.getContentPane().add((Component)this.createThreeButtonsPanel(string2, string3, string4, false), "South");
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setInfoContent(String string, String string2) {
        this.useInfoIcon = true;
        this.contentString = string;
        try {
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            this.dialogInterface.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialogInterface.getContentPane().add((Component)this.createCenterPanel(false, string2, null, -1, true), "Center");
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setPasswordContent(String string, boolean bl, boolean bl2, String string2, String string3, boolean bl3, char[] cArray, String string4) {
        try {
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            this.dialogInterface.getContentPane().add((Component)this.createPasswordPanel(string, bl, bl2, string2, string3, bl3, cArray, string4), "Center");
            this.dialogInterface.setModalOnTop(true);
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setUpdateCheckContent(String string, String string2, String string3, String string4) {
        try {
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            this.dialogInterface.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialogInterface.getContentPane().add((Component)this.createInfoPanel(string), "Center");
            this.dialogInterface.getContentPane().add((Component)this.createThreeButtonsPanel(string2, string3, string4, true), "South");
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setProgressContent(String string, String string2, String string3, boolean bl, int n) {
        try {
            this.cacheUpgradeContentString = string3;
            this.dialogInterface.getContentPane().setLayout(new BorderLayout());
            this.dialogInterface.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialogInterface.getContentPane().add((Component)this.createCenterPanel(false, string, string2, n, true), "Center");
            if (this.cacheUpgradeContentString == null) {
                this.dialogInterface.getContentPane().add((Component)this.createBottomPanel(false), "South");
            }
            this.dialogInterface.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    public void setTitle(String string) {
        this.dialogInterface.setTitle(string);
    }

    private JPanel createInfoPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 12));
        UITextArea uITextArea = new UITextArea(ResourceManager.getUIFont().getSize(), 478, false);
        uITextArea.setText(string);
        uITextArea.setSize(uITextArea.getPreferredSize());
        jPanel.add(uITextArea);
        return jPanel;
    }

    private JPanel createThreeButtonsPanel(String string, String string2, String string3, boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(4, 6, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JButton jButton = new JButton(this.getMessage(string));
        jButton.setMnemonic(ResourceManager.getMnemonic(string));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogTemplate.this.setUserAnswer(0);
                DialogTemplate.this.setVisible(false);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(this.getMessage(string2));
        jButton2.setMnemonic(ResourceManager.getMnemonic(string2));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogTemplate.this.setUserAnswer(1);
                DialogTemplate.this.setVisible(false);
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = null;
        if (string3 != null) {
            jButton3 = new JButton(this.getMessage(string3));
            jButton3.setMnemonic(ResourceManager.getMnemonic(string3));
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DialogTemplate.this.setUserAnswer(3);
                    DialogTemplate.this.setVisible(false);
                }
            });
            jPanel.add(jButton3);
        }
        if (bl) {
            jButton3.setToolTipText(this.getMessage("autoupdatecheck.masthead"));
        }
        if (jButton3 != null) {
            JButton[] jButtonArray = new JButton[]{jButton, jButton2, jButton3};
            DialogTemplate.resizeButtons(jButtonArray);
        } else {
            JButton[] jButtonArray = new JButton[]{jButton, jButton2};
            DialogTemplate.resizeButtons(jButtonArray);
        }
        return jPanel;
    }

    private JPanel createTopPanel(boolean bl) {
        Accessible accessible;
        this.topPanel = new JPanel();
        this.topPanel.setBackground(this.BG);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.topPanel.setLayout(gridBagLayout);
        Font font = ResourceManager.getUIFont();
        int n = this.isBlockedDialog ? font.getSize() + 2 : font.getSize() + 4;
        this.masthead = new UITextArea(n, MAIN_TEXT_WIDTH, true);
        this.masthead.setText(this.topText);
        Dimension dimension = this.masthead.getPreferredSize();
        this.masthead.setSize(dimension.width, dimension.height);
        this.masthead.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 6));
        if (bl) {
            if (this.includeMasthead) {
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.masthead, gridBagConstraints);
                this.topPanel.add(this.masthead);
                accessible = ResourceManager.getIcon("progress.background.image");
                if (this.masthead instanceof UITextArea) {
                    ((UITextArea)this.masthead).setBackgroundImage(((ImageIcon)accessible).getImage());
                }
            }
        } else if (this.includeMasthead) {
            this.topPanel.setBackground(Color.white);
            this.topPanel.setForeground(Color.white);
            this.topPanel.setOpaque(true);
            this.topIcon = new JLabel();
            this.topIcon.setHorizontalAlignment(0);
            this.topIcon.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 12));
            accessible = ResourceManager.getIcon("java48.image");
            if (this.useErrorIcon) {
                accessible = ResourceManager.getIcon("error48.image");
            }
            if (this.useInfoIcon) {
                accessible = ResourceManager.getIcon("info48.image");
            }
            if (this.useMixcodeIcon) {
                accessible = ResourceManager.getIcon("mixcode.image");
            }
            if (this.useBlockedIcon) {
                accessible = ResourceManager.getIcon("cert_error48.image");
            }
            this.topIcon.setIcon((Icon)((Object)accessible));
            if (this.useWarningIcon) {
                accessible = ResourceManager.getIcon("warning48.image");
                this.topIcon.setIcon((Icon)((Object)accessible));
            } else if (this.ainfo.getIconRef() != null) {
                ImageLoader.getInstance().loadImage(this.ainfo.getIconRef(), this.ainfo.getIconVersion(), this);
            }
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.masthead, gridBagConstraints);
            this.topPanel.add(this.masthead);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.topIcon, gridBagConstraints);
            this.topPanel.add(this.topIcon);
        }
        accessible = new JSeparator();
        ((JComponent)((Object)accessible)).setPreferredSize(new Dimension(510, 1));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)((Object)accessible), gridBagConstraints);
        this.topPanel.add((Component)((Object)accessible));
        return this.topPanel;
    }

    private JPanel createLinkPanel(String string, URL uRL, String string2) {
        this.dialogWidth = this.appTitle != null || this.appPublisher != null ? 510 : 260;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.ssvSetFonts();
        LinkText linkText = new LinkText(string, string2, uRL);
        linkText.setFont(ssvFont);
        linkText.setBorder(BorderFactory.createEmptyBorder(6, 6, 0, 6));
        this.topIcon = new JLabel();
        this.topIcon.setHorizontalAlignment(0);
        this.topIcon.setBorder(BorderFactory.createEmptyBorder(6, 20, 6, 6));
        this.topIcon.setIcon(new ImageIcon(ClassLoader.getSystemResource("com/sun/deploy/resources/image/security_high.png")));
        jPanel.add((Component)this.topIcon, "West");
        jPanel.add((Component)linkText, "Center");
        JSeparator jSeparator = new JSeparator();
        jSeparator.setPreferredSize(new Dimension(this.dialogWidth, 0));
        jPanel.add((Component)jSeparator, "South");
        return jPanel;
    }

    private JPanel createCenterPanel(boolean bl, String string, String string2, int n, boolean bl2) {
        Object object;
        Object object2;
        JComponent jComponent;
        Object object3;
        int n2;
        Object object4;
        Serializable serializable;
        Font font = ResourceManager.getUIFont();
        int n3 = DialogTemplate.getSubpanelFontSize();
        Font font2 = font.deriveFont(font.getStyle(), n3);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(24, 24, 12, 12));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        String string3 = this.mixedJsToJava ? this.getMessage("security.dialog.nativemixcode.js.appLabelStr") : this.getMessage("dialog.template.name");
        JLabel jLabel = new JLabel(string3);
        final Font font3 = jLabel.getFont().deriveFont(1);
        final Font font4 = jLabel.getFont().deriveFont(0);
        jLabel.setFont(font3);
        JLabel jLabel2 = new JLabel(this.getMessage("dialog.template.publisher"));
        jLabel2.setFont(font3);
        String string4 = this.mixedJsToJava ? this.getMessage("security.dialog.mixcode.js.appLabelWebsite") : this.getMessage("deployment.ssv.location");
        JLabel jLabel3 = new JLabel(string4);
        jLabel3.setFont(font3);
        JLabel jLabel4 = new JLabel(this.getMessage("deployment.ssv.reason"));
        jLabel4.setFont(font3);
        this.nameInfo = new JLabel();
        this.publisherInfo = new JLabel();
        this.urlInfo = new JLabel();
        this.nameInfo.setFont(font4);
        this.publisherInfo.setFont(font4);
        this.urlInfo.setFont(font4);
        this.nameInfo.putClientProperty("html.disable", Boolean.TRUE);
        this.publisherInfo.putClientProperty("html.disable", Boolean.TRUE);
        this.urlInfo.putClientProperty("html.disable", Boolean.TRUE);
        if (!this.hideTitleAndPublisher && this.appTitle != null) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(this.mixedJsToJava ? 12 : 0, 0, 0, 12);
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            gridBagConstraints.insets = new Insets(this.mixedJsToJava ? 12 : 0, 0, 0, 12);
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.nameInfo, gridBagConstraints);
            jPanel.add(this.nameInfo);
        }
        if (!this.hideTitleAndPublisher && bl2 && this.appPublisher != null) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(this.mixedJsToJava ? 0 : 12, 0, 0, 12);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            jPanel.add(jLabel2);
            gridBagConstraints.insets = new Insets(this.mixedJsToJava ? 0 : 12, 0, 0, 12);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.publisherInfo, gridBagConstraints);
            jPanel.add(this.publisherInfo);
        }
        if (this.appTitle != null && this.appURL != null) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(this.mixedJsToJava ? 0 : 12, 0, 0, 12);
            gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
            if (this.mixedJsToJava) {
                jPanel.add((Component)jLabel3, 0);
            } else {
                jPanel.add(jLabel3);
            }
            gridBagConstraints.insets = new Insets(this.mixedJsToJava ? 0 : 12, 0, 0, 12);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.urlInfo, gridBagConstraints);
            if (this.mixedJsToJava) {
                jPanel.add((Component)this.urlInfo, 1);
            } else {
                jPanel.add(this.urlInfo);
            }
        }
        if (Config.isJavaVersionAtLeast17() && this.throwable instanceof BlockedException) {
            serializable = (BlockedException)this.throwable;
            object4 = ((BlockedException)serializable).getReason();
            JSmartTextArea jSmartTextArea = new JSmartTextArea((String)object4);
            jSmartTextArea.setFont(font4);
            jSmartTextArea.setLineWrap(true);
            jSmartTextArea.setWrapStyleWord(true);
            jSmartTextArea.setOpaque(false);
            int n4 = jSmartTextArea.getPreferredSize().height * 3;
            jSmartTextArea.setPreferredSize(new Dimension(jSmartTextArea.getPreferredSize().width, n4));
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(12, 0, 0, 12);
            gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
            jPanel.add(jLabel4);
            gridBagConstraints.insets = new Insets(12, 0, 0, 12);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(jSmartTextArea, gridBagConstraints);
            jPanel.add(jSmartTextArea);
        }
        serializable = new JSmartTextArea(font4.getSize(), 0, false);
        object4 = ((JComponent)serializable).getFontMetrics(font4);
        int n5 = 462 - ((FontMetrics)object4).stringWidth(jLabel4.getText());
        if (this.reason != null) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(this.mixedJsToJava ? 0 : 12, 0, 0, 12);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
            jPanel.add(jLabel4);
            gridBagConstraints.insets = new Insets(this.mixedJsToJava ? 0 : 12, 0, 0, 12);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            ((JTextComponent)serializable).setText(this.reason);
            gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
            jPanel.add((Component)serializable);
        }
        this.setInfo(this.ainfo);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(3, 0, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        if (this.alwaysString != null) {
            this.always = new JCheckBox(this.alwaysString);
            this.always.setMnemonic(ResourceManager.getMnemonic("security.dialog.always"));
            this.always.setSelected(bl);
            this.always.setFont(font4);
            n2 = this.always.getBorder().getBorderInsets((Component)this.always).left;
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, n2, 0, 0));
            jPanel2.add(this.always);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        }
        if (this.mixedCodeString != null) {
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new FlowLayout());
            this.mixedCodeLabel = new JLabel(this.mixedCodeString);
            this.mixedCodeLabel.setFont(font4);
            jPanel5.add(this.mixedCodeLabel);
            object3 = new JPanel();
            ((Container)object3).setLayout(new BorderLayout());
            jComponent = null;
            object2 = "dialog.template.more.info";
            jComponent = new FancyButton(this.getMessage((String)object2), ResourceManager.getMnemonic((String)object2));
            object = font.deriveFont((float)n3);
            jComponent.setFont((Font)object);
            jComponent.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getComponent() instanceof FancyButton) {
                        DialogTemplate.this.showMixedcodeMoreInfo();
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DialogTemplate.this.showMixedcodeMoreInfo();
                }
            });
            ((Container)object3).add((Component)jComponent, "West");
            jPanel3.add(jPanel5);
            if (this.alwaysString != null) {
                jPanel3.add(Box.createVerticalStrut(12));
                jPanel3.add(jPanel2);
                jPanel3.add(Box.createVerticalStrut(12));
            }
            jPanel3.add((Component)object3);
        }
        int n6 = n2 = n >= 0 ? 1 : 0;
        if (n2 != 0) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setVisible(n <= 100);
        }
        if (this.isBlockedDialog) {
            jComponent = new JEditorPane(){

                public Dimension getPreferredSize() {
                    return new Dimension(474, this.getContentHeight(this.getText()));
                }

                private int getContentHeight(String string) {
                    JEditorPane jEditorPane = new JEditorPane();
                    jEditorPane.setEditorKit(new PromptEditorKit(font4, font3, false));
                    jEditorPane.setSize(474, Short.MAX_VALUE);
                    jEditorPane.setText(string);
                    return jEditorPane.getPreferredSize().height;
                }
            };
            jComponent.setOpaque(false);
            ((JTextComponent)jComponent).setEditable(false);
            ((JEditorPane)jComponent).setEditorKit(new PromptEditorKit(font4, font3, false));
            ((JEditorPane)jComponent).setContentType("text/html");
            object2 = this.getMessage("deployment.blocked.moreinfo.hyperlink.text");
            object = this.getMessage("deployment.blocked.moreinfo.hyperlink.url");
            ((JEditorPane)jComponent).setText(this.contentString + " <A HREF=\"" + (String)object + "\">" + (String)object2 + "</A>");
            ((JEditorPane)jComponent).addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Platform.get().showDocument(hyperlinkEvent.getURL().toString());
                    }
                }
            });
            jPanel4.add((Component)jComponent, "West");
        } else if (this.contentString != null) {
            if (this.contentLabel != null) {
                object3 = new JPanel(new BorderLayout());
                ((Container)object3).add((Component)new JLabel(this.contentLabel), "West");
                jPanel4.add((Component)object3, "North");
            }
            if (this.contentScroll) {
                final boolean bl3 = this.largeScroll;
                object3 = this.largeScroll ? new JTextArea(this.contentString, 20, 80) : new JTextArea(this.contentString, 4, 40);
                ((JTextComponent)object3).setEditable(false);
                object2 = new JScrollPane((Component)object3, 20, 30){

                    public Dimension getPreferredSize() {
                        Dimension dimension = super.getPreferredSize();
                        if (bl3) {
                            dimension.width = Math.min(dimension.width, 600);
                        }
                        return dimension;
                    }
                };
                jPanel4.add((Component)object2, "Center");
            } else {
                object3 = new UITextArea(this.contentString);
                ((Component)object3).setSize(((UITextArea)object3).getPreferredSize());
                jPanel4.add((Component)object3, "Center");
            }
            jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        }
        if (this.scrollList != null) {
            if (this.contentLabel != null) {
                object3 = new JPanel(new BorderLayout());
                ((Container)object3).add((Component)new JLabel(this.contentLabel), "West");
                jPanel4.add((Component)object3, "North");
            }
            if (this.contentScroll) {
                object3 = new JScrollPane(this.scrollList, 20, 30);
                jPanel4.add((Component)object3, "Center");
            }
            if (this.showDetails) {
                object3 = "security.more.info.details";
                FancyButton fancyButton = new FancyButton(this.getMessage((String)object3), ResourceManager.getMnemonic((String)object3));
                fancyButton.setFont(font2);
                fancyButton.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getComponent() instanceof FancyButton) {
                            DialogTemplate.this.showCertificateDetails();
                        }
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                    }
                });
                object2 = new JPanel();
                ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 0));
                ((Container)object2).setLayout(new FlowLayout(4, 0, 0));
                ((Container)object2).add(fancyButton);
                ((Container)object2).add(Box.createGlue());
                jPanel4.add((Component)object2, "South");
            }
        }
        object3 = this.createButtonsPanel(string, string2);
        if (this.cacheUpgradeContentString != null) {
            UITextArea uITextArea = new UITextArea(this.cacheUpgradeContentString);
            uITextArea.setBorder(null);
            jPanel4.add((Component)uITextArea, "North");
            this.centerPanel.add(jPanel4);
            this.centerPanel.add(Box.createVerticalStrut(12));
        } else if (this.isBlockedDialog) {
            if (this.contentString != null || this.scrollList != null) {
                this.centerPanel.add(jPanel4);
                this.centerPanel.add(Box.createVerticalStrut(24));
            }
            if (this.includeAppInfo) {
                this.centerPanel.add(jPanel);
                this.centerPanel.add(Box.createVerticalStrut(12));
            }
            if (this.mixedCodeString != null) {
                this.centerPanel.add(jPanel3);
            } else if (this.alwaysString != null) {
                this.centerPanel.add(jPanel2);
            }
        } else {
            if (this.includeAppInfo) {
                this.centerPanel.add(jPanel);
                this.centerPanel.add(Box.createVerticalStrut(12));
            }
            if (this.mixedCodeString != null) {
                this.centerPanel.add(jPanel3);
            } else if (this.alwaysString != null) {
                this.centerPanel.add(jPanel2);
            }
            if (this.contentString != null || this.scrollList != null) {
                this.centerPanel.add(jPanel4);
            }
        }
        JPanel jPanel6 = new JPanel(new BorderLayout());
        this.centerPanel.add(jPanel6);
        object2 = new JPanel(new BorderLayout());
        if (n2 != 0) {
            this.progressStatusLabel = new JLabel(" ");
            this.progressStatusLabel.setFont(font2);
            jPanel6.add((Component)this.progressStatusLabel, "West");
            this.progressBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            ((Container)object2).add((Component)this.progressBar, "Center");
        }
        ((Container)object2).add((Component)object3, "East");
        this.centerPanel.add((Component)object2);
        if (this.isBlockedDialog) {
            int n7 = ((FontMetrics)object4).getHeight() * (((FontMetrics)object4).stringWidth(((JTextComponent)serializable).getText()) / n5);
            this.centerPanel.add(Box.createVerticalStrut(n7));
        }
        this.dialogInterface.setCancelAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogTemplate.this.cancelAction();
            }
        });
        return this.centerPanel;
    }

    private JPanel createBottomPanel(boolean bl) {
        this.bottomPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.bottomPanel.setLayout(gridBagLayout);
        if (this.alertStrs != null || this.infoStrs != null) {
            Serializable serializable;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            JSeparator jSeparator = new JSeparator();
            jSeparator.setPreferredSize(new Dimension(510, 1));
            gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
            this.bottomPanel.add(jSeparator);
            this.securityIcon = new JLabel();
            String string = "com/sun/deploy/resources/image/security_high.png";
            if (this.alertStrs == null || this.alertStrs.length == 0) {
                string = "com/sun/deploy/resources/image/security_low.png";
                if (this.always != null) {
                    this.always.setSelected(true);
                }
            } else if (this.mixedCodeString == null) {
                this.dialogInterface.setDefaultButton(this.cancelBtn);
            }
            this.securityIcon.setIcon(new ImageIcon(ClassLoader.getSystemResource(string)));
            gridBagConstraints.insets = new Insets(12, 12, 12, 20);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.securityIcon, gridBagConstraints);
            this.bottomPanel.add(this.securityIcon);
            Font font = ResourceManager.getUIFont();
            int n = DialogTemplate.getSubpanelFontSize();
            int n2 = 0;
            FancyButton fancyButton = null;
            if (bl) {
                String string2 = "dialog.template.more.info";
                fancyButton = new FancyButton(this.getMessage(string2), ResourceManager.getMnemonic(string2));
                serializable = font.deriveFont((float)n);
                fancyButton.setFont((Font)serializable);
                fancyButton.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getComponent() instanceof FancyButton) {
                            DialogTemplate.this.showMoreInfo();
                        }
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                    }
                });
                fancyButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (DialogTemplate.this.mixedCodeString != null) {
                            DialogTemplate.this.showMixedcodeMoreInfo();
                        } else {
                            DialogTemplate.this.showMoreInfo();
                        }
                    }
                });
                n2 = fancyButton.getPreferredSize().width + fancyButton.getInsets().left + fancyButton.getInsets().right;
            }
            int n3 = 486 - this.securityIcon.getPreferredSize().width - 20 - 6 - n2 - 8;
            serializable = new UITextArea(n, n3, false);
            Font font2 = ((Component)serializable).getFont().deriveFont(0);
            ((JTextArea)serializable).setFont(font2);
            if ((this.alertStrs == null || this.alertStrs.length == 0) && this.infoStrs != null && this.infoStrs.length != 0) {
                ((UITextArea)serializable).setText(this.infoStrs[0] != null ? this.infoStrs[0] : " ");
                ((Component)serializable).setSize(((UITextArea)serializable).getPreferredSize());
                if (this.infoStrs.length > 1) {
                    String[] stringArray = new String[this.infoStrs.length - 1];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = this.infoStrs[i + 1];
                    }
                    this.infoStrs = stringArray;
                } else {
                    this.infoStrs = null;
                }
            } else if (this.alertStrs != null && this.alertStrs.length != 0) {
                ((UITextArea)serializable).setText(this.alertStrs[0] != null ? this.alertStrs[0] : " ");
                ((Component)serializable).setSize(((UITextArea)serializable).getPreferredSize());
                this.consumeAlertString0();
            }
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.insets = new Insets(12, 0, 12, 6);
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
            this.bottomPanel.add((Component)serializable);
            gridBagConstraints.insets = new Insets(12, 0, 12, 12);
            gridBagConstraints.gridwidth = 0;
            if (fancyButton != null) {
                gridBagConstraints.gridx = 22;
                gridBagLayout.setConstraints(fancyButton, gridBagConstraints);
                this.bottomPanel.add(fancyButton);
            }
        } else {
            this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        }
        return this.bottomPanel;
    }

    JPanel createButtonsPanel(String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(4, 0, 0));
        this.okBtn = new JButton(string == null ? "" : this.getMessage(string));
        this.okBtn.setMnemonic(ResourceManager.getMnemonic(string));
        this.okBtn.addActionListener(this);
        this.okBtn.setActionCommand("OK");
        jPanel.add(this.okBtn);
        this.okBtn.setVisible(string != null);
        this.cancelBtn = new JButton(string2 == null ? "" : this.getMessage(string2));
        this.cancelBtn.addActionListener(this);
        jPanel.add(Box.createHorizontalStrut(6));
        jPanel.add(this.cancelBtn);
        this.cancelBtn.setVisible(string2 != null);
        if (this.defaultButton == 0) {
            this.dialogInterface.setDefaultButton(this.okBtn);
            this.dialogInterface.setInitialFocusComponent(this.okBtn);
        } else if (this.cancelBtn.isVisible()) {
            this.dialogInterface.setDefaultButton(this.cancelBtn);
            this.dialogInterface.setInitialFocusComponent(this.cancelBtn);
        }
        this.dialogInterface.setCancelAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogTemplate.this.cancelAction();
            }
        });
        JButton[] jButtonArray = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        return jPanel;
    }

    private void ssvSetFonts() {
        if (ssvFont == null) {
            int n;
            JLabel jLabel = new JLabel();
            int n2 = n = ResourceManager.getUIFont().getSize();
            int n3 = n + 2;
            int n4 = n + 4;
            ssvSmallFont = jLabel.getFont().deriveFont(0, n2);
            ssvSmallBoldFont = jLabel.getFont().deriveFont(1, n2);
            ssvFont = jLabel.getFont().deriveFont(0, n3);
            ssvBold = jLabel.getFont().deriveFont(1, n3);
            ssvBigFont = jLabel.getFont().deriveFont(0, n4);
            ssvBigBoldFont = jLabel.getFont().deriveFont(1, n4);
        }
    }

    static JPanel createShadedContentBorderPanel(final boolean bl) {
        JPanel jPanel = new JPanel(){

            protected void paintComponent(Graphics graphics) {
                Color color = new Color(240, 240, 240);
                Color color2 = new Color(200, 200, 200);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, 4 * this.getHeight() / 7, color2, false);
                graphics2D.setPaint(gradientPaint);
                Insets insets = this.getInsets();
                graphics2D.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                super.paintComponent(graphics);
            }

            protected void paintBorder(Graphics graphics) {
                if (bl) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setColor(new Color(116, 116, 116));
                    graphics2D.drawRoundRect(0, 0, this.getWidth() - 2, this.getHeight() - 2, 20, 20);
                }
                super.paintBorder(graphics);
            }
        };
        return jPanel;
    }

    private JPanel createShadedContentPanel() {
        JPanel jPanel = new JPanel(){

            protected void paintComponent(Graphics graphics) {
                Color color = new Color(240, 240, 240);
                Color color2 = new Color(200, 200, 200);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, 4 * this.getHeight() / 7, color2, false);
                graphics2D.setPaint(gradientPaint);
                Insets insets = this.getInsets();
                graphics2D.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                super.paintComponent(graphics);
            }
        };
        return jPanel;
    }

    private JPanel createMessageClosePanel(JLabel jLabel) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        ImageIcon imageIcon = ResourceManager.getIcon("close_box_normal.image");
        JButton jButton = new JButton(imageIcon);
        jButton.setOpaque(false);
        jButton.setEnabled(true);
        jButton.setContentAreaFilled(false);
        jButton.setBorderPainted(false);
        jButton.setPreferredSize(new Dimension(10, 10));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogTemplate.this.cancelAction();
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)jButton, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setOpaque(false);
        jPanel3.setPreferredSize(new Dimension(300, 20));
        jPanel3.add((Component)jLabel, "West");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JPanel createSecurityTopPanel(boolean bl) {
        Component component;
        Serializable serializable;
        Serializable serializable2;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(this.topText);
        jLabel.setOpaque(false);
        if (bl) {
            serializable2 = new JPanel(new BorderLayout());
            ((JComponent)serializable2).setOpaque(false);
            serializable = new JLabel(this.getMessage("dialog.template.continue"));
            serializable.setOpaque(false);
            serializable.setFont(ssvBigBoldFont);
            jLabel.setFont(ssvFont);
            ((Container)serializable2).add((Component)serializable, "North");
            ((Container)serializable2).add(jLabel, "South");
            jPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 0, 16));
            jPanel.add((Component)serializable2, "North");
        } else {
            jLabel.setFont(ssvBigBoldFont);
            if (this.alertStrs == null) {
                jPanel.setBorder(BorderFactory.createEmptyBorder(8, 16, 0, 8));
                serializable2 = this.createMessageClosePanel(jLabel);
                jPanel.add((Component)serializable2, "North");
            } else {
                jPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 0, 16));
                jPanel.add((Component)jLabel, "North");
            }
        }
        serializable2 = new GridBagLayout();
        serializable = new GridBagConstraints();
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout((LayoutManager)((Object)serializable2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel2 = new JLabel(this.getMessage("dialog.template.name"));
        jLabel2.setFont(ssvSmallBoldFont);
        jLabel2.setOpaque(false);
        JLabel jLabel3 = new JLabel(this.getMessage("dialog.template.publisher"));
        jLabel3.setFont(ssvSmallBoldFont);
        jLabel3.setOpaque(false);
        String string = bl ? this.getMessage(this.ainfo.isMultiHost() ? "dialog.template.website.multihost" : "dialog.template.website") : this.getMessage(this.ainfo.isMultiHost() ? "deployment.ssv.location.multihost" : "deployment.ssv.location");
        JLabel jLabel4 = new JLabel(string);
        jLabel4.setFont(ssvSmallBoldFont);
        jLabel4.setOpaque(false);
        this.nameInfo = new JLabel();
        this.publisherInfo = new JLabel();
        this.urlInfo = new JLabel();
        this.nameInfo.setFont(ssvBigBoldFont);
        this.publisherInfo.setFont(ssvSmallFont);
        this.urlInfo.setFont(ssvSmallFont);
        this.nameInfo.putClientProperty("html.disable", Boolean.TRUE);
        this.publisherInfo.putClientProperty("html.disable", Boolean.TRUE);
        this.urlInfo.putClientProperty("html.disable", Boolean.TRUE);
        if (this.ainfo.shouldDisplayMainJNLP()) {
            this.originInfo = new JLabel();
            this.originInfo.setFont(ssvSmallFont);
            this.originInfo.putClientProperty("html.disable", Boolean.TRUE);
        }
        if (this.ainfo.shouldDisplayDocumentBase()) {
            this.appletLocationInfo = new JLabel();
            this.appletLocationInfo.setFont(ssvSmallFont);
            this.appletLocationInfo.putClientProperty("html.disable", Boolean.TRUE);
        }
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).insets = new Insets(0, 32, 0, 12);
        ((GridBagConstraints)serializable).weightx = 0.0;
        if (this.appTitle != null && this.appTitle.length() > 0 && !bl) {
            ((GridBagLayout)serializable2).setConstraints(jLabel2, (GridBagConstraints)serializable);
            jPanel2.add(jLabel2);
            ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 12);
            ((GridBagConstraints)serializable).gridx = -1;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagLayout)serializable2).setConstraints(this.nameInfo, (GridBagConstraints)serializable);
            jPanel2.add(this.nameInfo);
        }
        if (this.appPublisher != null && !bl) {
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).insets = new Insets(12, 32, 0, 12);
            ((GridBagConstraints)serializable).gridwidth = 1;
            ((GridBagConstraints)serializable).weightx = 0.0;
            ((GridBagConstraints)serializable).anchor = 17;
            ((GridBagLayout)serializable2).setConstraints(jLabel3, (GridBagConstraints)serializable);
            jPanel2.add(jLabel3);
            ((GridBagConstraints)serializable).insets = new Insets(12, 0, 0, 12);
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagLayout)serializable2).setConstraints(this.publisherInfo, (GridBagConstraints)serializable);
            jPanel2.add(this.publisherInfo);
        }
        if (this.appURL != null) {
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).weightx = 0.0;
            ((GridBagConstraints)serializable).gridwidth = 1;
            ((GridBagConstraints)serializable).anchor = 17;
            ((GridBagConstraints)serializable).insets = new Insets(12, 32, 0, 12);
            ((GridBagLayout)serializable2).setConstraints(jLabel4, (GridBagConstraints)serializable);
            jPanel2.add(jLabel4);
            ((GridBagConstraints)serializable).insets = new Insets(12, 0, 0, 12);
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagLayout)serializable2).setConstraints(this.urlInfo, (GridBagConstraints)serializable);
            jPanel2.add(this.urlInfo);
            if (this.originInfo != null) {
                ((GridBagConstraints)serializable).fill = 2;
                ((GridBagConstraints)serializable).weightx = 0.0;
                ((GridBagConstraints)serializable).gridwidth = 1;
                ((GridBagConstraints)serializable).anchor = 17;
                ((GridBagConstraints)serializable).insets = new Insets(6, 32, 0, 12);
                component = Box.createGlue();
                ((GridBagLayout)serializable2).setConstraints(component, (GridBagConstraints)serializable);
                jPanel2.add(component);
                ((GridBagConstraints)serializable).insets = new Insets(6, 0, 0, 12);
                ((GridBagConstraints)serializable).gridwidth = 0;
                ((GridBagConstraints)serializable).weightx = 1.0;
                ((GridBagLayout)serializable2).setConstraints(this.originInfo, (GridBagConstraints)serializable);
                jPanel2.add(this.originInfo);
            }
            if (this.appletLocationInfo != null) {
                ((GridBagConstraints)serializable).fill = 2;
                ((GridBagConstraints)serializable).weightx = 0.0;
                ((GridBagConstraints)serializable).gridwidth = 1;
                ((GridBagConstraints)serializable).anchor = 17;
                ((GridBagConstraints)serializable).insets = new Insets(6, 32, 0, 12);
                component = Box.createGlue();
                ((GridBagLayout)serializable2).setConstraints(component, (GridBagConstraints)serializable);
                jPanel2.add(component);
                ((GridBagConstraints)serializable).insets = new Insets(6, 0, 0, 12);
                ((GridBagConstraints)serializable).gridwidth = 0;
                ((GridBagConstraints)serializable).weightx = 1.0;
                ((GridBagLayout)serializable2).setConstraints(this.appletLocationInfo, (GridBagConstraints)serializable);
                jPanel2.add(this.appletLocationInfo);
            }
        }
        this.setInfo(this.ainfo);
        component = new JLabel();
        component.setOpaque(false);
        if (this.alertStrs != null) {
            component.setIcon(ResourceManager.getIcon("warning48s.image"));
        } else {
            component.setIcon(ResourceManager.getIcon("java48s.image"));
        }
        component.setBorder(BorderFactory.createEmptyBorder(0, 32, 0, 0));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setOpaque(false);
        jPanel3.add(component, "West");
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(16, 0, 16, 0));
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private JPanel createSSVTopPanel(String string, String string2, String string3) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 0, 16));
        JLabel jLabel = new JLabel(string);
        jLabel.setOpaque(false);
        jLabel.setFont(ssvBigBoldFont);
        jLabel.setEnabled(true);
        jPanel.add((Component)jLabel, "North");
        JLabel jLabel2 = new JLabel(this.getMessage("dialog.template.name"));
        jLabel2.setFont(ssvSmallBoldFont);
        jLabel2.setOpaque(false);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 16));
        JLabel jLabel3 = new JLabel(this.getMessage("deployment.ssv.location"));
        jLabel3.setFont(ssvSmallBoldFont);
        jLabel3.setOpaque(false);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 16));
        this.nameInfo = new JLabel(string2);
        this.nameInfo.setFont(ssvBigBoldFont);
        this.nameInfo.setOpaque(false);
        JLabel jLabel4 = new JLabel(string3);
        jLabel4.setFont(ssvSmallFont);
        jLabel4.setOpaque(false);
        JPanel[] jPanelArray = new JPanel[4];
        for (int i = 0; i < 4; ++i) {
            jPanelArray[i] = new JPanel(new BorderLayout());
            jPanelArray[i].setOpaque(false);
        }
        JLabel jLabel5 = new JLabel();
        jLabel5.setOpaque(false);
        jLabel5.setIcon(ResourceManager.getIcon("warning48.image"));
        jLabel5.setBorder(BorderFactory.createEmptyBorder(0, 32, 0, 0));
        jPanelArray[2].add((Component)jLabel2, "North");
        jPanelArray[2].add((Component)jLabel3, "South");
        jPanelArray[2].setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        jPanelArray[3].add((Component)this.nameInfo, "North");
        jPanelArray[3].add((Component)jLabel4, "South");
        jPanelArray[1].add((Component)jPanelArray[2], "West");
        jPanelArray[1].add((Component)jPanelArray[3], "Center");
        jPanelArray[1].setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 0));
        jPanelArray[0].add((Component)jLabel5, "West");
        jPanelArray[0].add((Component)jPanelArray[1], "East");
        jPanelArray[0].setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        jPanel.add((Component)jPanelArray[0], "South");
        return jPanel;
    }

    private JPanel createTrustSecurityRiskPanel(String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 16, 16, 16));
        JSmartTextArea jSmartTextArea = new JSmartTextArea(string);
        jSmartTextArea.setFont(ssvSmallFont);
        jSmartTextArea.setLineWrap(true);
        jSmartTextArea.setWrapStyleWord(true);
        jSmartTextArea.setOpaque(false);
        jSmartTextArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel.add((Component)jSmartTextArea, "North");
        return jPanel;
    }

    private JPanel createSecurityRiskPanel(String string, boolean bl, boolean bl2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 12));
        int n = string.indexOf(" ");
        if (n < string.length() - 2) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setOpaque(false);
            JLabel jLabel = new JLabel(string2);
            jLabel.setFont(ssvSmallBoldFont);
            jLabel.setOpaque(false);
            jPanel2.add((Component)jLabel, "North");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setOpaque(false);
            JSmartTextArea jSmartTextArea = new JSmartTextArea(string3);
            jSmartTextArea.setFont(ssvSmallFont);
            jSmartTextArea.setLineWrap(true);
            jSmartTextArea.setWrapStyleWord(true);
            jSmartTextArea.setOpaque(false);
            jSmartTextArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            jPanel3.add((Component)jSmartTextArea, "North");
            String string4 = "dialog.template.more.info2";
            FancyButton fancyButton = new FancyButton(this.getMessage(string4), ResourceManager.getMnemonic(string4));
            fancyButton.setOpaque(false);
            fancyButton.setFont(ssvSmallFont);
            fancyButton.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getComponent() instanceof FancyButton) {
                        DialogTemplate.this.showMoreInfo();
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
            fancyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DialogTemplate.this.showMoreInfo();
                }
            });
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setOpaque(false);
            jPanel4.add((Component)fancyButton, "West");
            jPanel3.add((Component)jPanel4, "Center");
            if (!bl2) {
                String string5 = this.getMessage("dialog.security.risk.warning");
                String string6 = this.getMessage("security.dialog.notverified.subject");
                JSmartTextArea jSmartTextArea2 = new JSmartTextArea(string5.replaceAll(string6, string6.toUpperCase()));
                jSmartTextArea2.setFont(ssvBold);
                jSmartTextArea2.setForeground(new Color(204, 0, 0));
                jSmartTextArea2.setLineWrap(true);
                jSmartTextArea2.setWrapStyleWord(true);
                jSmartTextArea2.setOpaque(false);
                jSmartTextArea2.setSize(480, Short.MAX_VALUE);
                Box box = Box.createVerticalBox();
                box.add(jSmartTextArea2);
                box.add(Box.createVerticalStrut(10));
                Box box2 = Box.createHorizontalBox();
                box2.add(Box.createHorizontalStrut(8));
                box2.add(box);
                jPanel.add((Component)box2, "North");
            }
            jPanel.add((Component)jPanel2, "West");
            jPanel.add((Component)jPanel3, "Center");
        }
        return jPanel;
    }

    private JPanel createSSVRiskPanel(String string, String string2, URL uRL) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        int n = string.indexOf(" ");
        if (n < string.length() - 2) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setOpaque(false);
            JLabel jLabel = new JLabel(string3);
            jLabel.setFont(ssvSmallBoldFont);
            jLabel.setOpaque(false);
            jPanel2.add((Component)jLabel, "North");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setOpaque(false);
            LinkText linkText = new LinkText(string4, string2, uRL);
            linkText.setFont(ssvSmallFont);
            linkText.setOpaque(false);
            jPanel3.add((Component)linkText, "Center");
            jPanel.add((Component)jPanel2, "West");
            jPanel.add((Component)jPanel3, "Center");
        }
        return jPanel;
    }

    private JPanel createTrustSecurityAlwaysPanel(boolean bl) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 16));
        this.always = new JCheckBox(this.alwaysString);
        this.always.setMnemonic(ResourceManager.getMnemonic("security.dialog.always"));
        this.always.setFont(ssvSmallFont);
        this.always.setOpaque(false);
        this.always.setSelected(bl);
        jPanel.add((Component)this.always, "North");
        return jPanel;
    }

    private JPanel createSecurityAcceptPanel(String string, String string2, boolean bl) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 16));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel3.setOpaque(false);
        JLabel jLabel = new JLabel(this.acceptTitle);
        jLabel.setOpaque(false);
        jLabel.setFont(ssvSmallBoldFont);
        jPanel2.add((Component)jLabel, "Center");
        JCheckBox jCheckBox = new JCheckBox(this.acceptText);
        jCheckBox.setFont(ssvSmallFont);
        jCheckBox.setOpaque(false);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    DialogTemplate.this.okBtn.setEnabled(false);
                    DialogTemplate.this.dialogInterface.setDefaultButton(DialogTemplate.this.cancelBtn);
                    if (DialogTemplate.this.always != null) {
                        DialogTemplate.this.always.setSelected(false);
                        DialogTemplate.this.always.setEnabled(false);
                    }
                }
                if (itemEvent.getStateChange() == 1) {
                    DialogTemplate.this.okBtn.setEnabled(true);
                    DialogTemplate.this.dialogInterface.setDefaultButton(DialogTemplate.this.okBtn);
                    if (DialogTemplate.this.always != null) {
                        DialogTemplate.this.always.setEnabled(true);
                    }
                }
            }
        });
        String string3 = "security.dialog.accept.text";
        jCheckBox.setMnemonic(ResourceManager.getMnemonic(string3));
        jCheckBox.setSelected(bl);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(4, 0, 0));
        jPanel4.setOpaque(false);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(8, 32, 8, 0));
        this.okBtn = new JButton(this.getMessage(string));
        this.okBtn.setMnemonic(ResourceManager.getMnemonic(string));
        this.okBtn.addActionListener(this);
        this.okBtn.setActionCommand("OK");
        this.okBtn.setOpaque(false);
        this.okBtn.setEnabled(false);
        jPanel4.add(this.okBtn);
        this.cancelBtn = new JButton(string2);
        this.cancelBtn.addActionListener(this);
        this.cancelBtn.setOpaque(false);
        jPanel4.add(Box.createHorizontalStrut(10));
        jPanel4.add(this.cancelBtn);
        this.dialogInterface.setDefaultButton(this.cancelBtn);
        this.dialogInterface.setInitialFocusComponent(jCheckBox);
        JButton[] jButtonArray = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        jPanel3.add((Component)jCheckBox, "West");
        jPanel3.add((Component)jPanel4, "East");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 16));
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "South");
        this.dialogInterface.setCancelAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogTemplate.this.cancelAction();
            }
        });
        return jPanel;
    }

    private JPanel createTrustSecurityBottomPanel(String string, String string2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        String string3 = "dialog.template.more.info2";
        FancyButton fancyButton = new FancyButton(this.getMessage(string3), ResourceManager.getMnemonic(string3));
        fancyButton.setOpaque(false);
        fancyButton.setFont(ssvSmallFont);
        fancyButton.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getComponent() instanceof FancyButton) {
                    DialogTemplate.this.showMoreInfo();
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        fancyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogTemplate.this.showMoreInfo();
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)fancyButton, "West");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        if (this.alertStrs != null) {
            jLabel.setIcon(ResourceManager.getIcon("yellowShield.image"));
        } else {
            jLabel.setIcon(ResourceManager.getIcon("blueShield.image"));
        }
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setOpaque(false);
        jPanel3.add((Component)jLabel, "West");
        jPanel3.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(4, 0, 0));
        jPanel4.setOpaque(false);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
        this.okBtn = new JButton(this.getMessage(string));
        this.okBtn.setMnemonic(ResourceManager.getMnemonic(string));
        this.okBtn.addActionListener(this);
        this.okBtn.setActionCommand("OK");
        this.okBtn.setOpaque(false);
        jPanel4.add(this.okBtn);
        this.cancelBtn = new JButton(string2);
        this.cancelBtn.addActionListener(this);
        this.cancelBtn.setOpaque(false);
        jPanel4.add(Box.createHorizontalStrut(10));
        jPanel4.add(this.cancelBtn);
        JButton[] jButtonArray = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        jPanel.add((Component)jPanel3, "West");
        jPanel.add((Component)jPanel4, "East");
        this.dialogInterface.setCancelAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogTemplate.this.cancelAction();
            }
        });
        return jPanel;
    }

    public static JPanel createYellowWarningPanel(String string, HyperlinkListener hyperlinkListener, final int n) {
        JPanel jPanel = DialogTemplate.createWarningPanel();
        jPanel.setOpaque(false);
        jPanel.setBackground(new Color(0xFFFCC4));
        JEditorPane jEditorPane = new JEditorPane(){

            public Dimension getPreferredSize() {
                return new Dimension(n, this.getContentHeight(this.getText()));
            }

            private int getContentHeight(String string) {
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.setEditorKit(new PromptEditorKit(ssvSmallFont, ssvSmallBoldFont, false));
                jEditorPane.setSize(n, Short.MAX_VALUE);
                jEditorPane.setText(string);
                return jEditorPane.getPreferredSize().height;
            }
        };
        jEditorPane.setOpaque(false);
        jEditorPane.setEditable(false);
        jEditorPane.setEditorKit(new PromptEditorKit(ssvSmallFont, ssvSmallBoldFont, false));
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(string);
        jEditorPane.addHyperlinkListener(hyperlinkListener);
        jPanel.add((Component)jEditorPane, "Center");
        return jPanel;
    }

    private static JPanel createWarningPanel() {
        JPanel jPanel = new JPanel(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Dimension dimension = new Dimension(10, 10);
                int n = this.getWidth();
                int n2 = this.getHeight();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRoundRect(0, 0, n - 1, n2 - 1, dimension.width, dimension.height);
                graphics2D.setColor(new Color(13943130));
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, dimension.width, dimension.height);
            }
        };
        return jPanel;
    }

    private JPanel createSecurityBottomPanel(boolean bl) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 16));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel3.setOpaque(false);
        final String string = this.getMessage("security.dialog.show.options");
        final String string2 = this.getMessage("security.dialog.hide.options");
        final ImageIcon imageIcon = ResourceManager.getIcon("toggle_up2.image");
        final ImageIcon imageIcon2 = ResourceManager.getIcon("toggle_down2.image");
        final JButton jButton = new JButton(string, imageIcon2);
        jButton.setOpaque(false);
        jButton.setEnabled(true);
        jButton.setContentAreaFilled(false);
        jButton.setBorderPainted(false);
        String string3 = "security.dialog.show.options";
        jButton.setMnemonic(ResourceManager.getMnemonic(string3));
        jPanel2.add((Component)jButton, "West");
        if (bl) {
            string3 = "https.dialog.always";
            this.always = new JCheckBox(this.getMessage(string3));
            this.always.setMnemonic(ResourceManager.getMnemonic(string3));
            this.always.setVisible(false);
            this.always.setEnabled(true);
        } else {
            this.always = new JCheckBox(this.alwaysString);
            this.always.setMnemonic(ResourceManager.getMnemonic("security.dialog.always"));
            this.always.setVisible(false);
            this.always.setEnabled(false);
        }
        this.always.setFont(ssvSmallFont);
        this.always.setOpaque(false);
        this.always.setSelected(false);
        jPanel3.add((Component)this.always, "West");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 32, 0, 16));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string3 = actionEvent.getActionCommand();
                if (string3.equals(string)) {
                    jButton.setIcon(imageIcon);
                    jButton.setText(string2);
                    jButton.setMnemonic(ResourceManager.getMnemonic("security.dialog.hide.options"));
                    DialogTemplate.this.always.setVisible(true);
                } else {
                    jButton.setIcon(imageIcon2);
                    jButton.setText(string);
                    jButton.setMnemonic(ResourceManager.getMnemonic("security.dialog.show.options"));
                    DialogTemplate.this.always.setVisible(false);
                }
                DialogTemplate.this.dialogInterface.pack();
                DialogTemplate.this.dialogInterface.setResizable(false);
            }
        });
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private void consumeAlertString0() {
        if (this.alertStrs.length > 1) {
            String[] stringArray = new String[this.alertStrs.length - 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.alertStrs[i + 1];
            }
            this.alertStrs = stringArray;
        } else {
            this.alertStrs = null;
        }
    }

    private JPanel createPasswordPanel(String string, boolean bl, boolean bl2, String string2, String string3, boolean bl3, char[] cArray, String string4) {
        Serializable serializable;
        Object object;
        Object object2;
        String string5;
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        Font font = jLabel.getFont().deriveFont(0);
        Font font2 = jLabel.getFont().deriveFont(1);
        JLabel jLabel3 = new JLabel();
        jLabel3.setIcon(ResourceManager.getIcon("pwd-masthead.png"));
        if (bl) {
            string5 = "password.dialog.username";
            jLabel.setText(this.getMessage(string5));
            jLabel.setDisplayedMnemonic(ResourceManager.getMnemonic(string5));
            this.pwdName = new JTextField();
            this.pwdName.setText(string2);
            jLabel.setLabelFor(this.pwdName);
            jLabel.setFont(font2);
        }
        string5 = "password.dialog.password";
        JLabel jLabel4 = new JLabel(this.getMessage(string5));
        this.password = new JPasswordField();
        this.password.setText(String.valueOf(cArray));
        jLabel4.setLabelFor(this.password);
        jLabel4.setDisplayedMnemonic(ResourceManager.getMnemonic(string5));
        jLabel4.setFont(font2);
        if (bl2) {
            object2 = "password.dialog.domain";
            jLabel2.setText(this.getMessage((String)object2));
            this.pwdDomain = new JTextField();
            this.pwdDomain.setText(string3);
            jLabel2.setLabelFor(this.pwdDomain);
            jLabel2.setDisplayedMnemonic(ResourceManager.getMnemonic((String)object2));
            jLabel2.setFont(font2);
        }
        object2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)object2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)object2).setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        JSeparator jSeparator = new JSeparator();
        ((GridBagLayout)object2).setConstraints(jSeparator, gridBagConstraints);
        jPanel.add(jSeparator);
        UITextArea uITextArea = new UITextArea(jLabel.getFont().getSize(), jLabel3.getPreferredSize().width - 24, false);
        uITextArea.setFont(font);
        uITextArea.setText(string);
        Dimension dimension = uITextArea.getPreferredSize();
        uITextArea.setSize(dimension.width, dimension.height);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        ((GridBagLayout)object2).setConstraints(uITextArea, gridBagConstraints);
        jPanel.add(uITextArea);
        Insets insets = new Insets(12, 12, 0, 6);
        Insets insets2 = new Insets(12, 0, 0, 12);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = insets;
        if (bl) {
            ((GridBagLayout)object2).setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = insets2;
            ((GridBagLayout)object2).setConstraints(this.pwdName, gridBagConstraints);
            jPanel.add(this.pwdName);
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = insets;
        ((GridBagLayout)object2).setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = insets2;
        ((GridBagLayout)object2).setConstraints(this.password, gridBagConstraints);
        jPanel.add(this.password);
        if (bl2) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = insets;
            ((GridBagLayout)object2).setConstraints(jLabel2, gridBagConstraints);
            jPanel.add(jLabel2);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = insets2;
            ((GridBagLayout)object2).setConstraints(this.pwdDomain, gridBagConstraints);
            jPanel.add(this.pwdDomain);
        }
        if (Config.getBooleanProperty("deployment.security.password.cache") && bl3) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(12, 8, 0, 12);
            object = "password.dialog.save";
            this.always = new JCheckBox(this.getMessage((String)object));
            if (cArray.length > 0) {
                this.always.setSelected(true);
            } else {
                this.always.setSelected(false);
            }
            ((GridBagLayout)object2).setConstraints(this.always, gridBagConstraints);
            jPanel.add(this.always);
        }
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 2));
        this.okBtn = new JButton(this.getMessage("common.ok_btn"));
        this.okBtn.setActionCommand("OK");
        this.okBtn.addActionListener(this);
        this.dialogInterface.setDefaultButton(this.okBtn);
        this.cancelBtn = new JButton(this.getMessage("common.cancel_btn"));
        this.cancelBtn.addActionListener(this);
        this.dialogInterface.setCancelAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogTemplate.this.cancelAction();
            }
        });
        JButton[] jButtonArray = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        ((Container)object).add(Box.createHorizontalGlue());
        ((Container)object).add(this.okBtn);
        ((Container)object).add(Box.createHorizontalStrut(6));
        ((Container)object).add(this.cancelBtn);
        ((Container)object).add(Box.createHorizontalStrut(12));
        JPanel jPanel2 = null;
        if (string4 != null) {
            jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(3, 0, 0));
            jPanel2.add(Box.createHorizontalStrut(12));
            serializable = new MessageFormat(this.getMessage("password.dialog.scheme"));
            Object[] objectArray = new Object[]{string4};
            JLabel jLabel5 = new JLabel(((Format)serializable).format(objectArray));
            jLabel5.setFont(font);
            jPanel2.add(jLabel5);
        }
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 3));
        ((Container)serializable).add(jPanel);
        ((Container)serializable).add(Box.createVerticalStrut(24));
        ((Container)serializable).add((Component)object);
        ((Container)serializable).add(Box.createVerticalStrut(12));
        if (jPanel2 != null) {
            ((Container)serializable).add(new JSeparator());
            ((Container)serializable).add(Box.createVerticalStrut(12));
            ((Container)serializable).add(jPanel2);
            ((Container)serializable).add(Box.createVerticalStrut(12));
        }
        return serializable;
    }

    void showMoreInfo() {
        MoreInfoDialog moreInfoDialog = this.throwable == null && this.detailPanel == null ? new MoreInfoDialog(this.dialogInterface.getDialog(), this.alertStrs, this.infoStrs, this.securityInfoCount, this.certs, this.start, this.end, this.majorWarning, this.sandboxApp) : new MoreInfoDialog(this.dialogInterface.getDialog(), this.detailPanel, this.throwable, this.certs, false);
        moreInfoDialog.setVisible(true);
    }

    void showMixedcodeMoreInfo() {
        MoreInfoDialog moreInfoDialog = new MoreInfoDialog(this.dialogInterface.getDialog(), null, this.infoStrs, 0, null, 0, 0, false, this.sandboxApp);
        moreInfoDialog.setVisible(true);
    }

    void showCertificateDetails() {
        Certificate[] certificateArray = null;
        Iterator iterator = this.clientAuthCertsMap.values().iterator();
        for (int i = this.scrollList.getSelectedIndex(); i >= 0 && iterator.hasNext(); --i) {
            certificateArray = (X509Certificate[])iterator.next();
        }
        if (certificateArray != null) {
            CertificateDialog.showCertificates(this.dialogInterface.getDialog(), certificateArray, 0, certificateArray.length);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            final DialogListener dialogListener = UIFactory.getDialogListener();
            final DialogInterface dialogInterface = this.dialogInterface;
            final Frame frame = this.dummyFrame;
            final boolean bl2 = URLClassPathControl.isDisabledInCurrentThread();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void run() {
                    if (dialogListener != null) {
                        dialogListener.beforeShow();
                    }
                    if (frame != null) {
                        frame.setVisible(true);
                    }
                    if (bl2) {
                        URLClassPathControl.disable();
                    }
                    try {
                        dialogInterface.setVisible(true);
                        Object var2_1 = null;
                        if (!bl2) return;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        if (!bl2) throw throwable;
                        URLClassPathControl.enable();
                        throw throwable;
                    }
                    URLClassPathControl.enable();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
            }
        } else {
            this.dialogInterface.setVisible(false);
            this.dialogInterface.dispose();
            if (this.dummyFrame != null) {
                this.dummyFrame.setVisible(false);
                this.dummyFrame.dispose();
            }
        }
    }

    public void setMasthead(String string, boolean bl) {
        if (this.masthead != null) {
            this.topText = string;
            this.masthead.setText(string);
            if (bl) {
                this.masthead.setBorder(BorderFactory.createEmptyBorder(16, 12, 16, 6));
            } else {
                this.masthead.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 6));
            }
        }
    }

    public void setIcon(Image image) {
        this.topIcon.setIcon(new ImageIcon(image));
    }

    public static void resizeButtons(JButton[] jButtonArray) {
        int n;
        int n2 = jButtonArray.length;
        int n3 = 50;
        for (n = 0; n < n2; ++n) {
            if (jButtonArray[n].getPreferredSize().width <= n3) continue;
            n3 = jButtonArray[n].getPreferredSize().width;
        }
        for (n = 0; n < n2; ++n) {
            Dimension dimension = jButtonArray[n].getPreferredSize();
            dimension.width = n3;
            jButtonArray[n].setPreferredSize(dimension);
        }
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.userAnswer = 0;
            if (this.always != null && this.always.isSelected()) {
                this.userAnswer = 2;
            }
            if (this.stayAliveOnOk) {
                return;
            }
            if (this.password != null) {
                this.pwd = this.password.getPassword();
            }
            if (this.pwdName != null) {
                this.userName = this.pwdName.getText();
            }
            if (this.pwdDomain != null) {
                this.domain = this.pwdDomain.getText();
            }
            if (this.scrollList != null) {
                this.userAnswer = this.scrollList.getSelectedIndex();
            }
        } else {
            if (this.throwable != null || this.detailPanel != null) {
                this.showMoreInfo();
                return;
            }
            this.userAnswer = 1;
            if (this.scrollList != null) {
                this.userAnswer = -1;
            }
        }
        this.setVisible(false);
    }

    public void cancelAction() {
        this.userAnswer = 1;
        this.setVisible(false);
    }

    public int getUserAnswer() {
        return this.userAnswer;
    }

    void setUserAnswer(int n) {
        this.userAnswer = n;
    }

    char[] getPassword() {
        return this.pwd;
    }

    String getUserName() {
        return this.userName;
    }

    String getDomain() {
        return this.domain;
    }

    public boolean isPasswordSaved() {
        return this.always != null && this.always.isSelected();
    }

    public void progress(int n) {
        if (this.progressBar != null) {
            if (n <= 100) {
                boolean bl = this.progressBar.isVisible();
                this.progressBar.setValue(n);
                this.progressBar.setVisible(true);
            } else {
                this.progressBar.setVisible(false);
            }
        }
    }

    void setMastheadBackground(Image image) {
        if (this.masthead != null && this.masthead instanceof UITextArea) {
            ((UITextArea)this.masthead).setBackgroundImage(image);
        }
    }

    public void disposeDialog() {
        this.dialogInterface.dispose();
    }

    public Component deriveParent(Component component, String string) {
        if (component == null && Config.getOSName().equals("Windows")) {
            this.dummyFrame = new Frame(string);
            this.dummyFrame.setLocation(-4096, -4096);
            return this.dummyFrame;
        }
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof Dialog) && !(component2 instanceof Frame)) continue;
            return component2;
        }
        return null;
    }

    public JDialog getDialog() {
        return this.dialogInterface.getDialog();
    }

    public void setInfo(String string, String string2, URL uRL, String string3) {
        if (this.nameInfo != null) {
            this.nameInfo.setText(string);
        }
        if (this.publisherInfo != null) {
            this.appPublisher = string2;
            this.publisherInfo.setText(string2);
        }
        if (this.urlInfo != null) {
            String string4 = uRL == null ? " " : uRL.toString();
            String string5 = string3 == null ? "" : string3;
            this.urlInfo.setText(string5);
            this.urlInfo.setToolTipText(string4);
        }
    }

    public void setInfo(AppInfo appInfo) {
        this.setInfo(appInfo.getDisplayTitle(), appInfo.getDisplayVendor(), appInfo.getFrom(), appInfo.getDisplayFrom());
        if (appInfo.shouldDisplayMainJNLP() && this.originInfo != null) {
            this.originInfo.setText(appInfo.getDisplayMainJNLP());
            this.originInfo.setToolTipText(appInfo.getDisplayMainJNLPTooltip());
        }
        if (appInfo.shouldDisplayDocumentBase() && this.appletLocationInfo != null) {
            this.appletLocationInfo.setText(appInfo.getDisplayDocumentBase());
            this.appletLocationInfo.setToolTipText(appInfo.getDocumentBase().toString());
        }
    }

    void showOk(boolean bl) {
        JButton[] jButtonArray = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        this.okBtn.setVisible(bl);
    }

    void stayAlive() {
        this.stayAliveOnOk = true;
    }

    public void setProgressStatusText(String string) {
        if (this.progressStatusLabel != null) {
            if (string == null || string.length() == 0) {
                string = " ";
            }
            this.progressStatusLabel.setText(string);
        }
    }

    public void imageAvailable(URL uRL, String string, Image image, File file) {
        final int n = image.getWidth(null);
        final int n2 = image.getHeight(null);
        final Image image2 = image;
        final JLabel jLabel = this.topIcon;
        new Thread(new Runnable(){

            public void run() {
                Image image = image2;
                if (48 != n || 48 != n2) {
                    image = image2.getScaledInstance(48, 48, 1);
                }
                jLabel.setIcon(new ImageIcon(image));
            }
        }).start();
    }

    public void finalImageAvailable(URL uRL, String string, Image image, File file) {
        this.imageAvailable(uRL, string, image, file);
    }

    public static int getSubpanelFontSize() {
        Font font = ResourceManager.getUIFont();
        int n = font.getSize() - 2;
        if (Config.getOSName().equalsIgnoreCase("windows")) {
            n = font.getSize() - 1;
        }
        if (n < minFontSize) {
            n = minFontSize;
        }
        return n;
    }

    public void addWindowListener(WindowListener windowListener) {
        this.dialogInterface.addWindowListener(windowListener);
    }

    public void removeWindowListener(WindowListener windowListener) {
        this.dialogInterface.removeWindowListener(windowListener);
    }

    static {
        MAIN_TEXT_WIDTH = 426;
        minFontSize = ResourceManager.getMinFontSize();
    }

    private class LinkText
    extends JPanel {
        private JSmartTextArea _text;
        private FancyButton _link;
        Dimension size;

        public LinkText(String string, String string2, URL uRL) {
            String string3;
            super(new BorderLayout());
            this.size = null;
            String string4 = string3 = uRL == null ? "http://java.com" : uRL.toString();
            if (string != null && string.length() > 0) {
                this._text = new JSmartTextArea(string);
            }
            this._link = new FancyButton(string2, 0, DialogTemplate.this.LINK_COLOR);
            this._link.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this._link.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    LinkText.this._link.setForeground(DialogTemplate.this.LINK_HIGHLIGHT_COLOR);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    LinkText.this._link.setForeground(DialogTemplate.this.LINK_COLOR);
                }
            });
            this._link.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Platform.get().showDocument(string3);
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            jPanel.add((Component)this._link, "West");
            if (this._text != null) {
                this.add((Component)this._text, "North");
            }
            this.add((Component)jPanel, "South");
        }

        public void setText(String string) {
            if (this._text != null) {
                this._text.setText(string);
            }
        }

        public void setFont(Font font) {
            if (this._text != null) {
                this._text.setFont(font);
            }
            if (this._link != null) {
                this._link.setFont(font);
            }
            this.size = null;
        }

        public void setOpaque(boolean bl) {
            super.setOpaque(bl);
            if (this._text != null) {
                this._text.setOpaque(bl);
            }
            if (this._link != null) {
                this._link.setOpaque(bl);
            }
        }
    }

    private class SSVChoicePanel
    extends JPanel {
        ButtonGroup group;
        JRadioButton button1;
        JRadioButton button2;

        public SSVChoicePanel(String string, String string2, String string3) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(8, 16, 0, 16));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            jPanel2.setOpaque(false);
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(false);
            jLabel.setFont(ssvSmallBoldFont);
            jPanel.add((Component)jLabel, "Center");
            this.button1 = new JRadioButton(string2, true);
            this.button1.setFont(ssvSmallFont);
            this.button1.setOpaque(false);
            this.button2 = new JRadioButton(string3, false);
            this.button2.setFont(ssvSmallFont);
            this.button2.setOpaque(false);
            this.group = new ButtonGroup();
            this.group.add(this.button1);
            this.group.add(this.button2);
            jPanel2.add((Component)this.button1, "North");
            jPanel2.add((Component)this.button2, "South");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 32, 0, 16));
            this.add((Component)jPanel, "North");
            this.add((Component)jPanel2, "South");
            DialogTemplate.this.dialogInterface.setInitialFocusComponent(this.button1);
        }

        public int getSelection() {
            if (this.button2.isSelected()) {
                return 1;
            }
            return 0;
        }
    }
}

